/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.linearreferencing;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.CidsBeanStore;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;
import de.cismet.cids.editors.EditorClosedEvent;
import de.cismet.cids.editors.EditorSaveListener;
import de.cismet.cids.navigator.utils.CidsBeanDropListener;
import de.cismet.cids.navigator.utils.CidsBeanDropListenerComponent;
import de.cismet.cids.navigator.utils.CidsBeanDropTarget;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableTransferHandler;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedLineFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedPointFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedPointFeatureListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.SelectionListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.CrsChangeListener;
import de.cismet.cismap.commons.interaction.events.CrsChangedEvent;
import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.cismap.commons.retrieval.RetrievalListener;
import de.cismet.cismap.linearreferencing.FeatureRegistry;
import de.cismet.cismap.linearreferencing.FeatureRegistryListener;
import de.cismet.cismap.linearreferencing.LineEditorDropBehavior;
import de.cismet.cismap.linearreferencing.LinearReferencedLineEditorListener;
import de.cismet.cismap.linearreferencing.LinearReferencedLineRenderer;
import de.cismet.cismap.linearreferencing.LinearReferencingConstants;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.cismap.linearreferencing.LinearReferencingSingletonInstances;
import de.cismet.cismap.linearreferencing.PointBeanMergeListener;
import de.cismet.cismap.linearreferencing.PointBeanMergeRequestListener;
import de.cismet.cismap.linearreferencing.StationEditor;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.CurrentStackTrace;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingWorker;
import javax.swing.TransferHandler;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;
import org.openide.util.NbBundle;

public class LinearReferencedLineEditor
extends JPanel
implements DisposableCidsBeanStore,
LinearReferencingConstants,
CidsBeanDropListener,
EditorSaveListener,
LinearReferencingSingletonInstances,
PointBeanMergeRequestListener,
WindowListener,
ConnectionContextProvider {
    private static Icon ICON_MERGED_WITH_FROM_POINT = new ImageIcon(LinearReferencedLineEditor.class.getResource("/de/cismet/cismap/linearreferencing/sql-join-left.png"));
    private static Icon ICON_MERGED_WITH_TO_POINT = new ImageIcon(LinearReferencedLineEditor.class.getResource("/de/cismet/cismap/linearreferencing/sql-join-right.png"));
    static DataFlavor CIDSBEAN_DATAFLAVOR = DataFlavor.stringFlavor;
    private static DecimalFormat decimalFormat = new DecimalFormat("###.00");
    private LinearReferencingHelper linearReferencingHelper;
    private LinearReferencedLineFeature feature;
    private LinearReferencedPointFeature fromPointFeature;
    private LinearReferencedPointFeature toPointFeature;
    private boolean isFromSpinnerChangeLocked;
    private boolean isFromFeatureChangeLocked;
    private boolean isFromBeanChangeLocked;
    private boolean isToSpinnerChangeLocked;
    private boolean isToFeatureChangeLocked;
    private boolean isToBeanChangeLocked;
    private PropertyChangeListener fromPointBeanChangeListener;
    private PropertyChangeListener toPointBeanChangeListener;
    private PointBeanMergeListener fromPointBeanMergeListener;
    private PointBeanMergeListener toPointBeanMergeListener;
    private LinearReferencedPointFeatureListener fromFeatureListener;
    private LinearReferencedPointFeatureListener toFeatureListener;
    private FeatureRegistryListener fromPointToFeatureRegistryListener;
    private FeatureRegistryListener toPointToFeatureRegistryListener;
    private LineEditorDropBehavior dropBehavior;
    private CrsChangeListener crsChangeListener;
    private Feature fromBadGeomFeature;
    private Feature toBadGeomFeature;
    private String lineField;
    private CidsBean cidsBean;
    private XBoundingBox boundingbox;
    private boolean isAutoZoomActivated;
    private boolean inited;
    private boolean changedSinceDrop;
    private boolean isEditable;
    private boolean isDrawingFeatureEnabled;
    private LinearReferencedLineEditor mergeParentLineEditor;
    private double backupFromPointValue;
    private double backupToPointValue;
    private String otherLinesFromQueryPart;
    private String otherLinesWhereQueryPart;
    private boolean isOtherLinesEnabled;
    private List<CidsBean> otherLines;
    private Collection<LinearReferencedLineEditorListener> listeners;
    private boolean showOtherInDialog;
    private LinearReferencedLineEditor externalOthersEditor;
    private LinearReferencedLineEditor parent;
    private LinePropertyChangeListener linePropertyChangeListener;
    private boolean routeCombo;
    private boolean allowDoubleValues;
    private boolean routesComboInitialised;
    private String routeMetaClassName;
    private CidsBeanStore cidsBeanStore;
    private final ConnectionContext connectionContext;
    private JToggleButton btnFromBadGeom;
    private JButton btnFromBadGeomCorrect;
    private JButton btnFromPointSplit;
    private JToggleButton btnRoute;
    private JToggleButton btnToBadGeom;
    private JButton btnToBadGeomCorrect;
    private JButton btnToPointSplit;
    private JButton butApply;
    private JButton butCancel;
    private JComboBox cbPossibleRoute;
    private JDialog externalGeomDialog;
    private JPanel geomDialogInternalPanel;
    private JScrollPane geomDialogScrollPane;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel lblError;
    private JLabel lblFromIcon;
    private JLabel lblFromValue;
    private JLabel lblFrontPointSplit;
    private JLabel lblRoute;
    private JLabel lblToIcon;
    private JLabel lblToPointSplit;
    private JLabel lblToValue;
    private JPanel panAdd;
    private JPanel panAddFromFeature;
    private JPanel panEdit;
    private JPanel panError;
    private JPanel panFromBadGeomSpacer;
    private JPanel panLine;
    private JPanel panLinePoints;
    private JPanel panOtherLines;
    private JPanel panSpacer;
    private JPanel panToBadGeomSpacer;
    private JSpinner spnFrom;
    private JSpinner spnTo;

    @Deprecated
    public LinearReferencedLineEditor(String routeMetaClassName) {
        this(routeMetaClassName, ConnectionContext.createDeprecated());
    }

    public LinearReferencedLineEditor(String routeMetaClassName, ConnectionContext connectionContext) {
        this(true, routeMetaClassName, connectionContext);
    }

    @Deprecated
    public LinearReferencedLineEditor(boolean isEditable, String routeMetaClassName) {
        this(isEditable, routeMetaClassName, ConnectionContext.createDeprecated());
    }

    public LinearReferencedLineEditor(boolean isEditable, String routeMetaClassName, ConnectionContext connectionContext) {
        this(isEditable, isEditable, false, routeMetaClassName);
    }

    @Deprecated
    public LinearReferencedLineEditor(boolean isEditable, boolean isDrawingFeaturesEnabled, boolean routeCombo, String routeMetaClassName) {
        this(isEditable, isDrawingFeaturesEnabled, routeCombo, routeMetaClassName, ConnectionContext.createDeprecated());
    }

    public LinearReferencedLineEditor(boolean isEditable, boolean isDrawingFeaturesEnabled, boolean routeCombo, String routeMetaClassName, ConnectionContext connectionContext) {
        block4: {
            this.linearReferencingHelper = FeatureRegistry.getInstance().getLinearReferencingSolver();
            this.isFromSpinnerChangeLocked = false;
            this.isFromFeatureChangeLocked = false;
            this.isFromBeanChangeLocked = false;
            this.isToSpinnerChangeLocked = false;
            this.isToFeatureChangeLocked = false;
            this.isToBeanChangeLocked = false;
            this.isAutoZoomActivated = true;
            this.inited = false;
            this.changedSinceDrop = false;
            this.backupFromPointValue = 0.0;
            this.backupToPointValue = 0.0;
            this.isOtherLinesEnabled = true;
            this.listeners = new ArrayList<LinearReferencedLineEditorListener>();
            this.showOtherInDialog = false;
            this.parent = null;
            this.linePropertyChangeListener = new LinePropertyChangeListener();
            this.routeCombo = false;
            this.allowDoubleValues = true;
            this.routesComboInitialised = false;
            this.routeCombo = routeCombo;
            this.routeMetaClassName = routeMetaClassName;
            this.connectionContext = connectionContext;
            this.initComponents();
            final String routeNamePropertyName = this.linearReferencingHelper.getRouteNamePropertyFromRouteByClassName(routeMetaClassName);
            AutoCompleteDecorator.decorate((JComboBox)this.cbPossibleRoute, (ObjectToStringConverter)new ObjectToStringConverter(){

                public String getPreferredStringForItem(Object o) {
                    if (o instanceof CidsLayerFeature) {
                        Object prop = ((CidsLayerFeature)((Object)o)).getProperty(routeNamePropertyName);
                        if (prop == null) {
                            return "";
                        }
                        return String.valueOf(prop);
                    }
                    if (o == null) {
                        return "";
                    }
                    return o.toString();
                }
            });
            this.cbPossibleRoute.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Object newValue = value;
                    if (value instanceof CidsLayerFeature) {
                        Object prop = ((CidsLayerFeature)((Object)value)).getProperty(routeNamePropertyName);
                        if (prop != null) {
                            newValue = String.valueOf(prop);
                        }
                    } else {
                        newValue = value != null ? value.toString() : " ";
                    }
                    return super.getListCellRendererComponent((JList<?>)list, newValue, index, isSelected, cellHasFocus);
                }
            });
            this.setEditable(isEditable);
            this.setDrawingFeaturesEnabled(isDrawingFeaturesEnabled);
            try {
                if (isEditable) {
                    new LineEditorDropTarget(this);
                }
                new DropTarget(this.lblFromIcon, new PointBeanDropTargetListener(true));
                new DropTarget(this.lblToIcon, new PointBeanDropTargetListener(false));
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block4;
                LOG.debug((Object)"error while creating DropTargets", (Throwable)ex);
            }
        }
        this.initSpinnerListener(true);
        this.initSpinnerListener(false);
        this.initFeatureRegistryListener(true);
        this.initFeatureRegistryListener(false);
        this.initPointFeatureListener(true);
        this.initPointFeatureListener(false);
        this.initPointBeanChangeListener(true);
        this.initPointBeanChangeListener(false);
        this.initPointBeanMergeListener(true);
        this.initPointBeanMergeListener(false);
        this.initPointTransferHandler(true);
        this.initPointTransferHandler(false);
        this.initPointIconLabelMouseListener(true);
        this.initPointIconLabelMouseListener(false);
        if (this.isDrawingFeaturesEnabled()) {
            this.initCrsChangeListener();
            CismapBroker.getInstance().addCrsChangeListener(this.getCrsChangeListener());
        }
        new DropTarget(this.externalGeomDialog, new DropTargetAdapter(){

            @Override
            public void dragOver(DropTargetDragEvent dtde) {
                Point p;
                Point newP;
                if (dtde.getLocation().getY() < 30.0) {
                    Point p2 = LinearReferencedLineEditor.this.geomDialogScrollPane.getViewport().getViewPosition();
                    int y = (int)(p2.getY() - 5.0);
                    if (y < 0) {
                        y = 0;
                    }
                    Point newP2 = new Point((int)p2.getX(), y);
                    LinearReferencedLineEditor.this.geomDialogScrollPane.getViewport().setViewPosition(newP2);
                } else if (dtde.getLocation().getY() > (double)(LinearReferencedLineEditor.this.externalGeomDialog.getHeight() - 20) && (newP = new Point((int)(p = LinearReferencedLineEditor.this.geomDialogScrollPane.getViewport().getViewPosition()).getX(), (int)(p.getY() + 5.0))).getY() < (double)(LinearReferencedLineEditor.this.geomDialogInternalPanel.getHeight() - LinearReferencedLineEditor.this.geomDialogScrollPane.getHeight())) {
                    LinearReferencedLineEditor.this.geomDialogScrollPane.getViewport().setViewPosition(newP);
                }
            }

            @Override
            public void drop(DropTargetDropEvent dtde) {
            }
        });
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public void setRouteCombo(boolean routeCombo) {
        this.routeCombo = routeCombo;
    }

    @Override
    public void pointBeanMergeRequest(boolean fromPoint, CidsBean withPointBean) {
        this.mergeRequest(fromPoint, withPointBean);
    }

    @Override
    public void pointBeanSplitRequest(boolean fromPoint) {
        this.splitPoint(fromPoint);
    }

    public List<CidsBean> getOtherLines() {
        return this.otherLines;
    }

    public void setOtherLines(List<CidsBean> otherLines) {
        this.otherLines = otherLines;
    }

    public void setOtherLinesEnabled(boolean isOtherLinesEnabled) {
        this.isOtherLinesEnabled = isOtherLinesEnabled;
    }

    private boolean isOtherLinesEnabled() {
        return this.isOtherLinesEnabled;
    }

    protected final void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
        this.spnFrom.setVisible(isEditable);
        this.spnTo.setVisible(isEditable);
        this.lblFromValue.setVisible(!isEditable);
        this.lblToValue.setVisible(!isEditable);
        this.btnRoute.setVisible(isEditable);
        this.lblRoute.setVisible(!isEditable);
        if (this.isInited()) {
            this.refresh();
        }
    }

    public final boolean isEditable() {
        return this.isEditable;
    }

    protected final void setDrawingFeaturesEnabled(boolean isDrawingFeatureEnabled) {
        this.isDrawingFeatureEnabled = isDrawingFeatureEnabled;
        if (this.isInited()) {
            this.refresh();
        }
    }

    public final boolean isDrawingFeaturesEnabled() {
        return this.isDrawingFeatureEnabled;
    }

    private void fireLineAdded() {
        for (LinearReferencedLineEditorListener listener : this.listeners) {
            listener.linearReferencedLineCreated();
        }
    }

    private void fireOtherLinesPanelVisibilityChange(boolean visible) {
        for (LinearReferencedLineEditorListener listener : this.listeners) {
            listener.otherLinesPanelVisibilityChange(visible);
        }
    }

    public boolean addListener(LinearReferencedLineEditorListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(LinearReferencedLineEditorListener listener) {
        return this.listeners.remove(listener);
    }

    public LinearReferencedLineFeature getLineFeature() {
        return this.feature;
    }

    private void setFeature(LinearReferencedLineFeature feature) {
        this.feature = feature;
        if (feature != null) {
            LinearReferencedPointFeature fromPointFeature = feature.getPointFeature(true);
            LinearReferencedPointFeature toPointFeature = feature.getPointFeature(false);
            if (fromPointFeature != null && !fromPointFeature.isEditable()) {
                fromPointFeature.setEditable(this.isEditable());
            }
            if (toPointFeature != null && !toPointFeature.isEditable()) {
                toPointFeature.setEditable(this.isEditable());
            }
        }
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    private void cleanupLine() {
        LinearReferencedLineFeature oldFeature = this.getLineFeature();
        if (oldFeature != null) {
            CidsBean oldBean = FEATURE_REGISTRY.getCidsBean((Feature)oldFeature);
            FEATURE_REGISTRY.removeLinearReferencedLineFeature(oldBean);
            this.setFeature(null);
        }
        this.cleanupPoint(true);
        this.cleanupPoint(false);
        this.cleanOtherLinesPanel();
        this.showCard(Card.add);
        this.setInited(false);
    }

    public static void main(String[] args) throws Exception {
    }

    private void cleanupPoint(boolean isFrom) {
        Feature badGeomFeature;
        LinearReferencedPointFeature pointFeature;
        CidsBean pointBean = this.getPointBean(isFrom);
        if (pointBean != null) {
            pointBean.removePropertyChangeListener(this.getPointBeanChangeListener(isFrom));
            MERGE_REGISTRY.removeListener(pointBean, this.getPointBeanMergeListener(isFrom));
        }
        if ((pointFeature = this.getPointFeature(isFrom)) != null) {
            pointFeature.removeListener(this.getPointFeatureListener(isFrom));
            if (pointBean != null) {
                FEATURE_REGISTRY.removeStationFeature(pointBean);
            }
            FEATURE_REGISTRY.removeListener(pointBean, this.getFeatureRegistryListener(isFrom));
            this.setPointFeature(null, isFrom);
        }
        if ((badGeomFeature = this.getBadGeomFeature(isFrom)) != null) {
            MAPPING_COMPONENT.getFeatureCollection().removeFeature(badGeomFeature);
            this.setBadGeomFeature(null, isFrom);
        }
    }

    protected void setLineColor(Color color) {
        this.panLine.setBackground(color);
    }

    protected Color getLineColor() {
        return this.panLine.getBackground();
    }

    private void initLine() {
        if (!this.isCrsSupported(CismapBroker.getInstance().getSrs())) {
            this.showCrsNotSupported();
        } else if (!this.isInited()) {
            CidsBean lineBean = this.getLineBean();
            if (lineBean != null) {
                this.initPoint(true);
                this.initPoint(false);
                if (this.isDrawingFeaturesEnabled() && this.linearReferencingHelper.getGeomBeanFromLineBean(lineBean) != null) {
                    LinearReferencedLineFeature lineFeature = FEATURE_REGISTRY.addLinearReferencedLineFeature(lineBean, this.getPointFeature(true), this.getPointFeature(false));
                    lineFeature.setLinePaint((Paint)this.getLineColor());
                    this.setFeature(lineFeature);
                }
                String routeText = "Route: " + this.linearReferencingHelper.getRouteNameFromStationBean(this.getPointBean(true));
                this.fireLineAdded();
                this.pointBeanValueChanged(true);
                this.pointBeanValueChanged(false);
                this.lblRoute.setText(routeText);
                if (this.isEditable()) {
                    this.initSpinner(true);
                    this.initSpinner(false);
                    this.btnRoute.setText(routeText);
                }
                if (this.linearReferencingHelper.getGeomBeanFromLineBean(lineBean) != null) {
                    this.showCard(Card.edit);
                    this.updateOtherLinesPanelVisibility();
                }
                this.setInited(true);
            } else if (this.isEditable()) {
                this.showCard(Card.add);
            } else {
                this.setErrorMsg("keine Stationierung zugewiesen.");
                this.showCard(Card.error);
            }
        }
    }

    private void initSpinner(boolean isFrom) {
        if (this.getRouteGeometry() != null) {
            ((SpinnerNumberModel)this.getPointSpinner(isFrom).getModel()).setMaximum(Double.valueOf(Math.ceil(this.getRouteGeometry().getLength())));
        }
    }

    private void backupPointValue(boolean isFrom) {
        this.setBackupPointValue(this.getPointValue(isFrom), isFrom);
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.cleanupLine();
        this.cidsBean = cidsBean;
        if (cidsBean != null) {
            MERGE_REGISTRY.addRequestListener(cidsBean, this);
        }
        CidsBean cachedLineBean = CIDSBEAN_CACHE.getCachedBeanFor(this.getLineBean());
        CidsBean cachedFromPointBean = CIDSBEAN_CACHE.getCachedBeanFor(this.getPointBean(true));
        CidsBean cachedToPointBean = CIDSBEAN_CACHE.getCachedBeanFor(this.getPointBean(false));
        CidsBean lineBean = this.getLineBean();
        if (lineBean != null) {
            lineBean.addPropertyChangeListener((PropertyChangeListener)this.linePropertyChangeListener);
        }
        if (!this.isEditable()) {
            this.setLineBean(cachedLineBean);
            cachedFromPointBean = CIDSBEAN_CACHE.getCachedBeanFor(this.getPointBean(true));
            cachedToPointBean = CIDSBEAN_CACHE.getCachedBeanFor(this.getPointBean(false));
            this.setPointBean(cachedFromPointBean, true);
            this.setPointBean(cachedToPointBean, false);
        }
        this.backupPointValue(true);
        this.backupPointValue(false);
        if (this.isEditable() && this.isOtherLinesEnabled()) {
            this.updateOtherLinesOnBaseline();
        }
        this.btnRoute.setVisible(this.panOtherLines.getComponents().length != 0);
        this.lblRoute.setVisible(this.panOtherLines.getComponents().length == 0);
        if (this.getLineBean() != null) {
            this.setLineColor(FeatureRegistry.getNextColor(this.getLineBean()));
        }
        this.initLine();
    }

    public void setCidsBeanStore(CidsBeanStore cidsBeanStore, CidsBean line) {
        this.cidsBeanStore = cidsBeanStore;
        if (line != null) {
            this.setCidsBean(line);
        } else {
            this.setCidsBean(null);
        }
    }

    public void refresh() {
        this.cleanupLine();
        this.initLine();
        if (this.isOtherLinesEnabled && this.isInited() && this.isEditable) {
            this.updateOtherLinesOnBaseline();
        }
    }

    public boolean hasChangedSinceDrop() {
        return this.changedSinceDrop;
    }

    private void setChangedSinceDrop(boolean changedSinceDrop) {
        this.changedSinceDrop = changedSinceDrop;
    }

    private boolean isInited() {
        return this.inited;
    }

    private void setInited(boolean inited) {
        this.inited = inited;
    }

    private JButton getPointSplitButton(boolean isFrom) {
        return isFrom ? this.btnFromPointSplit : this.btnToPointSplit;
    }

    private JLabel getPointSplitLabel(boolean isFrom) {
        return isFrom ? this.lblFrontPointSplit : this.lblToPointSplit;
    }

    private static String getPointField(boolean isFrom) {
        return isFrom ? "von" : "bis";
    }

    public void setLineField(String lineField) {
        this.lineField = lineField;
    }

    private String getLineField() {
        return this.lineField;
    }

    public boolean hasBadGeomFeature() {
        return this.getBadGeomFeature(true) != null && this.getBadGeomFeature(false) != null;
    }

    private Feature getBadGeomFeature(boolean isFrom) {
        return isFrom ? this.fromBadGeomFeature : this.toBadGeomFeature;
    }

    private void setBadGeomFeature(Feature badGeomFeature, boolean isFrom) {
        if (isFrom) {
            this.fromBadGeomFeature = badGeomFeature;
        } else {
            this.toBadGeomFeature = badGeomFeature;
        }
    }

    public void setOtherLinesQueryAddition(String otherLinesFromQueryPart, String otherLinesWhereQueryPart) {
        this.otherLinesFromQueryPart = otherLinesFromQueryPart;
        this.otherLinesWhereQueryPart = otherLinesWhereQueryPart;
    }

    private void updateOtherLinesOnBaseline() {
        block7: {
            if (this.getLineBean() == null || this.getLineBean().getProperty("von.route.id") == null) break block7;
            if (this.otherLines == null) {
                int route_id = (Integer)this.getLineBean().getProperty("von.route.id");
                int id = (Integer)this.getLineBean().getProperty("id");
                MetaClass mcStationLine = this.cidsBean.getMetaObject().getMetaClass();
                MetaClass mcStation = this.linearReferencingHelper.getStationBeanFromLineBean(this.cidsBean, true).getMetaObject().getMetaClass();
                String queryOtherLines = "SELECT    " + mcStationLine.getID() + ",    station_linie." + mcStationLine.getPrimaryKey() + " FROM    " + mcStationLine.getTableName() + " AS station_linie,    " + mcStation.getTableName() + " AS station " + (this.otherLinesFromQueryPart != null ? ", " + this.otherLinesFromQueryPart + " " : "") + "WHERE    station.id = station_linie.von    AND station.route = " + route_id + "    AND station_linie.id != " + id + " " + (this.otherLinesWhereQueryPart != null ? " AND " + this.otherLinesWhereQueryPart + " station_linie.id" : "") + ";";
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)queryOtherLines);
                }
                MetaObject[] mosOtherLines = null;
                try {
                    mosOtherLines = SessionManager.getProxy().getMetaObjectByQuery(queryOtherLines, 0, this.getConnectionContext());
                }
                catch (Exception ex) {
                    LOG.error((Object)"error while loading other lines on baseline", (Throwable)ex);
                }
                this.cleanOtherLinesPanel();
                for (MetaObject moOtherLine : mosOtherLines) {
                    CidsBean otherLineBean = moOtherLine.getBean();
                    LinearReferencedLineRenderer renderer = new LinearReferencedLineRenderer(this.routeMetaClassName);
                    renderer.setMergeParentLineEditor(this);
                    renderer.setCidsBean(otherLineBean);
                    renderer.updateSplitMergeControls(true);
                    renderer.updateSplitMergeControls(false);
                    this.panOtherLines.add(renderer);
                }
            } else {
                this.cleanOtherLinesPanel();
                Collections.sort(this.otherLines, new OtherLinesComparator());
                for (CidsBean otherLineBean : this.otherLines) {
                    LinearReferencedLineRenderer renderer = new LinearReferencedLineRenderer(this.routeMetaClassName);
                    renderer.setMergeParentLineEditor(this);
                    renderer.setCidsBean(otherLineBean);
                    renderer.updateSplitMergeControls(true);
                    renderer.updateSplitMergeControls(false);
                    this.panOtherLines.add(renderer);
                }
            }
        }
    }

    private JButton getBadGeomCorrectButton(boolean isFrom) {
        return isFrom ? this.btnFromBadGeomCorrect : this.btnToBadGeomCorrect;
    }

    private JToggleButton getBadGeomButton(boolean isFrom) {
        return isFrom ? this.btnFromBadGeom : this.btnToBadGeom;
    }

    private JLabel getPointIconLabel(boolean isFrom) {
        return isFrom ? this.lblFromIcon : this.lblToIcon;
    }

    private FeatureRegistryListener getFeatureRegistryListener(boolean isFrom) {
        return isFrom ? this.fromPointToFeatureRegistryListener : this.toPointToFeatureRegistryListener;
    }

    private void setFeatureRegistryListener(FeatureRegistryListener listener, boolean isFrom) {
        if (isFrom) {
            this.fromPointToFeatureRegistryListener = listener;
        } else {
            this.toPointToFeatureRegistryListener = listener;
        }
    }

    private CrsChangeListener getCrsChangeListener() {
        return this.crsChangeListener;
    }

    private void setCrsChangeListener(CrsChangeListener crsChangeListener) {
        this.crsChangeListener = crsChangeListener;
    }

    private PropertyChangeListener getPointBeanChangeListener(boolean isFrom) {
        return isFrom ? this.fromPointBeanChangeListener : this.toPointBeanChangeListener;
    }

    private void setPointBeanChangeListener(PropertyChangeListener listener, boolean isFrom) {
        if (isFrom) {
            this.fromPointBeanChangeListener = listener;
        } else {
            this.toPointBeanChangeListener = listener;
        }
    }

    private PointBeanMergeListener getPointBeanMergeListener(boolean isFrom) {
        return isFrom ? this.fromPointBeanMergeListener : this.toPointBeanMergeListener;
    }

    private void setPointBeanMergeListener(PointBeanMergeListener listener, boolean isFrom) {
        if (isFrom) {
            this.fromPointBeanMergeListener = listener;
        } else {
            this.toPointBeanMergeListener = listener;
        }
    }

    protected LinearReferencedPointFeature getPointFeature(boolean isFrom) {
        return isFrom ? this.fromPointFeature : this.toPointFeature;
    }

    private void setPointFeature(LinearReferencedPointFeature pointFeature, boolean isFrom) {
        if (pointFeature != null && !pointFeature.isEditable()) {
            pointFeature.setEditable(this.isEditable());
        }
        if (isFrom) {
            this.fromPointFeature = pointFeature;
        } else {
            this.toPointFeature = pointFeature;
        }
        LinearReferencedLineFeature lineFeature = this.getLineFeature();
        if (lineFeature != null) {
            this.getLineFeature().setPointFeature(pointFeature, isFrom);
        }
    }

    private LinearReferencedPointFeatureListener getPointFeatureListener(boolean isFrom) {
        return isFrom ? this.fromFeatureListener : this.toFeatureListener;
    }

    private void setPointFeatureListener(LinearReferencedPointFeatureListener featureListener, boolean isFrom) {
        if (isFrom) {
            this.fromFeatureListener = featureListener;
        } else {
            this.toFeatureListener = featureListener;
        }
    }

    private JSpinner getPointSpinner(boolean isFrom) {
        return isFrom ? this.spnFrom : this.spnTo;
    }

    public LineEditorDropBehavior getDropBehavior() {
        return this.dropBehavior;
    }

    public void setDropBehavior(LineEditorDropBehavior dropBehavior) {
        this.dropBehavior = dropBehavior;
    }

    private void setBackupPointValue(double value, boolean isFrom) {
        if (isFrom) {
            this.backupFromPointValue = value;
        } else {
            this.backupToPointValue = value;
        }
    }

    private double getBackupPointValue(boolean isFrom) {
        return isFrom ? this.backupFromPointValue : this.backupToPointValue;
    }

    protected void resetPointValue(boolean isFrom) {
        this.setPointValueToBean(this.getBackupPointValue(isFrom), isFrom);
        this.pointBeanValueChanged(isFrom);
    }

    private void initPoint(boolean isFrom) {
        CidsBean pointBean = this.getPointBean(isFrom);
        if (pointBean != null) {
            pointBean.addPropertyChangeListener(this.getPointBeanChangeListener(isFrom));
            MERGE_REGISTRY.addListener(pointBean, this.getPointBeanMergeListener(isFrom));
            if (this.isEditable()) {
                double distance = this.linearReferencingHelper.distanceOfStationGeomToRouteGeomFromStationBean(pointBean);
                if (distance > 1.0) {
                    this.setBadGeomFeature(StationEditor.createBadGeomFeature(this.linearReferencingHelper.getPointGeometryFromStationBean(pointBean)), isFrom);
                } else {
                    this.setBadGeomFeature(null, isFrom);
                }
            }
            if (this.isDrawingFeaturesEnabled() && this.linearReferencingHelper.getPointGeometryFromStationBean(pointBean) != null) {
                FEATURE_REGISTRY.addListener(pointBean, this.getFeatureRegistryListener(isFrom));
                LinearReferencedPointFeature pointFeature = FEATURE_REGISTRY.addStationFeature(pointBean);
                pointFeature.addListener(this.getPointFeatureListener(isFrom));
                this.setPointFeature(pointFeature, isFrom);
            }
        }
        this.updateBadGeomButton(isFrom);
        this.updateSplitMergeControls(isFrom);
    }

    private void setPoint(CidsBean pointBean, boolean isFrom) {
        this.cleanupPoint(isFrom);
        this.setPointBean(pointBean, isFrom);
        this.initPoint(isFrom);
    }

    private void switchBadGeomVisibility(boolean isFrom) {
        if (this.isEditable()) {
            Feature badGeomFeature = this.getBadGeomFeature(isFrom);
            LinearReferencedPointFeature pointFeature = this.getPointFeature(isFrom);
            boolean selected = this.getBadGeomButton(isFrom).isSelected();
            if (selected) {
                this.boundingbox = (XBoundingBox)MAPPING_COMPONENT.getCurrentBoundingBox();
                MAPPING_COMPONENT.getFeatureCollection().addFeature(badGeomFeature);
                MAPPING_COMPONENT.getFeatureCollection().select((Feature)pointFeature);
                this.zoomToBadFeature(isFrom);
            } else {
                MAPPING_COMPONENT.getFeatureCollection().removeFeature(badGeomFeature);
                MAPPING_COMPONENT.gotoBoundingBoxWithoutHistory((BoundingBox)this.boundingbox);
            }
            this.getBadGeomCorrectButton(isFrom).setVisible(selected);
        }
    }

    private void zoomToBadFeature(boolean isFrom) {
        Feature badGeomFeature = this.getBadGeomFeature(isFrom);
        ArrayList<Object> aFeatureCollection = new ArrayList<Object>();
        aFeatureCollection.add(badGeomFeature);
        aFeatureCollection.add(this.getLineFeature());
        MAPPING_COMPONENT.zoomToAFeatureCollection(aFeatureCollection, false, MAPPING_COMPONENT.isFixedMapScale());
    }

    public Collection<Feature> getZoomFeatures() {
        ArrayList<Feature> zoomFeatures = new ArrayList<Feature>();
        this.addZoomFeaturesToCollection(zoomFeatures);
        return zoomFeatures;
    }

    public void addZoomFeaturesToCollection(Collection<Feature> collection) {
        LinearReferencedPointFeature fromPointFeature = this.getPointFeature(true);
        LinearReferencedPointFeature toPointFeature = this.getPointFeature(false);
        if (fromPointFeature != null && toPointFeature != null) {
            PureNewFeature boundedFromFeature = new PureNewFeature(fromPointFeature.getGeometry().buffer(500.0));
            PureNewFeature boundedToFeature = new PureNewFeature(toPointFeature.getGeometry().buffer(500.0));
            collection.add((Feature)boundedFromFeature);
            collection.add((Feature)boundedToFeature);
        }
    }

    private void correctBadGeom(boolean isFrom) {
        if (this.isEditable()) {
            LinearReferencedPointFeature feature = this.getPointFeature(isFrom);
            Feature badFeature = this.getBadGeomFeature(isFrom);
            feature.moveTo(badFeature.getGeometry().getCoordinate(), null);
            this.zoomToBadFeature(isFrom);
        }
    }

    private void showCard(Card card) {
        switch (card) {
            case edit: {
                ((CardLayout)this.getLayout()).show(this, "edit");
                break;
            }
            case add: {
                if (this.routeCombo) {
                    this.fillRoutesCombo();
                    ((CardLayout)this.getLayout()).show(this, "addFeature");
                    break;
                }
                ((CardLayout)this.getLayout()).show(this, "add");
                break;
            }
            case error: {
                ((CardLayout)this.getLayout()).show(this, "error");
            }
        }
    }

    public static void fillFromRoute(CidsBean routeBean, CidsBean cidsBean, String lineField) {
        block2: {
            try {
                CidsBean linieBean = FeatureRegistry.getInstance().getLinearReferencingSolver().createLineBeanFromRouteBean(routeBean);
                cidsBean.setProperty(lineField, (Object)linieBean);
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)"Error while filling bean", (Throwable)ex);
            }
        }
    }

    public void dispose() {
        this.cleanupLine();
        MERGE_REGISTRY.removeRequestListener(this.cidsBean, this);
        CismapBroker.getInstance().removeCrsChangeListener(this.getCrsChangeListener());
    }

    private void initFeatureRegistryListener(final boolean isFrom) {
        FeatureRegistryListener featureRegistryListener = new FeatureRegistryListener(){

            @Override
            public void FeatureCountChanged() {
                LinearReferencedLineEditor.this.updateSplitMergeControls(isFrom);
            }
        };
        this.setFeatureRegistryListener(featureRegistryListener, isFrom);
    }

    private void initSpinnerListener(final boolean isFrom) {
        JSpinner spinner = this.getPointSpinner(isFrom);
        ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent de) {
                LinearReferencedLineEditor.this.spinnerValueChanged(isFrom);
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
                LinearReferencedLineEditor.this.spinnerValueChanged(isFrom);
            }

            @Override
            public void changedUpdate(DocumentEvent de) {
                LinearReferencedLineEditor.this.spinnerValueChanged(isFrom);
            }
        });
        ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent fe) {
                LinearReferencingSingletonInstances.MAPPING_COMPONENT.getFeatureCollection().select((Feature)LinearReferencedLineEditor.this.getPointFeature(isFrom));
            }
        });
    }

    private void initPointFeatureListener(final boolean isFrom) {
        LinearReferencedPointFeatureListener featureListener = new LinearReferencedPointFeatureListener(){

            public void featureMoved(LinearReferencedPointFeature pointFeature) {
                LinearReferencedLineEditor.this.featureValueChanged(isFrom);
            }

            public void featureMerged(LinearReferencedPointFeature mergePoint, LinearReferencedPointFeature withPoint) {
            }
        };
        this.setPointFeatureListener(featureListener, isFrom);
    }

    private void initCrsChangeListener() {
        this.setCrsChangeListener(new CrsChangeListener(){

            public void crsChanged(CrsChangedEvent event) {
                if (!LinearReferencedLineEditor.this.isCrsSupported(event.getCurrentCrs())) {
                    LinearReferencedLineEditor.this.showCrsNotSupported();
                } else {
                    LinearReferencedLineEditor.this.initLine();
                }
            }
        });
    }

    private void showCrsNotSupported() {
        this.cleanupLine();
        this.setErrorMsg("Das aktuelle CRS wird vom Stationierungseditor nicht unterst\u00fctzt.");
        this.showCard(Card.error);
    }

    private void setErrorMsg(String msg) {
        this.lblError.setText(msg);
    }

    private boolean isCrsSupported(Crs crs) {
        return CrsTransformer.extractSridFromCrs((String)crs.getCode()) == 35833 || CrsTransformer.extractSridFromCrs((String)crs.getCode()) == 5650;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void featureValueChanged(boolean isFrom) {
        if (this.isEditable()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"feature changed", (Throwable)new CurrentStackTrace());
            }
            try {
                this.lockFeatureChange(true, isFrom);
                if (!this.isBeanChangeLocked(isFrom)) {
                    LinearReferencedPointFeature linearRefFeature = this.getPointFeature(isFrom);
                    double value = this.round(linearRefFeature.getCurrentPosition());
                    this.setPointValueToBean(value, isFrom);
                }
            }
            finally {
                this.lockFeatureChange(false, isFrom);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spinnerValueChanged(boolean isFrom) {
        if (this.isEditable()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"spinner changed", (Throwable)new CurrentStackTrace());
            }
            try {
                this.lockSpinnerChange(true, isFrom);
                JFormattedTextField.AbstractFormatter formatter = ((JSpinner.DefaultEditor)this.getPointSpinner(isFrom).getEditor()).getTextField().getFormatter();
                String text = ((JSpinner.DefaultEditor)this.getPointSpinner(isFrom).getEditor()).getTextField().getText();
                if (!text.isEmpty()) {
                    try {
                        double value = (Double)formatter.stringToValue(text);
                        this.setPointValueToBean(value, isFrom);
                    }
                    catch (ParseException ex) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"error parsing spinner", (Throwable)ex);
                        }
                    }
                }
            }
            finally {
                this.lockSpinnerChange(false, isFrom);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pointBeanValueChanged(boolean isFrom) {
        try {
            Double value;
            this.lockBeanChange(true, isFrom);
            this.setChangedSinceDrop(true);
            CidsBean pointBean = this.getPointBean(isFrom);
            if (pointBean != null && (value = (Double)pointBean.getProperty("wert")) != null) {
                if (this.isEditable()) {
                    this.setPointValueToSpinner(value, isFrom);
                } else {
                    this.setPointValueToLabel(value, isFrom);
                }
                if (this.isDrawingFeaturesEnabled()) {
                    this.setPointValueToFeature(value, isFrom);
                }
                if (this.isInited()) {
                    this.updateRealGeoms(isFrom);
                }
            }
        }
        finally {
            this.lockBeanChange(false, isFrom);
        }
    }

    public void updateRealGeoms() {
        this.updateRealGeoms(true);
        this.updateRealGeoms(false);
    }

    private JLabel getValueLabel(boolean isFrom) {
        return isFrom ? this.lblFromValue : this.lblToValue;
    }

    private void setPointValueToLabel(double value, boolean isFrom) {
        JLabel valueLabel = this.getValueLabel(isFrom);
        valueLabel.setText(decimalFormat.format(this.round(value)));
    }

    public double getPointValue(boolean isFrom) {
        CidsBean pointBean = this.getPointBean(isFrom);
        if (pointBean != null) {
            return this.linearReferencingHelper.getLinearValueFromStationBean(pointBean);
        }
        return 0.0;
    }

    protected void updateSplitMergeControls(boolean isFrom) {
        if (this.isEditable()) {
            boolean isPointMerged = this.isPointMerged(isFrom);
            if (this.btnRoute.isSelected()) {
                this.getPointSplitButton(isFrom).setVisible(isPointMerged);
                this.getPointSplitLabel(isFrom).setVisible(false);
            } else {
                this.getPointSplitButton(isFrom).setVisible(false);
                this.getPointSplitLabel(isFrom).setVisible(isPointMerged);
                this.getPointSplitLabel(isFrom).setIcon(isFrom ? ICON_MERGED_WITH_FROM_POINT : ICON_MERGED_WITH_TO_POINT);
            }
        } else {
            this.getPointSplitButton(isFrom).setVisible(false);
            LinearReferencedLineEditor editor = this.getMergeParentLineEditor();
            JLabel lblPointSplit = this.getPointSplitLabel(isFrom);
            if (editor == null) {
                lblPointSplit.setVisible(false);
            } else if (this.getPointBean(isFrom).equals((Object)editor.getPointBean(true))) {
                lblPointSplit.setIcon(ICON_MERGED_WITH_FROM_POINT);
                lblPointSplit.setVisible(true);
            } else if (this.getPointBean(isFrom).equals((Object)editor.getPointBean(false))) {
                lblPointSplit.setIcon(ICON_MERGED_WITH_TO_POINT);
                lblPointSplit.setVisible(true);
            } else {
                lblPointSplit.setVisible(false);
            }
        }
    }

    private boolean isPointMerged(boolean isFrom) {
        if (this.getLineBean() != null) {
            CidsBean pointBean = this.getPointBean(isFrom);
            for (Component component : this.panOtherLines.getComponents()) {
                LinearReferencedLineRenderer renderer = (LinearReferencedLineRenderer)component;
                CidsBean fromPointBean = renderer.getPointBean(true);
                CidsBean toPointBean = renderer.getPointBean(false);
                if (fromPointBean != null && fromPointBean.equals((Object)pointBean)) {
                    return true;
                }
                if (toPointBean == null || !toPointBean.equals((Object)pointBean)) continue;
                return true;
            }
        }
        return false;
    }

    private void updateBadGeomButton(boolean isFrom) {
        boolean visible = this.isEditable() && this.getBadGeomFeature(isFrom) != null;
        this.getBadGeomButton(isFrom).setVisible(visible);
        this.getBadGeomCorrectButton(isFrom).setVisible(visible && this.getBadGeomButton(isFrom).isSelected());
    }

    private void setPointValueToSpinner(double value, boolean isFrom) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"change spinner");
        }
        if (!this.isSpinnerChangeLocked(isFrom)) {
            JSpinner pointSpinner = this.getPointSpinner(isFrom);
            pointSpinner.setValue(this.round(value));
        }
    }

    private void setPointValueToFeature(double value, boolean isFrom) {
        if (!this.isFeatureChangeLocked(isFrom)) {
            LinearReferencedPointFeature pointFeature = this.getPointFeature(isFrom);
            if (pointFeature != null) {
                pointFeature.setInfoFormat((Format)decimalFormat);
                pointFeature.moveToPosition(value);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"there are no feature to move");
            }
        }
    }

    private void updateRealGeoms(boolean isFrom) {
        block6: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"update real geom");
            }
            try {
                LinearReferencedPointFeature pointFeature = this.getPointFeature(isFrom);
                CidsBean pointBean = this.getPointBean(isFrom);
                if (pointFeature != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"change station geom");
                    }
                    Geometry pointGeom = LinearReferencedPointFeature.getPointOnLine((double)this.linearReferencingHelper.getLinearValueFromStationBean(pointBean), (Geometry)this.linearReferencingHelper.getRouteGeometryFromStationBean(pointBean));
                    pointGeom.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
                    this.linearReferencingHelper.setPointGeometryToStationBean(pointGeom, pointBean);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"change line geom");
                }
                Geometry lineGeom = LinearReferencedLineFeature.createSubline((double)this.getPointValue(true), (double)this.getPointValue(false), (Geometry)this.linearReferencingHelper.getRouteGeometryFromStationBean(this.getPointBean(isFrom)));
                lineGeom.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
                this.setLineGeometry(lineGeom);
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block6;
                LOG.debug((Object)"Error while setting real geoms", (Throwable)ex);
            }
        }
    }

    private void setPointValueToBean(double value, boolean isFrom) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("change bean value to " + value));
        }
        if (!this.isBeanChangeLocked(isFrom)) {
            CidsBean pointBean = this.getPointBean(isFrom);
            double oldValue = this.linearReferencingHelper.getLinearValueFromStationBean(pointBean);
            if (oldValue != this.round(value)) {
                try {
                    this.linearReferencingHelper.setLinearValueToStationBean(this.round(value), pointBean);
                }
                catch (Exception ex) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"error changing bean", (Throwable)ex);
                    }
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("no changes needed, old value was " + oldValue));
            }
        }
    }

    private boolean isFeatureChangeLocked(boolean isFrom) {
        return isFrom ? this.isFromFeatureChangeLocked : this.isToFeatureChangeLocked;
    }

    private boolean isSpinnerChangeLocked(boolean isFrom) {
        return isFrom ? this.isFromSpinnerChangeLocked : this.isToSpinnerChangeLocked;
    }

    private boolean isBeanChangeLocked(boolean isFrom) {
        return isFrom ? this.isFromBeanChangeLocked : this.isToBeanChangeLocked;
    }

    private void lockFeatureChange(boolean lock, boolean isFrom) {
        if (isFrom) {
            this.isFromFeatureChangeLocked = lock;
        } else {
            this.isToFeatureChangeLocked = lock;
        }
    }

    private void lockSpinnerChange(boolean lock, boolean isFrom) {
        if (isFrom) {
            this.isFromSpinnerChangeLocked = lock;
        } else {
            this.isToSpinnerChangeLocked = lock;
        }
    }

    private void lockBeanChange(boolean lock, boolean isFrom) {
        if (isFrom) {
            this.isFromBeanChangeLocked = lock;
        } else {
            this.isToBeanChangeLocked = lock;
        }
    }

    private void initPointBeanChangeListener(final boolean isFrom) {
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                if (pce.getPropertyName().equals("wert")) {
                    LinearReferencedLineEditor.this.pointBeanValueChanged(isFrom);
                }
            }
        };
        this.setPointBeanChangeListener(listener, isFrom);
    }

    private void initPointBeanMergeListener(final boolean isFrom) {
        PointBeanMergeListener listener = new PointBeanMergeListener(){

            @Override
            public void pointBeanMerged(CidsBean pointBean) {
                LinearReferencedLineEditor.this.updateSplitMergeControls(isFrom);
                LinearReferencedLineEditor.this.refresh();
            }

            @Override
            public void pointBeanSplitted() {
                LinearReferencedLineEditor.this.updateSplitMergeControls(isFrom);
                LinearReferencedLineEditor.this.resetPointValue(isFrom);
                LinearReferencedLineEditor.this.refresh();
            }
        };
        this.setPointBeanMergeListener(listener, isFrom);
    }

    private void initPointTransferHandler(boolean isFrom) {
        this.getPointIconLabel(isFrom).setTransferHandler(new PointBeanTransferHandler(isFrom));
    }

    private void initPointIconLabelMouseListener(final boolean isFrom) {
        this.getPointIconLabel(isFrom).addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                boolean isNew;
                boolean bl = isNew = LinearReferencedLineEditor.this.getPointBean(isFrom).getMetaObject().getStatus() == 1;
                if (LinearReferencedLineEditor.this.isEditable() && !LinearReferencedLineEditor.this.isPointMerged(isFrom)) {
                    JComponent comp = (JComponent)evt.getSource();
                    TransferHandler th = comp.getTransferHandler();
                    th.exportAsDrag(comp, evt, 1);
                }
            }
        });
    }

    private Geometry getRouteGeometry() {
        CidsBean routeGeomBean = this.getRouteGeomBean();
        if (routeGeomBean == null) {
            return null;
        }
        return (Geometry)routeGeomBean.getProperty("geo_field");
    }

    protected CidsBean getPointBean(boolean isFrom) {
        CidsBean pointBean = this.linearReferencingHelper.getStationBeanFromLineBean(this.getLineBean(), isFrom);
        return pointBean;
    }

    protected CidsBean getLineBean() {
        if (this.getLineField() == null) {
            return this.getCidsBean();
        }
        CidsBean lineBean = LinearReferencedLineEditor.getLineBean(this.getCidsBean(), this.getLineField());
        return lineBean;
    }

    private static CidsBean getLineBean(CidsBean cidsBean, String lineField) {
        if (cidsBean == null) {
            return null;
        }
        return (CidsBean)cidsBean.getProperty(lineField);
    }

    private CidsBean getRouteBean() {
        CidsBean pointBean = this.getPointBean(true);
        if (pointBean == null) {
            return null;
        }
        return (CidsBean)pointBean.getProperty("route");
    }

    private CidsBean getRouteGeomBean() {
        CidsBean routeBean = this.getRouteBean();
        if (routeBean == null) {
            return null;
        }
        return (CidsBean)routeBean.getProperty("geom");
    }

    private void setLineGeometry(Geometry line) throws Exception {
        this.linearReferencingHelper.setGeometryToLineBean(line, this.getLineBean());
        if (this.getLineBean() != null) {
            this.getLineBean().setArtificialChangeFlag(true);
        }
    }

    @Override
    public void setEnabled(boolean bln) {
        super.setEnabled(bln);
        this.jLabel3.setVisible(bln);
        this.getPointSpinner(true).setEnabled(bln);
        this.getPointSpinner(false).setEnabled(bln);
    }

    private void initComponents() {
        this.externalGeomDialog = new JDialog(StaticSwingTools.getParentFrame((Component)this));
        this.geomDialogScrollPane = new JScrollPane();
        this.geomDialogInternalPanel = new JPanel();
        this.panEdit = new JPanel();
        this.panLinePoints = new JPanel();
        this.lblFromIcon = new JLabel();
        this.lblToIcon = new JLabel();
        this.spnFrom = new JSpinner();
        this.spnTo = new JSpinner();
        this.lblFromValue = new JLabel();
        this.lblToValue = new JLabel();
        this.panFromBadGeomSpacer = new JPanel();
        this.btnFromBadGeom = new JToggleButton();
        this.btnFromBadGeomCorrect = new JButton();
        this.panToBadGeomSpacer = new JPanel();
        this.btnToBadGeomCorrect = new JButton();
        this.btnToBadGeom = new JToggleButton();
        this.lblToPointSplit = new JLabel();
        this.lblFrontPointSplit = new JLabel();
        this.btnFromPointSplit = new JButton();
        this.btnToPointSplit = new JButton();
        this.lblRoute = new JLabel();
        this.btnRoute = new JToggleButton();
        this.panLine = new JPanel();
        this.panOtherLines = new JPanel();
        this.panSpacer = new JPanel();
        this.panAdd = new JPanel();
        this.jLabel3 = new JLabel();
        this.panError = new JPanel();
        this.lblError = new JLabel();
        this.panAddFromFeature = new JPanel();
        this.jLabel4 = new JLabel();
        this.cbPossibleRoute = new JComboBox();
        this.butApply = new JButton();
        this.butCancel = new JButton();
        this.externalGeomDialog.setDefaultCloseOperation(2);
        this.externalGeomDialog.setTitle(NbBundle.getMessage(LinearReferencedLineEditor.class, (String)"LinearReferencedLineEditor.externalGeomDialog.title"));
        this.externalGeomDialog.getContentPane().setLayout(new GridBagLayout());
        this.geomDialogInternalPanel.setLayout(new GridBagLayout());
        this.geomDialogScrollPane.setViewportView(this.geomDialogInternalPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.externalGeomDialog.getContentPane().add((Component)this.geomDialogScrollPane, gridBagConstraints);
        this.setOpaque(false);
        this.setLayout(new CardLayout());
        this.panEdit.setOpaque(false);
        this.panEdit.setLayout(new GridBagLayout());
        this.panLinePoints.setOpaque(false);
        this.panLinePoints.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LinearReferencedLineEditor.this.panLinePointsMouseClicked(evt);
            }
        });
        this.panLinePoints.setLayout(new GridBagLayout());
        this.lblFromIcon.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/linearreferencing/station.png")));
        this.lblFromIcon.setText(NbBundle.getMessage(LinearReferencedLineEditor.class, (String)"LinearReferencedLineEditor.lblFromIcon.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.panLinePoints.add((Component)this.lblFromIcon, gridBagConstraints);
        this.lblToIcon.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/linearreferencing/station.png")));
        this.lblToIcon.setText(NbBundle.getMessage(LinearReferencedLineEditor.class, (String)"LinearReferencedLineEditor.lblToIcon.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 15);
        this.panLinePoints.add((Component)this.lblToIcon, gridBagConstraints);
        this.spnFrom.setModel(new SpinnerNumberModel(0.0, 0.0, 0.0, 1.0));
        this.spnFrom.setEditor(new JSpinner.NumberEditor(this.spnFrom, "###.00"));
        this.spnFrom.setMinimumSize(new Dimension(100, 28));
        this.spnFrom.setPreferredSize(new Dimension(100, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.panLinePoints.add((Component)this.spnFrom, gridBagConstraints);
        this.spnTo.setModel(new SpinnerNumberModel(0.0, 0.0, 0.0, 1.0));
        this.spnTo.setEditor(new JSpinner.NumberEditor(this.spnTo, "###.00"));
        this.spnTo.setMinimumSize(new Dimension(100, 28));
        this.spnTo.setPreferredSize(new Dimension(100, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weighty = 1.0;
        this.panLinePoints.add((Component)this.spnTo, gridBagConstraints);
        this.lblFromValue.setHorizontalAlignment(11);
        this.lblFromValue.setBorder(BorderFactory.createEtchedBorder());
        this.lblFromValue.setMaximumSize(new Dimension(100, 28));
        this.lblFromValue.setMinimumSize(new Dimension(100, 28));
        this.lblFromValue.setPreferredSize(new Dimension(100, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.panLinePoints.add((Component)this.lblFromValue, gridBagConstraints);
        this.lblToValue.setHorizontalAlignment(11);
        this.lblToValue.setBorder(BorderFactory.createEtchedBorder());
        this.lblToValue.setMaximumSize(new Dimension(100, 28));
        this.lblToValue.setMinimumSize(new Dimension(100, 28));
        this.lblToValue.setPreferredSize(new Dimension(100, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weighty = 1.0;
        this.panLinePoints.add((Component)this.lblToValue, gridBagConstraints);
        this.panFromBadGeomSpacer.setMaximumSize(new Dimension(86, 28));
        this.panFromBadGeomSpacer.setMinimumSize(new Dimension(86, 28));
        this.panFromBadGeomSpacer.setOpaque(false);
        this.panFromBadGeomSpacer.setPreferredSize(new Dimension(86, 28));
        this.panFromBadGeomSpacer.setLayout(new FlowLayout(1, 0, 0));
        this.btnFromBadGeom.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/linearreferencing/exclamation.png")));
        this.btnFromBadGeom.setText(NbBundle.getMessage(LinearReferencedLineEditor.class, (String)"LinearReferencedLineEditor.btnFromBadGeom.text"));
        this.btnFromBadGeom.setToolTipText(NbBundle.getMessage(LinearReferencedLineEditor.class, (String)"LinearReferencedLineEditor.btnFromBadGeom.toolTipText"));
        this.btnFromBadGeom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LinearReferencedLineEditor.this.btnFromBadGeomActionPerformed(evt);
            }
        });
        this.panFromBadGeomSpacer.add(this.btnFromBadGeom);
        this.btnFromBadGeomCorrect.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/linearreferencing/node-delete.png")));
        this.btnFromBadGeomCorrect.setText(NbBundle.getMessage(LinearReferencedLineEditor.class, (String)"LinearReferencedLineEditor.btnFromBadGeomCorrect.text_1"));
        this.btnFromBadGeomCorrect.setToolTipText(NbBundle.getMessage(LinearReferencedLineEditor.class, (String)"LinearReferencedLineEditor.btnFromBadGeomCorrect.toolTipText"));
        this.btnFromBadGeomCorrect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LinearReferencedLineEditor.this.btnFromBadGeomCorrectActionPerformed(evt);
            }
        });
        this.panFromBadGeomSpacer.add(this.btnFromBadGeomCorrect);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.panLinePoints.add((Component)this.panFromBadGeomSpacer, gridBagConstraints);
        this.panToBadGeomSpacer.setMaximumSize(new Dimension(86, 28));
        this.panToBadGeomSpacer.setMinimumSize(new Dimension(86, 28));
        this.panToBadGeomSpacer.setOpaque(false);
        this.panToBadGeomSpacer.setPreferredSize(new Dimension(86, 28));
        this.panToBadGeomSpacer.setLayout(new FlowLayout(1, 0, 0));
        this.btnToBadGeomCorrect.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/linearreferencing/node-delete-child.png")));
        this.btnToBadGeomCorrect.setText(NbBundle.getMessage(LinearReferencedLineEditor.class, (String)"LinearReferencedLineEditor.btnToBadGeomCorrect.text_1"));
        this.btnToBadGeomCorrect.setToolTipText(NbBundle.getMessage(LinearReferencedLineEditor.class, (String)"LinearReferencedLineEditor.btnToBadGeomCorrect.toolTipText"));
        this.btnToBadGeomCorrect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LinearReferencedLineEditor.this.btnToBadGeomCorrectActionPerformed(evt);
            }
        });
        this.panToBadGeomSpacer.add(this.btnToBadGeomCorrect);
        this.btnToBadGeom.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/linearreferencing/exclamation.png")));
        this.btnToBadGeom.setText(NbBundle.getMessage(LinearReferencedLineEditor.class, (String)"LinearReferencedLineEditor.btnToBadGeom.text"));
        this.btnToBadGeom.setToolTipText(NbBundle.getMessage(LinearReferencedLineEditor.class, (String)"LinearReferencedLineEditor.btnToBadGeom.toolTipText"));
        this.btnToBadGeom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LinearReferencedLineEditor.this.btnToBadGeomActionPerformed(evt);
            }
        });
        this.panToBadGeomSpacer.add(this.btnToBadGeom);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.panLinePoints.add((Component)this.panToBadGeomSpacer, gridBagConstraints);
        this.lblToPointSplit.setText(NbBundle.getMessage(LinearReferencedLineEditor.class, (String)"LinearReferencedLineEditor.lblToPointSplit.text"));
        this.lblToPointSplit.setToolTipText(NbBundle.getMessage(LinearReferencedLineEditor.class, (String)"LinearReferencedLineEditor.lblToPointSplit.toolTipText"));
        this.lblToPointSplit.setMaximumSize(new Dimension(16, 16));
        this.lblToPointSplit.setMinimumSize(new Dimension(16, 16));
        this.lblToPointSplit.setPreferredSize(new Dimension(16, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        this.panLinePoints.add((Component)this.lblToPointSplit, gridBagConstraints);
        this.lblFrontPointSplit.setText(NbBundle.getMessage(LinearReferencedLineEditor.class, (String)"LinearReferencedLineEditor.lblFrontPointSplit.text_1"));
        this.lblFrontPointSplit.setToolTipText(NbBundle.getMessage(LinearReferencedLineEditor.class, (String)"LinearReferencedLineEditor.lblFrontPointSplit.toolTipText"));
        this.lblFrontPointSplit.setMaximumSize(new Dimension(16, 16));
        this.lblFrontPointSplit.setMinimumSize(new Dimension(16, 16));
        this.lblFrontPointSplit.setPreferredSize(new Dimension(16, 16));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.panLinePoints.add((Component)this.lblFrontPointSplit, gridBagConstraints);
        this.btnFromPointSplit.setIcon(ICON_MERGED_WITH_FROM_POINT);
        this.btnFromPointSplit.setText(NbBundle.getMessage(LinearReferencedLineEditor.class, (String)"LinearReferencedLineEditor.btnFromPointSplit.text"));
        this.btnFromPointSplit.setToolTipText(NbBundle.getMessage(LinearReferencedLineEditor.class, (String)"LinearReferencedLineEditor.btnFromPointSplit.toolTipText"));
        this.btnFromPointSplit.setMaximumSize(new Dimension(28, 28));
        this.btnFromPointSplit.setMinimumSize(new Dimension(28, 28));
        this.btnFromPointSplit.setPreferredSize(new Dimension(28, 28));
        this.btnFromPointSplit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LinearReferencedLineEditor.this.btnFromPointSplitActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        this.panLinePoints.add((Component)this.btnFromPointSplit, gridBagConstraints);
        this.btnToPointSplit.setIcon(ICON_MERGED_WITH_TO_POINT);
        this.btnToPointSplit.setText(NbBundle.getMessage(LinearReferencedLineEditor.class, (String)"LinearReferencedLineEditor.btnToPointSplit.text"));
        this.btnToPointSplit.setToolTipText(NbBundle.getMessage(LinearReferencedLineEditor.class, (String)"LinearReferencedLineEditor.btnToPointSplit.toolTipText"));
        this.btnToPointSplit.setMaximumSize(new Dimension(28, 28));
        this.btnToPointSplit.setMinimumSize(new Dimension(28, 28));
        this.btnToPointSplit.setPreferredSize(new Dimension(28, 28));
        this.btnToPointSplit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LinearReferencedLineEditor.this.btnToPointSplitActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        this.panLinePoints.add((Component)this.btnToPointSplit, gridBagConstraints);
        this.lblRoute.setHorizontalAlignment(0);
        this.lblRoute.setText(NbBundle.getMessage(LinearReferencedLineEditor.class, (String)"LinearReferencedLineEditor.lblRoute.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.panLinePoints.add((Component)this.lblRoute, gridBagConstraints);
        this.btnRoute.setText(NbBundle.getMessage(LinearReferencedLineEditor.class, (String)"LinearReferencedLineEditor.btnRoute.text"));
        this.btnRoute.setToolTipText(NbBundle.getMessage(LinearReferencedLineEditor.class, (String)"LinearReferencedLineEditor.btnRoute.toolTipText"));
        this.btnRoute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LinearReferencedLineEditor.this.btnRouteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.panLinePoints.add((Component)this.btnRoute, gridBagConstraints);
        this.panLine.setBackground(new Color(255, 91, 0));
        this.panLine.setMinimumSize(new Dimension(10, 3));
        this.panLine.setPreferredSize(new Dimension(100, 3));
        this.panLine.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                LinearReferencedLineEditor.this.panLineMouseClicked(evt);
            }
        });
        this.panLine.setLayout(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.panLinePoints.add((Component)this.panLine, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.panEdit.add((Component)this.panLinePoints, gridBagConstraints);
        this.panOtherLines.setOpaque(false);
        this.panOtherLines.setLayout(new BoxLayout(this.panOtherLines, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.panEdit.add((Component)this.panOtherLines, gridBagConstraints);
        this.panSpacer.setMaximumSize(new Dimension(0, 0));
        this.panSpacer.setMinimumSize(new Dimension(0, 0));
        this.panSpacer.setOpaque(false);
        this.panSpacer.setPreferredSize(new Dimension(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        this.panEdit.add((Component)this.panSpacer, gridBagConstraints);
        this.add((Component)this.panEdit, "edit");
        this.panAdd.setOpaque(false);
        this.panAdd.setLayout(new GridBagLayout());
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText(NbBundle.getMessage(LinearReferencedLineEditor.class, (String)"LinearReferencedLineEditor.jLabel3.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.panAdd.add((Component)this.jLabel3, gridBagConstraints);
        this.add((Component)this.panAdd, "add");
        this.panError.setOpaque(false);
        this.panError.setLayout(new GridBagLayout());
        this.lblError.setText(NbBundle.getMessage(LinearReferencedLineEditor.class, (String)"LinearReferencedLineEditor.lblError.text_1"));
        this.panError.add((Component)this.lblError, new GridBagConstraints());
        this.add((Component)this.panError, "error");
        this.panAddFromFeature.setOpaque(false);
        this.panAddFromFeature.setLayout(new GridBagLayout());
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText(NbBundle.getMessage(LinearReferencedLineEditor.class, (String)"LinearReferencedLineEditor.jLabel4.text_1"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.panAddFromFeature.add((Component)this.jLabel4, gridBagConstraints);
        this.cbPossibleRoute.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbPossibleRoute.setPreferredSize(new Dimension(300, 20));
        this.cbPossibleRoute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LinearReferencedLineEditor.this.cbPossibleRouteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.panAddFromFeature.add((Component)this.cbPossibleRoute, gridBagConstraints);
        this.butApply.setText(NbBundle.getMessage(LinearReferencedLineEditor.class, (String)"LinearReferencedLineEditor.butApply.text_1", (Object[])new Object[0]));
        this.butApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LinearReferencedLineEditor.this.butApplyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.panAddFromFeature.add((Component)this.butApply, gridBagConstraints);
        this.butCancel.setText(NbBundle.getMessage(LinearReferencedLineEditor.class, (String)"LinearReferencedLineEditor.butCancel.text_1", (Object[])new Object[0]));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LinearReferencedLineEditor.this.butCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.panAddFromFeature.add((Component)this.butCancel, gridBagConstraints);
        this.add((Component)this.panAddFromFeature, "addFeature");
    }

    private void btnFromPointSplitActionPerformed(ActionEvent evt) {
        this.splitPoint(true);
    }

    private void btnToPointSplitActionPerformed(ActionEvent evt) {
        this.splitPoint(false);
    }

    private void btnToBadGeomCorrectActionPerformed(ActionEvent evt) {
        this.correctBadGeom(false);
    }

    private void btnToBadGeomActionPerformed(ActionEvent evt) {
        this.switchBadGeomVisibility(false);
    }

    private void btnFromBadGeomCorrectActionPerformed(ActionEvent evt) {
        this.correctBadGeom(true);
    }

    private void btnFromBadGeomActionPerformed(ActionEvent evt) {
        this.switchBadGeomVisibility(true);
    }

    private void btnRouteActionPerformed(ActionEvent evt) {
        this.updateOtherLinesPanelVisibility();
    }

    private void cbPossibleRouteActionPerformed(ActionEvent evt) {
    }

    private void butApplyActionPerformed(ActionEvent evt) {
        if (this.isEnabled() && this.isEditable() && this.cbPossibleRoute.getSelectedItem() instanceof CidsLayerFeature) {
            CidsLayerFeature f = (CidsLayerFeature)((Object)this.cbPossibleRoute.getSelectedItem());
            CidsBean routeBean = f.getBean();
            if (this.getDropBehavior() == null || this.getDropBehavior().checkForAdding(routeBean)) {
                this.setLineBeanFromRouteBean(routeBean);
                this.setChangedSinceDrop(false);
            }
            if (this.cidsBeanStore != null) {
                this.cidsBeanStore.setCidsBean(this.cidsBean);
            }
            if (this.isAutoZoomActivated) {
                LinearReferencedLineEditor.zoomToFeatureCollection(this.getZoomFeatures());
            }
        }
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        this.showCard(Card.edit);
    }

    private void panLineMouseClicked(MouseEvent evt) {
        if (!this.routeCombo) {
            return;
        }
        this.showCard(Card.add);
        this.fillRoutesCombo();
    }

    private void panLinePointsMouseClicked(MouseEvent evt) {
        this.panLineMouseClicked(evt);
    }

    private void fillRoutesCombo() {
        if (!this.routeCombo) {
            return;
        }
        List<Feature> selectedRoutes = this.getPossibleRoutes();
        if (!selectedRoutes.isEmpty()) {
            this.cbPossibleRoute.setModel(new DefaultComboBoxModel<Object>(selectedRoutes.toArray()));
        } else if (!this.routesComboInitialised) {
            this.routesComboInitialised = true;
            this.cbPossibleRoute.setModel(new DefaultComboBoxModel<Object>(new Object[]{"Lade"}));
            MetaClass routeMc = ClassCacheMultiple.getMetaClass((String)this.linearReferencingHelper.getDomainOfRouteTable(this.routeMetaClassName)[0], (String)this.routeMetaClassName, (ConnectionContext)this.getConnectionContext());
            MappingComponent mc = CismapBroker.getInstance().getMappingComponent();
            CidsLayer layer = new CidsLayer(routeMc);
            try {
                layer.setBoundingBox(mc.getCurrentBoundingBox());
                layer.addRetrievalListener(new RetrievalListener(){

                    public void retrievalStarted(RetrievalEvent e) {
                    }

                    public void retrievalProgress(RetrievalEvent e) {
                    }

                    public void retrievalComplete(RetrievalEvent e) {
                        if (!e.isInitialisationEvent()) {
                            this.complete((List)e.getRetrievedObject());
                        }
                    }

                    public void retrievalAborted(RetrievalEvent e) {
                        this.complete((List)e.getRetrievedObject());
                    }

                    public void retrievalError(RetrievalEvent e) {
                        this.complete((List)e.getRetrievedObject());
                    }

                    private void complete(List features) {
                        ArrayList<Feature> routes = new ArrayList<Feature>();
                        if (features instanceof List) {
                            List fl = features;
                            for (Object o : fl) {
                                if (!(o instanceof Feature)) continue;
                                routes.add((Feature)o);
                            }
                        }
                        LinearReferencedLineEditor.this.cbPossibleRoute.setModel(new DefaultComboBoxModel<Object>(routes.toArray()));
                    }
                });
                layer.retrieve(true);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while retrieving features", (Throwable)e);
            }
        }
    }

    public List<Feature> getPossibleRoutes() {
        MappingComponent mc = CismapBroker.getInstance().getMappingComponent();
        SelectionListener sl = (SelectionListener)mc.getInputEventListener().get("SELECT");
        List featureList = sl.getAllSelectedPFeatures();
        ArrayList<Feature> possibleRoutes = new ArrayList<Feature>();
        MetaClass routeMc = ClassCacheMultiple.getMetaClass((String)this.linearReferencingHelper.getDomainOfRouteTable(this.routeMetaClassName)[0], (String)this.routeMetaClassName, (ConnectionContext)this.getConnectionContext());
        for (PFeature f : featureList) {
            CidsLayerFeature clFeature;
            Feature selectedFeature = f.getFeature();
            if (!(selectedFeature instanceof CidsLayerFeature) || !routeMc.equals((Object)(clFeature = (CidsLayerFeature)selectedFeature).getBean().getMetaObject().getMetaClass())) continue;
            possibleRoutes.add(selectedFeature);
        }
        return possibleRoutes;
    }

    public boolean changeOtherLinesPanelVisibility() {
        this.btnRoute.setSelected(!this.btnRoute.isSelected());
        this.updateOtherLinesPanelVisibility();
        return this.btnRoute.isSelected();
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent evt) {
        if (evt.getSource() == this.externalGeomDialog) {
            this.externalGeomDialog.removeWindowListener(this);
            this.geomDialogInternalPanel.remove(this.externalOthersEditor);
            this.externalOthersEditor.dispose();
            this.externalOthersEditor = null;
            this.btnRoute.setSelected(false);
            this.updateOtherLinesPanelVisibility();
        }
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    private void updateOtherLinesPanelVisibility() {
        if (this.isEditable() && this.isOtherLinesEnabled()) {
            this.fireOtherLinesPanelVisibilityChange(this.btnRoute.isSelected());
            if (this.isDrawingFeaturesEnabled()) {
                for (Component component : this.panOtherLines.getComponents()) {
                    LinearReferencedLineRenderer renderer = (LinearReferencedLineRenderer)component;
                    renderer.setDrawingFeaturesEnabled(this.btnRoute.isSelected());
                }
            }
            if (this.btnRoute.isSelected() && this.showOtherInDialog) {
                if (this.externalOthersEditor != null) {
                    return;
                }
                this.externalOthersEditor = new LinearReferencedLineEditor(this.routeMetaClassName);
                this.externalOthersEditor.setOtherLines(this.otherLines);
                this.externalOthersEditor.setOtherLinesEnabled(this.isOtherLinesEnabled);
                this.externalOthersEditor.setOtherLinesQueryAddition(this.otherLinesFromQueryPart, this.otherLinesWhereQueryPart);
                this.externalOthersEditor.setDrawingFeaturesEnabled(true);
                this.externalOthersEditor.setLineField(this.lineField);
                this.externalOthersEditor.parent = this;
                this.externalOthersEditor.setCidsBean(this.cidsBean);
                this.geomDialogInternalPanel.add(this.externalOthersEditor);
                if (!this.externalOthersEditor.btnRoute.isSelected()) {
                    this.externalOthersEditor.btnRoute.doClick();
                }
                this.externalGeomDialog.addWindowListener(this);
                this.externalGeomDialog.setSize(500, 400);
                this.externalGeomDialog.setModal(true);
                StaticSwingTools.showDialog((Component)StaticSwingTools.getParentFrame((Component)this), (JDialog)this.externalGeomDialog, (boolean)true);
            } else {
                this.panOtherLines.setVisible(this.btnRoute.isSelected());
            }
            this.updateSplitMergeControls(true);
            this.updateSplitMergeControls(false);
        } else {
            this.panOtherLines.setVisible(false);
        }
    }

    public void setShowOtherInDialog(boolean showOtherInDialog) {
        this.showOtherInDialog = showOtherInDialog;
    }

    private void cleanOtherLinesPanel() {
        for (Component component : this.panOtherLines.getComponents()) {
            LinearReferencedLineRenderer renderer = (LinearReferencedLineRenderer)component;
            renderer.dispose();
        }
        this.panOtherLines.removeAll();
    }

    private void splitPoint(boolean isFrom) {
        if (this.isEditable()) {
            CidsBean oldPointBean = this.getPointBean(isFrom);
            LinearReferencedPointFeature oldPointFeature = this.getPointFeature(isFrom);
            double oldPosition = this.getPointFeature(isFrom).getCurrentPosition();
            CidsBean newPointBean = this.linearReferencingHelper.createStationBeanFromRouteBean(this.linearReferencingHelper.getRouteBeanFromStationBean(this.getPointBean(isFrom)));
            if (this.parent != null) {
                this.parent.cleanupPoint(isFrom);
            }
            this.setPoint(newPointBean, isFrom);
            if (this.parent != null) {
                this.parent.initPoint(isFrom);
            }
            this.pointBeanValueChanged(isFrom);
            LinearReferencedPointFeature pointFeature = this.getPointFeature(isFrom);
            this.getLineFeature().setPointFeature(pointFeature, isFrom);
            if (this.fromPointFeature != null && !this.fromPointFeature.isEditable()) {
                this.fromPointFeature.setEditable(this.isEditable());
            }
            if (oldPointFeature != null) {
                oldPointFeature.setEditable(false);
            }
            MERGE_REGISTRY.firePointBeanSplitted(oldPointBean);
            pointFeature.moveToPosition(oldPosition);
            if (oldPointFeature.isEditable()) {
                try {
                    this.linearReferencingHelper.setLinearValueToStationBean(oldPosition, oldPointBean);
                }
                catch (Exception ex) {
                    LOG.error((Object)"error while avoiding reset of editable point", (Throwable)ex);
                }
            }
        }
    }

    private void setPointBean(CidsBean pointBean, boolean isFrom) {
        block2: {
            try {
                this.getLineBean().setProperty(LinearReferencedLineEditor.getPointField(isFrom), (Object)pointBean);
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)"error while setting cidsbean for point", (Throwable)ex);
            }
        }
    }

    private void setLineBean(CidsBean lineBean) {
        block6: {
            try {
                this.cleanupLine();
                if (this.getCidsBean() != null && this.getLineField() != null) {
                    CidsBean bean = (CidsBean)this.getCidsBean().getProperty(this.getLineField());
                    if (bean != null) {
                        bean.removePropertyChangeListener((PropertyChangeListener)this.linePropertyChangeListener);
                    }
                    this.getCidsBean().setProperty(this.getLineField(), (Object)lineBean);
                    lineBean.addPropertyChangeListener((PropertyChangeListener)this.linePropertyChangeListener);
                } else {
                    CidsBean bean = this.getCidsBean();
                    if (bean != null) {
                        bean.removePropertyChangeListener((PropertyChangeListener)this.linePropertyChangeListener);
                    }
                    this.cidsBean = lineBean;
                    lineBean.addPropertyChangeListener((PropertyChangeListener)this.linePropertyChangeListener);
                }
                this.initLine();
            }
            catch (Exception ex) {
                if (!LOG.isDebugEnabled()) break block6;
                LOG.debug((Object)"error while setting line bean to cidsbean", (Throwable)ex);
            }
        }
    }

    private void setLineBeanFromRouteBean(CidsBean routeBean) {
        CidsBean lineBean = this.linearReferencingHelper.createLineBeanFromRouteBean(routeBean);
        this.setLineBean(lineBean);
        XBoundingBox boundingBox = (XBoundingBox)MAPPING_COMPONENT.getCurrentBoundingBox();
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        coordinates.add(new Coordinate(boundingBox.getX1(), boundingBox.getY1()));
        coordinates.add(new Coordinate(boundingBox.getX2(), boundingBox.getY1()));
        coordinates.add(new Coordinate(boundingBox.getX2(), boundingBox.getY2()));
        coordinates.add(new Coordinate(boundingBox.getX1(), boundingBox.getY2()));
        coordinates.add(new Coordinate(boundingBox.getX1(), boundingBox.getY1()));
        GeometryFactory gf = new GeometryFactory();
        LineString boundingBoxGeom = gf.createLineString(coordinates.toArray(new Coordinate[0]));
        LinearReferencedLineFeature lineFeature = this.getLineFeature();
        Coordinate fromCoord = lineFeature.getPointFeature(true).getGeometry().getCoordinate();
        Coordinate toCoord = lineFeature.getPointFeature(false).getGeometry().getCoordinate();
        boolean testFrom = fromCoord.x > boundingBox.getX1() && fromCoord.x < boundingBox.getX2() && fromCoord.y > boundingBox.getY1() && fromCoord.y < boundingBox.getY2();
        boolean testTo = toCoord.x > boundingBox.getX1() && toCoord.x < boundingBox.getX2() && toCoord.y > boundingBox.getY1() && toCoord.y < boundingBox.getY2();
        LineString featureGeom = (LineString)lineFeature.getGeometry();
        double minPosition = testFrom ? 0.0 : featureGeom.getLength();
        double maxPosition = testTo ? featureGeom.getLength() : 0.0;
        Geometry intersectionGeom = featureGeom.intersection((Geometry)boundingBoxGeom);
        for (Coordinate coord : intersectionGeom.getCoordinates()) {
            double position = LinearReferencedPointFeature.getPositionOnLine((Coordinate)coord, (Geometry)featureGeom);
            if (position > maxPosition) {
                maxPosition = position;
            }
            if (!(position < minPosition)) continue;
            minPosition = position;
        }
        if (minPosition > maxPosition) {
            double tmp = minPosition;
            minPosition = maxPosition;
            maxPosition = tmp;
        }
        this.setPointValueToBean(minPosition, true);
        this.setPointValueToBean(maxPosition, false);
    }

    public void beansDropped(ArrayList<CidsBean> cidsBeans) {
        if (this.isEnabled() && this.isEditable()) {
            for (CidsBean routeBean : cidsBeans) {
                if (!routeBean.getMetaObject().getMetaClass().getName().equals("route")) continue;
                if (this.getDropBehavior() == null || this.getDropBehavior().checkForAdding(routeBean)) {
                    this.setLineBeanFromRouteBean(routeBean);
                    this.setChangedSinceDrop(false);
                }
                if (this.isAutoZoomActivated) {
                    LinearReferencedLineEditor.zoomToFeatureCollection(this.getZoomFeatures());
                }
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"no route found in dropped objects");
            }
        }
    }

    private void updateSnappedRealGeoms(boolean isFrom, boolean targetIsFrom, CidsBean lineBean) {
        MetaClass mcLine = lineBean.getMetaObject().getMetaClass();
        int ownLineId = lineBean.getMetaObject().getId();
        CidsBean pointBean = isFrom ? (CidsBean)lineBean.getProperty("von") : (CidsBean)lineBean.getProperty("bis");
        int pointId = pointBean.getMetaObject().getId();
        String query = "SELECT " + mcLine.getId() + ", " + mcLine.getPrimaryKey() + " FROM " + mcLine.getTableName() + " WHERE " + mcLine.getPrimaryKey() + " != " + ownLineId + " AND " + LinearReferencedLineEditor.getPointField(targetIsFrom) + " = " + pointId + " ;";
        try {
            MetaObject[] mos;
            for (MetaObject mo : mos = SessionManager.getProxy().getMetaObjectByQuery(query, 0, this.getConnectionContext())) {
                CidsBean targetBean = CIDSBEAN_CACHE.getCachedBeanFor(mo.getBean());
                CidsBean targetFromBean = (CidsBean)targetBean.getProperty(LinearReferencedLineEditor.getPointField(true));
                CidsBean targetToBean = (CidsBean)targetBean.getProperty(LinearReferencedLineEditor.getPointField(false));
                Geometry routeGeometry = FeatureRegistry.getInstance().getLinearReferencingSolver().getRouteGeometryFromStationBean(targetFromBean);
                double currentValue = (Double)pointBean.getProperty("wert");
                double targetFromValue = targetIsFrom ? currentValue : FeatureRegistry.getInstance().getLinearReferencingSolver().getLinearValueFromStationBean(targetFromBean);
                double targetToValue = targetIsFrom ? FeatureRegistry.getInstance().getLinearReferencingSolver().getLinearValueFromStationBean(targetToBean) : currentValue;
                Geometry targetLineGeometry = LinearReferencedLineFeature.createSubline((double)targetFromValue, (double)targetToValue, (Geometry)routeGeometry);
                FeatureRegistry.getInstance().getLinearReferencingSolver().setGeometryToLineBean(targetLineGeometry, targetBean);
                targetBean.persist(this.getConnectionContext());
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"error while updating snapped real geoms", (Throwable)ex);
        }
    }

    private void updateSnappedRealGeoms(boolean isFrom, CidsBean lineBean) {
        this.updateSnappedRealGeoms(isFrom, true, lineBean);
        this.updateSnappedRealGeoms(isFrom, false, lineBean);
    }

    public void editorClosed(final EditorClosedEvent event) {
        CIDSBEAN_CACHE.clear();
        if (event.getStatus() == EditorSaveListener.EditorSaveStatus.SAVE_SUCCESS && this.isEditable()) {
            new SwingWorker<Void, Void>(){

                @Override
                protected Void doInBackground() throws Exception {
                    CidsBean savedBean = event.getSavedBean();
                    LinearReferencedLineEditor.this.updateSnappedRealGeoms(true, LinearReferencedLineEditor.getLineBean(savedBean, LinearReferencedLineEditor.this.lineField));
                    LinearReferencedLineEditor.this.updateSnappedRealGeoms(false, LinearReferencedLineEditor.getLineBean(savedBean, LinearReferencedLineEditor.this.lineField));
                    return null;
                }
            }.execute();
        }
    }

    public boolean prepareForSave() {
        return true;
    }

    protected void setMergeParentLineEditor(LinearReferencedLineEditor mergeParentLineEditor) {
        this.mergeParentLineEditor = mergeParentLineEditor;
    }

    private LinearReferencedLineEditor getMergeParentLineEditor() {
        return this.mergeParentLineEditor;
    }

    private boolean mergeRequest(boolean fromPoint, CidsBean withPointBean) {
        CidsBean parentPointBean = this.getPointBean(fromPoint);
        if (!withPointBean.equals((Object)this.getPointBean(!fromPoint))) {
            if (this.parent != null) {
                this.parent.cleanupPoint(fromPoint);
            }
            this.setPoint(withPointBean, fromPoint);
            if (this.parent != null) {
                this.parent.initPoint(fromPoint);
            }
            this.pointBeanValueChanged(fromPoint);
            MERGE_REGISTRY.firePointBeanMerged(parentPointBean, withPointBean);
            return true;
        }
        return false;
    }

    private static void zoomToFeatureCollection(Collection<Feature> collection) {
        if (!MAPPING_COMPONENT.isFixedMapExtent() && !collection.isEmpty()) {
            MAPPING_COMPONENT.zoomToAFeatureCollection(collection, true, MAPPING_COMPONENT.isFixedMapScale());
        }
    }

    private double round(double value) {
        if (this.allowDoubleValues) {
            return value;
        }
        return Math.round(value);
    }

    private class PointBeanDropTargetListener
    implements DropTargetListener {
        private boolean isFrom;

        public PointBeanDropTargetListener(boolean isFrom) {
            this.isFrom = isFrom;
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            try {
                LinearReferencedLineEditor mergeParentLineEditor = LinearReferencedLineEditor.this.getMergeParentLineEditor();
                if (mergeParentLineEditor != null) {
                    Transferable tr = e.getTransferable();
                    DataFlavor[] flavors = tr.getTransferDataFlavors();
                    for (int i = 0; i < flavors.length; ++i) {
                        if (!flavors[i].isFlavorSerializedObjectType()) continue;
                        e.acceptDrop(e.getDropAction());
                        boolean isParentFrom = (Boolean)tr.getTransferData(CIDSBEAN_DATAFLAVOR);
                        e.dropComplete(mergeParentLineEditor.mergeRequest(isParentFrom, LinearReferencedLineEditor.this.getPointBean(this.isFrom)));
                    }
                }
            }
            catch (Throwable t) {
                LinearReferencingSingletonInstances.LOG.error((Object)"error while drop", t);
            }
            e.rejectDrop();
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            LinearReferencingSingletonInstances.LOG.info((Object)"dragEnter");
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            LinearReferencingSingletonInstances.LOG.info((Object)"dragOver");
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
            LinearReferencingSingletonInstances.LOG.info((Object)"dropActionChanged");
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            LinearReferencingSingletonInstances.LOG.info((Object)"dragExit");
        }
    }

    private class PointBeanTransferHandler
    extends TransferHandler {
        boolean isFrom;

        public PointBeanTransferHandler(boolean isFrom) {
            this.isFrom = isFrom;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            return new PointBeanTransferable(this.isFrom);
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        private class PointBeanTransferable
        implements Transferable {
            private final boolean isFrom;

            private PointBeanTransferable(boolean isFrom) {
                this.isFrom = isFrom;
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
                if (!this.isDataFlavorSupported(flavor)) {
                    throw new UnsupportedFlavorException(flavor);
                }
                return this.isFrom;
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{CIDSBEAN_DATAFLAVOR};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return flavor.equals(CIDSBEAN_DATAFLAVOR);
            }
        }
    }

    private class LinePropertyChangeListener
    implements PropertyChangeListener {
        private LinePropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
        }
    }

    private class OtherLinesComparator
    implements Comparator<CidsBean> {
        private OtherLinesComparator() {
        }

        @Override
        public int compare(CidsBean o1, CidsBean o2) {
            Double from = (Double)o1.getProperty("von.wert");
            Double from2 = (Double)o2.getProperty("von.wert");
            if (from == null && from2 == null) {
                return 0;
            }
            if (from == null) {
                return -1;
            }
            if (from2 == null) {
                return 1;
            }
            return from.compareTo(from2);
        }
    }

    private class LineEditorDropTarget
    extends CidsBeanDropTarget {
        public LineEditorDropTarget(CidsBeanDropListenerComponent c) throws HeadlessException {
            super(c);
        }

        public LineEditorDropTarget(Component c) throws HeadlessException {
            super(c);
        }

        public synchronized void drop(DropTargetDropEvent dtde) {
            boolean consumed = false;
            try {
                Transferable t;
                Object data;
                if (dtde.getTransferable().isDataFlavorSupported(AttributeTableTransferHandler.rowFlavor) && (data = (t = dtde.getTransferable()).getTransferData(AttributeTableTransferHandler.rowFlavor)) instanceof FeatureServiceFeature[]) {
                    FeatureServiceFeature f;
                    FeatureServiceFeature[] fsf = (FeatureServiceFeature[])t.getTransferData(AttributeTableTransferHandler.rowFlavor);
                    consumed = true;
                    int n = 0;
                    FeatureServiceFeature[] featureServiceFeatureArray = fsf;
                    int n2 = featureServiceFeatureArray.length;
                    if (n < n2 && (f = featureServiceFeatureArray[n]) instanceof CidsLayerFeature) {
                        CidsBean routeBean = ((CidsLayerFeature)f).getBean();
                        CidsBean station = LinearReferencedLineEditor.this.linearReferencingHelper.getStationBeanFromLineBean(LinearReferencedLineEditor.this.cidsBean, true);
                        MetaClass routeMc = ClassCacheMultiple.getMetaClass((String)LinearReferencedLineEditor.this.linearReferencingHelper.getDomainOfRouteTable(LinearReferencedLineEditor.this.routeMetaClassName)[0], (String)LinearReferencedLineEditor.this.routeMetaClassName, (ConnectionContext)LinearReferencedLineEditor.this.getConnectionContext());
                        if (routeBean.getMetaObject().getMetaClass().equals((Object)routeMc)) {
                            if (LinearReferencedLineEditor.this.getDropBehavior() == null || LinearReferencedLineEditor.this.getDropBehavior().checkForAdding(routeBean)) {
                                LinearReferencedLineEditor.this.setLineBeanFromRouteBean(routeBean);
                                LinearReferencedLineEditor.this.setChangedSinceDrop(false);
                            }
                            if (LinearReferencedLineEditor.this.isAutoZoomActivated) {
                                LinearReferencedLineEditor.zoomToFeatureCollection(LinearReferencedLineEditor.this.getZoomFeatures());
                            }
                        } else {
                            JOptionPane.showMessageDialog(LinearReferencedLineEditor.this, NbBundle.getMessage(LinearReferencedLineEditor.class, (String)"LinearReferencedLineEditor.LineEditorDropTarget.invalidRoute.message"), NbBundle.getMessage(LinearReferencedLineEditor.class, (String)"LinearReferencedLineEditor.LineEditorDropTarget.invalidRoute.title"), 0);
                        }
                    }
                }
            }
            catch (Exception e) {
                LinearReferencingSingletonInstances.LOG.error((Object)"Error processing drop event", (Throwable)e);
            }
            if (!consumed) {
                super.drop(dtde);
            }
        }
    }

    private static enum Card {
        edit,
        add,
        error;

    }
}

