/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.linearreferencing;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.linearreferencing.PointBeanMergeListener;
import de.cismet.cismap.linearreferencing.PointBeanMergeRequestListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class PointBeanMergeRegistry {
    private static PointBeanMergeRegistry INSTANCE = new PointBeanMergeRegistry();
    private HashMap<CidsBean, Collection<PointBeanMergeListener>> listenersMap = new HashMap();
    private HashMap<CidsBean, Collection<PointBeanMergeRequestListener>> requestListenersMap = new HashMap();

    private PointBeanMergeRegistry() {
    }

    public static PointBeanMergeRegistry getInstance() {
        return INSTANCE;
    }

    public void addListener(CidsBean pointBean, PointBeanMergeListener listener) {
        Collection<PointBeanMergeListener> listeners = this.listenersMap.get(pointBean);
        if (listeners == null) {
            listeners = new CopyOnWriteArrayList<PointBeanMergeListener>();
            this.listenersMap.put(pointBean, listeners);
        }
        listeners.add(listener);
    }

    public void removeListener(CidsBean pointBean, PointBeanMergeListener listener) {
        Collection<PointBeanMergeListener> listeners = this.listenersMap.get(pointBean);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.listenersMap.remove(pointBean);
            }
        }
    }

    public void addRequestListener(CidsBean objectBean, PointBeanMergeRequestListener listener) {
        Collection<PointBeanMergeRequestListener> listeners = this.requestListenersMap.get(objectBean);
        if (listeners == null) {
            listeners = new CopyOnWriteArrayList<PointBeanMergeRequestListener>();
            this.requestListenersMap.put(objectBean, listeners);
        }
        listeners.add(listener);
    }

    public void removeRequestListener(CidsBean objectBean, PointBeanMergeRequestListener listener) {
        Collection<PointBeanMergeRequestListener> listeners = this.requestListenersMap.get(objectBean);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.requestListenersMap.remove(objectBean);
            }
        }
    }

    private Collection<PointBeanMergeListener> getListenersOfPointBean(CidsBean pointBean) {
        Collection<PointBeanMergeListener> listeners = this.listenersMap.get(pointBean);
        if (listeners == null) {
            return new CopyOnWriteArrayList<PointBeanMergeListener>();
        }
        return listeners;
    }

    private Collection<PointBeanMergeRequestListener> getListenersOfObjectBean(CidsBean object) {
        Collection<PointBeanMergeRequestListener> listeners = this.requestListenersMap.get(object);
        if (listeners == null) {
            return new CopyOnWriteArrayList<PointBeanMergeRequestListener>();
        }
        return listeners;
    }

    public void firePointBeanMerged(CidsBean oldBean, CidsBean newBean) {
        for (PointBeanMergeListener listener : this.getListenersOfPointBean(oldBean)) {
            listener.pointBeanMerged(newBean);
        }
    }

    public void firePointBeanMergeRequest(CidsBean object, boolean fromPoint, CidsBean newBean) {
        for (PointBeanMergeRequestListener requestListener : this.getListenersOfObjectBean(object)) {
            requestListener.pointBeanMergeRequest(fromPoint, newBean);
        }
    }

    public void firePointBeanSplitRequest(CidsBean object, boolean fromPoint) {
        for (PointBeanMergeRequestListener requestListener : this.getListenersOfObjectBean(object)) {
            requestListener.pointBeanSplitRequest(fromPoint);
        }
    }

    public void firePointBeanSplitted(CidsBean pointBean) {
        for (PointBeanMergeListener listener : this.getListenersOfPointBean(pointBean)) {
            listener.pointBeanSplitted();
        }
    }
}

