/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.linearreferencing;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.features.JDBCFeature;
import de.cismet.cismap.commons.featureservice.LinearReferencingInfo;
import de.cismet.cismap.commons.gui.attributetable.AttributeTable;
import de.cismet.cismap.commons.gui.featureinfopanel.FeatureInfoPanel;
import de.cismet.cismap.linearreferencing.FeatureRegistry;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.cismap.linearreferencing.TableLinearReferencedLineEditor;
import de.cismet.cismap.linearreferencing.TableStationEditor;
import de.cismet.cismap.linearreferencing.tools.StationEditorInterface;
import de.cismet.cismap.linearreferencing.tools.StationTableCellEditorInterface;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import java.awt.Component;
import java.awt.Container;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import org.apache.log4j.Logger;

public class StationTableCellEditor
extends AbstractCellEditor
implements StationTableCellEditorInterface,
ConnectionContextProvider {
    private static Logger LOG = Logger.getLogger(StationTableCellEditor.class);
    private TableStationEditor stat;
    private String columnName;
    private List<LinearReferencingInfo> linRefInfos;
    private LinearReferencingHelper linHelper = FeatureRegistry.getInstance().getLinearReferencingSolver();
    private final ConnectionContext connectionContext;

    public StationTableCellEditor() {
        this(null, ConnectionContext.createDeprecated());
    }

    public StationTableCellEditor(String columnName) {
        this(columnName, ConnectionContext.createDeprecated());
    }

    public StationTableCellEditor(String columnName, ConnectionContext connectionContext) {
        this.columnName = columnName;
        this.connectionContext = connectionContext;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        FeatureInfoPanel infoPanel;
        FeatureServiceFeature feature;
        Container o = table;
        while (o.getParent() != null && !(o.getParent() instanceof AttributeTable) && !(o.getParent() instanceof FeatureInfoPanel)) {
            o = o.getParent();
        }
        if (o.getParent() instanceof AttributeTable) {
            AttributeTable tab = (AttributeTable)o.getParent();
            FeatureServiceFeature feature2 = tab.getFeatureByRow(row);
            if (feature2 instanceof CidsLayerFeature) {
                CidsLayerFeature cidsFeature = (CidsLayerFeature)feature2;
                this.stat = cidsFeature.getStationEditor(this.getColumnName());
            } else if (feature2 instanceof JDBCFeature) {
                JDBCFeature f = (JDBCFeature)feature2;
                TableStationEditor editor = (TableStationEditor)f.getStationEditor(this.getColumnName());
                this.stat = editor != null ? editor : this.createEditor(f);
            }
        } else if (o.getParent() instanceof FeatureInfoPanel && (feature = (infoPanel = (FeatureInfoPanel)o.getParent()).getSelectedFeature()) instanceof CidsLayerFeature) {
            CidsLayerFeature cidsFeature = (CidsLayerFeature)feature;
            this.stat = cidsFeature.getStationEditor(this.getColumnName());
        }
        this.stat.requestFocus();
        return this.stat;
    }

    private TableStationEditor createEditor(JDBCFeature feature) {
        LinearReferencingInfo info = this.getInfoForColumn(this.columnName);
        MetaClass metaClass = ClassCacheMultiple.getMetaClass((String)info.getDomain(), (String)info.getLinRefReferenceName(), (ConnectionContext)this.getConnectionContext());
        if (metaClass != null) {
            try {
                String query = "SELECT %s, %s FROM %s WHERE %s = '%s';";
                String routeQuery = String.format("SELECT %s, %s FROM %s WHERE %s = '%s';", metaClass.getID(), metaClass.getPrimaryKey(), metaClass.getTableName(), info.getTrgLinRefJoinField(), feature.getProperty(info.getSrcLinRefJoinField()));
                MetaObject[] mos = SessionManager.getProxy().getMetaObjectByQuery(SessionManager.getSession().getUser(), routeQuery, this.getConnectionContext());
                if (mos != null && mos.length == 1) {
                    MetaObject routeObject = mos[0];
                    if (info.getTillField() == null || info.getTillField().isEmpty()) {
                        CidsBean stationBean = this.linHelper.createStationBeanFromRouteBean(routeObject.getBean(), (Double)feature.getProperty(info.getFromField()));
                        TableStationEditor editor = new TableStationEditor(info.getLinRefReferenceName(), (FeatureServiceFeature)feature, info.getSrcLinRefJoinField());
                        editor.setCidsBean(stationBean);
                        editor.addPropertyChangeListener(feature.getPropertyChangeListener());
                        feature.setStationEditor(this.getColumnName(), (StationEditorInterface)editor);
                        return editor;
                    }
                    CidsBean lineBean = this.linHelper.createLineBeanFromRouteBean(routeObject.getBean());
                    this.linHelper.setGeometryToLineBean(feature.getGeometry(), lineBean);
                    CidsBean fromStation = this.linHelper.getStationBeanFromLineBean(lineBean, true);
                    this.linHelper.setLinearValueToStationBean((Double)feature.getProperty(info.getFromField()), fromStation);
                    CidsBean toStation = this.linHelper.getStationBeanFromLineBean(lineBean, false);
                    this.linHelper.setLinearValueToStationBean((Double)feature.getProperty(info.getTillField()), toStation);
                    TableLinearReferencedLineEditor st = new TableLinearReferencedLineEditor(info.getLinRefReferenceName(), (FeatureServiceFeature)feature, info.getSrcLinRefJoinField());
                    st.setCidsBean(lineBean);
                    TableStationEditor fromEditor = st.getFromStation();
                    TableStationEditor toEditor = st.getToStation();
                    st.addPropertyChangeListener(feature.getPropertyChangeListener());
                    feature.setBackgroundColor(st.getLineColor());
                    feature.setStationEditor(info.getGeomField(), (StationEditorInterface)st);
                    feature.setStationEditor(info.getFromField(), (StationEditorInterface)fromEditor);
                    feature.setStationEditor(info.getTillField(), (StationEditorInterface)toEditor);
                    if (this.getColumnName().equalsIgnoreCase(info.getFromField())) {
                        return fromEditor;
                    }
                    return toEditor;
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Error while creating station bean", (Throwable)ex);
            }
        }
        return null;
    }

    private LinearReferencingInfo getInfoForColumn(String colName) {
        for (LinearReferencingInfo info : this.linRefInfos) {
            if (!info.getFromField().equals(colName) && (info.getTillField() == null || !info.getTillField().equals(colName))) continue;
            return info;
        }
        return null;
    }

    @Override
    public Object getCellEditorValue() {
        return this.stat.getValue();
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setLinRefInfos(List<LinearReferencingInfo> linRefInfos) {
        this.linRefInfos = linRefInfos;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

