/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.linearreferencing;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedLineFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.linearreferencing.FeatureRegistry;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.cismap.linearreferencing.TableStationEditor;
import de.cismet.cismap.linearreferencing.tools.StationEditorInterface;
import java.awt.Color;
import java.awt.Paint;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class TableLinearReferencedLineEditor
implements DisposableCidsBeanStore,
PropertyChangeListener,
StationEditorInterface {
    private static final Logger LOG = Logger.getLogger(TableLinearReferencedLineEditor.class);
    private static LinearReferencingHelper linearReferencedHelper = FeatureRegistry.getInstance().getLinearReferencingSolver();
    private TableStationEditor fromStation;
    private TableStationEditor toStation;
    private CidsBean cidsBean;
    private LinearReferencedLineFeature lineFeature;
    private Color lineColor;
    private List<PropertyChangeListener> propListener = new ArrayList<PropertyChangeListener>();
    private String valueProperty;
    private String routeName;
    private String otherLinesFrom;
    private String otherLinesQuery;
    private FeatureServiceFeature parentFeature;
    private String stationProperty;

    public TableLinearReferencedLineEditor(String routeName, FeatureServiceFeature parentFeature, String stationProperty) {
        this.routeName = routeName;
        this.parentFeature = parentFeature;
        this.stationProperty = stationProperty;
    }

    public void setCidsBean(CidsBean cidsBean) {
        this.cidsBean = cidsBean;
        this.fromStation = new TableStationEditor(true, cidsBean, this.routeName, this.parentFeature, this.stationProperty);
        this.toStation = new TableStationEditor(true, cidsBean, this.routeName, this.parentFeature, this.stationProperty);
        if (this.otherLinesFrom != null && this.otherLinesQuery != null) {
            this.fromStation.setOtherLinesFrom(this.otherLinesFrom);
            this.fromStation.setOtherLinesQuery(this.otherLinesQuery);
            this.toStation.setOtherLinesFrom(this.otherLinesFrom);
            this.toStation.setOtherLinesQuery(this.otherLinesQuery);
        }
        this.fromStation.setCidsBean(linearReferencedHelper.getStationBeanFromLineBean(cidsBean, true));
        this.toStation.setCidsBean(linearReferencedHelper.getStationBeanFromLineBean(cidsBean, false));
        if (this.fromStation.getStationFeature() != null) {
            this.lineFeature = FeatureRegistry.getInstance().addLinearReferencedLineFeature(cidsBean, this.fromStation.getStationFeature(), this.toStation.getStationFeature());
            this.lineColor = FeatureRegistry.getNextColor(cidsBean);
            this.lineFeature.setLinePaint((Paint)this.getLineColor());
        }
        this.fromStation.addPropertyChangeListener(this);
        this.toStation.addPropertyChangeListener(this);
        this.valueProperty = linearReferencedHelper.getValueProperty(linearReferencedHelper.getStationBeanFromLineBean(cidsBean, false));
    }

    public TableStationEditor getFromStation() {
        return this.fromStation;
    }

    public TableStationEditor getToStation() {
        return this.toStation;
    }

    public void dispose() {
        if (this.fromStation != null) {
            this.fromStation.removePropertyChangeListener(this);
        }
        if (this.toStation != null) {
            this.toStation.removePropertyChangeListener(this);
        }
        try {
            this.recreateGeometry();
        }
        catch (Exception e) {
            LOG.warn((Object)"Cannot recreate geometry.", (Throwable)e);
        }
        if (this.cidsBean != null) {
            FeatureRegistry.getInstance().removeLinearReferencedLineFeature(this.cidsBean);
        }
    }

    public Geometry recreateGeometry() {
        if (this.fromStation != null && this.toStation != null) {
            double from = (Double)this.fromStation.getValue();
            double to = (Double)this.toStation.getValue();
            Geometry lineGeom = LinearReferencedLineFeature.createSubline((double)from, (double)to, (Geometry)linearReferencedHelper.getRouteGeometryFromStationBean(this.fromStation.getCidsBean()));
            lineGeom.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
            try {
                linearReferencedHelper.setGeometryToLineBean(lineGeom, this.cidsBean);
                if (Math.abs(to - this.toStation.getFeature().getCurrentPosition()) > 0.1) {
                    linearReferencedHelper.setLinearValueToStationBean(this.toStation.getFeature().getCurrentPosition(), this.toStation.getCidsBean());
                }
                if (Math.abs(from - this.fromStation.getFeature().getCurrentPosition()) > 0.1) {
                    linearReferencedHelper.setLinearValueToStationBean(this.fromStation.getFeature().getCurrentPosition(), this.fromStation.getCidsBean());
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot create line geometry", (Throwable)e);
            }
            return lineGeom;
        }
        return null;
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void undoChanges() {
        if (this.fromStation != null) {
            this.fromStation.undoChanges();
        }
        if (this.fromStation != null) {
            this.toStation.undoChanges();
        }
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equalsIgnoreCase(this.valueProperty)) {
            this.recreateGeometry();
            this.firePropertyChange(evt);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propListener.add(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propListener.remove(l);
    }

    protected void firePropertyChange(PropertyChangeEvent e) {
        for (PropertyChangeListener l : this.propListener) {
            l.propertyChange(e);
        }
    }

    public Object getValue() {
        CidsBean geomBean = linearReferencedHelper.getGeomBeanFromLineBean(this.cidsBean);
        return geomBean.getProperty("geo_field");
    }

    public String getOtherLinesFrom() {
        return this.otherLinesFrom;
    }

    public void setOtherLinesFrom(String otherLinesFrom) {
        this.otherLinesFrom = otherLinesFrom;
    }

    public String getOtherLinesQuery() {
        return this.otherLinesQuery;
    }

    public void setOtherLinesQuery(String otherLinesQuery) {
        this.otherLinesQuery = otherLinesQuery;
    }

    public FeatureServiceFeature getParentFeature() {
        return this.parentFeature;
    }

    public void setParentFeature(FeatureServiceFeature parentFeature) {
        this.parentFeature = parentFeature;
    }

    public String getStationProperty() {
        return this.stationProperty;
    }

    public void setStationProperty(String stationProperty) {
        this.stationProperty = stationProperty;
    }

    public Geometry getGeometry() {
        try {
            if (this.cidsBean != null) {
                return (Geometry)linearReferencedHelper.getGeomBeanFromLineBean(this.cidsBean).getProperty("geo_field");
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot create line geometry", (Throwable)e);
        }
        return null;
    }
}

