/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin;

import Sirius.server.middleware.types.MetaObject;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.features.SelectFeature;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import java.util.ArrayList;
import java.util.Collection;

public class CidsBeansSelectFeature
extends SelectFeature {
    private final Collection<CidsBean> beans;

    public CidsBeansSelectFeature(Geometry geom, Collection<CidsBean> beans, String inputListenerName) {
        super(geom, inputListenerName);
        this.beans = beans;
    }

    public static CidsBeansSelectFeature createFromBeans(Collection<CidsBean> beans, String interactionmode) {
        ArrayList<Geometry> selectGeoms = new ArrayList<Geometry>();
        Integer origSrid = null;
        String metricCrs = null;
        for (CidsBean cb : beans) {
            MetaObject mo = cb.getMetaObject();
            CidsFeature cf = new CidsFeature(mo);
            if (origSrid == null) {
                origSrid = cf.getGeometry().getSRID();
                int metricSrid = CrsTransformer.transformToMetricCrs((Geometry)cf.getGeometry()).getSRID();
                metricCrs = CrsTransformer.createCrsFromSrid((int)metricSrid);
            }
            selectGeoms.add(CrsTransformer.transformToGivenCrs((Geometry)cf.getGeometry(), metricCrs));
        }
        Geometry[] selectGeomsArr = selectGeoms.toArray(new Geometry[0]);
        GeometryCollection coll = new GeometryFactory().createGeometryCollection(selectGeomsArr);
        Geometry newG = coll.buffer(0.1);
        newG.setSRID(CrsTransformer.extractSridFromCrs(metricCrs));
        if (origSrid != null) {
            newG = CrsTransformer.transformToGivenCrs((Geometry)newG, (String)CrsTransformer.createCrsFromSrid((int)origSrid));
            newG.setSRID(origSrid.intValue());
        }
        return new CidsBeansSelectFeature(newG, beans, interactionmode);
    }

    public Collection<CidsBean> getBeans() {
        return this.beans;
    }
}

