/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin;

import Sirius.navigator.types.treenode.DefaultMetaTreeNode;
import Sirius.navigator.types.treenode.ObjectTreeNode;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.server.middleware.types.MetaObject;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.CidsBeanDropTarget;
import de.cismet.cismap.commons.features.AbstractNewFeature;
import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.SearchFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.AbstractCreateSearchGeometryListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateSearchGeometryListener;
import de.cismet.cismap.navigatorplugin.CidsBeansSearchFeature;
import de.cismet.cismap.navigatorplugin.metasearch.MetaSearch;
import de.cismet.cismap.navigatorplugin.metasearch.SearchTopic;
import de.cismet.cismap.tools.gui.CidsBeanDropJPopupMenuButton;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.gui.HighlightingRadioButtonMenuItem;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.StayOpenCheckBoxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Logger;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class GeoSearchButton
extends CidsBeanDropJPopupMenuButton
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(GeoSearchButton.class);
    private final String interactionMode;
    private final MappingComponent mappingComponent;
    private final String searchName;
    private final AbstractCreateSearchGeometryListener searchListener;
    private Action searchAction;
    private Action searchMenuSelectedAction;
    private Action searchRectangleAction;
    private Action searchPolygonAction;
    private Action searchCidsFeatureAction;
    private Action searchEllipseAction;
    private Action searchPolylineAction;
    private Action searchRedoAction;
    private Action searchShowLastFeatureAction;
    private Action searchBufferAction;
    private ButtonGroup buttonGroup1;
    private JSeparator jSeparator12;
    private JMenuItem mniSearchBuffer1;
    private JRadioButtonMenuItem mniSearchCidsFeature1;
    private JRadioButtonMenuItem mniSearchEllipse1;
    private JRadioButtonMenuItem mniSearchPolygon1;
    private JRadioButtonMenuItem mniSearchPolyline1;
    private JRadioButtonMenuItem mniSearchRectangle1;
    private JMenuItem mniSearchRedo1;
    private JMenuItem mniSearchShowLastFeature1;
    private JPopupMenu popMenSearch;

    public GeoSearchButton(String interactionMode, MappingComponent mappingComponent, String searchName) {
        this(interactionMode, mappingComponent, searchName, "");
    }

    public GeoSearchButton(String interactionMode, MappingComponent mappingComponent, String searchName, String toolTipText) {
        super(interactionMode, mappingComponent, searchName);
        this.searchAction = GeoSearchButton.createSearchAction(interactionMode, mappingComponent);
        this.searchMenuSelectedAction = GeoSearchButton.createSearchMenuSelectedAction(interactionMode, mappingComponent);
        this.searchRectangleAction = GeoSearchButton.createSearchRectangleAction(interactionMode, mappingComponent);
        this.searchPolygonAction = GeoSearchButton.createSearchPolygonAction(interactionMode, mappingComponent);
        this.searchCidsFeatureAction = GeoSearchButton.createSearchCidsFeatureAction(interactionMode, mappingComponent);
        this.searchEllipseAction = GeoSearchButton.createSearchEllipseAction(interactionMode, mappingComponent);
        this.searchPolylineAction = GeoSearchButton.createSearchPolylineAction(interactionMode, mappingComponent);
        this.searchRedoAction = GeoSearchButton.createSearchRedoAction(interactionMode, mappingComponent);
        this.searchShowLastFeatureAction = GeoSearchButton.createSearchShowLastFeatureAction(interactionMode, mappingComponent);
        this.searchBufferAction = GeoSearchButton.createSearchBufferAction(interactionMode, mappingComponent);
        this.initComponents();
        this.setPopupMenu(this.popMenSearch);
        new CidsBeanDropTarget((Component)((Object)this));
        this.setTargetIcon(new ImageIcon(this.getClass().getResource("/images/pluginSearchTarget.png")));
        this.interactionMode = interactionMode;
        this.mappingComponent = mappingComponent;
        this.searchName = searchName;
        this.searchListener = (AbstractCreateSearchGeometryListener)mappingComponent.getInputListener(interactionMode);
        this.setButtonIcon(this.searchListener.getMode());
        this.setModeSelection(this.searchListener.getMode());
        this.setLastFeature((AbstractNewFeature)this.searchListener.getLastSearchFeature());
        this.searchListener.addPropertyChangeListener((PropertyChangeListener)this);
        this.setFireOnArrow(true);
    }

    public static Action createSearchAction(final String interactionMode, final MappingComponent mappingComponent) {
        CreateSearchGeometryListener searchListener = (CreateSearchGeometryListener)mappingComponent.getInputListener(interactionMode);
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"searchAction");
                }
                mappingComponent.setInteractionMode(interactionMode);
            }
        };
    }

    public static Action createSearchMenuSelectedAction(String interactionMode, MappingComponent mappingComponent) {
        CreateSearchGeometryListener searchListener = (CreateSearchGeometryListener)mappingComponent.getInputListener(interactionMode);
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"searchMenuSelectedAction");
                }
            }
        };
    }

    public static Action createSearchRectangleAction(final String interactionMode, final MappingComponent mappingComponent) {
        final CreateSearchGeometryListener searchListener = (CreateSearchGeometryListener)mappingComponent.getInputListener(interactionMode);
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"searchRectangleAction");
                }
                mappingComponent.setInteractionMode(interactionMode);
                searchListener.setMode("BOUNDING_BOX");
            }
        };
    }

    public static Action createSearchPolygonAction(final String interactionMode, final MappingComponent mappingComponent) {
        final CreateSearchGeometryListener searchListener = (CreateSearchGeometryListener)mappingComponent.getInputListener(interactionMode);
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"searchPolygonAction");
                }
                mappingComponent.setInteractionMode(interactionMode);
                searchListener.setMode("POLYGON");
            }
        };
    }

    public static Action createSearchCidsFeatureAction(final String interactionMode, final MappingComponent mappingComponent) {
        final CreateSearchGeometryListener searchListener = (CreateSearchGeometryListener)mappingComponent.getInputListener(interactionMode);
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"searchCidsFeatureAction");
                }
                mappingComponent.setInteractionMode(interactionMode);
                CismetThreadPool.execute((Runnable)new SwingWorker<SearchFeature, Void>(){

                    @Override
                    protected SearchFeature doInBackground() throws Exception {
                        Thread.currentThread().setName("GeoSearchButton createSearchCidsFeatureAction");
                        DefaultMetaTreeNode[] nodes = ComponentRegistry.getRegistry().getActiveCatalogue().getSelectedNodesArray();
                        ArrayList<CidsBean> beans = new ArrayList<CidsBean>();
                        for (DefaultMetaTreeNode dmtn : nodes) {
                            if (!(dmtn instanceof ObjectTreeNode)) continue;
                            MetaObject mo = ((ObjectTreeNode)dmtn).getMetaObject();
                            beans.add(mo.getBean());
                        }
                        CidsBeansSearchFeature sf = CidsBeansSearchFeature.createFromBeans(beans, interactionMode);
                        if (sf != null && sf.getGeometry() != null && sf.getGeometry() instanceof MultiPolygon) {
                            sf.setGeometryType(AbstractNewFeature.geomTypes.MULTIPOLYGON);
                        } else {
                            sf.setGeometryType(AbstractNewFeature.geomTypes.POLYGON);
                        }
                        return sf;
                    }

                    @Override
                    protected void done() {
                        try {
                            SearchFeature search = (SearchFeature)this.get();
                            if (search != null) {
                                searchListener.search(search);
                            }
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Exception in Background Thread", (Throwable)e);
                        }
                    }
                });
            }
        };
    }

    public static Action createSearchEllipseAction(final String interactionMode, final MappingComponent mappingComponent) {
        final CreateSearchGeometryListener searchListener = (CreateSearchGeometryListener)mappingComponent.getInputListener(interactionMode);
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"searchEllipseAction");
                }
                mappingComponent.setInteractionMode(interactionMode);
                searchListener.setMode("ELLIPSE");
            }
        };
    }

    public static Action createSearchPolylineAction(final String interactionMode, final MappingComponent mappingComponent) {
        final CreateSearchGeometryListener searchListener = (CreateSearchGeometryListener)mappingComponent.getInputListener(interactionMode);
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"searchPolylineAction");
                }
                mappingComponent.setInteractionMode(interactionMode);
                searchListener.setMode("LINESTRING");
            }
        };
    }

    public static Action createSearchRedoAction(final String interactionMode, final MappingComponent mappingComponent) {
        final CreateSearchGeometryListener searchListener = (CreateSearchGeometryListener)mappingComponent.getInputListener(interactionMode);
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"redoSearchAction");
                }
                searchListener.redoLastSearch();
                mappingComponent.setInteractionMode(interactionMode);
            }
        };
    }

    public static Action createSearchShowLastFeatureAction(final String interactionMode, final MappingComponent mappingComponent) {
        final CreateSearchGeometryListener searchListener = (CreateSearchGeometryListener)mappingComponent.getInputListener(interactionMode);
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"searchShowLastFeatureAction");
                }
                searchListener.showLastFeature();
                mappingComponent.setInteractionMode(interactionMode);
            }
        };
    }

    public static Action createSearchBufferAction(final String interactionMode, final MappingComponent mappingComponent) {
        final CreateSearchGeometryListener searchListener = (CreateSearchGeometryListener)mappingComponent.getInputListener(interactionMode);
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block8: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"bufferSearchGeometry");
                    }
                    String message = NbBundle.getMessage(GeoSearchButton.class, (String)"GeoSearchButton.createSearchBufferAction().bufferDialog.message");
                    String title = NbBundle.getMessage(GeoSearchButton.class, (String)"GeoSearchButton.createSearchBufferAction().bufferDialog.title");
                    String s = (String)JOptionPane.showInputDialog(StaticSwingTools.getParentFrame((Component)mappingComponent), message, title, -1, null, null, "");
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)s);
                    }
                    if (s.matches("\\d*,\\d*")) {
                        s.replace(",", ".");
                    }
                    try {
                        float buffer = Float.valueOf(s).floatValue();
                        SearchFeature lastFeature = searchListener.getLastSearchFeature();
                        if (lastFeature != null) {
                            Geometry geom = lastFeature.getGeometry();
                            Geometry bufferGeom = geom.buffer((double)buffer);
                            lastFeature.setGeometry(bufferGeom);
                            lastFeature.setGeometryType(AbstractNewFeature.geomTypes.POLYGON);
                            for (Object feature : mappingComponent.getFeatureCollection().getAllFeatures()) {
                                PFeature sel = (PFeature)mappingComponent.getPFeatureHM().get(feature);
                                if (!sel.getFeature().equals(lastFeature)) continue;
                                sel.setCoordArr(bufferGeom.getCoordinates());
                                sel.syncGeometry();
                                ArrayList<Feature> v = new ArrayList<Feature>();
                                v.add(sel.getFeature());
                                ((DefaultFeatureCollection)mappingComponent.getFeatureCollection()).fireFeaturesChanged(v);
                            }
                            searchListener.search(lastFeature);
                            mappingComponent.setInteractionMode(interactionMode);
                        }
                    }
                    catch (NumberFormatException ex) {
                        String messageEx = NbBundle.getMessage(GeoSearchButton.class, (String)"GeoSearchButton.createSearchBufferAction().NumberFormatException.bufferDialog.message");
                        String titleEx = NbBundle.getMessage(GeoSearchButton.class, (String)"GeoSearchButton.createSearchBufferAction().NumberFormatException.bufferDialog.title");
                        JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)mappingComponent), messageEx, titleEx, 0);
                    }
                    catch (Exception ex) {
                        if (!LOG.isDebugEnabled()) break block8;
                        LOG.debug((Object)"", (Throwable)ex);
                    }
                }
            }
        };
    }

    private void initComponents() {
        this.popMenSearch = new JPopupMenu();
        this.mniSearchRectangle1 = new HighlightingRadioButtonMenuItem(UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE);
        this.mniSearchPolygon1 = new HighlightingRadioButtonMenuItem(UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE);
        this.mniSearchEllipse1 = new HighlightingRadioButtonMenuItem(UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE);
        this.mniSearchPolyline1 = new HighlightingRadioButtonMenuItem(UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE);
        this.jSeparator12 = new JSeparator();
        this.mniSearchCidsFeature1 = new JRadioButtonMenuItem();
        this.mniSearchShowLastFeature1 = new JMenuItem();
        this.mniSearchRedo1 = new JMenuItem();
        this.mniSearchBuffer1 = new JMenuItem();
        this.buttonGroup1 = new ButtonGroup();
        this.popMenSearch.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                GeoSearchButton.this.popMenSearchPopupMenuWillBecomeVisible(evt);
            }
        });
        this.mniSearchRectangle1.setAction(this.searchRectangleAction);
        this.mniSearchRectangle1.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.mniSearchRectangle1, (String)NbBundle.getMessage(GeoSearchButton.class, (String)"GeoSearchButton.mniSearchRectangle1.text"));
        this.mniSearchRectangle1.setIcon(new ImageIcon(this.getClass().getResource("/images/rectangle.png")));
        this.popMenSearch.add(this.mniSearchRectangle1);
        this.mniSearchPolygon1.setAction(this.searchPolygonAction);
        Mnemonics.setLocalizedText((AbstractButton)this.mniSearchPolygon1, (String)NbBundle.getMessage(GeoSearchButton.class, (String)"GeoSearchButton.mniSearchPolygon1.text"));
        this.mniSearchPolygon1.setIcon(new ImageIcon(this.getClass().getResource("/images/polygon.png")));
        this.popMenSearch.add(this.mniSearchPolygon1);
        this.mniSearchEllipse1.setAction(this.searchEllipseAction);
        Mnemonics.setLocalizedText((AbstractButton)this.mniSearchEllipse1, (String)NbBundle.getMessage(GeoSearchButton.class, (String)"GeoSearchButton.mniSearchEllipse1.text"));
        this.mniSearchEllipse1.setIcon(new ImageIcon(this.getClass().getResource("/images/ellipse.png")));
        this.popMenSearch.add(this.mniSearchEllipse1);
        this.mniSearchPolyline1.setAction(this.searchPolylineAction);
        Mnemonics.setLocalizedText((AbstractButton)this.mniSearchPolyline1, (String)NbBundle.getMessage(GeoSearchButton.class, (String)"GeoSearchButton.mniSearchPolyline1.text"));
        this.mniSearchPolyline1.setIcon(new ImageIcon(this.getClass().getResource("/images/polyline.png")));
        this.popMenSearch.add(this.mniSearchPolyline1);
        this.popMenSearch.add(this.jSeparator12);
        this.mniSearchCidsFeature1.setAction(this.searchCidsFeatureAction);
        Mnemonics.setLocalizedText((AbstractButton)this.mniSearchCidsFeature1, (String)NbBundle.getMessage(GeoSearchButton.class, (String)"GeoSearchButton.mniSearchCidsFeature1.text"));
        this.mniSearchCidsFeature1.setIcon(new ImageIcon(this.getClass().getResource("/images/polygon.png")));
        this.popMenSearch.add(this.mniSearchCidsFeature1);
        this.mniSearchShowLastFeature1.setAction(this.searchShowLastFeatureAction);
        this.mniSearchShowLastFeature1.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        Mnemonics.setLocalizedText((AbstractButton)this.mniSearchShowLastFeature1, (String)NbBundle.getMessage(GeoSearchButton.class, (String)"GeoSearchButton.mniSearchShowLastFeature1.text"));
        this.mniSearchShowLastFeature1.setToolTipText(NbBundle.getMessage(GeoSearchButton.class, (String)"GeoSearchButton.mniSearchShowLastFeature1.toolTipText"));
        this.popMenSearch.add(this.mniSearchShowLastFeature1);
        this.mniSearchRedo1.setAction(this.searchRedoAction);
        this.mniSearchRedo1.setAccelerator(KeyStroke.getKeyStroke(89, 10));
        Mnemonics.setLocalizedText((AbstractButton)this.mniSearchRedo1, (String)NbBundle.getMessage(GeoSearchButton.class, (String)"GeoSearchButton.mniSearchRedo1.text"));
        this.mniSearchRedo1.setToolTipText(NbBundle.getMessage(GeoSearchButton.class, (String)"GeoSearchButton.mniSearchRedo1.toolTipText"));
        this.popMenSearch.add(this.mniSearchRedo1);
        this.mniSearchBuffer1.setAction(this.searchBufferAction);
        this.mniSearchBuffer1.setIcon(new ImageIcon(this.getClass().getResource("/images/buffer.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.mniSearchBuffer1, (String)NbBundle.getMessage(GeoSearchButton.class, (String)"GeoSearchButton.mniSearchBuffer1.text"));
        this.mniSearchBuffer1.setToolTipText(NbBundle.getMessage(GeoSearchButton.class, (String)"GeoSearchButton.mniSearchBuffer1.toolTipText"));
        this.popMenSearch.add(this.mniSearchBuffer1);
        this.setAction(this.searchAction);
        this.setIcon(new ImageIcon(this.getClass().getResource("/images/pluginSearchRectangle.png")));
        this.setToolTipText(NbBundle.getMessage(GeoSearchButton.class, (String)"GeoSearchButton.toolTipText"));
    }

    private void popMenSearchPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        this.searchMenuSelectedAction.actionPerformed(new ActionEvent(this.popMenSearch, 1001, null));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource().equals(this.searchListener)) {
            if ("PROPERTY_LAST_FEATURE".equals(evt.getPropertyName())) {
                this.setLastFeature((AbstractNewFeature)this.searchListener.getLastSearchFeature());
            } else if ("PROPERTY_MODE".equals(evt.getPropertyName())) {
                this.setSelected(true);
                this.setModeSelection(this.searchListener.getMode());
                this.setButtonIcon(this.searchListener.getMode());
            }
        }
    }

    private void setLastFeature(AbstractNewFeature lastFeature) {
        if (lastFeature == null) {
            this.mniSearchShowLastFeature1.setIcon(null);
            this.mniSearchShowLastFeature1.setEnabled(false);
            this.mniSearchRedo1.setIcon(null);
            this.mniSearchRedo1.setEnabled(false);
            this.mniSearchBuffer1.setEnabled(false);
        } else {
            switch (lastFeature.getGeometryType()) {
                case ELLIPSE: {
                    this.mniSearchRedo1.setIcon(this.mniSearchEllipse1.getIcon());
                    break;
                }
                case LINESTRING: {
                    this.mniSearchRedo1.setIcon(this.mniSearchPolyline1.getIcon());
                    break;
                }
                case POLYGON: {
                    this.mniSearchRedo1.setIcon(this.mniSearchPolygon1.getIcon());
                    break;
                }
                case RECTANGLE: {
                    this.mniSearchRedo1.setIcon(this.mniSearchRectangle1.getIcon());
                }
            }
            this.mniSearchRedo1.setEnabled(true);
            this.mniSearchBuffer1.setEnabled(true);
            this.mniSearchShowLastFeature1.setIcon(this.mniSearchRedo1.getIcon());
            this.mniSearchShowLastFeature1.setEnabled(true);
        }
    }

    private void setButtonIcon(String mode) {
        if ("BOUNDING_BOX".equals(mode)) {
            this.setIcon(new ImageIcon(this.getClass().getResource("/images/pluginSearchRectangle.png")));
            this.setSelectedIcon(new ImageIcon(this.getClass().getResource("/images/pluginSearchRectangle.png")));
        } else if ("POLYGON".equals(mode)) {
            this.setIcon(new ImageIcon(this.getClass().getResource("/images/pluginSearchPolygon.png")));
            this.setSelectedIcon(new ImageIcon(this.getClass().getResource("/images/pluginSearchPolygon.png")));
        } else if ("ELLIPSE".equals(mode)) {
            this.setIcon(new ImageIcon(this.getClass().getResource("/images/pluginSearchEllipse.png")));
            this.setSelectedIcon(new ImageIcon(this.getClass().getResource("/images/pluginSearchEllipse.png")));
        } else if ("LINESTRING".equals(mode)) {
            this.setIcon(new ImageIcon(this.getClass().getResource("/images/pluginSearchPolyline.png")));
            this.setSelectedIcon(new ImageIcon(this.getClass().getResource("/images/pluginSearchPolyline.png")));
        }
    }

    private void setModeSelection(String mode) {
        this.mniSearchRectangle1.setSelected("BOUNDING_BOX".equals(mode));
        this.mniSearchPolygon1.setSelected("POLYGON".equals(mode));
        this.mniSearchEllipse1.setSelected("ELLIPSE".equals(mode));
        this.mniSearchPolyline1.setSelected("LINESTRING".equals(mode));
    }

    public void initSearchTopicMenues(MetaSearch metaSearch) {
        this.setPopupMenu(this.popMenSearch);
        if (this.popMenSearch.getComponent(this.popMenSearch.getComponentCount() - 1) instanceof StayOpenCheckBoxMenuItem) {
            for (int i = this.popMenSearch.getComponentCount() - 1; i > 0; --i) {
                if (this.popMenSearch.getComponent(i) instanceof StayOpenCheckBoxMenuItem) {
                    this.popMenSearch.remove(i);
                    continue;
                }
                if (!(this.popMenSearch.getComponent(i) instanceof JSeparator)) continue;
                this.popMenSearch.remove(i);
                break;
            }
        }
        if (metaSearch.getSearchTopics() != null && !metaSearch.getSearchTopics().isEmpty()) {
            this.popMenSearch.add(new JSeparator());
            for (SearchTopic searchTopic : metaSearch.getSearchTopics()) {
                this.popMenSearch.add((JMenuItem)new StayOpenCheckBoxMenuItem((Action)searchTopic, UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE));
                searchTopic.addPropertyChangeListener((PropertyChangeListener)this.mappingComponent.getInputListener(this.interactionMode));
            }
        }
    }
}

