/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin;

import Sirius.navigator.types.treenode.DefaultMetaTreeNode;
import Sirius.navigator.types.treenode.ObjectTreeNode;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.server.middleware.types.MetaObject;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.CidsBeanDropTarget;
import de.cismet.cismap.commons.features.AbstractNewFeature;
import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.SelectFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.SelectionListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.navigatorplugin.CidsBeansSelectFeature;
import de.cismet.cismap.tools.gui.CidsBeanDropJPopupMenuButton;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.gui.HighlightingRadioButtonMenuItem;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.menu.CidsUiComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Logger;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class GeoSelectionButton
extends CidsBeanDropJPopupMenuButton
implements PropertyChangeListener,
CidsUiComponent {
    private static final Logger LOG = Logger.getLogger(GeoSelectionButton.class);
    private SelectionListener selectListener;
    private Action selectAction;
    private Action selectMenuSelectedAction;
    private Action selectRectangleAction;
    private Action selectPolygonAction;
    private Action selectCidsFeatureAction;
    private Action selectEllipseAction;
    private Action selectPolylineAction;
    private Action selectRedoAction;
    private Action selectShowLastFeatureAction;
    private Action selectBufferAction;
    private ButtonGroup buttonGroup1;
    private JSeparator jSeparator12;
    private JMenuItem mniSelectBuffer1;
    private JRadioButtonMenuItem mniSelectCidsFeature1;
    private JRadioButtonMenuItem mniSelectEllipse1;
    private JRadioButtonMenuItem mniSelectPolygon1;
    private JRadioButtonMenuItem mniSelectPolyline1;
    private JRadioButtonMenuItem mniSelectRectangle1;
    private JMenuItem mniSelectRedo1;
    private JMenuItem mniSelectShowLastFeature1;
    private JPopupMenu popMenSelect;

    public GeoSelectionButton() {
        this("SELECT", CismapBroker.getInstance().getMappingComponent(), null);
    }

    public GeoSelectionButton(String interactionMode, MappingComponent mappingComponent, String selectName) {
        this(interactionMode, mappingComponent, selectName, "");
    }

    public GeoSelectionButton(String interactionMode, MappingComponent mappingComponent, String selectName, String toolTipText) {
        this.setModel(new JToggleButton.ToggleButtonModel());
        this.init(interactionMode, mappingComponent, selectName, toolTipText);
    }

    public final void init(String interactionMode, MappingComponent mappingComponent, String selectName, String toolTipText) {
        super.init(interactionMode, mappingComponent, selectName);
        this.selectAction = GeoSelectionButton.createSelectAction(interactionMode, mappingComponent);
        this.selectMenuSelectedAction = GeoSelectionButton.createSelectMenuSelectedAction(interactionMode, mappingComponent);
        this.selectRectangleAction = GeoSelectionButton.createSelectRectangleAction(interactionMode, mappingComponent);
        this.selectPolygonAction = GeoSelectionButton.createSelectPolygonAction(interactionMode, mappingComponent);
        this.selectCidsFeatureAction = GeoSelectionButton.createSelectCidsFeatureAction(interactionMode, mappingComponent);
        this.selectEllipseAction = GeoSelectionButton.createSelectEllipseAction(interactionMode, mappingComponent);
        this.selectPolylineAction = GeoSelectionButton.createSelectPolylineAction(interactionMode, mappingComponent);
        this.selectRedoAction = GeoSelectionButton.createSelectRedoAction(interactionMode, mappingComponent);
        this.selectShowLastFeatureAction = GeoSelectionButton.createSelectShowLastFeatureAction(interactionMode, mappingComponent);
        this.selectBufferAction = GeoSelectionButton.createSelectBufferAction(interactionMode, mappingComponent);
        this.initComponents();
        this.setPopupMenu(this.popMenSelect);
        new CidsBeanDropTarget((Component)((Object)this));
        this.setTargetIcon(new ImageIcon(this.getClass().getResource("/images/selectTarget.png")));
        this.selectListener = (SelectionListener)mappingComponent.getInputListener(interactionMode);
        this.setButtonIcon(this.selectListener.getMode());
        this.setModeSelection(this.selectListener.getMode());
        this.setLastFeature((AbstractNewFeature)this.selectListener.getLastSelectFeature());
        this.selectListener.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public static Action createSelectAction(final String interactionMode, final MappingComponent mappingComponent) {
        SelectionListener selectListener = (SelectionListener)mappingComponent.getInputListener(interactionMode);
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"selectAction");
                }
                mappingComponent.setInteractionMode(interactionMode);
            }
        };
    }

    public static Action createSelectMenuSelectedAction(String interactionMode, MappingComponent mappingComponent) {
        SelectionListener selectListener = (SelectionListener)mappingComponent.getInputListener(interactionMode);
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"selectMenuSelectedAction");
                }
            }
        };
    }

    public static Action createSelectRectangleAction(final String interactionMode, final MappingComponent mappingComponent) {
        final SelectionListener selectListener = (SelectionListener)mappingComponent.getInputListener(interactionMode);
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"selectRectangleAction");
                }
                mappingComponent.setInteractionMode(interactionMode);
                selectListener.setMode("BOUNDING_BOX");
            }
        };
    }

    public static Action createSelectPolygonAction(final String interactionMode, final MappingComponent mappingComponent) {
        final SelectionListener selectListener = (SelectionListener)mappingComponent.getInputListener(interactionMode);
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"selectPolygonAction");
                }
                mappingComponent.setInteractionMode(interactionMode);
                selectListener.setMode("POLYGON");
            }
        };
    }

    public static Action createSelectCidsFeatureAction(final String interactionMode, final MappingComponent mappingComponent) {
        final SelectionListener selectListener = (SelectionListener)mappingComponent.getInputListener(interactionMode);
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"selectCidsFeatureAction");
                }
                mappingComponent.setInteractionMode(interactionMode);
                CismetThreadPool.execute((Runnable)new SwingWorker<SelectFeature, Void>(){

                    @Override
                    protected SelectFeature doInBackground() throws Exception {
                        Thread.currentThread().setName("GeoSelectionButton createSelectCidsFeatureAction");
                        DefaultMetaTreeNode[] nodes = ComponentRegistry.getRegistry().getActiveCatalogue().getSelectedNodesArray();
                        ArrayList<CidsBean> beans = new ArrayList<CidsBean>();
                        for (DefaultMetaTreeNode dmtn : nodes) {
                            if (!(dmtn instanceof ObjectTreeNode)) continue;
                            MetaObject mo = ((ObjectTreeNode)dmtn).getMetaObject();
                            beans.add(mo.getBean());
                        }
                        CidsBeansSelectFeature sf = CidsBeansSelectFeature.createFromBeans(beans, interactionMode);
                        sf.setGeometryType(AbstractNewFeature.geomTypes.MULTIPOLYGON);
                        return sf;
                    }

                    @Override
                    protected void done() {
                        try {
                            SelectFeature select = (SelectFeature)this.get();
                            if (select != null) {
                                selectListener.select(select);
                            }
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Exception in Background Thread", (Throwable)e);
                        }
                    }
                });
            }
        };
    }

    public static Action createSelectEllipseAction(final String interactionMode, final MappingComponent mappingComponent) {
        final SelectionListener selectListener = (SelectionListener)mappingComponent.getInputListener(interactionMode);
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"selectEllipseAction");
                }
                mappingComponent.setInteractionMode(interactionMode);
                selectListener.setMode("ELLIPSE");
            }
        };
    }

    public static Action createSelectPolylineAction(final String interactionMode, final MappingComponent mappingComponent) {
        final SelectionListener selectListener = (SelectionListener)mappingComponent.getInputListener(interactionMode);
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"selectPolylineAction");
                }
                mappingComponent.setInteractionMode(interactionMode);
                selectListener.setMode("LINESTRING");
            }
        };
    }

    public static Action createSelectRedoAction(final String interactionMode, final MappingComponent mappingComponent) {
        final SelectionListener selectListener = (SelectionListener)mappingComponent.getInputListener(interactionMode);
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"redoSelectAction");
                }
                selectListener.redoLastSelect();
                mappingComponent.setInteractionMode(interactionMode);
            }
        };
    }

    public static Action createSelectShowLastFeatureAction(final String interactionMode, final MappingComponent mappingComponent) {
        final SelectionListener selectListener = (SelectionListener)mappingComponent.getInputListener(interactionMode);
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"selectShowLastFeatureAction");
                }
                selectListener.showLastFeature();
                mappingComponent.setInteractionMode(interactionMode);
            }
        };
    }

    public static Action createSelectBufferAction(final String interactionMode, final MappingComponent mappingComponent) {
        final SelectionListener selectListener = (SelectionListener)mappingComponent.getInputListener(interactionMode);
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block8: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"bufferSelectGeometry");
                    }
                    String message = NbBundle.getMessage(GeoSelectionButton.class, (String)"GeoSelectionButton.createSelectBufferAction().bufferDialog.message");
                    String title = NbBundle.getMessage(GeoSelectionButton.class, (String)"GeoSelectionButton.createSelectBufferAction().bufferDialog.title");
                    String s = (String)JOptionPane.showInputDialog(StaticSwingTools.getParentFrame((Component)mappingComponent), message, title, -1, null, null, "");
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)s);
                    }
                    if (s.matches("\\d*,\\d*")) {
                        s.replace(",", ".");
                    }
                    try {
                        float buffer = Float.valueOf(s).floatValue();
                        SelectFeature lastFeature = selectListener.getLastSelectFeature();
                        if (lastFeature != null) {
                            Geometry geom = lastFeature.getGeometry();
                            Geometry bufferGeom = geom.buffer((double)buffer);
                            lastFeature.setGeometry(bufferGeom);
                            lastFeature.setGeometryType(AbstractNewFeature.geomTypes.POLYGON);
                            for (Object feature : mappingComponent.getFeatureCollection().getAllFeatures()) {
                                PFeature sel = (PFeature)mappingComponent.getPFeatureHM().get(feature);
                                if (!sel.getFeature().equals(lastFeature)) continue;
                                sel.setCoordArr(bufferGeom.getCoordinates());
                                sel.syncGeometry();
                                ArrayList<Feature> v = new ArrayList<Feature>();
                                v.add(sel.getFeature());
                                ((DefaultFeatureCollection)mappingComponent.getFeatureCollection()).fireFeaturesChanged(v);
                            }
                            selectListener.select(lastFeature);
                            mappingComponent.setInteractionMode(interactionMode);
                        }
                    }
                    catch (NumberFormatException ex) {
                        String messageEx = NbBundle.getMessage(GeoSelectionButton.class, (String)"GeoSelectionButton.createSelectBufferAction().NumberFormatException.bufferDialog.message");
                        String titleEx = NbBundle.getMessage(GeoSelectionButton.class, (String)"GeoSelectionButton.createSelectBufferAction().NumberFormatException.bufferDialog.title");
                        JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)mappingComponent), messageEx, titleEx, 0);
                    }
                    catch (Exception ex) {
                        if (!LOG.isDebugEnabled()) break block8;
                        LOG.debug((Object)"", (Throwable)ex);
                    }
                }
            }
        };
    }

    private void initComponents() {
        this.popMenSelect = new JPopupMenu();
        this.mniSelectRectangle1 = new HighlightingRadioButtonMenuItem(UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE);
        this.mniSelectPolygon1 = new HighlightingRadioButtonMenuItem(UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE);
        this.mniSelectEllipse1 = new HighlightingRadioButtonMenuItem(UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE);
        this.mniSelectPolyline1 = new HighlightingRadioButtonMenuItem(UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE);
        this.jSeparator12 = new JSeparator();
        this.mniSelectCidsFeature1 = new JRadioButtonMenuItem();
        this.mniSelectShowLastFeature1 = new JMenuItem();
        this.mniSelectRedo1 = new JMenuItem();
        this.mniSelectBuffer1 = new JMenuItem();
        this.buttonGroup1 = new ButtonGroup();
        this.popMenSelect.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                GeoSelectionButton.this.popMenSelectPopupMenuWillBecomeVisible(evt);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }
        });
        this.mniSelectRectangle1.setAction(this.selectRectangleAction);
        this.mniSelectRectangle1.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.mniSelectRectangle1, (String)NbBundle.getMessage(GeoSelectionButton.class, (String)"GeoSelectionButton.mniSelectRectangle1.text"));
        this.mniSelectRectangle1.setIcon(new ImageIcon(this.getClass().getResource("/images/rectangle.png")));
        this.popMenSelect.add(this.mniSelectRectangle1);
        this.mniSelectPolygon1.setAction(this.selectPolygonAction);
        Mnemonics.setLocalizedText((AbstractButton)this.mniSelectPolygon1, (String)NbBundle.getMessage(GeoSelectionButton.class, (String)"GeoSelectionButton.mniSelectPolygon1.text"));
        this.mniSelectPolygon1.setIcon(new ImageIcon(this.getClass().getResource("/images/polygon.png")));
        this.popMenSelect.add(this.mniSelectPolygon1);
        this.mniSelectEllipse1.setAction(this.selectEllipseAction);
        Mnemonics.setLocalizedText((AbstractButton)this.mniSelectEllipse1, (String)NbBundle.getMessage(GeoSelectionButton.class, (String)"GeoSelectionButton.mniSelectEllipse1.text"));
        this.mniSelectEllipse1.setIcon(new ImageIcon(this.getClass().getResource("/images/ellipse.png")));
        this.popMenSelect.add(this.mniSelectEllipse1);
        this.mniSelectPolyline1.setAction(this.selectPolylineAction);
        Mnemonics.setLocalizedText((AbstractButton)this.mniSelectPolyline1, (String)NbBundle.getMessage(GeoSelectionButton.class, (String)"GeoSelectionButton.mniSelectPolyline1.text"));
        this.mniSelectPolyline1.setIcon(new ImageIcon(this.getClass().getResource("/images/polyline.png")));
        this.popMenSelect.add(this.mniSelectPolyline1);
        this.popMenSelect.add(this.jSeparator12);
        this.mniSelectCidsFeature1.setAction(this.selectCidsFeatureAction);
        Mnemonics.setLocalizedText((AbstractButton)this.mniSelectCidsFeature1, (String)NbBundle.getMessage(GeoSelectionButton.class, (String)"GeoSelectionButton.mniSelectCidsFeature1.text"));
        this.mniSelectCidsFeature1.setIcon(new ImageIcon(this.getClass().getResource("/images/polygon.png")));
        this.popMenSelect.add(this.mniSelectCidsFeature1);
        this.mniSelectShowLastFeature1.setAction(this.selectShowLastFeatureAction);
        Mnemonics.setLocalizedText((AbstractButton)this.mniSelectShowLastFeature1, (String)NbBundle.getMessage(GeoSelectionButton.class, (String)"GeoSelectionButton.mniSelectShowLastFeature1.text"));
        this.mniSelectShowLastFeature1.setToolTipText(NbBundle.getMessage(GeoSelectionButton.class, (String)"GeoSelectionButton.mniSelectShowLastFeature1.toolTipText"));
        this.popMenSelect.add(this.mniSelectShowLastFeature1);
        this.mniSelectRedo1.setAction(this.selectRedoAction);
        Mnemonics.setLocalizedText((AbstractButton)this.mniSelectRedo1, (String)NbBundle.getMessage(GeoSelectionButton.class, (String)"GeoSelectionButton.mniSelectRedo1.text"));
        this.mniSelectRedo1.setToolTipText(NbBundle.getMessage(GeoSelectionButton.class, (String)"GeoSelectionButton.mniSelectRedo1.toolTipText"));
        this.popMenSelect.add(this.mniSelectRedo1);
        this.mniSelectBuffer1.setAction(this.selectBufferAction);
        this.mniSelectBuffer1.setIcon(new ImageIcon(this.getClass().getResource("/images/buffer.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.mniSelectBuffer1, (String)NbBundle.getMessage(GeoSelectionButton.class, (String)"GeoSelectionButton.mniSelectBuffer1.text"));
        this.mniSelectBuffer1.setToolTipText(NbBundle.getMessage(GeoSelectionButton.class, (String)"GeoSelectionButton.mniSelectBuffer1.toolTipText"));
        this.popMenSelect.add(this.mniSelectBuffer1);
        this.setAction(this.selectAction);
        this.setIcon(new ImageIcon(this.getClass().getResource("/images/selectRectangle.png")));
        this.setToolTipText(NbBundle.getMessage(GeoSelectionButton.class, (String)"GeoSelectionButton.toolTipText"));
    }

    private void popMenSelectPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        this.selectMenuSelectedAction.actionPerformed(new ActionEvent(this.popMenSelect, 1001, null));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource().equals(this.selectListener)) {
            if ("PROPERTY_LAST_FEATURE".equals(evt.getPropertyName())) {
                this.setLastFeature((AbstractNewFeature)this.selectListener.getLastSelectFeature());
            } else if ("PROPERTY_MODE".equals(evt.getPropertyName())) {
                this.setSelected(true);
                this.setModeSelection(this.selectListener.getMode());
                this.setButtonIcon(this.selectListener.getMode());
            }
        }
    }

    private void setLastFeature(AbstractNewFeature lastFeature) {
        if (lastFeature == null) {
            this.mniSelectShowLastFeature1.setIcon(null);
            this.mniSelectShowLastFeature1.setEnabled(false);
            this.mniSelectRedo1.setIcon(null);
            this.mniSelectRedo1.setEnabled(false);
            this.mniSelectBuffer1.setEnabled(false);
        } else {
            switch (lastFeature.getGeometryType()) {
                case ELLIPSE: {
                    this.mniSelectRedo1.setIcon(this.mniSelectEllipse1.getIcon());
                    break;
                }
                case LINESTRING: {
                    this.mniSelectRedo1.setIcon(this.mniSelectPolyline1.getIcon());
                    break;
                }
                case POLYGON: {
                    this.mniSelectRedo1.setIcon(this.mniSelectPolygon1.getIcon());
                    break;
                }
                case RECTANGLE: {
                    this.mniSelectRedo1.setIcon(this.mniSelectRectangle1.getIcon());
                }
            }
            this.mniSelectRedo1.setEnabled(true);
            this.mniSelectBuffer1.setEnabled(true);
            this.mniSelectShowLastFeature1.setIcon(this.mniSelectRedo1.getIcon());
            this.mniSelectShowLastFeature1.setEnabled(true);
        }
    }

    private void setButtonIcon(String mode) {
        if ("BOUNDING_BOX".equals(mode)) {
            this.setIcon(new ImageIcon(this.getClass().getResource("/images/selectRectangle.png")));
            this.setSelectedIcon(new ImageIcon(this.getClass().getResource("/images/selectRectangle.png")));
        } else if ("POLYGON".equals(mode)) {
            this.setIcon(new ImageIcon(this.getClass().getResource("/images/selectPolygon.png")));
            this.setSelectedIcon(new ImageIcon(this.getClass().getResource("/images/selectPolygon.png")));
        } else if ("ELLIPSE".equals(mode)) {
            this.setIcon(new ImageIcon(this.getClass().getResource("/images/selectEllipse.png")));
            this.setSelectedIcon(new ImageIcon(this.getClass().getResource("/images/selectEllipse.png")));
        } else if ("LINESTRING".equals(mode)) {
            this.setIcon(new ImageIcon(this.getClass().getResource("/images/selectPolyline.png")));
            this.setSelectedIcon(new ImageIcon(this.getClass().getResource("/images/selectPolyline.png")));
        }
    }

    private void setModeSelection(String mode) {
        this.mniSelectRectangle1.setSelected("BOUNDING_BOX".equals(mode));
        this.mniSelectPolygon1.setSelected("POLYGON".equals(mode));
        this.mniSelectEllipse1.setSelected("ELLIPSE".equals(mode));
        this.mniSelectPolyline1.setSelected("LINESTRING".equals(mode));
    }

    public String getValue(String key) {
        return "GeoSelectionButton";
    }

    public Component getComponent() {
        return this;
    }
}

