/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.gui.piccolo.FixedPImage;
import de.cismet.cismap.commons.gui.piccolo.PSticky;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.StaticDecimalTools;
import edu.umd.cs.piccolo.PNode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import org.deegree.model.crs.UnknownCRSException;
import org.openide.util.NbBundle;

public class GotoPointDialog
extends JDialog {
    private static volatile GotoPointDialog instance = null;
    private final Logger log = Logger.getLogger(this.getClass());
    private ImageIcon mark = new ImageIcon(this.getClass().getResource("/images/markPoint.png"));
    private final Properties sweetSpotOfpMark = new Properties();
    private FixedPImage pMark = new FixedPImage(this.mark.getImage());
    private Point gotoPoint = null;
    private HashMap<JTextField, Crs> crsByTextfieldHM = new HashMap();
    private boolean docListenersEnabled = false;
    private JButton btnCancel;
    private JButton btnPosition;
    private JCheckBox cbMarkPoint;
    private JComboBox<String> cboAdditionalSRS;
    private JPanel jPanel1;
    private JLabel lblIcon;
    private JLabel lblMessage;
    private JLabel lblSRS1;
    private JLabel lblSRS2;
    private JLabel lblSRS3;
    private JPanel panActions;
    private JPanel panMarkPoint;
    private JTextField tfCoordinatesSRS0;
    private JTextField tfCoordinatesSRS1;
    private JTextField tfCoordinatesSRS2;

    private GotoPointDialog() {
        try {
            this.sweetSpotOfpMark.load(this.getClass().getResourceAsStream("/images/markPointSweetSpot.properties"));
            this.pMark.setSweetSpotX(Double.valueOf(this.sweetSpotOfpMark.getProperty("x", "0")).doubleValue());
            this.pMark.setSweetSpotY(Double.valueOf(this.sweetSpotOfpMark.getProperty("y", "0")).doubleValue());
        }
        catch (IOException iox) {
            this.log.warn((Object)"Problem when loading the markPointSweetSpot.properties", (Throwable)iox);
        }
        this.initComponents();
        this.tfCoordinatesSRS0.getDocument().addDocumentListener(new CoordDocumentListener(this.tfCoordinatesSRS0));
        this.tfCoordinatesSRS1.getDocument().addDocumentListener(new CoordDocumentListener(this.tfCoordinatesSRS1));
        this.tfCoordinatesSRS2.getDocument().addDocumentListener(new CoordDocumentListener(this.tfCoordinatesSRS2));
        this.cboAdditionalSRS.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof Crs) {
                    Component c = super.getListCellRendererComponent(list, ((Crs)value).getShortname(), index, isSelected, cellHasFocus);
                    if (c instanceof JLabel) {
                        ((JLabel)c).setHorizontalAlignment(4);
                    }
                    return c;
                }
                return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        });
        this.pMark.setVisible(true);
        List crss = CismapBroker.getInstance().getMappingComponent().getCrsList();
        if (crss.size() > 3) {
            this.crsByTextfieldHM.put(this.tfCoordinatesSRS0, (Crs)crss.get(0));
            this.crsByTextfieldHM.put(this.tfCoordinatesSRS1, (Crs)crss.get(1));
            this.lblSRS3.setVisible(false);
            this.lblSRS1.setText(((Crs)crss.get(0)).getShortname());
            this.lblSRS2.setText(((Crs)crss.get(1)).getShortname());
            DefaultComboBoxModel<Crs> model = new DefaultComboBoxModel<Crs>();
            for (Crs s : crss.subList(2, crss.size())) {
                model.addElement(s);
            }
            this.cboAdditionalSRS.setModel(model);
            this.crsByTextfieldHM.put(this.tfCoordinatesSRS2, (Crs)this.cboAdditionalSRS.getSelectedItem());
        } else if (crss.size() == 3) {
            this.crsByTextfieldHM.put(this.tfCoordinatesSRS0, (Crs)crss.get(0));
            this.crsByTextfieldHM.put(this.tfCoordinatesSRS1, (Crs)crss.get(1));
            this.crsByTextfieldHM.put(this.tfCoordinatesSRS2, (Crs)crss.get(2));
            this.lblSRS1.setText(((Crs)crss.get(0)).getShortname());
            this.lblSRS2.setText(((Crs)crss.get(1)).getShortname());
            this.lblSRS3.setText(((Crs)crss.get(2)).getShortname());
            this.cboAdditionalSRS.setVisible(false);
        } else if (crss.size() == 2) {
            this.lblSRS3.setVisible(false);
            this.cboAdditionalSRS.setVisible(false);
            this.tfCoordinatesSRS2.setVisible(false);
            this.lblSRS1.setText(((Crs)crss.get(0)).getShortname());
            this.lblSRS2.setText(((Crs)crss.get(1)).getShortname());
            this.crsByTextfieldHM.put(this.tfCoordinatesSRS0, (Crs)crss.get(0));
            this.crsByTextfieldHM.put(this.tfCoordinatesSRS1, (Crs)crss.get(1));
        } else if (crss.size() == 1) {
            this.cboAdditionalSRS.setVisible(false);
            this.tfCoordinatesSRS2.setVisible(false);
            this.lblSRS3.setVisible(false);
            this.lblSRS2.setVisible(false);
            this.tfCoordinatesSRS1.setVisible(false);
            this.crsByTextfieldHM.put(this.tfCoordinatesSRS0, (Crs)crss.get(0));
            this.lblSRS1.setText(((Crs)crss.get(0)).getShortname());
        }
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static GotoPointDialog getInstance() {
        if (instance == null) {
            Class<GotoPointDialog> clazz = GotoPointDialog.class;
            // MONITORENTER : de.cismet.cismap.navigatorplugin.GotoPointDialog.class
            if (instance == null) {
                instance = new GotoPointDialog();
            }
            // MONITOREXIT : clazz
        }
        try {
            instance.setInternalCenterCoordinatesCenterOfCamera();
            return instance;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return instance;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.lblMessage = new JLabel();
        this.panActions = new JPanel();
        this.btnPosition = new JButton();
        this.btnCancel = new JButton();
        this.cboAdditionalSRS = new JComboBox();
        this.lblSRS1 = new JLabel();
        this.lblSRS2 = new JLabel();
        this.panMarkPoint = new JPanel();
        this.cbMarkPoint = new JCheckBox();
        this.lblIcon = new JLabel();
        this.tfCoordinatesSRS0 = new JTextField();
        this.tfCoordinatesSRS1 = new JTextField();
        this.tfCoordinatesSRS2 = new JTextField();
        this.lblSRS3 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(GotoPointDialog.class, (String)"GotoPointDialog.title"));
        this.setIconImage(null);
        this.setModal(true);
        this.setResizable(false);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.lblMessage.setText(NbBundle.getMessage(GotoPointDialog.class, (String)"GotoPointDialog.lblMessage.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.ipady = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 9, 3, 3);
        this.jPanel1.add((Component)this.lblMessage, gridBagConstraints);
        this.panActions.setLayout(new GridLayout(1, 0, 5, 0));
        this.btnPosition.setText(NbBundle.getMessage(GotoPointDialog.class, (String)"GotoPointDialog.btnPosition.text"));
        this.btnPosition.setMaximumSize(new Dimension(100, 25));
        this.btnPosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GotoPointDialog.this.btnPositionActionPerformed(evt);
            }
        });
        this.panActions.add(this.btnPosition);
        this.btnCancel.setText(NbBundle.getMessage(GotoPointDialog.class, (String)"GotoPointDialog.btnCancel.text"));
        this.btnCancel.setMaximumSize(new Dimension(90, 25));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GotoPointDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.panActions.add(this.btnCancel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(8, 0, 13, 14);
        this.jPanel1.add((Component)this.panActions, gridBagConstraints);
        this.cboAdditionalSRS.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cboAdditionalSRS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GotoPointDialog.this.cboAdditionalSRSActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 14, 3, 3);
        this.jPanel1.add(this.cboAdditionalSRS, gridBagConstraints);
        this.lblSRS1.setText(NbBundle.getMessage(GotoPointDialog.class, (String)"GotoPointDialog.lblSRS1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(14, 14, 3, 3);
        this.jPanel1.add((Component)this.lblSRS1, gridBagConstraints);
        this.lblSRS2.setText(NbBundle.getMessage(GotoPointDialog.class, (String)"GotoPointDialog.lblSRS2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 14, 3, 3);
        this.jPanel1.add((Component)this.lblSRS2, gridBagConstraints);
        this.cbMarkPoint.setSelected(true);
        this.cbMarkPoint.setText(NbBundle.getMessage(GotoPointDialog.class, (String)"GotoPointDialog.cbMarkPoint.text"));
        this.cbMarkPoint.setToolTipText(NbBundle.getMessage(GotoPointDialog.class, (String)"GotoPointDialog.cbMarkPoint.toolTipText"));
        this.cbMarkPoint.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                GotoPointDialog.this.cbMarkPointItemStateChanged(evt);
            }
        });
        this.panMarkPoint.add(this.cbMarkPoint);
        this.lblIcon.setIcon(new ImageIcon(this.getClass().getResource("/images/markPoint.png")));
        this.lblIcon.setText(NbBundle.getMessage(GotoPointDialog.class, (String)"GotoPointDialog.lblIcon.text"));
        this.lblIcon.setToolTipText(NbBundle.getMessage(GotoPointDialog.class, (String)"GotoPointDialog.cbMarkPoint.toolTipText"));
        this.panMarkPoint.add(this.lblIcon);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(0, 11, 10, 6);
        this.jPanel1.add((Component)this.panMarkPoint, gridBagConstraints);
        this.tfCoordinatesSRS0.setText(NbBundle.getMessage(GotoPointDialog.class, (String)"GotoPointDialog.tfCoordinatesSRS0.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(14, 3, 3, 13);
        this.jPanel1.add((Component)this.tfCoordinatesSRS0, gridBagConstraints);
        this.tfCoordinatesSRS1.setText(NbBundle.getMessage(GotoPointDialog.class, (String)"GotoPointDialog.tfCoordinatesSRS1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 13);
        this.jPanel1.add((Component)this.tfCoordinatesSRS1, gridBagConstraints);
        this.tfCoordinatesSRS2.setText(NbBundle.getMessage(GotoPointDialog.class, (String)"GotoPointDialog.tfCoordinatesSRS2.text"));
        this.tfCoordinatesSRS2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GotoPointDialog.this.tfCoordinatesSRS2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 13);
        this.jPanel1.add((Component)this.tfCoordinatesSRS2, gridBagConstraints);
        this.lblSRS3.setText(NbBundle.getMessage(GotoPointDialog.class, (String)"GotoPointDialog.lblSRS3.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(3, 14, 3, 3);
        this.jPanel1.add((Component)this.lblSRS3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 6, 10);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btnPositionActionPerformed(ActionEvent evt) {
        try {
            Point gotoPointInTheRightCRS = (Point)CrsTransformer.transformToCurrentCrs((Geometry)this.gotoPoint);
            BoundingBox bb = new BoundingBox(gotoPointInTheRightCRS.getX(), gotoPointInTheRightCRS.getY(), gotoPointInTheRightCRS.getX(), gotoPointInTheRightCRS.getY());
            CismapBroker.getInstance().getMappingComponent().gotoBoundingBox(bb, true, false, CismapBroker.getInstance().getMappingComponent().getAnimationDuration());
            this.visualizePosition(gotoPointInTheRightCRS.getX(), gotoPointInTheRightCRS.getY());
        }
        catch (Exception skip) {
            this.log.error((Object)"Error in mniGotoPointActionPerformed", (Throwable)skip);
        }
        finally {
            this.setVisible(false);
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void cbMarkPointItemStateChanged(ItemEvent evt) {
        this.visualizePosition();
    }

    private void tfCoordinatesSRS2ActionPerformed(ActionEvent evt) {
    }

    private void cboAdditionalSRSActionPerformed(ActionEvent evt) {
        this.crsByTextfieldHM.put(this.tfCoordinatesSRS2, (Crs)this.cboAdditionalSRS.getSelectedItem());
        this.syncPosition(null);
    }

    private void setInternalCenterCoordinatesCenterOfCamera() throws UnknownCRSException {
        BoundingBox c = CismapBroker.getInstance().getMappingComponent().getCurrentBoundingBoxFromCamera();
        double x = (c.getX1() + c.getX2()) / 2.0;
        double y = (c.getY1() + c.getY2()) / 2.0;
        CoordinateArraySequence coordSeq = new CoordinateArraySequence(new Coordinate[]{new Coordinate(x, y)});
        GeometryFactory gfactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getSrs().getCode()));
        this.gotoPoint = new Point((CoordinateSequence)coordSeq, gfactory);
        this.syncPosition(null);
    }

    private void syncPosition(JTextField origin) {
        if (origin != null) {
            try {
                String[] sa = origin.getText().split(",");
                double x = Double.parseDouble(sa[0]);
                double y = Double.parseDouble(sa[1]);
                CoordinateArraySequence coordSeq = new CoordinateArraySequence(new Coordinate[]{new Coordinate(x, y)});
                GeometryFactory gfactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CrsTransformer.extractSridFromCrs((String)this.crsByTextfieldHM.get(origin).getCode()));
                this.gotoPoint = new Point((CoordinateSequence)coordSeq, gfactory);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.gotoPoint != null) {
            this.disableAllDocumentListeners();
            for (JTextField tf : this.crsByTextfieldHM.keySet()) {
                if (tf == origin) continue;
                this.fillCoordinateToTextField(tf, (Point)CrsTransformer.transformToGivenCrs((Geometry)this.gotoPoint, (String)this.crsByTextfieldHM.get(tf).getCode()));
            }
            this.enableAllDocumentListeners();
        }
    }

    private void disableAllDocumentListeners() {
        this.docListenersEnabled = false;
    }

    private void enableAllDocumentListeners() {
        this.docListenersEnabled = true;
    }

    private void fillCoordinateToTextField(JTextField tf, Point p) {
        double x = p.getX();
        double y = p.getY();
        String pattern = CismapBroker.getInstance().crsFromCode(CrsTransformer.createCrsFromSrid((int)p.getSRID())).isMetric() ? "0.00" : "0.000000";
        tf.setText(StaticDecimalTools.round((String)pattern, (double)x) + "," + StaticDecimalTools.round((String)pattern, (double)y));
    }

    private void visualizePosition() {
        BoundingBox c = CismapBroker.getInstance().getMappingComponent().getCurrentBoundingBoxFromCamera();
        double x = (c.getX1() + c.getX2()) / 2.0;
        double y = (c.getY1() + c.getY2()) / 2.0;
        this.visualizePosition(x, y);
    }

    private void visualizePosition(double x, double y) {
        CismapBroker.getInstance().getMappingComponent().getHighlightingLayer().removeAllChildren();
        if (this.cbMarkPoint.isSelected()) {
            CismapBroker.getInstance().getMappingComponent().getHighlightingLayer().addChild((PNode)this.pMark);
            CismapBroker.getInstance().getMappingComponent().addStickyNode((PSticky)this.pMark);
            double screenx = CismapBroker.getInstance().getMappingComponent().getWtst().getScreenX(x);
            double screeny = CismapBroker.getInstance().getMappingComponent().getWtst().getScreenY(y);
            this.pMark.setOffset(screenx, screeny);
            CismapBroker.getInstance().getMappingComponent().rescaleStickyNodes();
        }
    }

    private class CoordDocumentListener
    implements DocumentListener {
        private JTextField tf;

        public CoordDocumentListener(JTextField tf) {
            this.tf = tf;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (GotoPointDialog.this.docListenersEnabled) {
                GotoPointDialog.this.syncPosition(this.tf);
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (GotoPointDialog.this.docListenersEnabled) {
                GotoPointDialog.this.syncPosition(this.tf);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            if (GotoPointDialog.this.docListenersEnabled) {
                GotoPointDialog.this.syncPosition(this.tf);
            }
        }
    }
}

