/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin;

import Sirius.navigator.plugin.listener.MetaNodeSelectionListener;
import Sirius.navigator.types.treenode.DefaultMetaTreeNode;
import Sirius.navigator.types.treenode.ObjectTreeNode;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.navigator.ui.ShowObjectsInGuiMethod;
import Sirius.server.localserver.attribute.ObjectAttribute;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollectionAdapter;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.FeatureGroup;
import de.cismet.cismap.commons.features.FeatureGroups;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import de.cismet.cismap.navigatorplugin.MapVisualisationProvider;
import de.cismet.cismap.navigatorplugin.ShowObjectsWaitDialog;
import de.cismet.ext.CExtContext;
import de.cismet.ext.CExtManager;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.EventQueue;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.SwingWorker;
import javax.swing.event.TreeSelectionListener;
import org.apache.log4j.Logger;

public class ShowObjectsMethod
implements ShowObjectsInGuiMethod {
    private static final Logger LOG = Logger.getLogger(ShowObjectsMethod.class);
    private ShowObjectsWaitDialog showObjectsWaitDialog;
    private final Map<DefaultMetaTreeNode, Feature> featuresInMap = new HashMap<DefaultMetaTreeNode, Feature>();
    private final Map<Feature, DefaultMetaTreeNode> featuresInMapReverse = new HashMap<Feature, DefaultMetaTreeNode>();
    private MappingComponent mapC;
    private boolean nodeSelectionEventBlocker = false;
    private boolean featureCollectionEventBlocker = false;

    public void init() {
        this.mapC = CismapBroker.getInstance().getMappingComponent();
        this.mapC.getFeatureCollection().addFeatureCollectionListener((FeatureCollectionListener)new CatalogueFeatureCollectionListener());
        NodeChangeListener nodeChangeListener = new NodeChangeListener();
        if (ComponentRegistry.getRegistry().getCatalogueTree() != null && ComponentRegistry.getRegistry().getSearchResultsTree() != null) {
            ComponentRegistry.getRegistry().getCatalogueTree().addTreeSelectionListener((TreeSelectionListener)((Object)nodeChangeListener));
            ComponentRegistry.getRegistry().getSearchResultsTree().addTreeSelectionListener((TreeSelectionListener)((Object)nodeChangeListener));
        }
    }

    public void invoke() throws Exception {
        Collection selectedNodes = ComponentRegistry.getRegistry().getActiveCatalogue().getSelectedNodes();
        this.invoke(selectedNodes);
    }

    public void invoke(Collection nodes) throws Exception {
        this.invoke(nodes, false);
    }

    public synchronized CidsFeature invoke(MetaObject mo, boolean editable) throws Exception {
        CidsFeature cidsFeature = new CidsFeature(mo);
        this.invoke(cidsFeature, editable);
        return cidsFeature;
    }

    private void invoke(CidsFeature cidsFeature, boolean editable) throws Exception {
        ArrayList<CidsFeature> v = new ArrayList<CidsFeature>();
        cidsFeature.setEditable(editable);
        v.add(cidsFeature);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("mapC.getFeatureCollection().getAllFeatures():" + this.mapC.getFeatureCollection().getAllFeatures()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("cidsFeature:" + cidsFeature));
            LOG.debug((Object)("mapC.getFeatureCollection().getAllFeatures().contains(cidsFeature):" + this.mapC.getFeatureCollection().getAllFeatures().contains(cidsFeature)));
        }
        this.mapC.getFeatureLayer().setVisible(true);
        this.mapC.getFeatureCollection().removeFeature((Feature)cidsFeature);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("mapC.getFeatureCollection().getAllFeatures():" + this.mapC.getFeatureCollection().getAllFeatures()));
        }
        this.mapC.getFeatureCollection().substituteFeatures(v);
        if (editable) {
            this.mapC.getFeatureCollection().select(v);
        }
        if (!this.mapC.isFixedMapExtent()) {
            this.mapC.zoomToFeatureCollection(this.mapC.isFixedMapScale());
            this.mapC.showHandles(true);
        }
    }

    public synchronized CidsFeature invoke(DefaultMetaTreeNode node, ObjectAttribute oAttr, boolean editable) throws Exception {
        MetaObject loader = ((ObjectTreeNode)node).getMetaObject();
        MetaObjectNode mon = ((ObjectTreeNode)node).getMetaObjectNode();
        CidsFeature cidsFeature = this.invoke(loader, editable);
        cidsFeature = oAttr != null ? new CidsFeature(mon, oAttr) : new CidsFeature(mon);
        this.featuresInMap.put(node, (Feature)cidsFeature);
        this.featuresInMapReverse.put((Feature)cidsFeature, node);
        this.invoke(cidsFeature, editable);
        return cidsFeature;
    }

    public synchronized void invoke(final Collection<DefaultMetaTreeNode> nodes, final boolean editable) throws Exception {
        LOG.info((Object)"invoke shows objects in the map");
        Runnable showWaitRunnable = new Runnable(){

            @Override
            public void run() {
                if (ShowObjectsMethod.this.showObjectsWaitDialog == null) {
                    ShowObjectsMethod.this.showObjectsWaitDialog = new ShowObjectsWaitDialog((Frame)ComponentRegistry.getRegistry().getMainWindow(), false);
                }
                StaticSwingTools.showDialog((JDialog)ShowObjectsMethod.this.showObjectsWaitDialog);
                SwingWorker<List<Feature>, Void> addToMapWorker = new SwingWorker<List<Feature>, Void>(){
                    private Map<DefaultMetaTreeNode, Feature> tmpFeaturesInMap = null;
                    private Map<Feature, DefaultMetaTreeNode> tmpFeaturesInMapReverse = null;

                    @Override
                    protected List<Feature> doInBackground() throws Exception {
                        Thread.currentThread().setName("ShowObjectsMethod addToMapWorker");
                        Iterator mapIter = ShowObjectsMethod.this.featuresInMap.keySet().iterator();
                        while (mapIter.hasNext()) {
                            DefaultMetaTreeNode node = (DefaultMetaTreeNode)mapIter.next();
                            Feature f = (Feature)ShowObjectsMethod.this.featuresInMap.get(node);
                            if (ShowObjectsMethod.this.mapC.getFeatureCollection().isHoldFeature(f)) continue;
                            mapIter.remove();
                            ShowObjectsMethod.this.featuresInMapReverse.remove(f);
                        }
                        ArrayList<Feature> features = new ArrayList<Feature>();
                        for (DefaultMetaTreeNode node : nodes) {
                            List<Feature> allFeaturesToAdd;
                            MetaObjectNode mon = ((ObjectTreeNode)node).getMetaObjectNode();
                            MetaObject mo = mon.getObject();
                            if (mo == null) {
                                mo = ((ObjectTreeNode)node).getMetaObject();
                            }
                            CExtContext context = new CExtContext("__ctx_prop_reference__", (Object)mo.getBean());
                            MapVisualisationProvider mvp = (MapVisualisationProvider)CExtManager.getInstance().getExtension(MapVisualisationProvider.class, context);
                            Feature feature = mvp.getFeature(mo.getBean());
                            if (feature == null) continue;
                            feature.setEditable(editable);
                            if (feature instanceof FeatureGroup) {
                                FeatureGroup fg = (FeatureGroup)feature;
                                allFeaturesToAdd = new ArrayList<Feature>(FeatureGroups.expandAll((FeatureGroup)fg));
                            } else {
                                allFeaturesToAdd = Arrays.asList(feature);
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("allFeaturesToAdd:" + allFeaturesToAdd));
                            }
                            if (ShowObjectsMethod.this.featuresInMap.containsValue(feature)) continue;
                            features.addAll(allFeaturesToAdd);
                            ShowObjectsMethod.this.featuresInMap.put(node, feature);
                            for (Feature f : allFeaturesToAdd) {
                                ShowObjectsMethod.this.featuresInMapReverse.put(f, node);
                            }
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug((Object)("featuresInMap.put(node,cidsFeature):" + node + "," + feature));
                        }
                        this.tmpFeaturesInMap = new HashMap<DefaultMetaTreeNode, Feature>(ShowObjectsMethod.this.featuresInMap);
                        this.tmpFeaturesInMapReverse = new HashMap<Feature, DefaultMetaTreeNode>(ShowObjectsMethod.this.featuresInMapReverse);
                        return features;
                    }

                    @Override
                    protected void done() {
                        try {
                            ShowObjectsMethod.this.showObjectsWaitDialog.setVisible(false);
                            List features = (List)this.get();
                            ShowObjectsMethod.this.mapC.getFeatureLayer().setVisible(true);
                            ShowObjectsMethod.this.mapC.getFeatureCollection().substituteFeatures((Collection)features);
                            ShowObjectsMethod.this.featuresInMap.clear();
                            ShowObjectsMethod.this.featuresInMap.putAll(this.tmpFeaturesInMap);
                            ShowObjectsMethod.this.featuresInMapReverse.clear();
                            ShowObjectsMethod.this.featuresInMapReverse.putAll(this.tmpFeaturesInMapReverse);
                            if (!ShowObjectsMethod.this.mapC.isFixedMapExtent()) {
                                ShowObjectsMethod.this.mapC.zoomToFeatureCollection(ShowObjectsMethod.this.mapC.isFixedMapScale());
                            }
                        }
                        catch (InterruptedException e) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)e, (Throwable)e);
                            }
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Error while displaying objects:", (Throwable)e);
                        }
                    }
                };
                CismetThreadPool.execute((Runnable)addToMapWorker);
            }
        };
        if (EventQueue.isDispatchThread()) {
            showWaitRunnable.run();
        } else {
            EventQueue.invokeLater(showWaitRunnable);
        }
    }

    public String getId() {
        return this.getClass().getName();
    }

    private class NodeChangeListener
    extends MetaNodeSelectionListener {
        private NodeChangeListener() {
        }

        protected void nodeSelectionChanged(Collection wirdNichtGebrauchtWeilScheissevonPascalgefuelltCollection) {
            if (!ShowObjectsMethod.this.nodeSelectionEventBlocker) {
                try {
                    Collection c = ComponentRegistry.getRegistry().getActiveCatalogue().getSelectedNodes();
                    if (c != null && !c.isEmpty()) {
                        Object[] nodes = c.toArray();
                        boolean oneHit = false;
                        ArrayList features = new ArrayList();
                        for (Object o : nodes) {
                            if (!(o instanceof DefaultMetaTreeNode)) continue;
                            DefaultMetaTreeNode node = (DefaultMetaTreeNode)o;
                            if (!ShowObjectsMethod.this.featuresInMap.containsKey(node)) continue;
                            oneHit = true;
                            features.add(ShowObjectsMethod.this.featuresInMap.get(node));
                        }
                        if (oneHit) {
                            ShowObjectsMethod.this.featureCollectionEventBlocker = true;
                            ShowObjectsMethod.this.mapC.getFeatureCollection().select(features);
                            ShowObjectsMethod.this.featureCollectionEventBlocker = false;
                        } else {
                            ShowObjectsMethod.this.featureCollectionEventBlocker = true;
                            ShowObjectsMethod.this.mapC.getFeatureCollection().unselectAll();
                            ShowObjectsMethod.this.featureCollectionEventBlocker = false;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("featuresInMap:" + ShowObjectsMethod.this.featuresInMap));
                            }
                        }
                    }
                }
                catch (Exception t) {
                    LOG.error((Object)"Error in WizardMode:", (Throwable)t);
                }
            }
        }
    }

    private class CatalogueFeatureCollectionListener
    extends FeatureCollectionAdapter {
        private CatalogueFeatureCollectionListener() {
        }

        public void allFeaturesRemoved(FeatureCollectionEvent fce) {
            for (Feature feature : fce.getEventFeatures()) {
                DefaultMetaTreeNode node = (DefaultMetaTreeNode)ShowObjectsMethod.this.featuresInMapReverse.get(feature);
                if (node == null) continue;
                ShowObjectsMethod.this.featuresInMapReverse.remove(feature);
                ShowObjectsMethod.this.featuresInMap.remove(node);
            }
        }

        public void featuresRemoved(FeatureCollectionEvent fce) {
            ShowObjectsMethod.this.featuresInMap.clear();
            ShowObjectsMethod.this.featuresInMapReverse.clear();
        }

        public void featureSelectionChanged(FeatureCollectionEvent fce) {
            if (!ShowObjectsMethod.this.featureCollectionEventBlocker) {
                ArrayList fc = new ArrayList(ShowObjectsMethod.this.mapC.getFeatureCollection().getSelectedFeatures());
                final ArrayList nodeVector = new ArrayList();
                for (Feature f : fc) {
                    if (!(f instanceof CidsFeature) && !(f instanceof FeatureGroup)) continue;
                    nodeVector.add(ShowObjectsMethod.this.featuresInMapReverse.get(f));
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ShowObjectsMethod.this.nodeSelectionEventBlocker = true;
                        if (ComponentRegistry.getRegistry().getActiveCatalogue() != null) {
                            ComponentRegistry.getRegistry().getActiveCatalogue().setSelectedNodes((Collection)nodeVector, true);
                        }
                        ShowObjectsMethod.this.nodeSelectionEventBlocker = false;
                    }
                });
            }
        }
    }
}

