/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin.actions;

import Sirius.navigator.NavigatorX;
import Sirius.navigator.ui.ComponentRegistry;
import de.cismet.cismap.commons.RestrictedFileSystemView;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.layerwidget.LayerDropUtils;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.gui.menu.CidsUiAction;
import de.cismet.tools.gui.menu.CidsUiActionProvider;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class ConfigurationActionProvider
implements CidsUiActionProvider {
    private static final Logger LOG = Logger.getLogger(ConfigurationActionProvider.class);
    private static String cismapDirectory;

    public ConfigurationActionProvider() {
        NavigatorX navigator = (NavigatorX)ComponentRegistry.getRegistry().getMainWindow();
        if (navigator != null) {
            cismapDirectory = navigator.getCismapDirectory();
        }
    }

    public List<CidsUiAction> getActions() {
        ArrayList<CidsUiAction> actionList = new ArrayList<CidsUiAction>();
        NavigatorX navigator = (NavigatorX)ComponentRegistry.getRegistry().getMainWindow();
        if (navigator != null) {
            // empty if block
        }
        actionList.add(new LoadConfigurationAction());
        actionList.add(new LoadConfigurationFromServerAction());
        actionList.add(new SaveConfigurationAction());
        actionList.add(new LoadShapeAction());
        return actionList;
    }

    private static class LoadShapeAction
    extends AbstractAction
    implements CidsUiAction {
        public LoadShapeAction() {
            String tooltip = NbBundle.getMessage(LoadShapeAction.class, (String)"ConfigurationActionProvider.LoadShapeAction.toolTipText");
            String name = NbBundle.getMessage(LoadShapeAction.class, (String)"ConfigurationActionProvider.LoadShapeAction.text");
            this.putValue("ShortDescription", tooltip);
            this.putValue("Name", name);
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/icon-importfile.png")));
            this.putValue("SwingLargeIconKey", new ImageIcon(this.getClass().getResource("/images/icon-importfile.png")));
            this.putValue("CidsActionKey", "cismap.load.shape");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fc;
            JFrame parent = ComponentRegistry.getRegistry().getMainWindow();
            try {
                fc = new JFileChooser(cismapDirectory);
            }
            catch (Exception bug) {
                fc = new JFileChooser(cismapDirectory, (FileSystemView)new RestrictedFileSystemView());
            }
            fc.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".shp");
                }

                @Override
                public String getDescription() {
                    return NbBundle.getMessage(ConfigurationActionProvider.class, (String)"ConfigurationActionProvider.LoadShapeAction.FileFiltergetDescription.return");
                }
            });
            int state = fc.showOpenDialog(parent);
            if (state == 0) {
                File file = fc.getSelectedFile();
                String name = file.getAbsolutePath();
                ActiveLayerModel model = (ActiveLayerModel)CismapBroker.getInstance().getMappingComponent().getMappingModel();
                LayerDropUtils.handleFiles(Collections.nCopies(1, file), (ActiveLayerModel)model, (int)0, (Component)parent);
            }
        }
    }

    private static class LoadConfigurationFromServerAction
    extends AbstractAction
    implements CidsUiAction {
        public LoadConfigurationFromServerAction() {
            this.initAction();
        }

        private void initAction() {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/config.png")));
            this.putValue("Name", NbBundle.getMessage(ConfigurationActionProvider.class, (String)"ConfigurationActionProvider.LoadConfigurationFromServerAction.initAction.title"));
            this.putValue("ShortDescription", NbBundle.getMessage(ConfigurationActionProvider.class, (String)"ConfigurationActionProvider.LoadConfigurationFromServerAction.initAction.tooltip"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("Ctrl+L"));
            this.putValue("CidsActionKey", "cismap.load.server.config");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((ActiveLayerModel)CismapBroker.getInstance().getMappingComponent().getMappingModel()).removeAllLayers();
            CismapBroker.getInstance().getMappingComponent().getMapServiceLayer().removeAllChildren();
            CismapBroker.getInstance().getMappingComponent().lock();
            NavigatorX navigator = (NavigatorX)ComponentRegistry.getRegistry().getMainWindow();
            navigator.getCismapConfigurationManager().configureFromClasspath();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CismapBroker.getInstance().getMappingComponent().unlock();
                }
            });
        }
    }

    private static class SaveConfigurationAction
    extends AbstractAction
    implements CidsUiAction {
        public SaveConfigurationAction() {
            this.initAction();
        }

        private void initAction() {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/config.png")));
            this.putValue("Name", NbBundle.getMessage(ConfigurationActionProvider.class, (String)"ConfigurationActionProvider.SaveConfigurationAction.initAction.title"));
            this.putValue("ShortDescription", NbBundle.getMessage(ConfigurationActionProvider.class, (String)"ConfigurationActionProvider.SaveConfigurationAction.initAction.tooltip"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl K"));
            this.putValue("CidsActionKey", "cismap.save.config");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fc;
            try {
                fc = new JFileChooser(cismapDirectory);
            }
            catch (Exception bug) {
                fc = new JFileChooser(cismapDirectory, (FileSystemView)new RestrictedFileSystemView());
            }
            fc.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".xml");
                }

                @Override
                public String getDescription() {
                    return NbBundle.getMessage(LoadConfigurationAction.class, (String)"ConfigurationActionProvider.SaveConfigurationAction.FileFilter.getDescription.return");
                }
            });
            int state = fc.showSaveDialog(ComponentRegistry.getRegistry().getMainWindow());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("state:" + state));
            }
            if (state == 0) {
                File file = fc.getSelectedFile();
                String name = file.getAbsolutePath();
                NavigatorX navigator = (NavigatorX)ComponentRegistry.getRegistry().getMainWindow();
                if (name.endsWith(".xml")) {
                    navigator.getCismapConfigurationManager().writeConfiguration(name);
                } else {
                    navigator.getCismapConfigurationManager().writeConfiguration(name + ".xml");
                }
            }
        }
    }

    private static class LoadConfigurationAction
    extends AbstractAction
    implements CidsUiAction {
        public LoadConfigurationAction() {
            this.initAction();
        }

        private void initAction() {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/config.png")));
            this.putValue("Name", NbBundle.getMessage(ConfigurationActionProvider.class, (String)"ConfigurationActionProvider.LoadConfigurationAction.initAction.title"));
            this.putValue("ShortDescription", NbBundle.getMessage(ConfigurationActionProvider.class, (String)"ConfigurationActionProvider.LoadConfigurationAction.initAction.tooltip"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl L"));
            this.putValue("CidsActionKey", "cismap.load.config");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fc;
            try {
                fc = new JFileChooser(cismapDirectory);
            }
            catch (Exception bug) {
                fc = new JFileChooser(cismapDirectory, (FileSystemView)new RestrictedFileSystemView());
            }
            fc.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".xml");
                }

                @Override
                public String getDescription() {
                    return NbBundle.getMessage(LoadConfigurationAction.class, (String)"ConfigurationActionProvider.LoadConfigurationAction.FileFiltergetDescription.return");
                }
            });
            int state = fc.showOpenDialog(ComponentRegistry.getRegistry().getMainWindow());
            if (state == 0) {
                File file = fc.getSelectedFile();
                String name = file.getAbsolutePath();
                NavigatorX navigator = (NavigatorX)ComponentRegistry.getRegistry().getMainWindow();
                if (name.endsWith(".xml")) {
                    ((ActiveLayerModel)CismapBroker.getInstance().getMappingComponent().getMappingModel()).removeAllLayers();
                    CismapBroker.getInstance().getMappingComponent().getMapServiceLayer().removeAllChildren();
                    navigator.getCismapConfigurationManager().configure(name);
                } else {
                    ((ActiveLayerModel)CismapBroker.getInstance().getMappingComponent().getMappingModel()).removeAllLayers();
                    CismapBroker.getInstance().getMappingComponent().getMapServiceLayer().removeAllChildren();
                    navigator.getCismapConfigurationManager().configure(name + ".xml");
                }
            }
        }
    }
}

