/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin.actions;

import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.gui.historybutton.HistoryModelListener;
import de.cismet.tools.gui.menu.CidsUiMenuProvider;
import de.cismet.tools.gui.menu.CidsUiMenuProviderEvent;
import de.cismet.tools.gui.menu.CidsUiMenuProviderListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class MapHistoryAction
extends AbstractAction
implements CidsUiMenuProvider,
HistoryModelListener {
    private static final ImageIcon ICON_BACK = new ImageIcon(MapHistoryAction.class.getResource("/images/miniBack.png"));
    private static final ImageIcon ICON_FORWARD = new ImageIcon(MapHistoryAction.class.getResource("/images/miniForward.png"));
    private static final ImageIcon ICON_CURRENT = new ImageIcon(MapHistoryAction.class.getResource("/images/current.png"));
    private final JMenu menu = new JMenu();
    private final List<JMenuItem> itemList = new ArrayList<JMenuItem>();
    private final List<CidsUiMenuProviderListener> listeners = new ArrayList<CidsUiMenuProviderListener>();

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public String getMenuKey() {
        return "mapHistory";
    }

    public JMenu getMenu() {
        if (CismapBroker.getInstance().getMappingComponent() != null) {
            CismapBroker.getInstance().getMappingComponent().addHistoryModelListener((HistoryModelListener)this);
        }
        return this.menu;
    }

    public void historyChanged() {
        final MappingComponent mapC = CismapBroker.getInstance().getMappingComponent();
        Vector backPos = mapC.getBackPossibilities();
        Vector forwPos = mapC.getForwardPossibilities();
        if (mapC.getCurrentElement() != null) {
            CidsUiMenuProviderEvent e;
            while (this.itemList.size() > 0) {
                JMenuItem item = this.itemList.get(0);
                e = new CidsUiMenuProviderEvent(item, 0, (Object)this);
                this.itemList.remove(item);
                this.fireMenuItemRemoved(e);
            }
            int counter = 0;
            int start = 0;
            if (backPos.size() - 10 > 0) {
                start = backPos.size() - 10;
            }
            int itemPosition = 0;
            for (int index = start; index < backPos.size(); ++index) {
                Object elem = backPos.get(index);
                JMenuItem item = new JMenuItem(elem.toString());
                item.setIcon(ICON_BACK);
                final int pos = backPos.size() - 1 - index;
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        for (int i = 0; i < pos; ++i) {
                            mapC.back(false);
                        }
                        mapC.back(true);
                    }
                });
                this.itemList.add(item);
                e = new CidsUiMenuProviderEvent(item, itemPosition++, (Object)this);
                this.fireMenuItemAdded(e);
            }
            JMenuItem currentItem = new JMenuItem(mapC.getCurrentElement().toString());
            currentItem.setEnabled(false);
            currentItem.setIcon(ICON_CURRENT);
            this.itemList.add(currentItem);
            e = new CidsUiMenuProviderEvent(currentItem, itemPosition++, (Object)this);
            this.fireMenuItemAdded(e);
            counter = 0;
            for (int index = forwPos.size() - 1; index >= 0; --index) {
                Object elem = forwPos.get(index);
                JMenuItem item = new JMenuItem(elem.toString());
                item.setIcon(ICON_FORWARD);
                final int pos = forwPos.size() - 1 - index;
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        for (int i = 0; i < pos; ++i) {
                            mapC.forward(false);
                        }
                        mapC.forward(true);
                    }
                });
                this.itemList.add(item);
                e = new CidsUiMenuProviderEvent(item, itemPosition++, (Object)this);
                this.fireMenuItemAdded(e);
                if (counter++ > 10) break;
            }
        }
    }

    public void backStatusChanged() {
    }

    public void forwardStatusChanged() {
    }

    public void historyActionPerformed() {
    }

    public void addCidsUiMenuProviderListener(CidsUiMenuProviderListener listener) {
        this.listeners.add(listener);
    }

    public void removeCidsUiMenuProviderListener(CidsUiMenuProviderListener listener) {
        this.listeners.remove(listener);
    }

    private void fireMenuItemAdded(CidsUiMenuProviderEvent e) {
        for (CidsUiMenuProviderListener listener : this.listeners) {
            listener.menuItemAdded(e);
        }
    }

    private void fireMenuItemRemoved(CidsUiMenuProviderEvent e) {
        for (CidsUiMenuProviderListener listener : this.listeners) {
            listener.menuItemRemoved(e);
        }
    }
}

