/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin.actions;

import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateNewGeometryListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.SelectionListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.gui.menu.CidsUiAction;
import de.cismet.tools.gui.menu.CidsUiActionProvider;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class MapModeActionProvider
implements CidsUiActionProvider {
    private static final Logger LOG = Logger.getLogger(MapModeActionProvider.class);
    private static String cismapDirectory;

    public static void setCismapDirectory(String cismapDirectory) {
        MapModeActionProvider.cismapDirectory = cismapDirectory;
    }

    public List<CidsUiAction> getActions() {
        ArrayList<CidsUiAction> actionList = new ArrayList<CidsUiAction>();
        actionList.add(new FeatureInfoAction());
        actionList.add(new MoveAction());
        actionList.add(new NewLineStringAction());
        actionList.add(new NewPointAction());
        actionList.add(new NewPolygonAction());
        actionList.add(new PanAction());
        actionList.add(new RemoveAction());
        actionList.add(new SelectionAction());
        actionList.add(new SingleSelectionAction());
        actionList.add(new ZoomAction());
        actionList.add(new NewLinearReferencingAction());
        return actionList;
    }

    private static class RemoveAction
    extends AbstractAction
    implements CidsUiAction {
        public RemoveAction() {
            this.initAction();
        }

        private void initAction() {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/remove.png")));
            this.putValue("ShortDescription", NbBundle.getMessage(MapModeActionProvider.class, (String)"MapModeActionProvider.RemoveAction.initAction.tooltip"));
            this.putValue("CidsActionKey", "RemoveAction");
            this.putValue("SwingSelectedKey", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MappingComponent mapC = CismapBroker.getInstance().getMappingComponent();
                    if (mapC != null) {
                        mapC.setInteractionMode("REMOVE_POLYGON");
                    }
                }
            });
        }
    }

    private static class MoveAction
    extends AbstractAction
    implements CidsUiAction {
        public MoveAction() {
            this.initAction();
        }

        private void initAction() {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/move.png")));
            this.putValue("ShortDescription", NbBundle.getMessage(MapModeActionProvider.class, (String)"MapModeActionProvider.MoveAction.initAction.tooltip"));
            this.putValue("CidsActionKey", "MoveAction");
            this.putValue("SwingSelectedKey", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MappingComponent mapC = CismapBroker.getInstance().getMappingComponent();
                    if (mapC != null) {
                        mapC.setInteractionMode("MOVE_POLYGON");
                    }
                }
            });
        }
    }

    private static class NewLinearReferencingAction
    extends AbstractAction
    implements CidsUiAction {
        public NewLinearReferencingAction() {
            this.initAction();
        }

        private void initAction() {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/linref.png")));
            this.putValue("ShortDescription", NbBundle.getMessage(MapModeActionProvider.class, (String)"MapModeActionProvider.NewLinearReferencingAction.initAction.tooltip"));
            this.putValue("CidsActionKey", "NewLinearReferencingAction");
            this.putValue("SwingSelectedKey", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MappingComponent mapC = CismapBroker.getInstance().getMappingComponent();
                    if (mapC != null) {
                        mapC.setInteractionMode("LINEMEASUREMENT");
                    }
                }
            });
        }
    }

    private static class NewPointAction
    extends AbstractAction
    implements CidsUiAction {
        public NewPointAction() {
            this.initAction();
        }

        private void initAction() {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/newPoint.png")));
            this.putValue("ShortDescription", NbBundle.getMessage(MapModeActionProvider.class, (String)"MapModeActionProvider.NewPointAction.initAction.tooltip"));
            this.putValue("CidsActionKey", "NewPointAction");
            this.putValue("SwingSelectedKey", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MappingComponent mapC = CismapBroker.getInstance().getMappingComponent();
                    if (mapC != null) {
                        ((CreateNewGeometryListener)mapC.getInputListener("NEW_POLYGON")).setMode("POINT");
                        mapC.setInteractionMode("NEW_POLYGON");
                    }
                }
            });
        }
    }

    private static class NewLineStringAction
    extends AbstractAction
    implements CidsUiAction {
        public NewLineStringAction() {
            this.initAction();
        }

        private void initAction() {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/newLinestring.png")));
            this.putValue("ShortDescription", NbBundle.getMessage(MapModeActionProvider.class, (String)"MapModeActionProvider.NewLineStringAction.initAction.tooltip"));
            this.putValue("CidsActionKey", "NewLineStringAction");
            this.putValue("SwingSelectedKey", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MappingComponent mapC = CismapBroker.getInstance().getMappingComponent();
                    if (mapC != null) {
                        ((CreateNewGeometryListener)mapC.getInputListener("NEW_POLYGON")).setMode("LINESTRING");
                        mapC.setInteractionMode("NEW_POLYGON");
                    }
                }
            });
        }
    }

    private static class NewPolygonAction
    extends AbstractAction
    implements CidsUiAction {
        public NewPolygonAction() {
            this.initAction();
        }

        private void initAction() {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/newPolygon.png")));
            this.putValue("ShortDescription", NbBundle.getMessage(MapModeActionProvider.class, (String)"MapModeActionProvider.NewPolygonAction.initAction.tooltip"));
            this.putValue("CidsActionKey", "NewPolygonAction");
            this.putValue("SwingSelectedKey", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MappingComponent mapC = CismapBroker.getInstance().getMappingComponent();
                    if (mapC != null) {
                        ((CreateNewGeometryListener)mapC.getInputListener("NEW_POLYGON")).setMode("POLYGON");
                        mapC.setInteractionMode("NEW_POLYGON");
                    }
                }
            });
        }
    }

    private static class FeatureInfoAction
    extends AbstractAction
    implements CidsUiAction {
        public FeatureInfoAction() {
            this.initAction();
        }

        private void initAction() {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/featureInfos.gif")));
            this.putValue("ShortDescription", NbBundle.getMessage(MapModeActionProvider.class, (String)"MapModeActionProvider.FeatureInfoAction.initAction.tooltip"));
            this.putValue("CidsActionKey", "FeatureInfoAction");
            this.putValue("SwingSelectedKey", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MappingComponent mapC = CismapBroker.getInstance().getMappingComponent();
                    if (mapC != null) {
                        mapC.setInteractionMode("FEATURE_INFO");
                    }
                }
            });
        }
    }

    private static class PanAction
    extends AbstractAction
    implements CidsUiAction {
        public PanAction() {
            this.initAction();
        }

        private void initAction() {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/pan.gif")));
            this.putValue("ShortDescription", NbBundle.getMessage(MapModeActionProvider.class, (String)"MapModeActionProvider.PanAction.initAction.tooltip"));
            this.putValue("CidsActionKey", "PanAction");
            this.putValue("SwingSelectedKey", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MappingComponent mapC = CismapBroker.getInstance().getMappingComponent();
                    if (mapC != null) {
                        mapC.setInteractionMode("PAN");
                    }
                }
            });
        }
    }

    private static class ZoomAction
    extends AbstractAction
    implements CidsUiAction {
        public ZoomAction() {
            this.initAction();
        }

        private void initAction() {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/zoom.gif")));
            this.putValue("ShortDescription", NbBundle.getMessage(MapModeActionProvider.class, (String)"MapModeActionProvider.ZoomAction.initAction.tooltip"));
            this.putValue("CidsActionKey", "ZoomAction");
            this.putValue("SwingSelectedKey", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MappingComponent mapC = CismapBroker.getInstance().getMappingComponent();
                    if (mapC != null) {
                        mapC.setInteractionMode("ZOOM");
                    }
                }
            });
        }
    }

    private static class SelectionAction
    extends AbstractAction
    implements CidsUiAction {
        public SelectionAction() {
            this.initAction();
        }

        private void initAction() {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/select.png")));
            this.putValue("ShortDescription", NbBundle.getMessage(MapModeActionProvider.class, (String)"MapModeActionProvider.SelectionAction.initAction.tooltip"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("Ctrl+L"));
            this.putValue("CidsActionKey", "SelectionAction");
            this.putValue("SwingSelectedKey", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MappingComponent mapC = CismapBroker.getInstance().getMappingComponent();
                    mapC.setInteractionMode("SELECT");
                    ((SelectionListener)mapC.getInputListener("SELECT")).setMode("BOUNDING_BOX");
                }
            });
        }
    }

    private static class SingleSelectionAction
    extends AbstractAction
    implements CidsUiAction {
        public SingleSelectionAction() {
            this.initAction();
        }

        private void initAction() {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/select.png")));
            this.putValue("ShortDescription", NbBundle.getMessage(MapModeActionProvider.class, (String)"MapModeActionProvider.SingleSelectionAction.initAction.tooltip"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("Ctrl+L"));
            this.putValue("CidsActionKey", "SingleSelectionAction");
            this.putValue("SwingSelectedKey", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MappingComponent mapC = CismapBroker.getInstance().getMappingComponent();
                    mapC.setInteractionMode("SELECT");
                    ((SelectionListener)mapC.getInputListener("SELECT")).setMode("BOUNDING_BOX");
                }
            });
        }
    }
}

