/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin.actions;

import Sirius.navigator.ui.ComponentRegistry;
import de.cismet.cismap.commons.gui.featureinfopanel.FeatureInfoPanel;
import de.cismet.cismap.commons.gui.featureinfopanel.FeatureInfoPanelListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.Static2DTools;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.menu.CidsUiAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class OpenFeatureInfoAction
extends AbstractAction
implements CidsUiAction {
    private static final Logger LOG = Logger.getLogger(OpenFeatureInfoAction.class);
    private JDialog dialog = null;
    private FeatureInfoPanel featureInfoPanel;

    public OpenFeatureInfoAction() {
        this.init();
    }

    private void init() {
        String tooltip = NbBundle.getMessage(OpenFeatureInfoAction.class, (String)"OpenFeatureInfoAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(OpenFeatureInfoAction.class, (String)"OpenFeatureInfoAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(OpenFeatureInfoAction.class, (String)"OpenFeatureInfoAction.mnemonic");
        ImageIcon icoMap = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/raster/wms/res/layers.png"));
        Icon icon = Static2DTools.borderIcon((Icon)icoMap, (int)0, (int)3, (int)0, (int)1);
        this.putValue("SmallIcon", icon);
        this.putValue("SwingLargeIconKey", icon);
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        this.putValue("CidsActionKey", "OpenFeatureInfo");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.initDialog();
        CismapBroker.getInstance().getMappingComponent().setInteractionMode("FEATURE_INFO_MULTI_GEOM");
        this.putValue("SwingSelectedKey", Boolean.TRUE);
        StaticSwingTools.showDialog((JDialog)this.dialog);
    }

    private void initDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(ComponentRegistry.getRegistry().getMainWindow(), NbBundle.getMessage(OpenFeatureInfoAction.class, (String)"OpenFeatureInfoAction.actionPerformed.JDialog"), false);
            this.featureInfoPanel = new FeatureInfoPanel(CismapBroker.getInstance().getMappingComponent(), null);
            this.dialog.add((Component)this.featureInfoPanel);
            this.dialog.setAlwaysOnTop(true);
            this.dialog.setSize(350, 550);
            this.dialog.setDefaultCloseOperation(0);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    if (OpenFeatureInfoAction.this.featureInfoPanel.dispose()) {
                        OpenFeatureInfoAction.this.dialog.setVisible(false);
                    }
                    CismapBroker.getInstance().getMappingComponent().setInteractionMode("ZOOM");
                }

                @Override
                public void windowClosed(WindowEvent e) {
                    this.windowClosing(e);
                }
            });
        }
    }

    public void showDialog() {
        this.initDialog();
        StaticSwingTools.showDialog((JDialog)this.dialog);
    }

    public void showAllFeature() {
        this.featureInfoPanel.showAllFeatures();
    }

    public void addFeatureInfoPanelListener(FeatureInfoPanelListener listener) {
        if (this.featureInfoPanel != null) {
            this.featureInfoPanel.addFeatureInfoPanelListeners(listener);
        }
    }

    public void dispose() {
        if (this.featureInfoPanel != null) {
            this.featureInfoPanel.dispose();
        }
    }
}

