/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin.actions;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import de.cismet.cismap.commons.features.AbstractNewFeature;
import de.cismet.cismap.commons.features.CommonFeatureAction;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.SearchFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.AbstractCreateSearchGeometryListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.CismetThreadPool;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class SearchInFeatureGeometryAction
extends AbstractAction
implements CommonFeatureAction {
    Feature f = null;
    private final transient Logger log = Logger.getLogger(this.getClass());

    public SearchInFeatureGeometryAction() {
        super(NbBundle.getMessage(SearchInFeatureGeometryAction.class, (String)"SearchInFeatureGeometryAction.SearchInFeatureGeometryAction()"));
        super.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/de/cismet/cismap/navigatorplugin/actions/search.png")));
    }

    public int getSorter() {
        return 1;
    }

    public Feature getSourceFeature() {
        return this.f;
    }

    public boolean isActive() {
        return true;
    }

    public void setSourceFeature(Feature source) {
        this.f = source;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CismetThreadPool.execute((Runnable)new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                Thread.currentThread().setName("SearchInFeatureGeometryAction");
                Geometry geom = (Geometry)SearchInFeatureGeometryAction.this.f.getGeometry().clone();
                SearchFeature sf = new SearchFeature(geom, "SEARCH_POLYGON");
                if (geom instanceof LineString || geom instanceof MultiLineString) {
                    sf.setGeometryType(AbstractNewFeature.geomTypes.LINESTRING);
                } else if (geom instanceof Polygon) {
                    sf.setGeometryType(AbstractNewFeature.geomTypes.POLYGON);
                } else if (geom instanceof MultiPolygon) {
                    sf.setGeometryType(AbstractNewFeature.geomTypes.MULTIPOLYGON);
                } else if (geom instanceof Point || geom instanceof MultiPoint) {
                    sf.setGeometryType(AbstractNewFeature.geomTypes.POINT);
                } else {
                    sf.setGeometryType(AbstractNewFeature.geomTypes.UNKNOWN);
                }
                ((AbstractCreateSearchGeometryListener)CismapBroker.getInstance().getMappingComponent().getInputListener(sf.getInteractionMode())).search(sf);
                return null;
            }

            @Override
            protected void done() {
            }
        });
    }
}

