/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin.export_map_actions;

import de.cismet.cismap.navigatorplugin.ImageSelection;
import de.cismet.cismap.navigatorplugin.export_map_actions.AbstractExportMapAction;
import de.cismet.cismap.navigatorplugin.export_map_actions.ExportMapDataProvider;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.menu.CidsUiAction;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class ExportMapToClipboardAction
extends AbstractExportMapAction
implements CidsUiAction {
    private static final Logger LOG = Logger.getLogger(ExportMapToClipboardAction.class);

    public ExportMapToClipboardAction() {
        this((ExportMapDataProvider)null);
    }

    public ExportMapToClipboardAction(ExportMapDataProvider exportMapDataProvider) {
        super(exportMapDataProvider);
        this.putValue("Name", NbBundle.getMessage(ExportMapToClipboardAction.class, (String)"ExportMapToClipboardAction.name"));
        this.putValue("ShortDescription", NbBundle.getMessage(ExportMapToClipboardAction.class, (String)"ExportMapToClipboardAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/clipboard16.png")));
        this.putValue("CidsActionKey", "ExportMapToClipboardAction");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 2));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.exportMapDataProvider.setLastUsedAction(this);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StaticSwingTools.showDialog((JDialog)ExportMapToClipboardAction.this.clipboarder);
                    }
                });
                Image image = ExportMapToClipboardAction.this.getMapC().getImage();
                ImageSelection imgSel = new ImageSelection(image);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(imgSel, null);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExportMapToClipboardAction.this.clipboarder.dispose();
                    }
                });
            }
        });
        t.start();
    }
}

