/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin.export_map_actions;

import de.cismet.cismap.commons.HeadlessMapProvider;
import de.cismet.cismap.commons.RestrictedFileSystemView;
import de.cismet.cismap.commons.tools.FutureImageDownload;
import de.cismet.cismap.commons.tools.WorldFileDownload;
import de.cismet.cismap.navigatorplugin.export_map_actions.AbstractExportMapAction;
import de.cismet.cismap.navigatorplugin.export_map_actions.ExportMapDataProvider;
import de.cismet.tools.gui.ConfirmationJFileChooser;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.MultipleDownload;
import de.cismet.tools.gui.menu.CidsUiAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.Future;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class ExportMapToFileAction
extends AbstractExportMapAction
implements CidsUiAction {
    private static final Logger LOG = Logger.getLogger(ExportMapToFileAction.class);

    public ExportMapToFileAction() {
        this((ExportMapDataProvider)null);
    }

    public ExportMapToFileAction(ExportMapDataProvider exportMapDataProvider) {
        super(exportMapDataProvider);
        this.putValue("Name", NbBundle.getMessage(ExportMapToFileAction.class, (String)"ExportMapToFileAction.name"));
        this.putValue("ShortDescription", NbBundle.getMessage(ExportMapToFileAction.class, (String)"ExportMapToFileAction.tooltip"));
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/clipboard16.png")));
        this.putValue("CidsActionKey", "ExportMapToFileAction");
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/de/cismet/cismap/navigatorplugin/res/legend.png")));
        this.putValue("CidsActionKey", "ExportMapToFileAction");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, 2));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.exportMapDataProvider.setLastUsedAction(this);
        Object[] o = this.getFutureImageFromMapViaHeadlessMapProvider();
        Future futureImage = (Future)o[0];
        HeadlessMapProvider headlessMapProvider = (HeadlessMapProvider)o[1];
        File file = this.chooseFile();
        if (file != null) {
            ArrayList<Object> downloads = new ArrayList<Object>();
            String imageFilePath = file.getAbsolutePath();
            FutureImageDownload imageDownload = new FutureImageDownload(FilenameUtils.getBaseName((String)imageFilePath), FilenameUtils.getExtension((String)imageFilePath), NbBundle.getMessage(ExportMapToFileAction.class, (String)"ExportMapToFileAction.downloadTitle.map"), file, futureImage);
            downloads.add(imageDownload);
            if (this.exportMapDataProvider.isGenerateWorldFile()) {
                String worldFileName = FilenameUtils.getFullPath((String)imageFilePath) + FilenameUtils.getBaseName((String)imageFilePath) + "." + this.exportMapDataProvider.getFileType().getWorldFileExtension();
                WorldFileDownload worldFileDownload = new WorldFileDownload(NbBundle.getMessage(ExportMapToFileAction.class, (String)"ExportMapToFileAction.downloadTitle.worldFile"), futureImage, headlessMapProvider.getCurrentBoundingBoxFromMap(), worldFileName);
                downloads.add(worldFileDownload);
            }
            if (downloads.size() > 1) {
                MultipleDownload multipleDownload = new MultipleDownload(downloads, NbBundle.getMessage(ExportMapToFileAction.class, (String)"ExportMapToFileAction.downloadTitle.multipleDownload"));
                DownloadManager.instance().add((Download)multipleDownload);
            } else {
                DownloadManager.instance().add((Download)downloads.get(0));
            }
        }
    }

    private File chooseFile() {
        Object fc;
        try {
            fc = new ConfirmationJFileChooser(DownloadManager.instance().getDestinationDirectory());
        }
        catch (Exception bug) {
            fc = new JFileChooser(DownloadManager.instance().getDestinationDirectory(), (FileSystemView)new RestrictedFileSystemView());
        }
        final String[] allowedExtensions = this.exportMapDataProvider.getFileType().getFilterExtensions();
        ((JFileChooser)fc).setAcceptAllFileFilterUsed(false);
        ((JFileChooser)fc).setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || ExportMapToFileAction.this.stringEndsWithArray(f.getName().toLowerCase(), allowedExtensions);
            }

            @Override
            public String getDescription() {
                return ExportMapToFileAction.this.exportMapDataProvider.getFileType().getDescription();
            }
        });
        int state = ((JFileChooser)fc).showSaveDialog(StaticSwingTools.getParentFrameIfNotNull((Component)this.exportMapDataProvider.getComponent()));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("state:" + state));
        }
        if (state == 0) {
            File file = ((JFileChooser)fc).getSelectedFile();
            String name = file.getAbsolutePath();
            if (!this.stringEndsWithArray(name.toLowerCase(), allowedExtensions)) {
                file = new File(file.getAbsolutePath() + "." + this.exportMapDataProvider.getFileType().getImageFileExtension());
            }
            return file;
        }
        return null;
    }

    private boolean stringEndsWithArray(String s, String[] arr) {
        for (String arrElement : arr) {
            if (!s.endsWith("." + arrElement)) continue;
            return true;
        }
        return false;
    }
}

