/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin.metasearch;

import de.cismet.cismap.navigatorplugin.metasearch.MetaSearch;
import de.cismet.cismap.navigatorplugin.metasearch.SearchTopic;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import java.util.Collection;
import java.util.LinkedList;
import org.openide.util.NbBundle;

public class MetaSearchTooltip
extends PNode {
    private static final Color COLOR_BACKGROUND = new Color(255, 255, 222, 200);

    public MetaSearchTooltip(Collection<SearchTopic> searchTopics) {
        LinkedList<Object> nodesToAdd = new LinkedList<Object>();
        String lblSelectedSearchTopicsText = "";
        lblSelectedSearchTopicsText = searchTopics == null || searchTopics.isEmpty() ? (MetaSearch.instance().getSearchTopics() == null || MetaSearch.instance().getSearchTopics().isEmpty() ? NbBundle.getMessage(MetaSearchTooltip.class, (String)"MetaSearchTooltip.MetaSearchTooltip(Collection).lblSelectedSearchTopicsText.notInitialized") : NbBundle.getMessage(MetaSearchTooltip.class, (String)"MetaSearchTooltip.MetaSearchTooltip(Collection).lblSelectedSearchTopicsText.empty")) : NbBundle.getMessage(MetaSearchTooltip.class, (String)"MetaSearchTooltip.MetaSearchTooltip(Collection).lblSelectedSearchTopicsText");
        PText lblSelectedSearchTopics = new PText(lblSelectedSearchTopicsText);
        Font defaultFont = lblSelectedSearchTopics.getFont();
        Font boldDefaultFont = new Font(defaultFont.getName(), defaultFont.getStyle() + 1, defaultFont.getSize());
        lblSelectedSearchTopics.setFont(boldDefaultFont);
        lblSelectedSearchTopics.setOffset(5.0, 5.0);
        nodesToAdd.add(lblSelectedSearchTopics);
        PImage lastIcon = null;
        PText lastLabel = lblSelectedSearchTopics;
        double rowX = lastLabel.getOffset().getX() + 10.0;
        double rowY = lastLabel.getOffset().getY() + lastLabel.getHeight() + 5.0;
        double maxWidth = lastLabel.getWidth();
        double totalHeight = lastLabel.getHeight();
        for (SearchTopic searchTopic : searchTopics) {
            PImage pImage = new PImage(searchTopic.getIcon().getImage());
            pImage.setOffset(rowX, rowY);
            lastIcon = pImage;
            PText lblSearchTopic = new PText(searchTopic.getName());
            double textPadding = 0.0;
            if (lastIcon.getHeight() > lblSearchTopic.getHeight()) {
                textPadding = (lastIcon.getHeight() - lblSearchTopic.getHeight()) / 2.0;
            }
            lblSearchTopic.setOffset(rowX + lastIcon.getWidth() + 5.0, rowY + textPadding);
            lastLabel = lblSearchTopic;
            nodesToAdd.add(lastIcon);
            nodesToAdd.add(lastLabel);
            rowY = Math.max(lastLabel.getOffset().getY() + lastLabel.getHeight(), lastIcon.getOffset().getY() + lastIcon.getHeight()) + 3.0;
            maxWidth = Math.max(maxWidth, lastIcon.getWidth() + 5.0 + lastLabel.getWidth());
            totalHeight += Math.max(lastIcon.getHeight(), lastLabel.getHeight()) + 3.0;
        }
        maxWidth += 20.0;
        totalHeight += 10.0;
        if (searchTopics != null && !searchTopics.isEmpty()) {
            totalHeight += 5.0;
        }
        PPath background = new PPath((Shape)new RoundRectangle2D.Double(0.0, 0.0, maxWidth, totalHeight, 10.0, 10.0));
        background.setPaint((Paint)COLOR_BACKGROUND);
        for (PNode pNode : nodesToAdd) {
            background.addChild(pNode);
        }
        this.setTransparency(0.85f);
        this.addChild((PNode)background);
    }
}

