/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin.metasearch;

import de.cismet.cismap.navigatorplugin.metasearch.SearchClass;
import de.cismet.cismap.navigatorplugin.metasearch.SearchTopicListener;
import de.cismet.cismap.navigatorplugin.metasearch.SearchTopicListenerEvent;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class SearchTopic
extends AbstractAction
implements Comparable<SearchTopic> {
    private static final Logger LOG = Logger.getLogger(SearchTopic.class);
    public static final String SELECTED = "selected";
    private final Collection<SearchClass> searchClasses;
    private final String name;
    private final String description;
    private final String key;
    private final String iconName;
    private final ImageIcon icon;
    private boolean selected;
    private final Collection<SearchTopicListener> listeners = new ArrayList<SearchTopicListener>();
    private final ListenerHandler listenerHandler = new ListenerHandler();

    public SearchTopic(String name, String description, String key, String iconName, boolean selected) {
        this.name = name;
        this.description = description;
        this.key = key;
        this.iconName = iconName;
        this.selected = selected;
        this.searchClasses = new LinkedHashSet<SearchClass>();
        URL urlToIcon = null;
        if (this.iconName != null) {
            urlToIcon = this.getClass().getResource(this.iconName);
        }
        if (urlToIcon == null) {
            LOG.warn((Object)("The given icon '" + this.iconName + "' can not be loaded."));
            urlToIcon = this.getClass().getResource("/de/cismet/cismap/navigatorplugin/metasearch/search.png");
        }
        if (urlToIcon != null) {
            this.icon = new ImageIcon(urlToIcon);
        } else {
            LOG.error((Object)("Neither given icon '" + this.iconName + "' nor '/de/cismet/cismap/navigatorplugin/metasearch/search.png' exist. There will be problems with the search."));
            this.icon = new ImageIcon();
        }
        this.putValue("SmallIcon", this.icon);
        this.putValue("ShortDescription", this.description);
        this.putValue("ActionCommandKey", this.key);
        this.putValue("Name", this.name);
        this.putValue("SwingSelectedKey", this.selected);
    }

    public void addSearchTopicListener(SearchTopicListener listener) {
        this.listeners.add(listener);
    }

    public void removeSearchTopicListener(SearchTopicListener listener) {
        this.listeners.remove(listener);
    }

    public void insert(SearchClass searchClass) {
        if (searchClass == null) {
            return;
        }
        if (!this.searchClasses.contains(searchClass)) {
            this.searchClasses.add(searchClass);
        } else {
            LOG.warn((Object)("Search class with domain '" + searchClass.getCidsDomain() + "' and table '" + searchClass.getCidsClass() + "' already exists in search topic '" + this.getName() + "'. The search class won't be added twice."));
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() instanceof AbstractButton) {
            this.setSelected(((AbstractButton)event.getSource()).isSelected());
        }
    }

    public String getDescription() {
        return this.description;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public String getIconName() {
        return this.iconName;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public Collection<SearchClass> getSearchClasses() {
        return this.searchClasses;
    }

    public void setSelected(boolean selected) {
        boolean oldValue = selected;
        this.selected = selected;
        this.putValue("SwingSelectedKey", this.selected);
        this.listenerHandler.selectionChanged(new SearchTopicListenerEvent(this, 1, this.selected));
        this.firePropertyChange(SELECTED, oldValue, selected);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SearchTopic)) {
            return false;
        }
        SearchTopic other = (SearchTopic)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        return !(this.iconName == null ? other.iconName != null : !this.iconName.equals(other.iconName));
    }

    public int hashCode() {
        int hash = 7;
        hash = 11 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 11 * hash + (this.description != null ? this.description.hashCode() : 0);
        hash = 11 * hash + (this.key != null ? this.key.hashCode() : 0);
        hash = 11 * hash + (this.iconName != null ? this.iconName.hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(SearchTopic o) {
        if (o == null) {
            return 1;
        }
        return this.name.compareTo(o.name);
    }

    class ListenerHandler
    implements SearchTopicListener {
        ListenerHandler() {
        }

        @Override
        public void selectionChanged(SearchTopicListenerEvent event) {
            for (SearchTopicListener listener : SearchTopic.this.listeners) {
                listener.selectionChanged(event);
            }
        }
    }
}

