/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin.metasearch;

import de.cismet.cismap.navigatorplugin.metasearch.SearchTopic;
import de.cismet.cismap.navigatorplugin.metasearch.SearchTopicListener;
import de.cismet.cismap.navigatorplugin.metasearch.SearchTopicListenerEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXHyperlink;
import org.openide.util.NbBundle;

public class SearchTopicsPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(SearchTopicsPanel.class);
    private final Set<SearchTopic> searchTopics = new HashSet<SearchTopic>();
    private Box.Filler gluFiller;
    private JXHyperlink hypSelectAll;
    private JXHyperlink hypSelectNone;
    private JLabel lblSelection;
    private JLabel lblSeparator;
    private JPanel pnlControls;

    public SearchTopicsPanel() {
        this.initComponents();
    }

    public void setSearchTopics(Collection<SearchTopic> searchTopics) {
        for (Component component : this.getComponents()) {
            if (!(component instanceof SearchTopicCheckBox)) continue;
            SearchTopicCheckBox searchTopicCheckBox = (SearchTopicCheckBox)component;
            searchTopicCheckBox.getSearchTopic().removeSearchTopicListener(searchTopicCheckBox);
        }
        this.searchTopics.clear();
        this.removeAll();
        if (searchTopics == null || searchTopics.isEmpty()) {
            this.revalidate();
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Setting search topics: " + searchTopics));
        }
        int maxRowWidth = 0;
        int rowHeight = 0;
        SearchTopic[] searchTopicsArray = searchTopics.toArray(new SearchTopic[0]);
        for (int i = 0; i < searchTopicsArray.length; ++i) {
            SearchTopic searchTopic = searchTopicsArray[i];
            if (!this.searchTopics.add(searchTopic)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Search topic '" + searchTopic.getName() + " - " + searchTopic.getDescription() + "' couldn't be added. Maybe it's defined twice."));
                continue;
            }
            JLabel lblIcon = new JLabel(searchTopic.getIcon());
            SearchTopicCheckBox chkSearchTopic = new SearchTopicCheckBox(searchTopic);
            searchTopic.addSearchTopicListener(chkSearchTopic);
            lblIcon.setToolTipText(searchTopic.getDescription());
            chkSearchTopic.setBackground(this.getBackground());
            Insets insetsIcon = new Insets(0, 7, 0, 2);
            Insets insetsCheckbox = new Insets(0, 2, 0, 7);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 21;
            constraints.gridx = 0;
            constraints.gridy = this.searchTopics.size() - 1;
            constraints.insets = i == 0 ? new Insets(5, 7, 0, 2) : (i == searchTopicsArray.length - 1 ? new Insets(0, 7, 5, 2) : insetsIcon);
            this.add((Component)lblIcon, constraints);
            constraints = new GridBagConstraints();
            constraints.anchor = 21;
            constraints.fill = 2;
            constraints.gridx = 1;
            constraints.gridy = this.searchTopics.size() - 1;
            constraints.insets = i == 0 ? new Insets(5, 2, 0, 7) : (i == searchTopicsArray.length - 1 ? new Insets(0, 2, 5, 7) : insetsCheckbox);
            constraints.weightx = 1.0;
            this.add((Component)chkSearchTopic, constraints);
            int rowWidth = lblIcon.getWidth() + chkSearchTopic.getWidth() + 10;
            if (rowWidth > maxRowWidth) {
                maxRowWidth = rowWidth;
            }
            rowHeight = chkSearchTopic.getHeight();
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Added '" + searchTopic.getName() + " - " + searchTopic.getDescription() + "' on position " + (this.searchTopics.size() - 1)));
        }
        this.setMinimumSize(new Dimension(maxRowWidth, 20 * rowHeight));
        Component gluFiller = Box.createGlue();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.gridx = 0;
        constraints.gridy = this.searchTopics.size();
        constraints.gridwidth = 2;
        constraints.weighty = 1.0;
        this.add(gluFiller, constraints);
        constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = this.searchTopics.size() + 1;
        constraints.gridwidth = 2;
        constraints.weightx = 1.0;
        this.add((Component)this.pnlControls, constraints);
        this.revalidate();
    }

    public void registerItemListener(ItemListener itemListener) {
        for (Component component : this.getComponents()) {
            if (!(component instanceof JCheckBox)) continue;
            JCheckBox checkbox = (JCheckBox)component;
            checkbox.addItemListener(itemListener);
        }
    }

    public void unregisterItemListener(ItemListener itemListener) {
        for (Component component : this.getComponents()) {
            if (!(component instanceof JCheckBox)) continue;
            JCheckBox checkbox = (JCheckBox)component;
            checkbox.removeItemListener(itemListener);
        }
    }

    private void initComponents() {
        this.pnlControls = new JPanel();
        this.lblSelection = new JLabel();
        this.hypSelectAll = new JXHyperlink();
        this.lblSeparator = new JLabel();
        this.hypSelectNone = new JXHyperlink();
        this.gluFiller = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.pnlControls.setBackground(UIManager.getDefaults().getColor("List.background"));
        this.pnlControls.setLayout(new GridBagLayout());
        this.lblSelection.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/navigatorplugin/metasearch/SearchTopicsPanel_lblSelection.png")));
        this.lblSelection.setText(NbBundle.getMessage(SearchTopicsPanel.class, (String)"SearchTopicsPanel.lblSelection.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 7, 0, 0);
        this.pnlControls.add((Component)this.lblSelection, gridBagConstraints);
        this.hypSelectAll.setText(NbBundle.getMessage(SearchTopicsPanel.class, (String)"SearchTopicsPanel.hypSelectAll.text"));
        this.hypSelectAll.setToolTipText(NbBundle.getMessage(SearchTopicsPanel.class, (String)"SearchTopicsPanel.hypSelectAll.toolTipText"));
        this.hypSelectAll.setFocusPainted(false);
        this.hypSelectAll.setHorizontalAlignment(0);
        this.hypSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchTopicsPanel.this.hypSelectAllActionPerformed(evt);
            }
        });
        this.pnlControls.add((Component)this.hypSelectAll, new GridBagConstraints());
        this.lblSeparator.setText(NbBundle.getMessage(SearchTopicsPanel.class, (String)"SearchTopicsPanel.lblSeparator.text"));
        this.pnlControls.add((Component)this.lblSeparator, new GridBagConstraints());
        this.hypSelectNone.setText(NbBundle.getMessage(SearchTopicsPanel.class, (String)"SearchTopicsPanel.hypSelectNone.text"));
        this.hypSelectNone.setToolTipText(NbBundle.getMessage(SearchTopicsPanel.class, (String)"SearchTopicsPanel.hypSelectNone.toolTipText"));
        this.hypSelectNone.setFocusPainted(false);
        this.hypSelectNone.setHorizontalAlignment(0);
        this.hypSelectNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchTopicsPanel.this.hypSelectNoneActionPerformed(evt);
            }
        });
        this.pnlControls.add((Component)this.hypSelectNone, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.pnlControls.add((Component)this.gluFiller, gridBagConstraints);
        this.setBackground(UIManager.getDefaults().getColor("List.background"));
        this.setLayout(new GridBagLayout());
    }

    private void hypSelectAllActionPerformed(ActionEvent evt) {
        for (SearchTopic searchTopic : this.searchTopics) {
            searchTopic.setSelected(true);
        }
    }

    private void hypSelectNoneActionPerformed(ActionEvent evt) {
        for (SearchTopic searchTopic : this.searchTopics) {
            searchTopic.setSelected(false);
        }
    }

    class SearchTopicCheckBox
    extends JCheckBox
    implements SearchTopicListener {
        private final SearchTopic searchTopic;

        public SearchTopicCheckBox(SearchTopic searchTopic) {
            super(searchTopic.getName());
            this.searchTopic = searchTopic;
            this.setToolTipText(searchTopic.getDescription());
            this.setSelected(searchTopic.isSelected());
        }

        @Override
        public void selectionChanged(SearchTopicListenerEvent event) {
            SearchTopic searchTopic;
            SearchTopic source = event.getSource();
            if (source instanceof SearchTopic && (searchTopic = source).equals(this.searchTopic) && searchTopic.isSelected() != this.isSelected()) {
                this.setSelected(searchTopic.isSelected());
            }
        }

        @Override
        protected void fireItemStateChanged(ItemEvent event) {
            super.fireItemStateChanged(event);
            if (this.searchTopic.isSelected() != this.isSelected()) {
                this.searchTopic.setSelected(this.isSelected());
            }
        }

        public SearchTopic getSearchTopic() {
            return this.searchTopic;
        }
    }
}

