/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin.protocol;

import Sirius.navigator.search.CidsSearchExecutor;
import Sirius.navigator.search.CidsServerSearchMetaObjectNodeWrapper;
import Sirius.navigator.search.CidsServerSearchProtocolStepImpl;
import Sirius.navigator.search.CidsServerSearchProtocolStepReexecutor;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObjectNode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.cids.server.search.SearchResultListener;
import de.cismet.cids.server.search.SearchResultListenerProvider;
import de.cismet.cids.server.search.builtin.FullTextSearch;
import de.cismet.cids.utils.MetaClassCacheService;
import de.cismet.cismap.navigatorplugin.metasearch.MetaSearch;
import de.cismet.cismap.navigatorplugin.metasearch.SearchClass;
import de.cismet.cismap.navigatorplugin.metasearch.SearchTopic;
import de.cismet.cismap.navigatorplugin.protocol.FulltextSearchProtocolStep;
import de.cismet.cismap.navigatorplugin.protocol.FulltextSearchProtocolStepPanel;
import de.cismet.cismap.navigatorplugin.protocol.GeoSearchProtocolStepSearchTopic;
import de.cismet.cismap.navigatorplugin.protocol.GeometryProtocolStepImpl;
import de.cismet.cismap.navigatorplugin.protocol.SearchTopicsProtocolStepImpl;
import de.cismet.commons.gui.protocol.AbstractProtocolStep;
import de.cismet.commons.gui.protocol.AbstractProtocolStepPanel;
import de.cismet.commons.gui.protocol.ProtocolHandler;
import de.cismet.commons.gui.protocol.ProtocolStep;
import de.cismet.commons.gui.protocol.ProtocolStepMetaInfo;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.openide.util.Lookup;

public class FulltextSearchProtocolStepImpl
extends AbstractProtocolStep
implements FulltextSearchProtocolStep,
ConnectionContextStore {
    private static final ProtocolStepMetaInfo META_INFO = new ProtocolStepMetaInfo("FullTextSearch", "FullTextSearch protocol step");
    @JsonIgnore
    private static final transient MetaClassCacheService META_CLASS_CACHE_SERVICE = (MetaClassCacheService)Lookup.getDefault().lookup(MetaClassCacheService.class);
    @JsonProperty(required=true)
    protected String wkt;
    @JsonProperty(required=true)
    private final String searchText;
    @JsonProperty(required=true)
    private final boolean caseSensitiveEnabled;
    @JsonProperty(required=true)
    private List<CidsServerSearchMetaObjectNodeWrapper> searchResults;
    @JsonProperty(required=true)
    private Set<GeoSearchProtocolStepSearchTopic> searchTopicInfos;
    @JsonIgnore
    private final CidsServerSearchProtocolStepImpl cidsServerSearchProtocolStep;
    @JsonIgnore
    private final GeometryProtocolStepImpl geometryProtocolStep;
    @JsonIgnore
    private final SearchTopicsProtocolStepImpl searchTopicsProtocolStep;
    private transient ConnectionContext connectionContext = ConnectionContext.createDummy();

    public FulltextSearchProtocolStepImpl(FullTextSearch fullTextSearch, Collection<SearchTopic> searchTopics, List resultNodes) {
        this.cidsServerSearchProtocolStep = new CidsServerSearchProtocolStepImpl((CidsServerSearch)fullTextSearch, resultNodes);
        this.geometryProtocolStep = new GeometryProtocolStepImpl(fullTextSearch.getGeometry());
        this.searchTopicsProtocolStep = new SearchTopicsProtocolStepImpl(searchTopics);
        this.searchText = fullTextSearch.getSearchText();
        this.caseSensitiveEnabled = fullTextSearch.isCaseSensitive();
        this.getCidsServerSearchProtocolStep().setReexecutor((CidsServerSearchProtocolStepReexecutor)this);
    }

    @JsonCreator
    public FulltextSearchProtocolStepImpl(@JsonProperty(value="searchText") String searchText, @JsonProperty(value="caseSensitiveEnabled") boolean caseSensitiveEnabled, @JsonProperty(value="wkt") String wkt, @JsonProperty(value="searchTopicInfos") Set<GeoSearchProtocolStepSearchTopic> searchTopicInfos, @JsonProperty(value="searchResults") List<CidsServerSearchMetaObjectNodeWrapper> searchResults) {
        this.cidsServerSearchProtocolStep = new CidsServerSearchProtocolStepImpl(searchResults);
        this.geometryProtocolStep = new GeometryProtocolStepImpl(wkt);
        this.searchTopicsProtocolStep = new SearchTopicsProtocolStepImpl(searchTopicInfos);
        this.searchText = searchText;
        this.caseSensitiveEnabled = caseSensitiveEnabled;
        this.getCidsServerSearchProtocolStep().setReexecutor((CidsServerSearchProtocolStepReexecutor)this);
    }

    protected ProtocolStepMetaInfo createMetaInfo() {
        return META_INFO;
    }

    public void initParameters() {
        super.initParameters();
        this.getGeometryProtocolStep().initParameters();
        this.getCidsServerSearchProtocolStep().initParameters();
        this.getSearchTopicsProtocolStep().initParameters();
        this.searchTopicInfos = this.getSearchTopicsProtocolStep().getSearchTopicInfos();
        this.searchResults = this.getCidsServerSearchProtocolStep().getSearchResults();
        this.wkt = this.getGeometryProtocolStep().getWkt();
    }

    public boolean isReExecuteSearchEnabled() {
        return true;
    }

    public void reExecuteSearch() {
        final FullTextSearch fullTextSearch = (FullTextSearch)Lookup.getDefault().lookup(FullTextSearch.class);
        fullTextSearch.setSearchText(this.getSearchText());
        fullTextSearch.setCaseSensitive(this.isCaseSensitiveEnabled());
        fullTextSearch.setGeometry(this.getGeometry());
        ArrayList<String> validClassesFromStrings = new ArrayList<String>();
        for (SearchTopic searchTopic : MetaSearch.instance().getSearchTopics()) {
            if (this.getSearchTopicsProtocolStep().getSearchTopics().contains(searchTopic)) {
                searchTopic.setSelected(true);
                if (META_CLASS_CACHE_SERVICE == null) continue;
                for (SearchClass searchClass : searchTopic.getSearchClasses()) {
                    MetaClass metaClass = META_CLASS_CACHE_SERVICE.getMetaClass(searchClass.getCidsDomain(), searchClass.getCidsClass(), this.getConnectionContext());
                    validClassesFromStrings.add(metaClass.getKey().toString());
                }
                continue;
            }
            searchTopic.setSelected(true);
        }
        fullTextSearch.setValidClassesFromStrings(validClassesFromStrings);
        if (fullTextSearch instanceof SearchResultListenerProvider) {
            ((SearchResultListenerProvider)fullTextSearch).setSearchResultListener(new SearchResultListener(){

                public void searchDone(List results) {
                    if (ProtocolHandler.getInstance().isRecordEnabled()) {
                        ProtocolHandler.getInstance().recordStep((ProtocolStep)new FulltextSearchProtocolStepImpl(fullTextSearch, MetaSearch.instance().getSelectedSearchTopics(), results));
                    }
                }
            });
        }
        CidsSearchExecutor.searchAndDisplayResultsWithDialog((MetaObjectNodeServerSearch)fullTextSearch, (ConnectionContext)this.getConnectionContext());
    }

    public AbstractProtocolStepPanel visualize() {
        return new FulltextSearchProtocolStepPanel(this);
    }

    public List<MetaObjectNode> getSearchResultNodes() {
        return this.getCidsServerSearchProtocolStep().getSearchResultNodes();
    }

    @Override
    public Geometry getGeometry() {
        return this.getGeometryProtocolStep().getGeometry();
    }

    public void initWithConnectionContext(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    @Generated
    public static MetaClassCacheService getMETA_CLASS_CACHE_SERVICE() {
        return META_CLASS_CACHE_SERVICE;
    }

    @Generated
    public String getWkt() {
        return this.wkt;
    }

    @Override
    @Generated
    public String getSearchText() {
        return this.searchText;
    }

    @Override
    @Generated
    public boolean isCaseSensitiveEnabled() {
        return this.caseSensitiveEnabled;
    }

    @Generated
    public List<CidsServerSearchMetaObjectNodeWrapper> getSearchResults() {
        return this.searchResults;
    }

    @Override
    @Generated
    public Set<GeoSearchProtocolStepSearchTopic> getSearchTopicInfos() {
        return this.searchTopicInfos;
    }

    @Generated
    public CidsServerSearchProtocolStepImpl getCidsServerSearchProtocolStep() {
        return this.cidsServerSearchProtocolStep;
    }

    @Generated
    public GeometryProtocolStepImpl getGeometryProtocolStep() {
        return this.geometryProtocolStep;
    }

    @Generated
    public SearchTopicsProtocolStepImpl getSearchTopicsProtocolStep() {
        return this.searchTopicsProtocolStep;
    }
}

