/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.tools.gui;

import com.vividsolutions.jts.geom.MultiPolygon;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.CidsBeanDropListener;
import de.cismet.cismap.commons.features.AbstractNewFeature;
import de.cismet.cismap.commons.features.SearchFeature;
import de.cismet.cismap.commons.features.SelectFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateGeometryListenerInterface;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateSearchGeometryListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.SelectionListener;
import de.cismet.cismap.navigatorplugin.CidsBeansSearchFeature;
import de.cismet.cismap.navigatorplugin.CidsBeansSelectFeature;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.gui.JPopupMenuButton;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;

public class CidsBeanDropJPopupMenuButton
extends JPopupMenuButton
implements CidsBeanDropListener,
DropTargetListener {
    private static final Logger LOG = Logger.getLogger(CidsBeanDropJPopupMenuButton.class);
    private static final String uiClassID = "ToggleButtonUI";
    private String interactionMode;
    private MappingComponent mappingComponent;
    private String searchName;
    private Icon defaultIcon = null;
    private Icon targetIcon = null;

    public CidsBeanDropJPopupMenuButton() {
    }

    public CidsBeanDropJPopupMenuButton(String interactionMode, MappingComponent mappingComponent, String searchName) {
        this.interactionMode = interactionMode;
        this.mappingComponent = mappingComponent;
        this.searchName = searchName;
        this.setModel(new JToggleButton.ToggleButtonModel());
    }

    protected void init(String interactionMode, MappingComponent mappingComponent, String searchName) {
        this.interactionMode = interactionMode;
        this.mappingComponent = mappingComponent;
        this.searchName = searchName;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void beansDropped(final ArrayList<CidsBean> beans) {
        this.mappingComponent.setInteractionMode(this.interactionMode);
        final CreateGeometryListenerInterface searchListener = (CreateGeometryListenerInterface)this.mappingComponent.getInputListener(this.interactionMode);
        if (searchListener instanceof CreateSearchGeometryListener) {
            CismetThreadPool.execute((Runnable)new SwingWorker<SearchFeature, Void>(){

                @Override
                protected SearchFeature doInBackground() throws Exception {
                    Thread.currentThread().setName("CidsBeanDropJPopupMenuButton beansDropped()");
                    CidsBeansSearchFeature feature = CidsBeansSearchFeature.createFromBeans(beans, CidsBeanDropJPopupMenuButton.this.interactionMode);
                    feature.setGeometryType(AbstractNewFeature.geomTypes.POLYGON);
                    return feature;
                }

                @Override
                protected void done() {
                    try {
                        SearchFeature feature = (SearchFeature)this.get();
                        if (feature != null) {
                            ((CreateSearchGeometryListener)searchListener).search(feature);
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Exception in Background Thread", (Throwable)e);
                    }
                }
            });
        } else if (searchListener instanceof SelectionListener) {
            CismetThreadPool.execute((Runnable)new SwingWorker<SelectFeature, Void>(){

                @Override
                protected SelectFeature doInBackground() throws Exception {
                    Thread.currentThread().setName("CidsBeanDropJPopupMenuButton beansDropped()");
                    CidsBeansSelectFeature feature = CidsBeansSelectFeature.createFromBeans(beans, CidsBeanDropJPopupMenuButton.this.interactionMode);
                    if (feature != null && feature.getGeometry() != null && feature.getGeometry() instanceof MultiPolygon) {
                        feature.setGeometryType(AbstractNewFeature.geomTypes.MULTIPOLYGON);
                    } else {
                        feature.setGeometryType(AbstractNewFeature.geomTypes.POLYGON);
                    }
                    return feature;
                }

                @Override
                protected void done() {
                    try {
                        SelectFeature feature = (SelectFeature)this.get();
                        if (feature != null) {
                            ((SelectionListener)searchListener).select(feature);
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Exception in Background Thread", (Throwable)e);
                    }
                }
            });
        }
        super.setSelectedIcon(this.defaultIcon);
        super.setIcon(this.defaultIcon);
    }

    public void setIcon(Icon defaultIcon) {
        super.setIcon(defaultIcon);
        this.defaultIcon = defaultIcon;
    }

    public void setTargetIcon(Icon targetIcon) {
        this.targetIcon = targetIcon;
    }

    public Icon getTargetIcon() {
        return this.targetIcon;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (this.isSelected()) {
            super.setSelectedIcon(this.targetIcon);
        } else {
            super.setIcon(this.targetIcon);
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        if (this.isSelected()) {
            super.setSelectedIcon(this.defaultIcon);
        } else {
            super.setIcon(this.defaultIcon);
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (this.isSelected()) {
            super.setSelectedIcon(this.targetIcon);
        } else {
            super.setIcon(this.targetIcon);
        }
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }
}

