/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.tools.gui;

import de.cismet.cids.search.QuerySearch;
import de.cismet.cids.search.QuerySearchMethod;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.FeatureServiceUtilities;
import de.cismet.cismap.commons.featureservice.WebFeatureService;
import de.cismet.cismap.commons.gui.attributetable.AttributeTable;
import de.cismet.cismap.tools.gui.SelectInAttributeTableSearchMethod;
import java.io.Reader;
import java.io.StringReader;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.openide.util.NbBundle;

public class RestrictInAttributeTableSearchMethod
implements QuerySearchMethod {
    private static final Logger LOG = Logger.getLogger(SelectInAttributeTableSearchMethod.class);
    private QuerySearch querySearch;
    private boolean searching = false;
    private AttributeTable table;

    public RestrictInAttributeTableSearchMethod(AttributeTable table) {
        this.table = table;
    }

    public void setQuerySearch(QuerySearch querySearch) {
        this.querySearch = querySearch;
    }

    public void actionPerformed(Object layer, String query) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)((this.searching ? "Cancel" : "Search") + " button was clicked."));
        }
        this.querySearch.setControlsAccordingToState(this.searching);
        if (query != null && !query.isEmpty()) {
            if (layer instanceof WebFeatureService) {
                WebFeatureService wfs = (WebFeatureService)layer;
                try {
                    Element e = (Element)wfs.getQueryElement().clone();
                    Element queryElement = e.getChild("Query", Namespace.getNamespace((String)"wfs", (String)"http://www.opengis.net/wfs"));
                    queryElement.removeChild("Filter", Namespace.getNamespace((String)"ogc", (String)"http://www.opengis.net/ogc"));
                    Element filterElement = new Element("Filter", Namespace.getNamespace((String)"ogc", (String)"http://www.opengis.net/ogc"));
                    SAXBuilder builder = new SAXBuilder();
                    Document d = builder.build((Reader)new StringReader(query));
                    filterElement.addContent((Content)((Element)d.getRootElement().clone()));
                    queryElement.addContent(0, (Content)filterElement);
                    this.table.setQuery((Object)FeatureServiceUtilities.elementToString((Element)e));
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error while retrieving features", (Throwable)ex);
                }
            } else if (layer instanceof AbstractFeatureService) {
                this.table.setQuery((Object)query);
            }
        } else {
            this.table.setQuery(null);
        }
        this.searching = false;
        this.querySearch.setControlsAccordingToState(this.searching);
    }

    public String toString() {
        return NbBundle.getMessage(RestrictInAttributeTableSearchMethod.class, (String)"RestrictInAttributeTableSearchMethod.toString");
    }
}

