/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.tools.gui;

import de.cismet.cids.search.QuerySearch;
import de.cismet.cids.search.QuerySearchMethod;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.FeatureServiceUtilities;
import de.cismet.cismap.commons.featureservice.WebFeatureService;
import de.cismet.cismap.commons.featureservice.factory.AbstractFeatureFactory;
import de.cismet.cismap.commons.featureservice.factory.FeatureFactory;
import de.cismet.cismap.commons.gui.attributetable.AttributeTable;
import de.cismet.cismap.commons.util.SelectionManager;
import de.cismet.commons.concurrency.CismetExecutors;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.openide.util.NbBundle;

public class SelectInSelectionAttributeTableSearchMethod
implements QuerySearchMethod {
    private static final Logger LOG = Logger.getLogger(SelectInSelectionAttributeTableSearchMethod.class);
    private QuerySearch querySearch;
    private boolean searching = false;
    private SearchAndSelectThread searchThread;
    private Object lastLayer;
    private final AttributeTable table;

    public SelectInSelectionAttributeTableSearchMethod(AttributeTable table) {
        this.table = table;
    }

    public void setQuerySearch(QuerySearch querySearch) {
        this.querySearch = querySearch;
    }

    public void actionPerformed(Object layer, String query) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)((this.searching ? "Cancel" : "Search") + " button was clicked."));
        }
        if (this.searching) {
            if (this.searchThread != null) {
                FeatureFactory ff;
                if (this.lastLayer instanceof AbstractFeatureService && (ff = ((AbstractFeatureService)this.lastLayer).getFeatureFactory()) instanceof AbstractFeatureFactory) {
                    ((AbstractFeatureFactory)ff).waitUntilInterruptedIsAllowed();
                }
                this.searchThread.cancel(true);
            }
        } else {
            this.lastLayer = layer;
            this.searchThread = new SearchAndSelectThread(layer, query);
            CismetExecutors.newSingleThreadExecutor().submit(this.searchThread);
            this.searching = true;
            this.querySearch.setControlsAccordingToState(this.searching);
        }
    }

    public String toString() {
        return NbBundle.getMessage(SelectInSelectionAttributeTableSearchMethod.class, (String)"SelectInSelectionAttributeTableSearchMethod.toString");
    }

    private class SearchAndSelectThread
    extends SwingWorker<List<Feature>, Void> {
        private final Object layer;
        private final String query;

        public SearchAndSelectThread(Object layer, String query) {
            this.layer = layer;
            this.query = query;
        }

        @Override
        protected List<Feature> doInBackground() throws Exception {
            List features = null;
            if (this.layer instanceof WebFeatureService) {
                WebFeatureService wfs = (WebFeatureService)this.layer;
                try {
                    Element e = (Element)wfs.getQueryElement().clone();
                    Element queryElement = e.getChild("Query", Namespace.getNamespace((String)"wfs", (String)"http://www.opengis.net/wfs"));
                    queryElement.removeChild("Filter", Namespace.getNamespace((String)"ogc", (String)"http://www.opengis.net/ogc"));
                    Element filterElement = new Element("Filter", Namespace.getNamespace((String)"ogc", (String)"http://www.opengis.net/ogc"));
                    SAXBuilder builder = new SAXBuilder();
                    Document d = builder.build((Reader)new StringReader(this.query));
                    filterElement.addContent((Content)((Element)d.getRootElement().clone()));
                    queryElement.addContent(0, (Content)filterElement);
                    features = wfs.getFeatureFactory().createFeatures((Object)FeatureServiceUtilities.elementToString((Element)e), null, null, 0, 0, null);
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error while retrieving features", (Throwable)ex);
                }
            } else if (this.layer instanceof AbstractFeatureService) {
                AbstractFeatureService fs = (AbstractFeatureService)this.layer;
                features = fs.getFeatureFactory().createFeatures((Object)this.query, null, null, 0, 0, null);
            }
            return features;
        }

        @Override
        protected void done() {
            try {
                List features = (List)this.get();
                if (this.isCancelled()) {
                    return;
                }
                if (features != null && this.layer instanceof AbstractFeatureService) {
                    HashSet selectedFeaturesSet = new HashSet();
                    List selectedFeatures = SelectInSelectionAttributeTableSearchMethod.this.table.getSelectedFeatures();
                    ArrayList<FeatureServiceFeature> featuresToRemove = new ArrayList<FeatureServiceFeature>();
                    selectedFeaturesSet.addAll(features);
                    for (FeatureServiceFeature f : selectedFeatures) {
                        if (selectedFeaturesSet.contains(f)) continue;
                        featuresToRemove.add(f);
                    }
                    SelectionManager.getInstance().removeSelectedFeatures(featuresToRemove);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while selecting features", (Throwable)e);
            }
            SelectInSelectionAttributeTableSearchMethod.this.searching = false;
            SelectInSelectionAttributeTableSearchMethod.this.querySearch.setControlsAccordingToState(SelectInSelectionAttributeTableSearchMethod.this.searching);
        }
    }
}

