/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
package de.cismet.cismap.navigatorplugin.protocol;

import Sirius.navigator.search.CidsServerSearchMetaObjectNodeWrapper;

import java.awt.Component;

import java.util.ArrayList;

import de.cismet.cismap.navigatorplugin.metasearch.SearchTopic;

import de.cismet.commons.gui.protocol.AbstractProtocolStepPanel;

import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;

/**
 * DOCUMENT ME!
 *
 * @author   jruiz
 * @version  $Revision$, $Date$
 */
public class FulltextSearchProtocolStepPanel extends AbstractProtocolStepPanel<FulltextSearchProtocolStep>
        implements ConnectionContextProvider {

    //~ Instance fields --------------------------------------------------------

    private final ConnectionContext connectionContext = ConnectionContext.createDummy();

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private Sirius.navigator.search.CidsServerSearchProtocolStepPanel cidsServerSearchProtocolStepPanel1;
    private de.cismet.cismap.navigatorplugin.protocol.GeometryProtocolStepPanel geometryProtocolStepPanel1;
    private javax.swing.JCheckBox jCheckBox1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JTextField jTextField1;
    private javax.swing.JLabel lblIconBoth;
    private javax.swing.JLabel lblIconCase;
    private javax.swing.JLabel lblIconGeom;
    private javax.swing.JLabel lblIconNone;
    private javax.swing.JLabel lblTitle;
    private de.cismet.cismap.navigatorplugin.protocol.SearchTopicsProtocolStepPanel searchTopicsProtocolStepPanel1;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates a new GeoSearchProtocolStepPanel object.
     */
    public FulltextSearchProtocolStepPanel() {
        this(new FulltextSearchProtocolStepImpl(
                null,
                new ArrayList<SearchTopic>(),
                new ArrayList<CidsServerSearchMetaObjectNodeWrapper>()));
    }

    /**
     * Creates new form MetaSearchProtocolStepPanel.
     *
     * @param  fulltextSearchProtocolStep  DOCUMENT ME!
     */
    public FulltextSearchProtocolStepPanel(final FulltextSearchProtocolStep fulltextSearchProtocolStep) {
        super(fulltextSearchProtocolStep);
        initComponents();

        geometryProtocolStepPanel1.setVisible(fulltextSearchProtocolStep.getGeometry() != null);
    }

    //~ Methods ----------------------------------------------------------------

    @Override
    public Component getIconComponent() {
        return lblIconNone;
    }

    @Override
    public Component getTitleComponent() {
        return lblTitle;
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        lblIconNone = new javax.swing.JLabel();
        lblIconGeom = new javax.swing.JLabel();
        lblIconCase = new javax.swing.JLabel();
        lblIconBoth = new javax.swing.JLabel();
        lblTitle = new javax.swing.JLabel();
        cidsServerSearchProtocolStepPanel1 = new Sirius.navigator.search.CidsServerSearchProtocolStepPanel(
                ((FulltextSearchProtocolStepImpl)getProtocolStep()).getCidsServerSearchProtocolStep(),
                getConnectionContext());
        jPanel3 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jTextField1 = new javax.swing.JTextField();
        jCheckBox1 = new javax.swing.JCheckBox();
        searchTopicsProtocolStepPanel1 = new de.cismet.cismap.navigatorplugin.protocol.SearchTopicsProtocolStepPanel(
                ((FulltextSearchProtocolStepImpl)getProtocolStep()).getSearchTopicsProtocolStep());
        geometryProtocolStepPanel1 = new de.cismet.cismap.navigatorplugin.protocol.GeometryProtocolStepPanel(
                ((FulltextSearchProtocolStepImpl)getProtocolStep()).getGeometryProtocolStep());

        lblIconNone.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblIconNone.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cismap/navigatorplugin/metasearch/search.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(
            lblIconNone,
            org.openide.util.NbBundle.getMessage(
                FulltextSearchProtocolStepPanel.class,
                "FulltextSearchProtocolStepPanel.lblIconNone.text"));                                // NOI18N

        lblIconGeom.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblIconGeom.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cismap/navigatorplugin/metasearch/search_geom.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(
            lblIconGeom,
            org.openide.util.NbBundle.getMessage(
                FulltextSearchProtocolStepPanel.class,
                "FulltextSearchProtocolStepPanel.lblIconGeom.text"));                                     // NOI18N

        lblIconCase.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblIconCase.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cismap/navigatorplugin/metasearch/search_casesensitive.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(
            lblIconCase,
            org.openide.util.NbBundle.getMessage(
                FulltextSearchProtocolStepPanel.class,
                "FulltextSearchProtocolStepPanel.lblIconCase.text"));                                              // NOI18N

        lblIconBoth.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblIconBoth.setIcon(new javax.swing.ImageIcon(
                getClass().getResource("/de/cismet/cismap/navigatorplugin/metasearch/search_geom_casesensitive.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(
            lblIconBoth,
            org.openide.util.NbBundle.getMessage(
                FulltextSearchProtocolStepPanel.class,
                "FulltextSearchProtocolStepPanel.lblIconBoth.text"));                                                   // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(
            lblTitle,
            org.openide.util.NbBundle.getMessage(
                FulltextSearchProtocolStepPanel.class,
                "FulltextSearchProtocolStepPanel.lblTitle.text")); // NOI18N

        setLayout(new java.awt.GridBagLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(cidsServerSearchProtocolStepPanel1, gridBagConstraints);

        jPanel3.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(
            jLabel1,
            org.openide.util.NbBundle.getMessage(
                FulltextSearchProtocolStepPanel.class,
                "FulltextSearchProtocolStepPanel.jLabel1.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        jPanel3.add(jLabel1, gridBagConstraints);

        jTextField1.setEditable(false);
        jTextField1.setText(getProtocolStep().getSearchText());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        jPanel3.add(jTextField1, gridBagConstraints);

        jCheckBox1.setSelected(getProtocolStep().isCaseSensitiveEnabled());
        org.openide.awt.Mnemonics.setLocalizedText(
            jCheckBox1,
            org.openide.util.NbBundle.getMessage(
                FulltextSearchProtocolStepPanel.class,
                "FulltextSearchProtocolStepPanel.jCheckBox1.text")); // NOI18N
        jCheckBox1.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 0, 0);
        jPanel3.add(jCheckBox1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(jPanel3, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(searchTopicsProtocolStepPanel1, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        add(geometryProtocolStepPanel1, gridBagConstraints);
    } // </editor-fold>//GEN-END:initComponents

    @Override
    public ConnectionContext getConnectionContext() {
        return connectionContext;
    }
}
