/***************************************************
*
* cismet GmbH, Saarbruecken, Germany
*
*              ... and it just works.
*
****************************************************/
/*
 * A4H.java
 *
 * Created on 11. Juli 2006, 12:19
 */
package de.cismet.cismap.printing.templateinscriber;

import java.io.FileInputStream;
import java.io.FileOutputStream;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import de.cismet.cismap.commons.gui.printing.AbstractPrintingInscriber;
import de.cismet.cismap.commons.gui.printing.FileNameChangedEvent;
import de.cismet.cismap.commons.gui.printing.FilenamePrintingInscriber;
import de.cismet.cismap.commons.gui.printing.FilenamePrintingInscriberListener;
import de.cismet.cismap.commons.interaction.CismapBroker;

import de.cismet.tools.CismetThreadPool;

/**
 * DOCUMENT ME!
 *
 * @author   thorsten.hell@cismet.de
 * @version  $Revision$, $Date$
 */
public class A4HPersistent extends AbstractPrintingInscriber implements FilenamePrintingInscriber {

    //~ Static fields/initializers ---------------------------------------------

    public static final String FIRST_LINE = "FIRST_LINE";   // NOI18N
    public static final String SECOND_LINE = "SECOND_LINE"; // NOI18N
    private static final org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(A4HPersistent.class);

    //~ Instance fields --------------------------------------------------------

    String cacheFile = ""; // NOI18N
    Properties cache = new Properties();
    private List<FilenamePrintingInscriberListener> listeners = new ArrayList<>();
    private String oldText = "";
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JTextField txtZeile1;
    private javax.swing.JTextField txtZeile2;
    // End of variables declaration//GEN-END:variables

    //~ Constructors -----------------------------------------------------------

    /**
     * Creates new form A4H.
     */
    public A4HPersistent() {
        initComponents();
        cacheFile = CismapBroker.getInstance().getCismapFolderPath() + System.getProperty("file.separator")
                    + "inscriberCache"; // NOI18N
        readInscriberCache();
        oldText = txtZeile1.getText();

        txtZeile1.getDocument().addDocumentListener(new DocumentListener() {

                @Override
                public void insertUpdate(final DocumentEvent e) {
                    onChange(e);
                }

                @Override
                public void removeUpdate(final DocumentEvent e) {
                    onChange(e);
                }

                @Override
                public void changedUpdate(final DocumentEvent e) {
                    onChange(e);
                }

                private void onChange(final DocumentEvent e) {
                    final FileNameChangedEvent event = new FileNameChangedEvent(oldText, txtZeile1.getText());

                    for (final FilenamePrintingInscriberListener listener : listeners) {
                        listener.fileNameChanged(event);
                    }

                    oldText = txtZeile1.getText();
                }
            });
    }

    //~ Methods ----------------------------------------------------------------

    /**
     * This Method should return the values in the Form<br>
     * key: placeholderName value: value
     *
     * @return  DOCUMENT ME!
     */
    @Override
    public HashMap<String, String> getValues() {
        final HashMap<String, String> hm = new HashMap<>();
        hm.put("Ueberschrift", txtZeile1.getText());         // NOI18N
        hm.put("Unterschrift", txtZeile2.getText());         // NOI18N
        cache.setProperty(FIRST_LINE, txtZeile1.getText());  // NOI18N
        cache.setProperty(SECOND_LINE, txtZeile2.getText()); // NOI18N
        writeInscriberCache();
        return hm;
    }

    /**
     * This method is called from within the constructor to initialize the form. WARNING: Do NOT modify this code. The
     * content of this method is always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        jLabel1 = new javax.swing.JLabel();
        txtZeile1 = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        txtZeile2 = new javax.swing.JTextField();

        jLabel1.setText(org.openide.util.NbBundle.getMessage(A4HPersistent.class, "A4HPersistent.jLabel1.text")); // NOI18N

        txtZeile1.addActionListener(new java.awt.event.ActionListener() {

                @Override
                public void actionPerformed(final java.awt.event.ActionEvent evt) {
                    txtZeile1ActionPerformed(evt);
                }
            });

        jLabel2.setText(org.openide.util.NbBundle.getMessage(A4HPersistent.class, "A4HPersistent.jLabel2.text")); // NOI18N

        final org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING).add(
                layout.createSequentialGroup().addContainerGap().add(
                    layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING).add(
                        layout.createSequentialGroup().add(jLabel1).addPreferredGap(
                            org.jdesktop.layout.LayoutStyle.RELATED).add(
                            txtZeile1,
                            org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                            232,
                            Short.MAX_VALUE)).add(
                        layout.createSequentialGroup().add(jLabel2).addPreferredGap(
                            org.jdesktop.layout.LayoutStyle.RELATED).add(
                            txtZeile2,
                            org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                            166,
                            Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING).add(
                layout.createSequentialGroup().addContainerGap().add(
                    layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE).add(jLabel1).add(
                        txtZeile1,
                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                        org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)).addPreferredGap(
                    org.jdesktop.layout.LayoutStyle.RELATED).add(
                    layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE).add(jLabel2).add(
                        txtZeile2,
                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                        org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)).addContainerGap(
                    org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                    Short.MAX_VALUE)));
    } // </editor-fold>//GEN-END:initComponents

    /**
     * DOCUMENT ME!
     *
     * @param  evt  DOCUMENT ME!
     */
    private void txtZeile1ActionPerformed(final java.awt.event.ActionEvent evt) { //GEN-FIRST:event_txtZeile1ActionPerformed
    }                                                                             //GEN-LAST:event_txtZeile1ActionPerformed

    /**
     * DOCUMENT ME!
     */
    private void readInscriberCache() {
        try {
            cache.load(new FileInputStream(cacheFile));
            final String z1 = cache.getProperty(FIRST_LINE);
            final String z2 = cache.getProperty(SECOND_LINE);
            txtZeile1.setText(z1);
            txtZeile2.setText(z2);
        } catch (Throwable t) {
            log.warn("Error while reading the InscriberCache", t); // NOI18N
        }
    }

    /**
     * DOCUMENT ME!
     */
    private void writeInscriberCache() {
        final Runnable t = new Thread("A4HPersistent writeInscriberCache()") {

                @Override
                public void run() {
                    try {
                        cache.store(new FileOutputStream(cacheFile), "Saved: " + System.currentTimeMillis()); // NOI18N
                    } catch (Throwable t) {
                        log.warn("Error while writing the InscriberCache", t);                                // NOI18N
                    }
                }
            };
        CismetThreadPool.execute(t);
    }

    /**
     * DOCUMENT ME!
     *
     * @param  newText  DOCUMENT ME!
     */
    protected void setTextOfJLabel1(final String newText) {
        jLabel1.setText(newText);
    }

    /**
     * DOCUMENT ME!
     *
     * @param  newText  DOCUMENT ME!
     */
    protected void setTextOfJLabel2(final String newText) {
        jLabel2.setText(newText);
    }

    /**
     * DOCUMENT ME!
     *
     * @param  listener  DOCUMENT ME!
     */
    @Override
    public void addFilenameChangeListener(final FilenamePrintingInscriberListener listener) {
        listeners.add(listener);
    }

    /**
     * DOCUMENT ME!
     *
     * @return  DOCUMENT ME!
     */
    @Override
    public String getFileName() {
        return txtZeile1.getText();
    }
}
