/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.cids.geometryeditor;

import Sirius.navigator.ui.ComponentRegistry;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.cids.geometryeditor.DefaultCismapGeometryComboBoxEditor;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.features.SearchFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.CurrentStackTrace;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

class CismapGeometryComboModel
extends AbstractListModel
implements ComboBoxModel,
FeatureCollectionListener {
    private final Logger log = Logger.getLogger(this.getClass());
    private final DefaultCismapGeometryComboBoxEditor editor;
    private Object selectedItem = null;
    private Feature currentObjectFeature;
    private List<Feature> newFeaturesInMap;
    private Class[] allowedGeometryTypes = null;

    public CismapGeometryComboModel(DefaultCismapGeometryComboBoxEditor editor, Feature currentObjectFeature) {
        this.editor = editor;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("editor (con): " + editor));
        }
        this.currentObjectFeature = currentObjectFeature;
        this.refresh();
    }

    @Override
    public void setSelectedItem(Object anItem) {
        if (anItem instanceof Feature) {
            Feature anFeature = (Feature)anItem;
            int srid = ((Feature)anItem).getGeometry().getSRID();
            int defaultSrid = CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getDefaultCrs());
            if (srid == CismapBroker.getInstance().getDefaultCrsAlias()) {
                srid = defaultSrid;
            }
            if (srid != defaultSrid) {
                int ans = JOptionPane.showConfirmDialog(ComponentRegistry.getRegistry().getMainWindow(), NbBundle.getMessage(CismapGeometryComboModel.class, (String)"CismapGeometryComboModel.setSelectedItem.JOptionPane.message", (Object[])new Object[]{"" + srid, "" + defaultSrid}), NbBundle.getMessage(CismapGeometryComboModel.class, (String)"CismapGeometryComboModel.setSelectedItem.JOptionPane.title"), 0, 3);
                if (ans == 0) {
                    anFeature.setGeometry(CrsTransformer.transformToDefaultCrs((Geometry)anFeature.getGeometry()));
                    anFeature.getGeometry().setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
                    this.selectedItem = anItem;
                }
            } else {
                anFeature.getGeometry().setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
                this.selectedItem = anItem;
            }
        } else {
            this.selectedItem = anItem;
        }
    }

    @Override
    public Object getElementAt(int index) {
        if (this.currentObjectFeature != null) {
            if (index == 0) {
                return this.currentObjectFeature;
            }
            if (index == this.getSize() - 1) {
                return null;
            }
            return this.newFeaturesInMap.get(index - 1);
        }
        if (index == 0) {
            return this.currentObjectFeature;
        }
        return this.newFeaturesInMap.get(index - 1);
    }

    @Override
    public int getSize() {
        if (this.currentObjectFeature != null) {
            return this.newFeaturesInMap.size() + 2;
        }
        return this.newFeaturesInMap.size() + 1;
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    public void refresh() {
        this.newFeaturesInMap = this.getAllNewFeatures();
        try {
            this.fireContentsChanged(this, 0, this.getSize() - 1);
        }
        catch (Throwable t) {
            this.log.error((Object)"Error in refresh()", t);
        }
    }

    private List<Feature> getAllNewFeatures() {
        ArrayList<Feature> allNewFeatures = new ArrayList<Feature>();
        if (CismapBroker.getInstance().getMappingComponent() != null) {
            List allFeatures = CismapBroker.getInstance().getMappingComponent().getFeatureCollection().getAllFeatures();
            for (Feature f : allFeatures) {
                if (!(f instanceof PureNewFeature) && !(f instanceof SearchFeature) || !this.isGeometryTypeAllowed(f.getGeometry())) continue;
                allNewFeatures.add(f);
            }
        } else {
            this.log.error((Object)"cismap not found. No content in the editor.");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("getAllNewFeatures " + allNewFeatures), (Throwable)new CurrentStackTrace());
        }
        return allNewFeatures;
    }

    public void setAllowedGeometryTypes(Class[] types) {
        this.allowedGeometryTypes = types;
    }

    private boolean isGeometryTypeAllowed(Geometry geom) {
        if (this.allowedGeometryTypes == null || geom == null) {
            return true;
        }
        for (Class geometryClass : this.allowedGeometryTypes) {
            if (!geometryClass.getName().equals(geom.getClass().getName())) continue;
            return true;
        }
        return false;
    }

    public void setCurrentObjectFeature(Feature currentObjectFeature) {
        this.currentObjectFeature = currentObjectFeature;
    }

    public void allFeaturesRemoved(FeatureCollectionEvent fce) {
        this.refresh();
    }

    public void featureCollectionChanged() {
        this.refresh();
    }

    public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
        this.refresh();
    }

    public void featureSelectionChanged(FeatureCollectionEvent fce) {
        this.refresh();
    }

    public void featuresAdded(FeatureCollectionEvent fce) {
        this.refresh();
    }

    public void featuresChanged(FeatureCollectionEvent fce) {
        this.refresh();
    }

    public void featuresRemoved(FeatureCollectionEvent fce) {
        this.refresh();
    }
}

