/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.cids.geometryeditor;

import Sirius.server.localserver.attribute.ObjectAttribute;
import Sirius.server.middleware.types.MetaClassStore;
import Sirius.server.middleware.types.MetaObject;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.dynamics.Disposable;
import de.cismet.cids.editors.Bindable;
import de.cismet.cismap.cids.geometryeditor.CismapGeometryComboModel;
import de.cismet.cismap.cids.geometryeditor.DefaultCismapGeometryComboBoxEditor;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollection;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.CurrentStackTrace;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.Converter;

public class DefaultCismapSimpleGeomComboBoxEditor
extends DefaultCismapGeometryComboBoxEditor
implements Bindable,
MetaClassStore,
Disposable,
ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(DefaultCismapSimpleGeomComboBoxEditor.class);
    private Geometry geometry;

    public DefaultCismapSimpleGeomComboBoxEditor() {
        this(true);
    }

    public DefaultCismapSimpleGeomComboBoxEditor(boolean editable) {
        super(editable);
    }

    @Override
    public Converter getConverter() {
        return new Converter<Geometry, Feature>(){

            public Feature convertForward(Geometry value) {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"convertForward", (Throwable)new CurrentStackTrace());
                    }
                    DefaultCismapSimpleGeomComboBoxEditor.this.geometry = value;
                    if (value != null) {
                        MetaObject cidsFeatureMetaObject = null;
                        if (DefaultCismapSimpleGeomComboBoxEditor.this.cidsMetaObject != null) {
                            cidsFeatureMetaObject = DefaultCismapSimpleGeomComboBoxEditor.this.cidsMetaObject;
                        } else if (DefaultCismapSimpleGeomComboBoxEditor.this.metaObjectNode != null) {
                            cidsFeatureMetaObject = DefaultCismapSimpleGeomComboBoxEditor.this.metaObjectNode.getObject();
                        }
                        ObjectAttribute oAttr = null;
                        if (DefaultCismapSimpleGeomComboBoxEditor.this.localRenderFeatureString != null) {
                            oAttr = cidsFeatureMetaObject.getAttributeByFieldName(DefaultCismapSimpleGeomComboBoxEditor.this.localRenderFeatureString);
                        }
                        DefaultCismapSimpleGeomComboBoxEditor.this.cidsFeature = new CidsFeature(cidsFeatureMetaObject, oAttr){
                            private Geometry lastGeom;
                            {
                                this.lastGeom = DefaultCismapSimpleGeomComboBoxEditor.this.geometry != null ? DefaultCismapSimpleGeomComboBoxEditor.this.geometry : null;
                            }

                            @Override
                            public void setGeometry(Geometry geom) {
                                if (geom == null) {
                                    LOG.warn((Object)"ATTENTION geom=null");
                                }
                                Geometry oldValue = this.lastGeom;
                                super.setGeometry(geom);
                                try {
                                    if (oldValue == null && geom != null || oldValue != null && !oldValue.equalsExact(geom)) {
                                        DefaultCismapSimpleGeomComboBoxEditor.this.geometry = geom;
                                        this.lastGeom = geom != null ? (Geometry)geom.clone() : null;
                                    }
                                }
                                catch (Exception e) {
                                    LOG.error((Object)"Error when setting the geometry.", (Throwable)e);
                                }
                            }
                        };
                        DefaultCismapSimpleGeomComboBoxEditor.this.selectedFeature = DefaultCismapSimpleGeomComboBoxEditor.this.cidsFeature;
                        DefaultCismapSimpleGeomComboBoxEditor.this.comboModel.setCurrentObjectFeature(DefaultCismapSimpleGeomComboBoxEditor.this.selectedFeature);
                        FeatureCollection cismapFeatures = CismapBroker.getInstance().getMappingComponent().getFeatureCollection();
                        if (cismapFeatures.getAllFeatures().contains(DefaultCismapSimpleGeomComboBoxEditor.this.selectedFeature)) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)"Feature already exists. Remove it from map.");
                            }
                            cismapFeatures.removeFeature(DefaultCismapSimpleGeomComboBoxEditor.this.selectedFeature);
                        }
                        if (DefaultCismapSimpleGeomComboBoxEditor.this.selectedFeature.getGeometry() == null) {
                            DefaultCismapSimpleGeomComboBoxEditor.this.selectedFeature.setGeometry(value);
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Add selectedFeature '" + DefaultCismapSimpleGeomComboBoxEditor.this.selectedFeature + "' with geometry '" + DefaultCismapSimpleGeomComboBoxEditor.this.selectedFeature.getGeometry() + "' to feature collection."));
                        }
                        cismapFeatures.addFeature(DefaultCismapSimpleGeomComboBoxEditor.this.selectedFeature);
                        DefaultCismapSimpleGeomComboBoxEditor.this.selectedFeature.setEditable(true);
                        cismapFeatures.holdFeature(DefaultCismapSimpleGeomComboBoxEditor.this.selectedFeature);
                        cismapFeatures.select(DefaultCismapSimpleGeomComboBoxEditor.this.selectedFeature);
                        CismapBroker.getInstance().getMappingComponent().showHandles(true);
                        if (DefaultCismapSimpleGeomComboBoxEditor.this.selectedFeature.getGeometry() != null) {
                            CismapBroker.getInstance().getMappingComponent().gotoBoundingBox((BoundingBox)new XBoundingBox(DefaultCismapSimpleGeomComboBoxEditor.this.selectedFeature.getGeometry()), false, true, 0);
                        }
                        DefaultCismapSimpleGeomComboBoxEditor.this.setSelectedItem(DefaultCismapSimpleGeomComboBoxEditor.this.selectedFeature);
                    }
                    return DefaultCismapSimpleGeomComboBoxEditor.this.selectedFeature;
                }
                catch (Exception e) {
                    LOG.error((Object)"Error in convertForward", (Throwable)e);
                    return null;
                }
            }

            public Geometry convertReverse(Feature value) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("convertReverse: " + value));
                }
                if (value == null) {
                    return null;
                }
                try {
                    Geometry oldValue = DefaultCismapSimpleGeomComboBoxEditor.this.geometry;
                    Geometry geom = value.getGeometry();
                    if (oldValue == null && geom != null || oldValue != null && !oldValue.equalsExact(geom)) {
                        DefaultCismapSimpleGeomComboBoxEditor.this.geometry = value.getGeometry();
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error during set geo_field", (Throwable)ex);
                }
                return DefaultCismapSimpleGeomComboBoxEditor.this.geometry;
            }
        };
    }

    @Override
    public void initForNewBinding() {
        CismapBroker.getInstance().getMappingComponent().getFeatureCollection().removeFeatureCollectionListener((FeatureCollectionListener)this.comboModel);
        this.geometry = null;
        this.selectedFeature = null;
        this.cidsFeature = null;
        this.comboModel = new CismapGeometryComboModel(this, this.selectedFeature);
        this.setModel(this.comboModel);
        CismapBroker.getInstance().getMappingComponent().getFeatureCollection().addFeatureCollectionListener((FeatureCollectionListener)this.comboModel);
    }
}

