/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.cidslayer;

import Sirius.server.localserver.attribute.ClassAttribute;
import Sirius.server.middleware.types.MetaClass;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.commons.LayerConfig;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import org.apache.log4j.Logger;

public class CidsLayerConfig
implements LayerConfig,
Comparable<CidsLayerConfig> {
    private static final Logger LOG = Logger.getLogger(CidsLayerConfig.class);
    public static final String LAYER_TITLE = "cidsLayerTitle";
    private static final String LAYER_POSITION = "cidsLayerPosition";
    private final MetaClass config;
    private final String title;
    private int position = -1;

    public CidsLayerConfig(MetaClass clazz) {
        this.config = clazz;
        ClassAttribute titleAttribute = this.config.getClassAttribute(LAYER_TITLE);
        this.title = titleAttribute != null && titleAttribute.getValue() != null ? titleAttribute.getValue().toString() : this.config.getName();
        ClassAttribute positionAttribute = this.config.getClassAttribute(LAYER_POSITION);
        if (positionAttribute != null && positionAttribute.getValue() != null) {
            try {
                this.position = Integer.parseInt(positionAttribute.getValue().toString());
            }
            catch (NumberFormatException ex) {
                LOG.warn((Object)("The position attribute of the cidsLayer " + this.title + " does not contain a valid number"), (Throwable)ex);
            }
        }
    }

    public AbstractFeatureService createConfiguredLayer() {
        CidsLayer layer = new CidsLayer(this.config);
        return layer;
    }

    public String toString() {
        return this.config.getName();
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public int compareTo(CidsLayerConfig o) {
        if (this.position == o.position) {
            return this.getTitle().compareTo(o.getTitle());
        }
        return this.position - o.position;
    }
}

