/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.cidslayer;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.tools.MetaObjectCache;
import Sirius.server.localserver.attribute.MemberAttributeInfo;
import Sirius.server.localserver.attribute.ObjectAttribute;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import Sirius.server.newuser.permission.PermissionHolder;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.cidslayer.CidsLayerInfo;
import de.cismet.cids.server.cidslayer.StationInfo;
import de.cismet.cids.tools.tostring.CidsLayerFeatureToStringConverter;
import de.cismet.cids.tools.tostring.ToStringConverter;
import de.cismet.cids.utils.ClassloadingHelper;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.cidslayer.CidsLayerPermissionProvider;
import de.cismet.cismap.cidslayer.DefaultCidsLayerBindableReferenceCombo;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.WorldToScreenTransform;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.features.ModifiableFeature;
import de.cismet.cismap.commons.features.PermissionProvider;
import de.cismet.cismap.commons.features.SLDStyledFeature;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableRuleSet;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.PSticky;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.util.SelectionManager;
import de.cismet.cismap.linearreferencing.FeatureRegistry;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.cismap.linearreferencing.TableLinearReferencedLineEditor;
import de.cismet.cismap.linearreferencing.TableStationEditor;
import de.cismet.cismap.linearreferencing.tools.StationEditorInterface;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.nodes.PImage;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.deegree.feature.types.FeatureType;
import org.deegree.style.se.unevaluated.Style;

public class CidsLayerFeature
extends DefaultFeatureServiceFeature
implements ModifiableFeature,
PermissionProvider,
ConnectionContextProvider {
    private static transient Logger LOG = Logger.getLogger(CidsLayerFeature.class);
    private MetaObject metaObject;
    private MetaClass metaClass;
    private CidsLayerInfo layerInfo;
    private Map<String, DisposableCidsBeanStore> stations = null;
    private Map<String, DefaultCidsLayerBindableReferenceCombo> combos = null;
    private Map<String, FeatureServiceFeature> initCatalogueValue = null;
    private Color backgroundColor;
    private final PropertyChangeListener propListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            CidsLayerFeature.this.modified = true;
            CidsLayerFeature.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            if (CidsLayerFeature.this.getLayerProperties() != null && CidsLayerFeature.this.getLayerProperties().getAttributeTableRuleSet() != null && !CidsLayerFeature.this.getLayerProperties().getAttributeTableRuleSet().isCatThree() && evt.getSource() instanceof TableStationEditor) {
                Geometry g;
                LinearReferencingHelper helper;
                TableStationEditor stat = (TableStationEditor)evt.getSource();
                if (stat.isLine()) {
                    helper = FeatureRegistry.getInstance().getLinearReferencingSolver();
                    g = (Geometry)helper.getGeomBeanFromLineBean(stat.getLineBean()).getProperty("geo_field");
                    CidsLayerFeature.this.setGeometry(g);
                } else {
                    helper = FeatureRegistry.getInstance().getLinearReferencingSolver();
                    g = helper.getPointGeometryFromStationBean(stat.getCidsBean());
                    CidsLayerFeature.this.setGeometry(g);
                }
            }
            if (evt.getSource() instanceof TableStationEditor) {
                LinearReferencingHelper helper = FeatureRegistry.getInstance().getLinearReferencingSolver();
                TableStationEditor stat = (TableStationEditor)evt.getSource();
                String routeProperty = stat.getStationProperty();
                String routeName = null;
                if (stat.getCidsBean() != null) {
                    routeName = helper.getRouteNameFromStationBean(stat.getCidsBean());
                }
                CidsLayerFeature.this.setProperty(routeProperty, routeName);
            }
        }
    };
    private HashMap backupProperties;
    private Geometry backupGeometry;
    private boolean modified;
    private boolean doNotChangeBackup = false;
    private boolean undoOnServer = false;
    private boolean useIdInHash = true;
    private final ConnectionContext connectionContext = ConnectionContext.createDummy();
    private Geometry oldGeom = null;

    public CidsLayerFeature(CidsLayerFeature feature) {
        super((FeatureServiceFeature)feature);
        this.metaClass = feature.metaClass;
        this.layerInfo = feature.layerInfo;
        if (feature.metaObject != null) {
            this.metaObject = feature.metaObject;
        }
        this.useIdInHash = feature.useIdInHash;
    }

    public CidsLayerFeature(Map<String, Object> properties, MetaClass metaClass, CidsLayerInfo layerInfo, LayerProperties layerProperties, List<Style> styles) {
        super(((Integer)properties.get(layerInfo.getIdField())).intValue(), (Geometry)properties.get(layerInfo.getGeoField()), layerProperties, styles);
        this.metaClass = metaClass;
        this.layerInfo = layerInfo;
        this.addProperties(properties);
        if ((Integer)properties.get(layerInfo.getIdField()) < 0) {
            this.useIdInHash = false;
        }
    }

    public boolean isDoNotChangeBackup() {
        return this.doNotChangeBackup;
    }

    public void setDoNotChangeBackup(boolean doNotChangeBackup) {
        this.doNotChangeBackup = doNotChangeBackup;
        if (doNotChangeBackup) {
            this.undoOnServer = false;
        }
    }

    public CidsBean getBean() {
        try {
            return this.getMetaObject().getBean();
        }
        catch (ConnectionException ex) {
            LOG.info((Object)"CidsBean could not be loaded, property is null", (Throwable)ex);
            return null;
        }
    }

    public void setMetaObject(MetaObject metaObject) {
        this.metaObject = metaObject;
        this.syncWithBean();
    }

    public void syncWithBean() {
        CidsBean bean = this.metaObject.getBean();
        for (String propName : bean.getPropertyNames()) {
            Object geomObject;
            this.setProperty(propName, bean.getProperty(propName));
            if (propName.equals(this.layerInfo.getIdField())) {
                this.setId((Integer)bean.getProperty(propName));
            }
            if (!propName.equals(this.layerInfo.getGeoField()) || !((geomObject = bean.getProperty(propName)) instanceof CidsBean)) continue;
            MetaObject mo = ((CidsBean)geomObject).getMetaObject().getMetaClass().getEmptyInstance(this.getConnectionContext());
            for (ObjectAttribute oa : mo.getAttribs()) {
                if (oa.isPrimaryKey() || oa.isArray()) continue;
                try {
                    mo.getBean().setProperty(oa.getMai().getFieldName().toLowerCase(), ((CidsBean)geomObject).getProperty(oa.getMai().getFieldName().toLowerCase()));
                }
                catch (Exception ex) {
                    LOG.error((Object)"Cannot copy attribute", (Throwable)ex);
                }
            }
            this.setProperty(propName, mo.getBean());
        }
    }

    public FeatureAnnotationSymbol getPointAnnotationSymbol() {
        if (this.styles == null || this.styles.isEmpty()) {
            if (this.getLayerProperties() != null && this.getLayerProperties().getAttributeTableRuleSet() != null) {
                return this.getLayerProperties().getAttributeTableRuleSet().getPointAnnotationSymbol((FeatureServiceFeature)this);
            }
            return this.getStyle().getPointSymbol();
        }
        return null;
    }

    protected org.deegree.feature.Feature getDeegreeFeature() {
        return new CidSLayerDeegreeFeature();
    }

    public boolean isPrimaryAnnotationVisible() {
        return false;
    }

    public Object clone() {
        return new CidsLayerFeature(this);
    }

    public Object getProperty(String propertyName) {
        if (propertyName != null && !propertyName.isEmpty() && propertyName.startsWith("original:")) {
            try {
                return this.getMetaObject().getBean().getProperty(propertyName.substring("original:".length()));
            }
            catch (ConnectionException ex) {
                LOG.info((Object)"CidsBean could not be loaded, property is null", (Throwable)ex);
                return null;
            }
        }
        if (this.stations != null && this.layerInfo.isStation(propertyName) && this.stations.get(propertyName) != null) {
            TableStationEditor se = (TableStationEditor)this.stations.get(propertyName);
            return se.getValue();
        }
        return super.getProperty(propertyName);
    }

    public void setEditable(boolean editable) {
        boolean oldEditableStatus = this.isEditable();
        super.setEditable(editable);
        if (oldEditableStatus != editable) {
            this.modified = false;
            if (!editable && this.stations != null) {
                this.removeStations();
                if (this.getLayerProperties().getAttributeTableRuleSet() != null && this.getLayerProperties().getAttributeTableRuleSet().isCatThree()) {
                    if (CismapBroker.getInstance().getMappingComponent().getFeatureCollection().isHoldFeature((Feature)this)) {
                        CismapBroker.getInstance().getMappingComponent().getFeatureCollection().unholdFeature((Feature)this);
                    }
                    if (CismapBroker.getInstance().getMappingComponent().getPFeatureHM().get((Object)this) != null) {
                        CismapBroker.getInstance().getMappingComponent().getFeatureCollection().removeFeature((Feature)this);
                    }
                }
            } else {
                if (CismapBroker.getInstance().getMappingComponent().getFeatureCollection().isHoldFeature((Feature)this)) {
                    CismapBroker.getInstance().getMappingComponent().getFeatureCollection().unholdFeature((Feature)this);
                }
                if (CismapBroker.getInstance().getMappingComponent().getPFeatureHM().get((Object)this) != null) {
                    CismapBroker.getInstance().getMappingComponent().getFeatureCollection().removeFeature((Feature)this);
                }
            }
            if (editable) {
                this.backupProperties = (HashMap)super.getProperties().clone();
                if (this.hasStations()) {
                    this.initStations();
                    if (this.getLayerProperties().getAttributeTableRuleSet() != null && this.getLayerProperties().getAttributeTableRuleSet().isCatThree()) {
                        if (!this.doNotChangeBackup) {
                            this.backupGeometry = (Geometry)this.getGeometry().clone();
                            this.backupProperties = (HashMap)super.getProperties().clone();
                        }
                        CismapBroker.getInstance().getMappingComponent().getFeatureCollection().addFeature((Feature)this);
                        CismapBroker.getInstance().getMappingComponent().getFeatureCollection().holdFeature((Feature)this);
                        SelectionManager.getInstance().addSelectedFeatures(Collections.nCopies(1, this));
                    } else {
                        StationEditorInterface te;
                        Geometry g;
                        DisposableCidsBeanStore beanStore;
                        Iterator<String> it = this.stations.keySet().iterator();
                        String stationKey = it.next();
                        StationInfo station = this.layerInfo.getStationInfo(stationKey);
                        if (station != null && station.isStationLine()) {
                            beanStore = this.stations.get(String.valueOf(station.getLineId()));
                            if (beanStore instanceof TableLinearReferencedLineEditor && (g = (te = (TableLinearReferencedLineEditor)beanStore).recreateGeometry()) != null) {
                                this.setGeometry(g);
                            }
                        } else if (station != null && !station.isStationLine()) {
                            beanStore = this.stations.get(stationKey);
                            if (beanStore instanceof TableStationEditor && (g = (te = (TableStationEditor)beanStore).updateGeometry()) != null) {
                                this.setGeometry(g);
                            }
                        } else if (station == null && (station = this.layerInfo.getStationInfo(stationKey = it.next())) != null && station.isStationLine() && (beanStore = this.stations.get(String.valueOf(station.getLineId()))) instanceof TableLinearReferencedLineEditor && (g = (te = (TableLinearReferencedLineEditor)beanStore).recreateGeometry()) != null) {
                            this.setGeometry(g);
                        }
                    }
                } else {
                    if (!this.doNotChangeBackup) {
                        if (this.getGeometry() != null) {
                            this.backupGeometry = (Geometry)this.getGeometry().clone();
                        }
                        this.backupProperties = (HashMap)super.getProperties().clone();
                    }
                    CismapBroker.getInstance().getMappingComponent().getFeatureCollection().addFeature((Feature)this);
                    CismapBroker.getInstance().getMappingComponent().getFeatureCollection().holdFeature((Feature)this);
                    SelectionManager.getInstance().addSelectedFeatures(Collections.nCopies(1, this));
                    CismapBroker.getInstance().getMappingComponent().getFeatureCollection().addToSelection((Feature)this);
                    this.backgroundColor = new Color(255, 91, 0);
                }
                if (this.hasCatalogues()) {
                    for (int i = 0; i < this.layerInfo.getColumnNames().length; ++i) {
                        try {
                            String col = this.layerInfo.getColumnNames()[i];
                            if (!this.layerInfo.isCatalogue(col)) continue;
                            int referencedForeignClassId = this.layerInfo.getCatalogueClass(col);
                            if (this.combos == null) {
                                this.combos = new HashMap<String, DefaultCidsLayerBindableReferenceCombo>();
                                this.initCatalogueValue = new HashMap<String, FeatureServiceFeature>();
                            }
                            MetaClass foreignClass = this.getMetaClass(referencedForeignClassId);
                            DefaultCidsLayerBindableReferenceCombo catalogueEditor = new DefaultCidsLayerBindableReferenceCombo(foreignClass, true);
                            String colName = this.layerInfo.getColumnPropertyNames()[i];
                            FeatureServiceFeature feature = null;
                            CidsBean bean = (CidsBean)this.getMetaObject().getBean().getProperty(colName);
                            if (bean != null) {
                                feature = this.retrieveFeature(bean.getPrimaryKeyValue(), bean.getMetaObject().getMetaClass());
                            }
                            catalogueEditor.setSelectedItem(feature);
                            this.combos.put(col, catalogueEditor);
                            this.initCatalogueValue.put(col, feature);
                            continue;
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Error while receiving meta class", (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    public void initStations() {
        try {
            for (int i = 0; i < this.layerInfo.getColumnNames().length; ++i) {
                String col = this.layerInfo.getColumnNames()[i];
                if (!this.layerInfo.isStation(col)) continue;
                String colName = this.layerInfo.getColumnPropertyNames()[i];
                CidsBean bean = (CidsBean)this.getMetaObject().getBean().getProperty(colName.substring(0, colName.indexOf(".")));
                StationInfo statInfo = this.layerInfo.getStationInfo(col);
                if (bean == null) continue;
                if (statInfo.isStationLine()) {
                    TableLinearReferencedLineEditor st;
                    if (this.stations == null) {
                        this.stations = new HashMap<String, DisposableCidsBeanStore>();
                    }
                    if ((st = (TableLinearReferencedLineEditor)this.stations.get(String.valueOf(statInfo.getLineId()))) == null) {
                        String statField = colName.substring(0, colName.indexOf("."));
                        st = new TableLinearReferencedLineEditor(statInfo.getRouteTable(), (FeatureServiceFeature)this, statInfo.getRoutePropertyName());
                        st.setOtherLinesFrom(this.metaClass.getTableName());
                        st.setOtherLinesQuery(this.metaClass.getTableName() + "." + statField + " = ");
                        st.setCidsBean(bean);
                        st.addPropertyChangeListener(this.propListener);
                        this.backgroundColor = st.getLineColor();
                        this.stations.put(String.valueOf(statInfo.getLineId()), st);
                    }
                    if (statInfo.isFromStation()) {
                        this.stations.put(col, st.getFromStation());
                        continue;
                    }
                    this.stations.put(col, st.getToStation());
                    continue;
                }
                if (this.stations == null) {
                    this.stations = new HashMap<String, DisposableCidsBeanStore>();
                }
                String statField = colName.substring(0, colName.indexOf("."));
                TableStationEditor st = new TableStationEditor(statInfo.getRouteTable(), (FeatureServiceFeature)this, statInfo.getRoutePropertyName());
                st.setOtherLinesFrom(this.metaClass.getTableName());
                st.setOtherLinesQuery(this.metaClass.getTableName() + "." + statField + " = ");
                st.setCidsBean(bean);
                st.addPropertyChangeListener(this.propListener);
                this.stations.put(col, st);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while retrieving meta object", (Throwable)e);
        }
    }

    public void removeStations() {
        if (this.stations != null) {
            for (String key : this.stations.keySet()) {
                DisposableCidsBeanStore editor = this.stations.get(key);
                if (editor instanceof TableLinearReferencedLineEditor) {
                    ((TableLinearReferencedLineEditor)editor).removePropertyChangeListener(this.propListener);
                }
                if (this.stations.get(key) == null) continue;
                this.stations.get(key).dispose();
            }
            this.stations.clear();
        }
    }

    public Object getPropertyObject(String propertyName) {
        if (this.layerInfo.isCatalogue(propertyName) && this.getCatalogueCombo(propertyName) != null) {
            Object result;
            int attempts = 0;
            do {
                ++attempts;
                result = this.getCatalogueCombo(propertyName).getSelectedItem();
                if (!(result instanceof CidsLayerFeature)) continue;
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException ex) {
                    LOG.warn((Object)"InterruptedException while waiting", (Throwable)ex);
                }
            } while (!(result instanceof CidsLayerFeature) && attempts < 20);
            return result;
        }
        return this.getProperty(propertyName);
    }

    public void addProperty(String propertyName, Object property, Object serverObject) {
        super.addProperty(propertyName, property);
    }

    public void setProperty(String propertyName, Object propertyValue) {
        TableStationEditor se;
        Object oldValue = this.getProperty(propertyName);
        super.setProperty(propertyName, propertyValue);
        if (this.stations != null && this.layerInfo.isStation(propertyName) && this.stations.get(propertyName) != null && propertyValue instanceof Double && (se = (TableStationEditor)this.stations.get(propertyName)) != null) {
            se.setPointValue((Double)propertyValue);
        }
        if (this.layerInfo != null && this.layerInfo.getGeoField() != null) {
            this.firePropertyChange(propertyName, oldValue, propertyValue);
        }
        if (this.isEditable()) {
            this.modified = true;
        }
    }

    private boolean hasStations() {
        AttributeTableRuleSet ruleSet = this.getLayerProperties().getAttributeTableRuleSet();
        for (String col : this.layerInfo.getColumnNames()) {
            if (!this.layerInfo.isStation(col) || ruleSet != null && !ruleSet.isColumnEditable(col)) continue;
            return true;
        }
        return false;
    }

    private boolean hasCatalogues() {
        for (String col : this.layerInfo.getColumnNames()) {
            if (!this.layerInfo.isCatalogue(col)) continue;
            return true;
        }
        return false;
    }

    public FeatureServiceFeature saveChanges() throws Exception {
        this.saveChangesWithoutReload();
        FeatureServiceFeature feature = this.reloadFeature();
        if (feature != null) {
            return feature;
        }
        return this;
    }

    public void saveChangesWithoutReload() throws Exception {
        HashMap propertyMap = super.getProperties();
        CidsBean bean = this.getMetaObject().getBean();
        String[] cols = this.layerInfo.getColumnNames();
        String[] props = this.layerInfo.getColumnPropertyNames();
        HashMap<String, String> colMap = new HashMap<String, String>();
        boolean hasAdditionalFields = this.hasAdditionalProperties();
        AttributeTableRuleSet ruleSet = this.getLayerProperties().getAttributeTableRuleSet();
        for (int i = 0; i < cols.length; ++i) {
            colMap.put(cols[i], props[i]);
        }
        if (this.stations != null) {
            for (String key : this.stations.keySet()) {
                DisposableCidsBeanStore editor = this.stations.get(key);
                if (!(editor instanceof TableLinearReferencedLineEditor)) continue;
                ((TableLinearReferencedLineEditor)editor).recreateGeometry();
            }
        }
        for (String key : propertyMap.keySet()) {
            if (hasAdditionalFields && ruleSet.getIndexOfAdditionalFieldName(key) != Integer.MIN_VALUE || key.equalsIgnoreCase("id")) continue;
            if (this.layerInfo.isPrimitive(key)) {
                bean.setProperty((String)colMap.get(key), propertyMap.get(key));
                continue;
            }
            if (this.layerInfo.getGeoField() != null && this.layerInfo.getGeoField().equals(key) && colMap.get(key) != null) {
                GeometryFactory gf;
                Geometry geom;
                String colName = (String)colMap.get(key);
                if (((String)colMap.get(key)).contains(".") && bean.getMetaObject().getAttributeByFieldName(((String)colMap.get(key)).substring(0, ((String)colMap.get(key)).indexOf("."))).getMai().getForeignKeyClassId() == this.layerInfo.getReferencedCidsClass(key)) {
                    if (this.layerInfo.isReferenceToCidsClass(key) && bean.getProperty(key) == null) {
                        CidsBean newGeoObject = this.getMetaClass(this.layerInfo.getReferencedCidsClass(key)).getEmptyInstance(this.getConnectionContext()).getBean();
                        bean.setProperty(colName.substring(0, colName.indexOf(".")), (Object)newGeoObject);
                    }
                    if (!((geom = this.getGeometry()) instanceof Serializable)) {
                        gf = new GeometryFactory(geom.getFactory().getPrecisionModel(), geom.getFactory().getSRID());
                        geom = gf.createGeometry(geom);
                    }
                    if (geom != null) {
                        geom = CrsTransformer.transformToDefaultCrs((Geometry)geom);
                        geom.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
                    }
                    bean.setProperty((String)colMap.get(key), (Object)geom);
                    continue;
                }
                geom = this.getGeometry();
                if (!(geom instanceof Serializable)) {
                    gf = new GeometryFactory(geom.getFactory().getPrecisionModel(), geom.getFactory().getSRID());
                    geom = gf.createGeometry(geom);
                }
                if (geom != null) {
                    geom = CrsTransformer.transformToDefaultCrs((Geometry)geom);
                    geom.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
                }
                bean.setProperty((String)colMap.get(key), (Object)geom);
                continue;
            }
            if (this.layerInfo.isCatalogue(key)) {
                if (this.getCatalogueCombo(key) != null) {
                    if (this.getCatalogueCombo(key).getSelectedItem() instanceof CidsLayerFeature) {
                        bean.setProperty((String)colMap.get(key), (Object)((CidsLayerFeature)((Object)this.getCatalogueCombo(key).getSelectedItem())).getMetaObject().getBean());
                        continue;
                    }
                    bean.setProperty((String)colMap.get(key), this.getCatalogueCombo(key).getSelectedItem());
                    continue;
                }
                bean.setProperty((String)colMap.get(key), propertyMap.get(key));
                continue;
            }
            if (this.layerInfo.isStation(key)) {
                DisposableCidsBeanStore store;
                StationInfo info = this.layerInfo.getStationInfo(key);
                if (info.isStationLine()) {
                    if (this.stations != null) {
                        store = this.stations.get(String.valueOf(info.getLineId()));
                        if (store != null) {
                            bean.setProperty(((String)colMap.get(key)).substring(0, ((String)colMap.get(key)).indexOf(".")), (Object)store.getCidsBean());
                            if (!this.undoOnServer || this.getProperty(key) == null) continue;
                            bean.setProperty((String)colMap.get(key), this.getProperty(key));
                            continue;
                        }
                        bean.setProperty(((String)colMap.get(key)).substring(0, ((String)colMap.get(key)).indexOf(".")), null);
                        continue;
                    }
                    if (this.getProperty(key) == null) continue;
                    bean.setProperty(((String)colMap.get(key)).substring(0, ((String)colMap.get(key)).indexOf(".")), this.getProperty(key));
                    continue;
                }
                if (this.stations != null && this.stations.get(key) != null) {
                    store = this.stations.get(key);
                    bean.setProperty(((String)colMap.get(key)).substring(0, ((String)colMap.get(key)).indexOf(".")), (Object)store.getCidsBean());
                    continue;
                }
                bean.setProperty(((String)colMap.get(key)).substring(0, ((String)colMap.get(key)).indexOf(".")), this.getProperty(key));
                continue;
            }
            String propKey = (String)colMap.get(key);
            if (propKey == null) {
                propKey = key;
            }
            if (propKey.contains(".")) continue;
            bean.setProperty(propKey, propertyMap.get(key));
        }
        CidsBean newBean = bean.persist(this.getConnectionContext());
        if (newBean != null) {
            this.setId(newBean.getMetaObject().getID());
            this.setProperty("id", newBean.getMetaObject().getID());
        } else {
            this.setId(bean.getMetaObject().getID());
            this.setProperty("id", bean.getMetaObject().getID());
        }
        this.metaObject = null;
        if (this.doNotChangeBackup) {
            this.undoOnServer = true;
        }
        this.fillBackupObjects();
    }

    private void fillBackupObjects() {
        if (!this.doNotChangeBackup) {
            this.backupGeometry = null;
            this.backupProperties = null;
            if (this.getGeometry() != null) {
                this.backupGeometry = (Geometry)this.getGeometry().clone();
            }
            this.backupProperties = (HashMap)super.getProperties().clone();
        }
    }

    private FeatureServiceFeature reloadFeature() {
        try {
            String idField = "id";
            String[] colNames = this.layerInfo.getColumnNames();
            for (int i = 0; i < colNames.length; ++i) {
                if (!colNames[i].equalsIgnoreCase("id")) continue;
                idField = this.layerInfo.getSqlColumnNames()[i];
                break;
            }
            String query = idField + " = " + this.getId();
            List features = this.getLayerProperties().getFeatureService().getFeatureFactory().createFeatures((Object)query, null, null, 0, 1, null);
            if (features.size() == 1) {
                this.setProperties(((FeatureServiceFeature)features.get(0)).getProperties());
                return (FeatureServiceFeature)features.get(0);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while reloading feature from server", (Throwable)e);
        }
        return null;
    }

    private FeatureServiceFeature retrieveFeature(int id, MetaClass mc) {
        try {
            String idField = "id";
            CidsLayer service = new CidsLayer(mc);
            String query = service.decoratePropertyName("id") + " = " + id;
            service.initAndWait();
            List features = service.getFeatureFactory().createFeatures((Object)query, null, null, 0, 1, null);
            if (features.size() == 1) {
                return (FeatureServiceFeature)features.get(0);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while reloading feature from server", (Throwable)e);
        }
        return null;
    }

    public void delete() throws Exception {
        CidsBean bean = this.getMetaObject().getBean();
        bean.delete();
        bean.persist(this.getConnectionContext());
    }

    public void restore() throws Exception {
        CidsBean bean = this.getMetaObject().getBean();
        bean.getMetaObject().setStatus(1);
        bean.persist(this.getConnectionContext());
        this.metaObject = null;
    }

    public boolean hasWritePermissions() {
        User usr = SessionManager.getSession().getUser();
        boolean groupPermission = false;
        PermissionHolder ph = this.metaClass.getPermissions();
        if (ph != null) {
            groupPermission = ph.hasWritePermission(usr);
        }
        if (groupPermission) {
            Class cl = ClassloadingHelper.getDynamicClass((MetaClass)this.metaClass, (ClassloadingHelper.CLASS_TYPE)ClassloadingHelper.CLASS_TYPE.PERMISSION_PROVIDER);
            if (cl != null) {
                try {
                    Object o = cl.newInstance();
                    if (o instanceof CidsLayerPermissionProvider) {
                        CidsLayerPermissionProvider permissionProvider = (CidsLayerPermissionProvider)o;
                        return permissionProvider.getCustomCidsLayerWritePermissionDecisionforUser(usr, this);
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error while checking write permission", (Throwable)ex);
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean hasReadPermissions() {
        return true;
    }

    private MetaObject getMetaObject() throws ConnectionException {
        if (this.metaObject == null) {
            if (this.getId() < 0) {
                this.metaObject = this.metaClass.getEmptyInstance(this.getConnectionContext());
                this.copyFeaturePropertiesToMetaObject();
            } else {
                this.metaObject = SessionManager.getConnection().getMetaObject(SessionManager.getSession().getUser(), this.getId(), this.metaClass.getID(), SessionManager.getSession().getUser().getDomain(), this.getConnectionContext());
                if (this.metaObject == null) {
                    this.metaObject = this.metaClass.getEmptyInstance(this.getConnectionContext());
                }
            }
        }
        return this.metaObject;
    }

    private void copyFeaturePropertiesToMetaObject() {
        CidsBean bean = this.metaObject.getBean();
        HashMap<Integer, CidsBean> stationLines = new HashMap<Integer, CidsBean>();
        try {
            for (int i = 0; i < this.layerInfo.getColumnNames().length; ++i) {
                String colName = this.layerInfo.getColumnNames()[i];
                if (this.layerInfo.isCatalogue(colName)) {
                    MemberAttributeInfo attr;
                    Object propValue = this.getProperty(colName);
                    if (propValue == null || (attr = this.getMemberAttribute(colName)) == null) continue;
                    int foereignKeyClass = attr.getForeignKeyClassId();
                    CidsBean catval = this.getCatalogueElement(this.metaClass.getDomain(), foereignKeyClass, String.valueOf(propValue));
                    bean.setProperty(colName, (Object)catval);
                    continue;
                }
                if (this.layerInfo.isStation(colName)) {
                    StationInfo info = this.layerInfo.getStationInfo(colName);
                    Object valueObject = this.getProperty(colName);
                    if (!(valueObject instanceof Double)) continue;
                    Double value = (Double)valueObject;
                    Object routeNameObject = this.getProperty(info.getRoutePropertyName());
                    if (value == null || routeNameObject == null) continue;
                    if (info.isStationLine()) {
                        CidsBean firstStation = (CidsBean)stationLines.get(info.getLineId());
                        if (firstStation != null) {
                            LinearReferencingHelper helper = FeatureRegistry.getInstance().getLinearReferencingSolver();
                            CidsBean secondStation = this.createStationBean(info, value);
                            CidsBean line = null;
                            line = info.isFromStation() ? helper.createLineBeanFromStationBean(secondStation, firstStation) : helper.createLineBeanFromStationBean(firstStation, secondStation);
                            String lineColName = this.layerInfo.getColumnPropertyNames()[i];
                            lineColName = lineColName.substring(0, lineColName.indexOf("."));
                            bean.setProperty(lineColName, (Object)line);
                            continue;
                        }
                        firstStation = this.createStationBean(info, value);
                        stationLines.put(info.getLineId(), firstStation);
                        continue;
                    }
                    String lineColName = this.layerInfo.getColumnPropertyNames()[i];
                    lineColName = lineColName.substring(0, lineColName.indexOf("."));
                    bean.setProperty(lineColName, (Object)this.createStationBean(info, value));
                    continue;
                }
                if (!this.layerInfo.isPrimitive(colName)) continue;
                bean.setProperty(colName, this.getProperty(colName));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while setting bean properties", (Throwable)e);
        }
    }

    private CidsBean createStationBean(StationInfo info, Double value) {
        String routeClass = info.getRouteTable();
        Object routeNameObject = this.getProperty(info.getRoutePropertyName());
        LinearReferencingHelper helper = FeatureRegistry.getInstance().getLinearReferencingSolver();
        String domain = helper.getDomainOfRouteTable(routeClass)[0];
        String routeNameProperty = helper.getRouteNamePropertyFromRouteByClassName(routeClass);
        CidsBean routeBean = null;
        routeBean = this.getRouteBean(domain, routeClass, routeNameProperty, routeNameObject);
        return helper.createStationBeanFromRouteBean(routeBean, value);
    }

    private MemberAttributeInfo getMemberAttribute(String attrName) {
        HashMap attrMap = this.metaClass.getMemberAttributeInfos();
        for (Object key : attrMap.keySet()) {
            MemberAttributeInfo attr;
            Object attrInfoObject = attrMap.get(key);
            if (!(attrInfoObject instanceof MemberAttributeInfo) || !(attr = (MemberAttributeInfo)attrInfoObject).getName().equals(attrName)) continue;
            return attr;
        }
        return null;
    }

    private CidsBean getCatalogueElement(String domain, int classId, String value) {
        MetaClass mc = ClassCacheMultiple.getMetaClass((String)domain, (int)classId, (ConnectionContext)this.getConnectionContext());
        String query = "select " + mc.getID() + ", " + mc.getPrimaryKey() + " from " + mc.getTableName();
        try {
            MetaObject[] mos = MetaObjectCache.getInstance().getMetaObjectsByQuery(query, mc.getDomain(), false, this.getConnectionContext());
            if (mos != null && mos.length > 0) {
                for (MetaObject object : mos) {
                    if (!object.getBean().toString().equals(value)) continue;
                    return object.getBean();
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot load catalogue data", (Throwable)e);
        }
        return null;
    }

    private CidsBean getRouteBean(String domain, String routeTable, String routeNameProperty, Object routeName) {
        MetaClass mc = ClassCacheMultiple.getMetaClass((String)domain, (String)routeTable, (ConnectionContext)this.getConnectionContext());
        String route = routeName instanceof String ? "'" + routeName + "'" : String.valueOf(routeName);
        String query = "select " + mc.getID() + ", " + mc.getPrimaryKey() + " from " + mc.getTableName();
        query = query + " where " + routeNameProperty + "=" + route;
        try {
            MetaObject[] mos = SessionManager.getConnection().getMetaObjectByQuery(SessionManager.getSession().getUser(), query, this.getConnectionContext());
            if (mos != null && mos.length > 0) {
                return mos[0].getBean();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot load catalogue data", (Throwable)e);
        }
        return null;
    }

    public void undoAll() {
        PFeature feature;
        if (this.backupProperties != null) {
            super.setProperties((HashMap)this.backupProperties.clone());
        }
        if (this.backupGeometry != null) {
            this.setGeometry((Geometry)this.backupGeometry.clone());
        }
        if ((feature = (PFeature)CismapBroker.getInstance().getMappingComponent().getPFeatureHM().get((Object)this)) != null) {
            feature.visualize();
        }
        if (this.stations != null) {
            for (String key : this.stations.keySet()) {
                DisposableCidsBeanStore editor = this.stations.get(key);
                if (editor instanceof TableLinearReferencedLineEditor) {
                    ((TableLinearReferencedLineEditor)editor).undoChanges();
                    continue;
                }
                if (!(editor instanceof TableStationEditor)) continue;
                ((TableStationEditor)editor).undoChanges();
            }
        }
        if (this.undoOnServer) {
            try {
                this.saveChangesWithoutReload();
                this.undoOnServer = false;
            }
            catch (Exception e) {
                LOG.error((Object)"Cannot undo changes on server", (Throwable)e);
            }
        }
    }

    public void setGeometry(Geometry geom) {
        if (this.oldGeom == null != (geom == null) || this.oldGeom != null && geom != null && (!this.oldGeom.getEnvelope().equalsExact(geom.getEnvelope()) || !this.oldGeom.equalsExact(geom))) {
            super.setGeometry(geom);
            if (this.layerInfo != null) {
                super.addProperty(this.layerInfo.getGeoField(), (Object)geom);
            }
            Geometry oldGeomTmp = this.oldGeom;
            Geometry geometry = this.oldGeom = geom == null ? null : (Geometry)geom.clone();
            if (this.layerInfo != null && this.layerInfo.getGeoField() != null) {
                this.firePropertyChange(this.layerInfo.getGeoField(), oldGeomTmp, geom);
            }
            if (this.isEditable()) {
                this.modified = true;
            }
        } else {
            this.oldGeom = geom == null ? null : (Geometry)geom.clone();
        }
    }

    public CidsLayerInfo getLayerInfo() {
        return this.layerInfo;
    }

    public TableStationEditor getStationEditor(String columnName) {
        if (this.stations == null) {
            return null;
        }
        DisposableCidsBeanStore store = this.stations.get(columnName);
        if (store instanceof TableStationEditor) {
            return (TableStationEditor)store;
        }
        return null;
    }

    public TableLinearReferencedLineEditor getLineEditorEditor(int lineId) {
        if (this.stations == null) {
            return null;
        }
        DisposableCidsBeanStore store = this.stations.get(String.valueOf(lineId));
        if (store instanceof TableLinearReferencedLineEditor) {
            return (TableLinearReferencedLineEditor)store;
        }
        return null;
    }

    public DefaultCidsLayerBindableReferenceCombo getCatalogueCombo(String columnName) {
        if (this.combos == null) {
            return null;
        }
        DefaultCidsLayerBindableReferenceCombo c = this.combos.get(columnName);
        return c;
    }

    public FeatureServiceFeature getInitialCalatogueValue(String columnName) {
        if (this.initCatalogueValue == null) {
            return null;
        }
        return this.initCatalogueValue.get(columnName);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CidsLayerFeature) {
            CidsLayerFeature other = (CidsLayerFeature)((Object)obj);
            if (this.getId() != -1 || other.getId() != -1) {
                return this.metaClass.getTableName().equals(other.metaClass.getTableName()) && this.getId() == other.getId();
            }
            return obj == other;
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        if (this.useIdInHash && this.getId() >= 0) {
            hash = 83 * hash + this.getId();
        }
        hash = 83 * hash + (this.metaClass != null && this.metaClass.getTableName() != null ? this.metaClass.getTableName().hashCode() : 0);
        return hash;
    }

    private MetaClass getMetaClass(int classId) throws ConnectionException {
        return ClassCacheMultiple.getMetaClass((String)this.metaClass.getDomain(), (int)classId, (ConnectionContext)this.getConnectionContext());
    }

    public boolean isFeatureChanged() {
        Geometry geom;
        if (this.backupGeometry == null != ((geom = this.getGeometry()) == null) || this.backupGeometry != null && geom != null && !this.backupGeometry.equalsExact(geom)) {
            return true;
        }
        if (!this.modified) {
            return false;
        }
        if (this.backupProperties != null && this.getProperties() != null) {
            HashMap props = this.getProperties();
            for (Object key : props.keySet()) {
                Object current = props.get(key);
                Object backup = this.backupProperties.get(key);
                if (!(current == null && backup != null || current != null && backup == null) && (current == null || backup == null || current.equals(backup))) continue;
                return true;
            }
            return false;
        }
        return this.modified;
    }

    public String toString() {
        ToStringConverter converter = this.metaClass.getToStringConverter();
        if (converter instanceof CidsLayerFeatureToStringConverter) {
            CidsLayerFeatureToStringConverter featureConverter = (CidsLayerFeatureToStringConverter)converter;
            return featureConverter.featureToString((Object)this);
        }
        return super.toString();
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    protected class CidSLayerDeegreeFeature
    extends DefaultFeatureServiceFeature.DeegreeFeature {
        protected CidSLayerDeegreeFeature() {
            super((DefaultFeatureServiceFeature)CidsLayerFeature.this);
        }

        public FeatureType getType() {
            return new DefaultFeatureServiceFeature.DeegreeFeatureType(){

                public QName getName() {
                    return new QName(CidsLayerFeature.this.metaClass.getTableName());
                }
            };
        }
    }

    private static class PImageWithDisplacement
    extends PImage
    implements PSticky {
        double displacementX;
        double displacementY;
        private SLDStyledFeature.UOM uom = SLDStyledFeature.UOM.metre;
        private double anchorPointX;
        private double anchorPointY;
        private WorldToScreenTransform wtst;
        private double scaledDisplacementX;
        private double scaledDisplacementY;
        private double oldScaledDisplacementX;
        private double oldScaledDisplacementY;
        private PCamera camera;

        public void setUOM(SLDStyledFeature.UOM uom) {
            this.uom = uom;
        }

        public void setDisplacement(SLDStyledFeature.UOM uomFromDeegree, double displacementX, double displacementY, double anchorPointX, double anchorPointY, WorldToScreenTransform wtst, PCamera camera) {
            this.uom = uomFromDeegree;
            this.displacementX = displacementX;
            this.displacementY = displacementY;
            this.anchorPointX = anchorPointX;
            this.anchorPointY = anchorPointY;
            this.wtst = wtst;
            this.camera = camera;
        }

        public void setScale(double scale) {
            if (this.uom != SLDStyledFeature.UOM.pixel) {
                super.setScale(scale);
            } else {
                super.setScale(scale);
                this.oldScaledDisplacementX = this.scaledDisplacementX;
                this.oldScaledDisplacementY = this.scaledDisplacementY;
                this.scaledDisplacementX = this.displacementX * scale;
                this.offset(this.scaledDisplacementX - this.oldScaledDisplacementX, this.scaledDisplacementY - this.oldScaledDisplacementY);
            }
        }

        public int compareTo(Object o) {
            return this.toString().compareTo(o.toString());
        }
    }
}

