/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.cidslayer;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.gui.attributetable.FeatureLockingInterface;
import de.cismet.cismap.commons.gui.attributetable.LockAlreadyExistsException;
import de.cismet.cismap.commons.gui.attributetable.LockFromSameUserAlreadyExistsException;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class CidsLayerLocker
implements FeatureLockingInterface,
ConnectionContextProvider {
    public static final String CS_LOCKS_TN = "lock";
    public static final String CS_LOCK_GROUP_TN = "lock_group";
    private static final Logger LOG = Logger.getLogger(CidsLayerLocker.class);
    private static final String LOCK_QUERY = "SELECT DISTINCT %1$s, g.%2$s  FROM %3$s g join lock_lock_group lg on (g.objects = lg.lock_group_reference) join  lock l on (lg.lock = l.id) WHERE l.class_id = %4$s and l.object_id = any(ARRAY[%5$s]) limit 1;";
    private final Map<String, MetaClass> LOCK_MC_MAP = new HashMap<String, MetaClass>();
    private final Map<String, MetaClass> LOCK_GROUP_MC_MAP = new HashMap<String, MetaClass>();
    private final ConnectionContext connectionContext = ConnectionContext.createDummy();

    public Object lock(Feature feature, boolean multiLockForSameUserAllowed) throws LockAlreadyExistsException, Exception {
        if (feature instanceof CidsLayerFeature) {
            List<Feature> l = Collections.nCopies(1, feature);
            return this.lock(l, multiLockForSameUserAllowed);
        }
        throw new IllegalArgumentException("Only CidsLayerFeature are supported");
    }

    public Object lock(List<Feature> features, boolean multiLockForSameUserAllowed) throws LockAlreadyExistsException, Exception {
        try {
            if (features == null || features.isEmpty()) {
                return new FakeLock();
            }
            MetaObject mo = ((CidsLayerFeature)features.get(0)).getBean().getMetaObject();
            MetaClass lockGroupMc = this.getLockGroupMetaClassForBean(mo.getDomain());
            MetaClass lockMc = this.getLockMetaClassForBean(mo.getDomain());
            String userString = NbBundle.getMessage(CidsLayerLocker.class, (String)"CidsLayerLocker.lock(CidsBean).userString", (Object)SessionManager.getSession().getUser().getName());
            boolean hasNotNewObject = false;
            for (Feature f : features) {
                if (((CidsLayerFeature)f).getId() <= 0) continue;
                hasNotNewObject = true;
            }
            if (!hasNotNewObject) {
                return new FakeLock();
            }
            String query = String.format(LOCK_QUERY, lockGroupMc.getID(), lockGroupMc.getPrimaryKey(), lockGroupMc.getTableName(), mo.getMetaClass().getID(), this.getIds(features));
            MetaObject[] mos = SessionManager.getProxy().getMetaObjectByQuery(query, 0, this.getConnectionContext());
            if (mos != null && mos.length > 0) {
                for (MetaObject metaObject : mos) {
                    if (metaObject.getBean().getProperty("user_string") == null || metaObject.getBean().getProperty("user_string").equals(userString)) {
                        if (multiLockForSameUserAllowed) continue;
                        LockFromSameUserAlreadyExistsException ex = new LockFromSameUserAlreadyExistsException("The lock does already exists", String.valueOf(mos[0].getBean().getProperty("user_string")));
                        throw ex;
                    }
                    LockAlreadyExistsException ex = new LockAlreadyExistsException("The lock does already exists", String.valueOf(mos[0].getBean().getProperty("user_string")));
                    throw ex;
                }
            }
            CidsBean lockGroupBean = lockGroupMc.getEmptyInstance(this.getConnectionContext()).getBean();
            ArrayList<CidsBean> list = new ArrayList<CidsBean>(features.size());
            Integer classId = mo.getMetaClass().getID();
            for (Feature f : features) {
                CidsBean lockBean = lockMc.getEmptyInstance(this.getConnectionContext()).getBean();
                lockBean.setProperty("class_id", (Object)classId);
                lockBean.setProperty("object_id", (Object)((CidsLayerFeature)f).getId());
                list.add(lockBean);
            }
            lockGroupBean.addCollectionElements("objects", list);
            try {
                InetAddress addr = InetAddress.getLocalHost();
                lockGroupBean.setProperty("additional_info", (Object)addr.getHostName());
            }
            catch (UnknownHostException e) {
                LOG.error((Object)"cnnot determine the computer name", (Throwable)e);
            }
            lockGroupBean.setProperty("user_string", (Object)userString);
            lockGroupBean = lockGroupBean.persist(this.getConnectionContext());
            return lockGroupBean;
        }
        catch (LockAlreadyExistsException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)"Error while creating lock object", (Throwable)e);
            throw new Exception("Cannot lock object");
        }
    }

    public Object lock(AbstractFeatureService service, boolean multiLockForSameUserAllowed) throws LockAlreadyExistsException, Exception {
        throw new IllegalArgumentException("Only CidsLayerFeature are supported");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unlock(Object lockObject) throws Exception {
        if (lockObject instanceof FakeLock) {
            return;
        }
        if (lockObject instanceof CidsBean) {
            CidsBean bean = (CidsBean)lockObject;
            MetaClass lockMc = this.getLockGroupMetaClassForBean(bean.getMetaObject().getMetaClass().getDomain());
            if (!bean.getMetaObject().getMetaClass().equals((Object)lockMc)) throw new IllegalArgumentException("The locking object must be of the type " + lockMc.toString());
            this.unlock(bean);
            return;
        } else {
            if (!(lockObject instanceof List)) throw new IllegalArgumentException("The locking object must be a cids bean");
            for (Object o : (List)lockObject) {
                this.unlock(o);
            }
        }
    }

    public void unlock(CidsBean bean) throws Exception {
        try {
            if (bean instanceof FakeLock) {
                return;
            }
            bean.delete();
            bean.persist(this.getConnectionContext());
        }
        catch (Exception e) {
            LOG.error((Object)("Cannot remove lock with id " + bean.getProperty("id")));
            throw e;
        }
    }

    public Class[] getSupportedFeatureServiceClasses() {
        return new Class[]{CidsLayer.class};
    }

    protected MetaClass getLockMetaClassForBean(String domain) throws Exception {
        MetaClass lockMc = this.LOCK_MC_MAP.get(domain);
        if (lockMc == null) {
            lockMc = ClassCacheMultiple.getMetaClass((String)domain, (String)CS_LOCKS_TN, (ConnectionContext)this.getConnectionContext());
            if (lockMc == null) {
                throw new Exception("The cids class lock does not exist in the domain " + domain);
            }
            this.LOCK_MC_MAP.put(domain, lockMc);
        }
        return lockMc;
    }

    protected MetaClass getLockGroupMetaClassForBean(String domain) throws Exception {
        MetaClass lockMc = this.LOCK_GROUP_MC_MAP.get(domain);
        if (lockMc == null) {
            lockMc = ClassCacheMultiple.getMetaClass((String)domain, (String)CS_LOCK_GROUP_TN, (ConnectionContext)this.getConnectionContext());
            if (lockMc == null) {
                throw new Exception("The cids class lock_group does not exist in the domain " + domain);
            }
            this.LOCK_GROUP_MC_MAP.put(domain, lockMc);
        }
        return lockMc;
    }

    private String getIds(List<Feature> features) {
        StringBuilder sb = null;
        for (Feature f : features) {
            if (sb == null) {
                sb = new StringBuilder();
            } else {
                sb.append(",");
            }
            sb.append(((CidsLayerFeature)f).getId());
        }
        return sb == null ? "" : sb.toString();
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private class FakeLock
    extends CidsBean {
        private FakeLock() {
        }
    }
}

