/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.cidslayer;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.middleware.types.MetaClass;
import de.cismet.cismap.cidslayer.CidsLayerConfig;
import de.cismet.cismap.commons.gui.capabilitywidget.StringFilter;
import de.cismet.cismap.commons.gui.capabilitywidget.TreeFolder;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class CidsLayerTreeModel
implements TreeModel,
StringFilter,
ConnectionContextProvider {
    private Logger LOG = Logger.getLogger(CidsLayerTreeModel.class);
    private String domain;
    private String title;
    private List<Object> classes = new ArrayList<Object>();
    private String filterString;
    private final ConnectionContext connectionContext = ConnectionContext.createDummy();

    public CidsLayerTreeModel(String domain, String title) {
        this.domain = domain;
        this.title = title;
        try {
            MetaClass[] mc;
            for (MetaClass clazz : mc = SessionManager.getProxy().getClasses(domain, this.getConnectionContext())) {
                Collection attributes = clazz.getAttributeByName("cidsLayer");
                Collection hidden = clazz.getAttributeByName("hidden");
                if (attributes == null || attributes.isEmpty() || hidden != null && !hidden.isEmpty() && hidden.toArray()[0].toString().equals("true")) continue;
                Collection folderAttributes = clazz.getAttributeByName("cidsLayerFolder");
                ArrayList<String> folderNames = new ArrayList<String>();
                if (folderAttributes != null && !folderAttributes.isEmpty()) {
                    String[] st;
                    String name = folderAttributes.toArray()[0].toString();
                    for (String tmp : st = name.split("->")) {
                        folderNames.add(tmp);
                    }
                }
                if (!folderNames.isEmpty()) {
                    TreeFolder currentFolder = this.classes;
                    for (String folderObject : folderNames) {
                        String folder = folderObject;
                        TreeFolder tf = new TreeFolder(folder);
                        int index = currentFolder.indexOf(tf);
                        if (index == -1) {
                            currentFolder.add((Object)tf);
                        } else {
                            tf = (TreeFolder)currentFolder.get(index);
                        }
                        currentFolder = tf;
                    }
                    if (currentFolder == null) continue;
                    currentFolder.add((Object)new CidsLayerConfig(clazz));
                    continue;
                }
                this.classes.add(new CidsLayerConfig(clazz));
            }
        }
        catch (ConnectionException ex) {
            this.LOG.error((Object)"Error while creating cids layer tree", (Throwable)ex);
        }
        this.sortList(this.classes);
        this.removeSortExpression(this.classes);
    }

    private void sortList(List listToSort) {
        Collections.sort(listToSort, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (!(o1 instanceof CidsLayerConfig) && !(o2 instanceof CidsLayerConfig)) {
                    return o1.toString().compareTo(o2.toString());
                }
                if (!(o1 instanceof CidsLayerConfig)) {
                    return -1;
                }
                if (!(o2 instanceof CidsLayerConfig)) {
                    return 1;
                }
                return ((CidsLayerConfig)o1).compareTo((CidsLayerConfig)o2);
            }
        });
        for (Object o : listToSort) {
            if (!(o instanceof List)) continue;
            this.sortList((List)o);
        }
    }

    private void removeSortExpression(List listToSort) {
        for (Object o : listToSort) {
            if (!(o instanceof List)) continue;
            TreeFolder tf = (TreeFolder)o;
            String newName = tf.getName();
            newName = newName.replaceAll("sort:[0123456789]* ", "");
            tf.setName(newName);
            this.removeSortExpression((List)o);
        }
    }

    @Override
    public Object getRoot() {
        return this.title;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent != null && parent.equals(this.title)) {
            return this.filteredChildren(this.classes).get(index);
        }
        if (parent instanceof TreeFolder) {
            return this.filteredChildren((List<Object>)((TreeFolder)parent)).get(index);
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent != null && parent.equals(this.title)) {
            return this.filteredChildren(this.classes).size();
        }
        if (parent instanceof TreeFolder) {
            return this.filteredChildren((List<Object>)((TreeFolder)parent)).size();
        }
        return 0;
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return 0;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString;
    }

    private List<Object> filteredChildren(List<Object> objectList) {
        ArrayList<Object> entries = new ArrayList<Object>();
        for (Object entry : objectList) {
            if (!this.fulfilFilterRequirements(entry)) continue;
            entries.add(entry);
        }
        return entries;
    }

    private boolean fulfilFilterRequirements(Object entry) {
        if (entry instanceof TreeFolder) {
            if (this.filterString == null || ((TreeFolder)entry).getName().toLowerCase().contains(this.filterString.toLowerCase())) {
                return true;
            }
            for (Object o : (TreeFolder)entry) {
                if (!this.fulfilFilterRequirements(o)) continue;
                return true;
            }
        } else {
            return this.filterString == null || ((CidsLayerConfig)entry).getTitle().toLowerCase().contains(this.filterString.toLowerCase());
        }
        return false;
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

