/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.cidslayer;

import Sirius.navigator.tools.MetaObjectChangeEvent;
import Sirius.navigator.tools.MetaObjectChangeListener;
import Sirius.navigator.tools.MetaObjectChangeSupport;
import Sirius.server.localserver.attribute.ClassAttribute;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaClassStore;
import de.cismet.cids.editors.Bindable;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerFeatureFilter;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.commons.ref.PurgingCache;
import de.cismet.tools.Calculator;
import de.cismet.tools.CismetThreadPool;
import java.awt.Component;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Validator;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class DefaultCidsLayerBindableReferenceCombo
extends JComboBox
implements Bindable,
MetaClassStore,
Serializable {
    private static final Logger LOG = Logger.getLogger(DefaultCidsLayerBindableReferenceCombo.class);
    protected static final Comparator<CidsLayerFeature> BEAN_TOSTRING_COMPARATOR = new FeatureToStringComparator();
    private static final PurgingCache<CatalogueDefinition, List<CidsLayerFeature>> cache = new PurgingCache((Calculator)new Calculator<CatalogueDefinition, List<CidsLayerFeature>>(){

        public List<CidsLayerFeature> calculate(CatalogueDefinition input) throws Exception {
            ClassAttribute ca = input.getMc().getClassAttribute("sortingColumn");
            CidsLayer layer = new CidsLayer(input.getMc());
            layer.initAndWait();
            Map attributeMap = layer.getFeatureServiceAttributes();
            List<Object> featureList = new ArrayList();
            FeatureServiceAttribute[] attrArray = null;
            String[] orderBy = null;
            if (input.getSortingColumn() == null) {
                if (ca != null) {
                    String value = ca.getValue().toString();
                    orderBy = value.split(",");
                }
            } else {
                orderBy = input.getSortingColumn().split(",");
            }
            if (orderBy != null && orderBy.length > 0) {
                ArrayList<FeatureServiceAttribute> attributeList = new ArrayList<FeatureServiceAttribute>();
                for (String attributeName : orderBy) {
                    FeatureServiceAttribute attr = (FeatureServiceAttribute)attributeMap.get(attributeName);
                    if (attr == null) continue;
                    attributeList.add(attr);
                }
                if (!attributeList.isEmpty()) {
                    attrArray = attributeList.toArray(new FeatureServiceAttribute[attributeList.size()]);
                }
            }
            try {
                featureList = layer.getFeatureFactory().createFeatures((Object)layer.getQuery(), null, null, 0, 0, attrArray);
            }
            catch (Exception ex) {
                LOG.warn((Object)"cache could not come up with appropriate objects", (Throwable)ex);
                throw ex;
            }
            if (input.isNullable()) {
                ArrayList<CidsLayerFeature> tmpList = new ArrayList<CidsLayerFeature>();
                tmpList.add(null);
                tmpList.addAll(featureList);
                featureList = tmpList;
            }
            return featureList;
        }
    }, 300000L, 3000000L);
    protected CidsLayerFeature cidsBean;
    private final transient MetaObjectChangeListener mocL;
    private MetaClass metaClass;
    private boolean fakeModel;
    private boolean nullable;
    private Comparator<CidsLayerFeature> comparator;
    private String nullValueRepresentation;
    private String sortingColumn;
    private CidsLayerFeatureFilter beanFilter;

    public DefaultCidsLayerBindableReferenceCombo() {
        this(null, false, BEAN_TOSTRING_COMPARATOR);
    }

    public DefaultCidsLayerBindableReferenceCombo(boolean nullable) {
        this(null, nullable, BEAN_TOSTRING_COMPARATOR);
    }

    public DefaultCidsLayerBindableReferenceCombo(Comparator<CidsLayerFeature> comparator) {
        this(null, false, comparator);
    }

    public DefaultCidsLayerBindableReferenceCombo(MetaClass mc) {
        this(mc, false, BEAN_TOSTRING_COMPARATOR);
    }

    public DefaultCidsLayerBindableReferenceCombo(MetaClass mc, String sortingcolumn) {
        this(mc, false, BEAN_TOSTRING_COMPARATOR, sortingcolumn);
    }

    public DefaultCidsLayerBindableReferenceCombo(MetaClass mc, boolean nullable) {
        this(mc, nullable, BEAN_TOSTRING_COMPARATOR);
    }

    public DefaultCidsLayerBindableReferenceCombo(MetaClass mc, boolean nullable, Comparator<CidsLayerFeature> comparator) {
        this(mc, nullable, BEAN_TOSTRING_COMPARATOR, null);
    }

    public DefaultCidsLayerBindableReferenceCombo(MetaClass mc, boolean nullable, Comparator<CidsLayerFeature> comparator, String sortingColumn) {
        String[] s = new String[]{NbBundle.getMessage(DefaultCidsLayerBindableReferenceCombo.class, (String)"DefaultCidsLayerBindableReferenceCombo.loading")};
        this.setModel((ComboBoxModel)new DefaultComboBoxModel<String>(s));
        this.nullable = nullable;
        this.comparator = comparator;
        this.nullValueRepresentation = " ";
        this.sortingColumn = sortingColumn;
        this.mocL = new MetaObjectChangeListenerImpl();
        this.metaClass = mc;
        this.setRenderer(new DefaultBindableReferenceComboRenderer());
        this.init(mc, false);
        MetaObjectChangeSupport mocSupport = MetaObjectChangeSupport.getDefault();
        mocSupport.addMetaObjectChangeListener((MetaObjectChangeListener)WeakListeners.create(MetaObjectChangeListener.class, (EventListener)this.mocL, (Object)mocSupport));
    }

    public void setSortingColumn(String sortingColumn) {
        this.sortingColumn = sortingColumn;
    }

    public String getSortingColumn() {
        return this.sortingColumn;
    }

    protected void init(final MetaClass mc, final boolean forceReload) {
        if (!this.isFakeModel() && mc != null) {
            CismetThreadPool.execute((Runnable)new SwingWorker<DefaultComboBoxModel, Void>(){

                @Override
                protected DefaultComboBoxModel doInBackground() throws Exception {
                    Thread.currentThread().setName("DefaultBindableReferenceCombo init()");
                    return DefaultCidsLayerBindableReferenceCombo.getModelByMetaClass(mc, DefaultCidsLayerBindableReferenceCombo.this.nullable, DefaultCidsLayerBindableReferenceCombo.this.comparator, forceReload, DefaultCidsLayerBindableReferenceCombo.this.sortingColumn);
                }

                @Override
                protected void done() {
                    try {
                        DefaultComboBoxModel tmp = (DefaultComboBoxModel)this.get();
                        tmp.setSelectedItem((Object)DefaultCidsLayerBindableReferenceCombo.this.cidsBean);
                        DefaultCidsLayerBindableReferenceCombo.this.setModel((ComboBoxModel)tmp);
                    }
                    catch (InterruptedException tmp) {
                    }
                    catch (ExecutionException executionException) {
                        LOG.error((Object)"Error while initializing the model of a referenceCombo", (Throwable)executionException);
                    }
                }
            });
        }
    }

    public void reload(boolean forceReload) {
        if (this.metaClass == null) {
            throw new IllegalStateException("the metaclass has not been set yet");
        }
        this.init(this.metaClass, forceReload);
    }

    public String getBindingProperty() {
        return "selectedItem";
    }

    public Validator getValidator() {
        return null;
    }

    public Converter getConverter() {
        return null;
    }

    @Override
    public void setSelectedItem(Object anObject) {
        if (this.isFakeModel()) {
            this.setModel((ComboBoxModel)new DefaultComboBoxModel<Object>(new Object[]{anObject}));
        }
        if (!(anObject instanceof CidsLayerFeature)) {
            anObject = null;
        }
        super.setSelectedItem(anObject);
        this.cidsBean = (CidsLayerFeature)((Object)anObject);
    }

    public MetaClass getMetaClass() {
        return this.metaClass;
    }

    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
        this.init(metaClass, false);
    }

    public boolean isFakeModel() {
        return this.fakeModel;
    }

    public void setFakeModel(boolean fakeModel) {
        this.fakeModel = fakeModel;
    }

    public String getNullValueRepresentation() {
        return this.nullValueRepresentation;
    }

    public void setNullValueRepresentation(String nullValueRepresentation) {
        this.nullValueRepresentation = nullValueRepresentation;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        if (this.nullable != nullable) {
            this.nullable = nullable;
            if (this.metaClass != null) {
                this.init(this.metaClass, false);
            }
        }
    }

    public Object getNullSourceValue() {
        return null;
    }

    public Object getErrorSourceValue() {
        return null;
    }

    protected Comparator<CidsLayerFeature> getComparator() {
        return this.comparator;
    }

    public static DefaultComboBoxModel getModelByMetaClass(MetaClass mc, boolean nullable, boolean onlyUsed, Comparator<CidsLayerFeature> comparator, boolean forceReload) {
        return DefaultCidsLayerBindableReferenceCombo.getModelByMetaClass(mc, nullable, comparator, forceReload, null);
    }

    public static DefaultComboBoxModel getModelByMetaClass(MetaClass mc, boolean nullable, Comparator<CidsLayerFeature> comparator, boolean forceReload, String sortingColumn) {
        if (mc != null) {
            ArrayList featureList;
            if (forceReload) {
                cache.clear();
            }
            if ((featureList = (ArrayList)cache.get((Object)new CatalogueDefinition(mc, nullable, sortingColumn))) != null) {
                featureList = new ArrayList(featureList);
            }
            if (sortingColumn == null && featureList != null && mc.getClassAttribute("sortingColumn") == null) {
                Collections.sort(featureList, comparator);
            }
            return new DefaultComboBoxModel<Object>(featureList.toArray());
        }
        return new DefaultComboBoxModel();
    }

    public static DefaultComboBoxModel getModelByMetaClass(MetaClass mc, boolean nullable, boolean onlyUsed, Comparator<CidsLayerFeature> comparator) throws Exception {
        return DefaultCidsLayerBindableReferenceCombo.getModelByMetaClass(mc, nullable, onlyUsed, comparator, false);
    }

    public static DefaultComboBoxModel getModelByMetaClass(MetaClass mc, boolean nullable, boolean onlyUsed) throws Exception {
        return DefaultCidsLayerBindableReferenceCombo.getModelByMetaClass(mc, nullable, onlyUsed, BEAN_TOSTRING_COMPARATOR, false);
    }

    public static DefaultComboBoxModel getModelByMetaClass(MetaClass mc, boolean nullable) throws Exception {
        return DefaultCidsLayerBindableReferenceCombo.getModelByMetaClass(mc, nullable, false, BEAN_TOSTRING_COMPARATOR, false);
    }

    public CidsLayerFeatureFilter getBeanFilter() {
        return this.beanFilter;
    }

    public synchronized void setBeanFilter(CidsLayerFeatureFilter beanFilter) {
        this.beanFilter = beanFilter;
        ComboBoxModel model = this.getModel();
        if (model != null) {
            this.setModel(model);
        }
    }

    public synchronized void setModel(ComboBoxModel aModel) {
        if (this.beanFilter == null) {
            super.setModel(aModel);
        } else {
            super.setModel(this.filterModel(aModel));
        }
    }

    private ComboBoxModel filterModel(ComboBoxModel aModel) {
        ArrayList<CidsLayerFeature> beanList = new ArrayList<CidsLayerFeature>();
        if (this.beanFilter == null) {
            return aModel;
        }
        for (int i = 0; i < aModel.getSize(); ++i) {
            CidsLayerFeature bean;
            if (!(aModel.getElementAt(i) instanceof CidsLayerFeature) && aModel.getElementAt(i) != null || !this.beanFilter.accept(bean = (CidsLayerFeature)((Object)aModel.getElementAt(i)))) continue;
            beanList.add(bean);
        }
        DefaultComboBoxModel<CidsLayerFeature> model = new DefaultComboBoxModel<CidsLayerFeature>(beanList.toArray(new CidsLayerFeature[beanList.size()]));
        model.setSelectedItem(aModel.getSelectedItem());
        return model;
    }

    public static void preloadData(MetaClass mc, boolean nullable, String sortingColumn) {
        cache.get((Object)new CatalogueDefinition(mc, nullable, sortingColumn));
    }

    private static class CatalogueDefinition {
        private final MetaClass mc;
        private final boolean nullable;
        private final String sortingColumn;

        public CatalogueDefinition(MetaClass mc, boolean nullable, String sortingColumn) {
            this.mc = mc;
            this.nullable = nullable;
            this.sortingColumn = sortingColumn;
        }

        public MetaClass getMc() {
            return this.mc;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public String getSortingColumn() {
            return this.sortingColumn;
        }

        public boolean equals(Object obj) {
            if (obj instanceof CatalogueDefinition) {
                CatalogueDefinition other = (CatalogueDefinition)obj;
                String otherSort = other.getSortingColumn() == null ? "" : other.getSortingColumn();
                String sort = this.getSortingColumn() == null ? "" : this.getSortingColumn();
                return otherSort.equals(sort) && other.getMc().equals((Object)this.mc) && other.isNullable() == this.nullable;
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + (this.mc != null ? this.mc.hashCode() : 0);
            hash = 29 * hash + (this.nullable ? 1 : 0);
            hash = 29 * hash + (this.sortingColumn != null ? this.sortingColumn.hashCode() : 0);
            return hash;
        }
    }

    private final class DefaultBindableReferenceComboRenderer
    extends DefaultListCellRenderer {
        private DefaultBindableReferenceComboRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component ret = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value == null && ret instanceof JLabel) {
                ((JLabel)ret).setText(DefaultCidsLayerBindableReferenceCombo.this.getNullValueRepresentation());
            }
            return ret;
        }
    }

    private final class MetaObjectChangeListenerImpl
    implements MetaObjectChangeListener {
        private MetaObjectChangeListenerImpl() {
        }

        public void metaObjectAdded(MetaObjectChangeEvent moce) {
            if (DefaultCidsLayerBindableReferenceCombo.this.metaClass != null && DefaultCidsLayerBindableReferenceCombo.this.metaClass.equals((Object)moce.getNewMetaObject().getMetaClass())) {
                DefaultCidsLayerBindableReferenceCombo.this.init(DefaultCidsLayerBindableReferenceCombo.this.metaClass, true);
            }
        }

        public void metaObjectChanged(MetaObjectChangeEvent moce) {
            if (DefaultCidsLayerBindableReferenceCombo.this.metaClass != null && DefaultCidsLayerBindableReferenceCombo.this.metaClass.equals((Object)moce.getNewMetaObject().getMetaClass())) {
                DefaultCidsLayerBindableReferenceCombo.this.init(DefaultCidsLayerBindableReferenceCombo.this.metaClass, true);
            }
        }

        public void metaObjectRemoved(MetaObjectChangeEvent moce) {
            if (DefaultCidsLayerBindableReferenceCombo.this.metaClass != null && DefaultCidsLayerBindableReferenceCombo.this.metaClass.equals((Object)moce.getOldMetaObject().getMetaClass())) {
                DefaultCidsLayerBindableReferenceCombo.this.init(DefaultCidsLayerBindableReferenceCombo.this.metaClass, true);
            }
        }
    }

    protected static final class FeatureToStringComparator
    implements Comparator<CidsLayerFeature> {
        protected FeatureToStringComparator() {
        }

        @Override
        public int compare(CidsLayerFeature o1, CidsLayerFeature o2) {
            String s1 = o1 == null ? "" : o1.toString();
            String s2 = o2 == null ? "" : o2.toString();
            return s1.compareToIgnoreCase(s2);
        }
    }
}

