/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.cidslayer;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.operation.distance.DistanceOp;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreatedEvent;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreatedListener;
import de.cismet.cismap.commons.gui.attributetable.creator.AbstractFeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.creator.CreaterGeometryListener;
import de.cismet.cismap.commons.gui.attributetable.creator.GeometryFinishedListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedPointFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.gui.WaitingDialogThread;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class PointAndStationCreator
extends AbstractFeatureCreator
implements ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(PointAndStationCreator.class);
    private static final String SUITABLE_ROUTE_QUERY = "select %1$s, %3$s.%2$s from %3$s join geom on (geom = geom.id) order by st_distance(geo_field, '%4$s') asc limit 1;";
    protected List<FeatureCreatedListener> listener = new ArrayList<FeatureCreatedListener>();
    private final String mode = "POINT";
    private final String stationProperty;
    private final MetaClass routeClass;
    private final LinearReferencingHelper helper;
    private AbstractFeatureService service = null;
    private final ConnectionContext connectionContext = ConnectionContext.createDummy();

    public PointAndStationCreator(String stationProperty, Map<String, Object> properties, MetaClass routeClass, LinearReferencingHelper helper) {
        this.properties = properties;
        this.routeClass = routeClass;
        this.helper = helper;
        this.stationProperty = stationProperty;
    }

    public void createFeature(final MappingComponent mc, final FeatureServiceFeature feature) {
        if (feature != null && feature.getLayerProperties() != null) {
            this.service = feature.getLayerProperties().getFeatureService();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                String oldInteractionMode = mc.getInteractionMode();
                CreaterGeometryListener listener = new CreaterGeometryListener(mc, new GeometryFinishedListener(){

                    public void geometryFinished(final Geometry g) {
                        feature.setGeometry(g);
                        if (feature instanceof DefaultFeatureServiceFeature) {
                            try {
                                PointAndStationCreator.fillFeatureWithDefaultValues((DefaultFeatureServiceFeature)((DefaultFeatureServiceFeature)feature), (Map)PointAndStationCreator.this.properties);
                                WaitingDialogThread<Void> dia = new WaitingDialogThread<Void>(null, true, NbBundle.getMessage(PointAndStationCreator.class, (String)"PointAndStationCreator.createFeature()"), null, 100){

                                    protected Void doInBackground() throws Exception {
                                        String query = String.format(PointAndStationCreator.SUITABLE_ROUTE_QUERY, PointAndStationCreator.this.routeClass.getID(), PointAndStationCreator.this.routeClass.getPrimaryKey(), PointAndStationCreator.this.routeClass.getTableName(), g.toText());
                                        MetaObject[] mo = SessionManager.getProxy().getMetaObjectByQuery(SessionManager.getSession().getUser(), query, PointAndStationCreator.this.getConnectionContext());
                                        if (mo != null && mo.length == 1) {
                                            CidsBean routeBean = mo[0].getBean();
                                            Coordinate[] coords = DistanceOp.nearestPoints((Geometry)PointAndStationCreator.this.helper.getGeometryFromRoute(routeBean), (Geometry)g);
                                            double position = LinearReferencedPointFeature.getPositionOnLine((Coordinate)coords[0], (Geometry)PointAndStationCreator.this.helper.getGeometryFromRoute(routeBean));
                                            CidsBean station = PointAndStationCreator.this.helper.createStationBeanFromRouteBean(routeBean, position);
                                            feature.setProperty(PointAndStationCreator.this.stationProperty, (Object)station);
                                        }
                                        ((DefaultFeatureServiceFeature)feature).saveChanges();
                                        return null;
                                    }

                                    protected void done() {
                                        try {
                                            this.get();
                                            for (FeatureCreatedListener featureCreatedListener : PointAndStationCreator.this.listener) {
                                                featureCreatedListener.featureCreated(new FeatureCreatedEvent((Object)PointAndStationCreator.this, feature));
                                            }
                                        }
                                        catch (Exception e) {
                                            LOG.error((Object)"Cannot save new feature", (Throwable)e);
                                        }
                                    }
                                };
                                dia.start();
                            }
                            catch (Exception e) {
                                LOG.error((Object)"Cannot save new feature", (Throwable)e);
                            }
                        }
                    }
                });
                mc.addInputListener("SimpleGeometryCreater", (PBasicInputEventHandler)listener);
                mc.putCursor("SimpleGeometryCreater", new Cursor(1));
                listener.setMode("POINT");
                mc.setInteractionMode("SimpleGeometryCreater");
            }
        });
    }

    public void addFeatureCreatedListener(FeatureCreatedListener listener) {
        this.listener.add(listener);
    }

    public String getTypeName() {
        return NbBundle.getMessage(PointAndStationCreator.class, (String)"PointAndStationCreator.getTypeName()");
    }

    public void cancel() {
    }

    public void resume() {
        CismapBroker.getInstance().getMappingComponent().setInteractionMode("SimpleGeometryCreater");
    }

    public AbstractFeatureService getService() {
        return this.service;
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

