/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.cidslayer;

import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.cidslayer.StationCreationCheck;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreatedEvent;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreatedListener;
import de.cismet.cismap.commons.gui.attributetable.creator.AbstractFeatureCreator;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.linearreferencing.CreateLinearReferencedLineListener;
import de.cismet.cismap.linearreferencing.CreateLinearReferencedPointListener;
import de.cismet.cismap.linearreferencing.CreateStationListener;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class StationCreator
extends AbstractFeatureCreator {
    private static final Logger LOG = Logger.getLogger(StationCreator.class);
    protected List<FeatureCreatedListener> listener = new ArrayList<FeatureCreatedListener>();
    private final String property;
    private final MetaClass routeClass;
    private final LinearReferencingHelper helper;
    private final String routeName;
    private StationCreationCheck check;
    private AbstractFeatureService service = null;
    private CreateLinearReferencedPointListener lastListener = null;

    public StationCreator(String property, MetaClass routeClass, String routeName, LinearReferencingHelper helper) {
        this.property = property;
        this.routeClass = routeClass;
        this.helper = helper;
        this.routeName = routeName;
    }

    public StationCreationCheck getCheck() {
        return this.check;
    }

    public void setCheck(StationCreationCheck check) {
        this.check = check;
    }

    public void createFeature(final MappingComponent mc, final FeatureServiceFeature feature) {
        if (feature != null && feature.getLayerProperties() != null) {
            this.service = feature.getLayerProperties().getFeatureService();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                String oldInteractionMode = mc.getInteractionMode();
                CreateLinearReferencedPointListener listener = new CreateLinearReferencedPointListener(mc, new CreateStationListener(){

                    @Override
                    public void pointFinished(CidsBean route, Geometry pointGeom, double point) {
                        if (route == null || StationCreator.this.check != null && !StationCreator.this.check.isStationValid(route, point, point)) {
                            return;
                        }
                        pointGeom = CrsTransformer.transformToDefaultCrs((Geometry)pointGeom);
                        pointGeom.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
                        CidsBean station = StationCreator.this.helper.createStationBeanFromRouteBean(route, point);
                        feature.setProperty(StationCreator.this.property, (Object)station);
                        feature.setGeometry(pointGeom);
                        if (feature instanceof DefaultFeatureServiceFeature) {
                            try {
                                StationCreator.fillFeatureWithDefaultValues((DefaultFeatureServiceFeature)((DefaultFeatureServiceFeature)feature), (Map)StationCreator.this.properties);
                                ((DefaultFeatureServiceFeature)feature).saveChanges();
                                for (FeatureCreatedListener featureCreatedListener : StationCreator.this.listener) {
                                    featureCreatedListener.featureCreated(new FeatureCreatedEvent((Object)StationCreator.this, feature));
                                }
                            }
                            catch (Exception e) {
                                LOG.error((Object)"Cannot save new feature", (Throwable)e);
                            }
                        }
                    }
                }, StationCreator.this.routeClass, StationCreator.this.routeName, StationCreator.this.check);
                mc.addInputListener("CREATE_NEW_STATION", (PBasicInputEventHandler)listener);
                mc.setInteractionMode("CREATE_NEW_STATION");
                StationCreator.this.lastListener = listener;
            }
        });
    }

    public void addFeatureCreatedListener(FeatureCreatedListener listener) {
        this.listener.add(listener);
    }

    public String getTypeName() {
        return "Station";
    }

    public void cancel() {
    }

    public void resume() {
        CismapBroker.getInstance().getMappingComponent().setInteractionMode("CREATE_NEW_STATION");
        if (this.lastListener != null) {
            this.lastListener.resumed();
        }
    }

    public AbstractFeatureService getService() {
        return this.service;
    }

    public boolean isCreationAllowed(MappingComponent mc) {
        PFeature line = CreateLinearReferencedLineListener.getSelectedLinePFeature(mc, this.routeClass);
        return line == null || this.check != null && this.check.isRouteValid(line);
    }
}

