/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.linearreferencing;

import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.linearref.LengthIndexedLine;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.StationCreationCheck;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateLinearReferencedMarksListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedPointFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.util.SelectionManager;
import de.cismet.cismap.linearreferencing.CreateStationLineListener;
import de.cismet.tools.gui.StaticSwingTools;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class CreateLinearReferencedLineListener
extends CreateLinearReferencedMarksListener {
    private static final Logger LOG = Logger.getLogger(CreateLinearReferencedLineListener.class);
    public static final String CREATE_LINEAR_REFERENCED_LINE_MODE = "CREATE_NEW_STATION_LINE";
    private int counter = 0;
    private final CreateStationLineListener lineFinishedListener;
    private final MetaClass acceptedRoute;
    private float minDistance = 0.0f;
    private float maxDistance = Float.MAX_VALUE;
    private String routeName = null;
    private boolean resumed = false;

    public CreateLinearReferencedLineListener(MappingComponent mc, CreateStationLineListener geometryFinishedListener, MetaClass acceptedRoute, String routeName, float minDistance, float maxDistance) {
        this(mc, geometryFinishedListener, acceptedRoute, routeName, minDistance, maxDistance, null);
    }

    public CreateLinearReferencedLineListener(MappingComponent mc, CreateStationLineListener geometryFinishedListener, MetaClass acceptedRoute, String routeName, float minDistance, float maxDistance, StationCreationCheck check) {
        super(mc);
        this.mcModus = CREATE_LINEAR_REFERENCED_LINE_MODE;
        this.lineFinishedListener = geometryFinishedListener;
        this.acceptedRoute = acceptedRoute;
        this.minDistance = minDistance;
        this.maxDistance = maxDistance;
        this.routeName = routeName;
        PFeature lineFeature = this.getSelectedLinePFeature();
        if (lineFeature == null) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)mc), "Sie m\u00fcssen genau ein " + routeName + " w\u00e4hlen.", "Fehler Thema-/Gew\u00e4sserwahl", 2);
            this.lineFinishedListener.lineFinished(null, null, null, null, 0.0, 0.0);
        } else if (check != null && !check.isRouteValid(lineFeature)) {
            this.lineFinishedListener.lineFinished(null, null, null, null, 0.0, 0.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseClicked(PInputEvent event) {
        if (event.isLeftMouseButton()) {
            if (this.counter == 0) {
                super.mouseClicked(event);
            } else if (this.counter == 1) {
                if (Math.abs(this.getCurrentPosition() - this.getMarkPositionsOfSelectedFeature()[0]) > (double)this.minDistance && Math.abs(this.getCurrentPosition() - this.getMarkPositionsOfSelectedFeature()[0]) <= (double)this.maxDistance) {
                    super.mouseClicked(event);
                } else {
                    return;
                }
            }
            ++this.counter;
            if (this.counter == 2) {
                Double[] pos = this.getMarkPositionsOfSelectedFeature();
                if (pos != null && pos.length == 2) {
                    try {
                        Geometry route = this.getSelectedLinePFeature().getFeature().getGeometry();
                        Geometry point1 = LinearReferencedPointFeature.getPointOnLine((double)pos[0], (Geometry)route);
                        Geometry point2 = LinearReferencedPointFeature.getPointOnLine((double)pos[1], (Geometry)route);
                        LengthIndexedLine lil = new LengthIndexedLine(route);
                        Geometry g = lil.extractLine(lil.indexOf(point1.getCoordinate()), lil.indexOf(point2.getCoordinate()));
                        CidsLayerFeature feature = (CidsLayerFeature)this.getSelectedLinePFeature().getFeature();
                        this.lineFinishedListener.lineFinished(feature.getBean(), g, point1, point2, pos[0], pos[1]);
                    }
                    finally {
                        this.counter = 0;
                        this.removeAllMarks();
                    }
                } else if (pos.length > 2) {
                    this.counter = 0;
                    this.removeAllMarks();
                } else {
                    --this.counter;
                }
            } else {
                Double[] pos = this.getMarkPositionsOfSelectedFeature();
                if (pos.length != this.counter) {
                    this.counter = 0;
                    this.removeAllMarks();
                }
            }
        }
    }

    public PFeature getSelectedLinePFeature() {
        PFeature line = CreateLinearReferencedLineListener.getSelectedLinePFeature(this.mc, this.acceptedRoute);
        if (line == null && this.resumed) {
            this.resumed = false;
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this.mc), "Sie m\u00fcssen genau ein " + this.routeName + " w\u00e4hlen.", "Fehler Thema-/Gew\u00e4sserwahl", 2);
            this.lineFinishedListener.lineFinished(null, null, null, null, 0.0, 0.0);
        }
        return line;
    }

    public static PFeature getSelectedLinePFeature(MappingComponent mc, MetaClass acceptedRoute) {
        Geometry geom;
        List fl = SelectionManager.getInstance().getSelectedFeatures();
        ArrayList<Feature> acceptedFeatures = new ArrayList<Feature>();
        for (Feature feature : fl) {
            CidsLayerFeature cidsFeature;
            if (!(feature instanceof CidsLayerFeature) || !(cidsFeature = (CidsLayerFeature)feature).getBean().getMetaObject().getMetaClass().equals((Object)acceptedRoute)) continue;
            acceptedFeatures.add(feature);
        }
        if (acceptedFeatures.size() == 1 && ((geom = ((Feature)acceptedFeatures.get(0)).getGeometry()) != null || geom instanceof MultiLineString || geom instanceof LineString)) {
            LayerProperties lp;
            Feature feature;
            feature = (Feature)acceptedFeatures.get(0);
            PFeature f = (PFeature)CismapBroker.getInstance().getMappingComponent().getPFeatureHM().get(feature);
            if (f == null && feature instanceof FeatureServiceFeature && (lp = ((FeatureServiceFeature)feature).getLayerProperties()) != null && lp.getFeatureService() != null && lp.getFeatureService().getPNode() != null) {
                PNode node = lp.getFeatureService().getPNode();
                for (int i = 0; i < node.getChildrenCount(); ++i) {
                    PNode pfeature;
                    if (!(node.getChild(i) instanceof PFeature) || !((pfeature = node.getChild(i)) instanceof PFeature) || !((PFeature)pfeature).getFeature().equals(feature)) continue;
                    f = (PFeature)pfeature;
                    break;
                }
            }
            return f;
        }
        return null;
    }

    public void resumed() {
        this.resumed = true;
    }
}

