/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.linearreferencing;

import Sirius.navigator.plugin.PluginRegistry;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollection;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.DrawSelectionFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedLineFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedPointFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.linearreferencing.FeatureRegistryListener;
import de.cismet.cismap.linearreferencing.LinearReferencingConstants;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.cismap.linearreferencing.LinearReferencingSingletonInstances;
import de.cismet.cismap.navigatorplugin.CismapPlugin;
import de.cismet.tools.CurrentStackTrace;
import java.awt.Color;
import java.awt.EventQueue;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openide.util.Lookup;

public class FeatureRegistry
implements LinearReferencingConstants,
LinearReferencingSingletonInstances {
    private static FeatureRegistry instance = new FeatureRegistry();
    private static final Color[] COLORS = new Color[]{new Color(217, 159, 126), new Color(242, 65, 48), new Color(121, 132, 39), new Color(216, 120, 57)};
    private HashMap<CidsBean, Feature> featureReg = new HashMap();
    private HashMap<Feature, CidsBean> cidsBeanReg = new HashMap();
    private HashMap<CidsBean, Integer> counterMap = new HashMap();
    private HashMap<CidsBean, Collection<FeatureRegistryListener>> listenerMap = new HashMap();
    private LinearReferencingHelper linearReferencingSolver = null;

    private FeatureRegistry() {
        Collection allLinearReferencingSolver = Lookup.getDefault().lookupAll(LinearReferencingHelper.class);
        if (allLinearReferencingSolver != null && allLinearReferencingSolver.size() > 0) {
            this.linearReferencingSolver = allLinearReferencingSolver.toArray(new LinearReferencingHelper[1])[0];
        }
    }

    public static FeatureRegistry getInstance() {
        return instance;
    }

    public boolean addListener(CidsBean cidsBean, FeatureRegistryListener listener) {
        if (this.listenerMap.get(cidsBean) == null) {
            this.listenerMap.put(cidsBean, new CopyOnWriteArrayList());
        }
        return this.listenerMap.get(cidsBean).add(listener);
    }

    public boolean removeListener(CidsBean cidsBean, FeatureRegistryListener listener) {
        Collection<FeatureRegistryListener> listeners = this.listenerMap.get(cidsBean);
        if (listeners != null) {
            return listeners.remove(listener);
        }
        return false;
    }

    private void fireFeatureCountChanged(CidsBean cidsBean) {
        Collection<FeatureRegistryListener> listeners = this.listenerMap.get(cidsBean);
        if (listeners != null) {
            for (FeatureRegistryListener listener : listeners) {
                listener.FeatureCountChanged();
            }
        }
    }

    private Feature addFeature(CidsBean cidsBean, Feature feature) {
        if (!this.featureReg.containsKey(cidsBean)) {
            this.featureReg.put(cidsBean, feature);
        }
        if (!this.cidsBeanReg.containsKey(feature)) {
            this.cidsBeanReg.put(feature, cidsBean);
        }
        if (this.getCounter(cidsBean) == 0) {
            FeatureRegistry.addFeatureToMap(feature);
        }
        this.incrementCounter(cidsBean);
        return this.featureReg.get(cidsBean);
    }

    public LinearReferencedPointFeature addStationFeature(CidsBean cidsBean) {
        double value = this.getLinearReferencingSolver().getLinearValueFromStationBean(cidsBean);
        Geometry routeGeometry = this.getLinearReferencingSolver().getRouteGeometryFromStationBean(cidsBean);
        this.addRouteFeature(this.getLinearReferencingSolver().getRouteBeanFromStationBean(cidsBean), routeGeometry);
        LinearReferencedPointFeature linRefPoint = new LinearReferencedPointFeature(value, routeGeometry);
        return (LinearReferencedPointFeature)this.addFeature(cidsBean, (Feature)linRefPoint);
    }

    public PureNewFeature addRouteFeature(CidsBean cidsBean, Geometry geometry) {
        return (RouteFeature)this.addFeature(cidsBean, (Feature)new RouteFeature(geometry));
    }

    public LinearReferencedLineFeature addLinearReferencedLineFeature(CidsBean cidsBean, LinearReferencedPointFeature from, LinearReferencedPointFeature to) {
        LinearReferencedLineFeature linRefLine = new LinearReferencedLineFeature(from, to);
        return (LinearReferencedLineFeature)this.addFeature(cidsBean, (Feature)linRefLine);
    }

    private Feature removeFeature(CidsBean cidsBean) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("remove " + cidsBean), (Throwable)new CurrentStackTrace());
        }
        if (this.decrementCounter(cidsBean) <= 0 && this.featureReg.containsKey(cidsBean)) {
            Feature feature = this.featureReg.remove(cidsBean);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"remove station from map");
            }
            FeatureRegistry.removeFeatureFromMap(feature);
            return feature;
        }
        return null;
    }

    public static Color getNextColor(CidsBean lineBean) {
        return COLORS[Math.abs(String.valueOf(lineBean.hashCode()).hashCode() % COLORS.length)];
    }

    public LinearReferencedLineFeature removeLinearReferencedLineFeature(CidsBean cidsBean) {
        return (LinearReferencedLineFeature)this.removeFeature(cidsBean);
    }

    public LinearReferencedPointFeature removeStationFeature(CidsBean cidsBean) {
        this.removeRouteFeature(this.getLinearReferencingSolver().getRouteBeanFromStationBean(cidsBean));
        return (LinearReferencedPointFeature)this.removeFeature(cidsBean);
    }

    public void removeRouteFeature(CidsBean cidsBean) {
        this.removeFeature(cidsBean);
    }

    private int incrementCounter(CidsBean cidsBean) {
        int counter = this.getCounter(cidsBean) + 1;
        this.counterMap.put(cidsBean, counter);
        if (LOG.isDebugEnabled()) {
            this.logCounterStatus("after increment " + cidsBean);
        }
        this.fireFeatureCountChanged(cidsBean);
        return counter;
    }

    private int decrementCounter(CidsBean cidsBean) {
        int counter = this.getCounter(cidsBean) - 1;
        this.counterMap.put(cidsBean, counter);
        if (counter == 0) {
            this.counterMap.remove(cidsBean);
        }
        this.logCounterStatus("after decrement " + cidsBean);
        this.fireFeatureCountChanged(cidsBean);
        return counter;
    }

    public int getCounter(CidsBean cidsBean) {
        if (!this.counterMap.containsKey(cidsBean)) {
            this.counterMap.put(cidsBean, new Integer(0));
        }
        return this.counterMap.get(cidsBean);
    }

    public static void addFeatureToMap(Feature feature) {
        final CismapPlugin cismap = (CismapPlugin)PluginRegistry.getRegistry().getPlugin("cismap");
        if (cismap != null) {
            cismap.setFeatureCollectionEventBlocker(true);
        }
        FeatureCollection featureCollection = CismapBroker.getInstance().getMappingComponent().getFeatureCollection();
        featureCollection.addFeature(feature);
        featureCollection.holdFeature(feature);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (cismap != null) {
                    cismap.setFeatureCollectionEventBlocker(false);
                }
            }
        });
    }

    public static void removeFeatureFromMap(Feature feature) {
        final CismapPlugin cismap = (CismapPlugin)PluginRegistry.getRegistry().getPlugin("cismap");
        if (cismap != null) {
            cismap.setFeatureCollectionEventBlocker(true);
        }
        FeatureCollection featureCollection = CismapBroker.getInstance().getMappingComponent().getFeatureCollection();
        featureCollection.removeFeature(feature);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (cismap != null) {
                    cismap.setFeatureCollectionEventBlocker(false);
                }
            }
        });
    }

    public CidsBean getCidsBean(Feature feature) {
        return this.cidsBeanReg.get(feature);
    }

    public Feature getFeature(CidsBean cidsBean) {
        return this.featureReg.get(cidsBean);
    }

    private void logCounterStatus(String string) {
        if (LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder("counterStatus ").append(string).append(":<br/>\n=============<br/>\n");
            for (Map.Entry<CidsBean, Integer> entry : this.counterMap.entrySet()) {
                if (entry.getKey() == null) continue;
                sb.append(entry.getKey()).append("-").append(entry.getKey().getMetaObject().getId()).append(" => ").append(entry.getValue()).append("<br/>\n");
            }
            LOG.debug((Object)sb.toString());
        }
    }

    public LinearReferencingHelper getLinearReferencingSolver() {
        return this.linearReferencingSolver;
    }

    public void setLinearReferencingSolver(LinearReferencingHelper linearReferencingSolver) {
        this.linearReferencingSolver = linearReferencingSolver;
    }

    public class RouteFeature
    extends PureNewFeature
    implements DrawSelectionFeature {
        public RouteFeature(Geometry geomety) {
            super(geomety);
            this.setEditable(false);
            this.setCanBeSelected(false);
            this.setName("Route");
        }

        public String getType() {
            return "Route";
        }

        public boolean isDrawingSelection() {
            return false;
        }
    }
}

