/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.linearreferencing;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.server.localserver.attribute.Attribute;
import Sirius.server.middleware.types.MetaClass;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.linearreferencing.FeatureRegistry;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.cismap.linearreferencing.tools.LinearReferencedGeomProvider;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class LinearReferencedCidsLayerProvider
implements LinearReferencedGeomProvider,
ConnectionContextProvider {
    private static Logger LOG = Logger.getLogger(LinearReferencedCidsLayerProvider.class);
    private final ConnectionContext connectionContext = ConnectionContext.createDummy();

    public List<AbstractFeatureService> getLinearReferencedGeomServices() {
        ArrayList<AbstractFeatureService> validLinRefClasses = new ArrayList<AbstractFeatureService>();
        LinearReferencingHelper helper = FeatureRegistry.getInstance().getLinearReferencingSolver();
        for (String domain : helper.getDomainOfRouteTable(null)) {
            try {
                MetaClass[] classes;
                for (MetaClass clazz : classes = SessionManager.getProxy().getClasses(domain, this.getConnectionContext())) {
                    Collection attributes = clazz.getAttributeByName("LinRefBaseGeom");
                    if (attributes == null || attributes.isEmpty()) continue;
                    CidsLayer cidsLayer = new CidsLayer(clazz);
                    Collection name = clazz.getAttributeByName("LinRefBaseName");
                    if (name != null && !name.isEmpty()) {
                        Attribute attr = name.toArray(new Attribute[name.size()])[0];
                        cidsLayer.setName(String.valueOf(attr.getValue()));
                    } else {
                        cidsLayer.setName(clazz.getTableName());
                    }
                    validLinRefClasses.add(cidsLayer);
                }
            }
            catch (ConnectionException ex) {
                LOG.error((Object)("Error while retrieving all classes from domain " + domain), (Throwable)ex);
            }
        }
        return validLinRefClasses;
    }

    public String getServiceDomain(AbstractFeatureService service) {
        if (service instanceof CidsLayer) {
            CidsLayer cidsLayer = (CidsLayer)service;
            return cidsLayer.getMetaClass().getDomain();
        }
        return null;
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public String getInternalServiceName(AbstractFeatureService service) {
        if (service instanceof CidsLayer) {
            CidsLayer cidsLayer = (CidsLayer)service;
            return cidsLayer.getMetaClass().getTableName();
        }
        return null;
    }
}

