/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.linearreferencing;

import Sirius.server.middleware.types.MetaClass;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.SelectionListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.linearreferencing.FeatureRegistry;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.cismap.linearreferencing.LinearReferencingSingletonInstances;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.CalculationCache;
import de.cismet.tools.Calculator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;

public class RouteCombo
extends JPanel
implements ConnectionContextProvider {
    private static Map<XBoundingBox, SoftReference<List<Feature>>> cache = new HashMap<XBoundingBox, SoftReference<List<Feature>>>();
    private static Date lastRefresh = new Date();
    public static final CalculationCache<RouteParameter, List<Feature>> routeCache = new CalculationCache((Calculator)new RouteCalculator());
    private LinearReferencingHelper linearReferencingHelper = FeatureRegistry.getInstance().getLinearReferencingSolver();
    private final String routeMetaClassName;
    private Date routesComboInitialised = null;
    private String routeNamePropertyName;
    private String routeQuery;
    private List<FocusListener> focusListener = new ArrayList<FocusListener>();
    private final ConnectionContext connectionContext;
    private JComboBox cbPossibleRoute;

    public RouteCombo(String routeMetaClassName, Object value, ConnectionContext connecitonContext) {
        this.connectionContext = connecitonContext;
        this.initComponents();
        this.routeMetaClassName = routeMetaClassName;
        this.routeNamePropertyName = this.linearReferencingHelper.getRouteNamePropertyFromRouteByClassName(routeMetaClassName);
        AutoCompleteDecorator.decorate((JComboBox)this.cbPossibleRoute, (ObjectToStringConverter)new ObjectToStringConverter(){

            public String getPreferredStringForItem(Object o) {
                if (o instanceof CidsLayerFeature) {
                    Object prop = ((CidsLayerFeature)((Object)o)).getProperty(RouteCombo.this.routeNamePropertyName);
                    if (prop == null) {
                        return "";
                    }
                    return String.valueOf(prop);
                }
                if (o == null) {
                    return "";
                }
                return o.toString();
            }
        });
        this.cbPossibleRoute.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Object newValue = value;
                if (value instanceof CidsLayerFeature) {
                    Object prop = ((CidsLayerFeature)((Object)value)).getProperty(RouteCombo.this.routeNamePropertyName);
                    if (prop != null) {
                        newValue = String.valueOf(prop);
                    }
                } else {
                    newValue = value != null ? value.toString() : " ";
                }
                return super.getListCellRendererComponent((JList<?>)list, newValue, index, isSelected, cellHasFocus);
            }
        });
        this.fillRoutesCombo(value);
    }

    public String getRouteQuery() {
        return this.routeQuery;
    }

    @Override
    public synchronized void addFocusListener(FocusListener l) {
        super.addFocusListener(l);
        this.focusListener.add(l);
    }

    @Override
    public synchronized void removeFocusListener(FocusListener l) {
        super.removeFocusListener(l);
        this.focusListener.remove(l);
    }

    public void setRouteQuery(String routeQuery) {
        this.routeQuery = routeQuery;
    }

    public void fillRoutesCombo(final Object value) {
        if (this.routesComboInitialised != null && this.routesComboInitialised.after(lastRefresh)) {
            return;
        }
        this.routesComboInitialised = new Date();
        this.cbPossibleRoute.setModel(new DefaultComboBoxModel<Object>(new Object[]{"Lade"}));
        final MetaClass routeMc = ClassCacheMultiple.getMetaClass((String)this.linearReferencingHelper.getDomainOfRouteTable(this.routeMetaClassName)[0], (String)this.routeMetaClassName, (ConnectionContext)this.getConnectionContext());
        MappingComponent mc = CismapBroker.getInstance().getMappingComponent();
        final XBoundingBox currentBoundingBox = new XBoundingBox(1.0, 1.0, 2.0, 2.0, null, true);
        SoftReference<List<Feature>> sr = cache.get(currentBoundingBox);
        List<Feature> featureList = null;
        if (sr != null) {
            featureList = sr.get();
        }
        if (featureList != null) {
            this.fillComboBox(featureList, value);
        } else {
            Thread t = new Thread("Load Routes"){

                @Override
                public void run() {
                    try {
                        RouteParameter parameter = new RouteParameter(routeMc, RouteCombo.this.routeQuery);
                        final List features = (List)routeCache.calcValue((Object)parameter);
                        cache.clear();
                        cache.put(currentBoundingBox, new SoftReference<List>(features));
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                RouteCombo.this.fillComboBox(features, value);
                            }
                        });
                    }
                    catch (Exception e) {
                        LinearReferencingSingletonInstances.LOG.error((Object)"Error while retrieving features", (Throwable)e);
                    }
                }
            };
            t.start();
        }
    }

    public static void clearRouteCache() {
        cache.clear();
        lastRefresh = new Date();
    }

    private void fillComboBox(List features, Object defaultVal) {
        MetaClass routeMc = ClassCacheMultiple.getMetaClass((String)this.linearReferencingHelper.getDomainOfRouteTable(this.routeMetaClassName)[0], (String)this.routeMetaClassName, (ConnectionContext)this.getConnectionContext());
        ArrayList<Object> routes = new ArrayList<Object>();
        boolean hasSelectedItem = defaultVal == null;
        boolean addSelectedItem = defaultVal != null;
        routes.add(null);
        if (features instanceof List) {
            List fl = features;
            for (Object o : fl) {
                if (!hasSelectedItem && o instanceof CidsLayerFeature && ((CidsLayerFeature)((Object)o)).getProperty(this.routeNamePropertyName).equals(defaultVal)) {
                    hasSelectedItem = true;
                    addSelectedItem = false;
                }
                routes.add((Feature)o);
            }
        }
        if (addSelectedItem) {
            if (defaultVal instanceof CidsLayerFeature) {
                routes.add((Feature)defaultVal);
            } else {
                routes.add(this.retrieveFeature(this.routeNamePropertyName, String.valueOf(defaultVal), routeMc));
            }
        }
        Comparator<Object> comp = new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return RouteCombo.this.featureToString(o1).compareTo(RouteCombo.this.featureToString(o2));
            }
        };
        Collections.sort(routes, comp);
        this.cbPossibleRoute.setModel(new DefaultComboBoxModel<Object>(routes.toArray()));
        if (defaultVal != null) {
            int index = Collections.binarySearch(routes, defaultVal, comp);
            if (index >= 0) {
                this.cbPossibleRoute.setSelectedItem(routes.get(index));
            }
        } else {
            this.cbPossibleRoute.setSelectedItem(null);
        }
    }

    private FeatureServiceFeature retrieveFeature(String property, String propertyValue, MetaClass mc) {
        try {
            CidsLayer service = new CidsLayer(mc);
            String query = service.decoratePropertyName(property) + " = " + service.decoratePropertyValue(property, propertyValue);
            service.initAndWait();
            List features = service.getFeatureFactory().createFeatures((Object)query, null, null, 0, 1, null);
            if (features.size() == 1) {
                return (FeatureServiceFeature)features.get(0);
            }
        }
        catch (Exception e) {
            LinearReferencingSingletonInstances.LOG.error((Object)"Error while reloading feature from server", (Throwable)e);
        }
        return null;
    }

    private String featureToString(Object value) {
        if (value instanceof CidsLayerFeature) {
            Object prop = ((CidsLayerFeature)((Object)value)).getProperty(this.routeNamePropertyName);
            if (prop != null) {
                return String.valueOf(prop);
            }
        } else {
            if (value != null) {
                return value.toString();
            }
            return " ";
        }
        return String.valueOf(value);
    }

    public List<Feature> getPossibleRoutes() {
        MappingComponent mc = CismapBroker.getInstance().getMappingComponent();
        SelectionListener sl = (SelectionListener)mc.getInputEventListener().get("SELECT");
        List featureList = sl.getAllSelectedPFeatures();
        ArrayList<Feature> possibleRoutes = new ArrayList<Feature>();
        MetaClass routeMc = ClassCacheMultiple.getMetaClass((String)this.linearReferencingHelper.getDomainOfRouteTable(this.routeMetaClassName)[0], (String)this.routeMetaClassName, (ConnectionContext)this.getConnectionContext());
        for (PFeature f : featureList) {
            CidsLayerFeature clFeature;
            Feature selectedFeature = f.getFeature();
            if (!(selectedFeature instanceof CidsLayerFeature) || !routeMc.equals((Object)(clFeature = (CidsLayerFeature)selectedFeature).getBean().getMetaObject().getMetaClass())) continue;
            possibleRoutes.add(selectedFeature);
        }
        return possibleRoutes;
    }

    public Object getValue() {
        return this.cbPossibleRoute.getSelectedItem();
    }

    private void initComponents() {
        this.cbPossibleRoute = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.cbPossibleRoute.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbPossibleRoute.setPreferredSize(new Dimension(300, 20));
        this.cbPossibleRoute.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                RouteCombo.this.cbPossibleRouteFocusLost(evt);
            }
        });
        this.cbPossibleRoute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RouteCombo.this.cbPossibleRouteActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.cbPossibleRoute, gridBagConstraints);
    }

    private void cbPossibleRouteActionPerformed(ActionEvent evt) {
        for (FocusListener l : this.focusListener) {
            l.focusLost(null);
        }
    }

    private void cbPossibleRouteFocusLost(FocusEvent evt) {
        for (FocusListener l : this.focusListener) {
            l.focusLost(evt);
        }
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private static class RouteParameter {
        private MetaClass routeMc;
        private String query;

        public RouteParameter(MetaClass routeMc, String query) {
            this.routeMc = routeMc;
            this.query = query;
        }

        public MetaClass getRouteMc() {
            return this.routeMc;
        }

        public void setRouteMc(MetaClass routeMc) {
            this.routeMc = routeMc;
        }

        public String getQuery() {
            return this.query;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public boolean equals(Object obj) {
            if (obj instanceof RouteParameter) {
                RouteParameter other = (RouteParameter)obj;
                boolean sameQuery = this.query == null && other.getQuery() == null || this.query != null && other.getQuery() != null && this.query.equals(other.getQuery());
                boolean sameMc = this.routeMc == null && other.getRouteMc() == null || this.routeMc != null && other.getRouteMc() != null && this.routeMc.equals((Object)other.getRouteMc());
                return sameQuery && sameMc;
            }
            return false;
        }

        public int hashCode() {
            int hash = 3;
            hash = 97 * hash + Objects.hashCode(this.routeMc);
            hash = 97 * hash + Objects.hashCode(this.query);
            return hash;
        }
    }

    private static class RouteCalculator
    implements Calculator<RouteParameter, List<Feature>> {
        private RouteCalculator() {
        }

        public List<Feature> calculate(RouteParameter parameter) throws Exception {
            CidsLayer layer = new CidsLayer(parameter.getRouteMc());
            String routeQuery = parameter.getQuery();
            if (routeQuery != null) {
                layer.setQuery(routeQuery);
            }
            layer.setBoundingBox(null);
            layer.initAndWait();
            return layer.getFeatureFactory().createFeatures((Object)routeQuery, null, null, 0, 0, null);
        }
    }
}

