/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.linearreferencing;

import com.vividsolutions.jts.algorithm.MinimumBoundingCircle;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.linearref.LengthIndexedLine;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.server.cidslayer.CidsLayerInfo;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.LinearReferencingInfo;
import de.cismet.cismap.commons.gui.attributetable.AttributeTable;
import de.cismet.cismap.commons.gui.featureinfopanel.FeatureInfoPanel;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.linearreferencing.FeatureRegistry;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.cismap.linearreferencing.RouteCombo;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import java.awt.Component;
import java.awt.Container;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.apache.log4j.Logger;

public class RouteTableCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(RouteTableCellEditor.class);
    private RouteCombo stat;
    private final String columnName;
    private List<LinearReferencingInfo> linRefInfos;
    private final LinearReferencingHelper linHelper = FeatureRegistry.getInstance().getLinearReferencingSolver();
    private final String routeName;
    private String oldValue;
    private CidsLayerFeature cidsFeature;
    private final boolean line;
    private String routeQuery = null;
    private final ConnectionContext connectionContext;

    @Deprecated
    public RouteTableCellEditor(String routeName, String columnName, boolean line) {
        this(routeName, columnName, line, ConnectionContext.createDeprecated());
    }

    public RouteTableCellEditor(String routeName, String columnName, boolean line, ConnectionContext connectionContext) {
        this.routeName = routeName;
        this.columnName = columnName;
        this.line = line;
        this.connectionContext = connectionContext;
    }

    public String getRouteQuery() {
        return this.routeQuery;
    }

    public void setRouteQuery(String routeQuery) {
        this.routeQuery = routeQuery;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        FeatureInfoPanel infoPanel;
        FeatureServiceFeature feature;
        Container o = table;
        while (o.getParent() != null && !(o.getParent() instanceof AttributeTable) && !(o.getParent() instanceof FeatureInfoPanel)) {
            o = o.getParent();
        }
        if (o.getParent() instanceof AttributeTable) {
            AttributeTable tab = (AttributeTable)o.getParent();
            FeatureServiceFeature feature2 = tab.getFeatureByRow(row);
            if (feature2 instanceof CidsLayerFeature) {
                this.cidsFeature = (CidsLayerFeature)feature2;
                this.oldValue = (String)value;
                this.stat = new RouteCombo(this.routeName, value, this.getConnectionContext());
            }
        } else if (o.getParent() instanceof FeatureInfoPanel && (feature = (infoPanel = (FeatureInfoPanel)o.getParent()).getSelectedFeature()) instanceof CidsLayerFeature) {
            this.cidsFeature = (CidsLayerFeature)feature;
            this.stat = new RouteCombo(this.routeName, value, this.getConnectionContext());
            this.oldValue = (String)value;
            this.stat = new RouteCombo(this.routeName, value, this.getConnectionContext());
        }
        return this.stat;
    }

    public Component getFeatureComponent(CidsLayerFeature feature, Object value) {
        this.cidsFeature = feature;
        this.oldValue = (String)value;
        this.stat = new RouteCombo(this.routeName, value, this.getConnectionContext());
        return this.stat;
    }

    @Override
    public Object getCellEditorValue() {
        String newValueName;
        String routeNamePropName = this.linHelper.getRouteNamePropertyFromRouteByClassName(this.routeName);
        Object newValue = this.stat.getValue();
        if (newValue instanceof String) {
            newValueName = this.oldValue;
        } else {
            String string = newValueName = newValue != null ? String.valueOf(((CidsLayerFeature)((Object)newValue)).getProperty(routeNamePropName)) : "null";
        }
        if (newValue == null && this.oldValue != null) {
            try {
                this.cidsFeature.removeStations();
                this.cidsFeature.setProperty(this.columnName, null);
                this.cidsFeature.getBean().setProperty(this.columnName, null);
                CidsLayerInfo info = this.cidsFeature.getLayerInfo();
                for (String colName : info.getColumnNames()) {
                    if (!info.isStation(colName) || !info.getStationInfo(colName).getRouteTable().equals(this.routeName)) continue;
                    this.cidsFeature.setProperty(colName, null);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while deleting property", (Throwable)e);
            }
        } else if (newValue != this.oldValue && !newValueName.equals(this.oldValue)) {
            this.cidsFeature.removeStations();
            CidsBean bean = (CidsBean)this.cidsFeature.getBean().getProperty(this.columnName);
            CidsLayerFeature routeFeature = (CidsLayerFeature)((Object)newValue);
            CidsBean routeBean = routeFeature.getBean();
            if (bean == null) {
                bean = this.line ? this.linHelper.createLineBeanFromRouteBean(routeBean) : this.linHelper.createStationBeanFromRouteBean(routeBean);
                try {
                    this.cidsFeature.setProperty(this.columnName, bean);
                    this.cidsFeature.getBean().setProperty(this.columnName, (Object)bean);
                }
                catch (Exception e) {
                    LOG.error((Object)"Set new Bean", (Throwable)e);
                }
            }
            if (bean != null) {
                if (this.line) {
                    CidsBean start = this.linHelper.getStationBeanFromLineBean(bean, true);
                    CidsBean end = this.linHelper.getStationBeanFromLineBean(bean, false);
                    try {
                        Geometry exEndPoint;
                        Geometry exPoint;
                        GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CismapBroker.getInstance().getDefaultCrsAlias());
                        LengthIndexedLine indexedLine = new LengthIndexedLine(routeFeature.getGeometry());
                        Geometry formerGeom = this.cidsFeature.getGeometry();
                        if (formerGeom != null && formerGeom instanceof Polygon) {
                            Geometry polGeom = formerGeom;
                            Coordinate[] coords = new MinimumBoundingCircle(polGeom).getExtremalPoints();
                            if (coords != null && coords.length == 2) {
                                exPoint = polGeom.getFactory().createPoint(coords[0]);
                                exEndPoint = polGeom.getFactory().createPoint(coords[1]);
                            } else {
                                exPoint = this.linHelper.getPointGeometryFromStationBean(end);
                                exEndPoint = this.linHelper.getPointGeometryFromStationBean(start);
                            }
                        } else if (formerGeom == null || !(formerGeom instanceof LineString)) {
                            exPoint = this.linHelper.getPointGeometryFromStationBean(end);
                            exEndPoint = this.linHelper.getPointGeometryFromStationBean(start);
                        } else {
                            exPoint = factory.createPoint(formerGeom.getCoordinates()[0]);
                            exEndPoint = factory.createPoint(formerGeom.getCoordinates()[formerGeom.getCoordinates().length - 1]);
                        }
                        double val = indexedLine.project(exPoint.getCoordinate());
                        double endVal = indexedLine.project(exEndPoint.getCoordinate());
                        if (val > endVal) {
                            double tmp = val;
                            val = endVal;
                            endVal = tmp;
                        }
                        if (endVal == val) {
                            if (val == 0.0) {
                                endVal = 1.0;
                            } else {
                                val = endVal - 1.0;
                                if (val < 0.0) {
                                    val = 0.0;
                                }
                            }
                        }
                        Point point = factory.createPoint(indexedLine.extractPoint(val));
                        Point endPoint = factory.createPoint(indexedLine.extractPoint(endVal));
                        this.linHelper.setRouteBeanToStationBean(routeBean, start);
                        this.linHelper.setLinearValueToStationBean(val, start);
                        this.linHelper.setPointGeometryToStationBean((Geometry)point, start);
                        this.linHelper.setRouteBeanToStationBean(routeBean, end);
                        this.linHelper.setLinearValueToStationBean(endVal, end);
                        this.linHelper.setPointGeometryToStationBean((Geometry)endPoint, end);
                        Geometry line = indexedLine.extractLine(val, endVal);
                        line.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
                        this.linHelper.setGeometryToLineBean(line, bean);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error while setting new line", (Throwable)e);
                    }
                } else {
                    try {
                        Geometry point;
                        this.linHelper.setRouteBeanToStationBean(routeBean, bean);
                        Geometry formerGeom = this.cidsFeature.getGeometry();
                        if (formerGeom == null || !(formerGeom instanceof Point)) {
                            point = this.linHelper.getPointGeometryFromStationBean(bean);
                        } else {
                            point = (Geometry)formerGeom.clone();
                            point.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
                        }
                        LengthIndexedLine indexedLine = new LengthIndexedLine(routeFeature.getGeometry());
                        double val = indexedLine.project(point.getCoordinate());
                        this.linHelper.setLinearValueToStationBean(val, bean);
                        this.linHelper.setPointGeometryToStationBean(point, bean);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error while setting new route", (Throwable)e);
                    }
                }
            }
            if (newValue != null) {
                this.cidsFeature.initStations();
            }
        }
        if (newValue == null) {
            return null;
        }
        if (newValue instanceof String) {
            return this.oldValue;
        }
        return String.valueOf(((CidsLayerFeature)((Object)newValue)).getProperty(routeNamePropName));
    }

    public String getColumnName() {
        return this.columnName;
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

