/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.linearreferencing;

import Sirius.navigator.ui.ComponentRegistry;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.dynamics.CidsBeanStore;
import de.cismet.cids.dynamics.DisposableCidsBeanStore;
import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedPointFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.LinearReferencedPointFeatureListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.linearreferencing.FeatureRegistry;
import de.cismet.cismap.linearreferencing.LinearReferencedLineEditor;
import de.cismet.cismap.linearreferencing.LinearReferencedLineEditorListener;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.cismap.linearreferencing.StationEditor;
import de.cismet.cismap.linearreferencing.tools.StationEditorInterface;
import de.cismet.tools.CurrentStackTrace;
import de.cismet.tools.gui.StaticSwingTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.Format;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.DockingWindowListener;
import net.infonode.docking.OperationAbortedException;
import net.infonode.docking.View;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class TableStationEditor
extends JPanel
implements DisposableCidsBeanStore,
StationEditorInterface {
    private static final Logger LOG = Logger.getLogger(TableStationEditor.class);
    private CidsBean cidsBean;
    private CidsBean backupBean;
    private boolean inited = false;
    private PropertyChangeListener cidsBeanListener;
    private boolean isSpinnerChangeLocked = false;
    private boolean isFeatureChangeLocked = false;
    private boolean isBeanChangeLocked = false;
    private boolean changedSinceDrop = false;
    private LinearReferencedPointFeatureListener featureListener;
    private final LinearReferencingHelper linearReferencingHelper = FeatureRegistry.getInstance().getLinearReferencingSolver();
    private boolean line;
    private boolean fromStation = false;
    private CidsBean lineBean;
    private LinearReferencedLineEditor dialogLineEditor;
    private StationEditor dialogStationEditor;
    private String routeTable;
    private String otherLinesFrom;
    private String otherLinesQuery;
    private FeatureServiceFeature parentFeature;
    private String stationProperty;
    private final WindowListener dialogCleanupListener = new WindowAdapter(){

        @Override
        public void windowClosed(WindowEvent e) {
            TableStationEditor.this.dialogCleanup();
        }
    };
    private boolean dialogInitialised = false;
    private DockingWindowListener windowCleanupListener = new DockingWindowListener(){

        public void windowAdded(DockingWindow addedToWindow, DockingWindow addedWindow) {
        }

        public void windowRemoved(DockingWindow removedFromWindow, DockingWindow removedWindow) {
        }

        public void windowShown(DockingWindow window) {
        }

        public void windowHidden(DockingWindow window) {
        }

        public void viewFocusChanged(View previouslyFocusedView, View focusedView) {
        }

        public void windowClosing(DockingWindow window) throws OperationAbortedException {
            TableStationEditor.this.diaExp.dispose();
            TableStationEditor.this.dialogCleanup();
        }

        public void windowClosed(DockingWindow window) {
            TableStationEditor.this.diaExp.dispose();
            TableStationEditor.this.dialogCleanup();
        }

        public void windowUndocking(DockingWindow window) throws OperationAbortedException {
        }

        public void windowUndocked(DockingWindow window) {
        }

        public void windowDocking(DockingWindow window) throws OperationAbortedException {
        }

        public void windowDocked(DockingWindow window) {
        }

        public void windowMinimizing(DockingWindow window) throws OperationAbortedException {
        }

        public void windowMinimized(DockingWindow window) {
        }

        public void windowMaximizing(DockingWindow window) throws OperationAbortedException {
        }

        public void windowMaximized(DockingWindow window) {
        }

        public void windowRestoring(DockingWindow window) throws OperationAbortedException {
        }

        public void windowRestored(DockingWindow window) {
        }
    };
    private JButton butExpand;
    private JButton butRemove;
    private JDialog diaExp;
    private JPanel dialogPanel;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSpinner jSpinner1;

    public TableStationEditor(String routeTable) {
        this(false, null, routeTable, null, null);
    }

    public TableStationEditor(String routeTable, FeatureServiceFeature parentFeature, String stationProperty) {
        this(false, null, routeTable, parentFeature, stationProperty);
    }

    public TableStationEditor(boolean line, CidsBean lineBean, String routeTable, FeatureServiceFeature parentFeature, String stationProperty) {
        this.line = line;
        this.lineBean = lineBean;
        this.routeTable = routeTable;
        this.parentFeature = parentFeature;
        this.stationProperty = stationProperty;
        this.initComponents();
        this.butExpand.setVisible(false);
        this.butRemove.setVisible(false);
        this.initSpinnerListener();
        this.initFeatureListener();
        this.initCidsBeanListener();
        if (lineBean != null) {
            lineBean.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (TableStationEditor.this.fromStation && evt.getPropertyName().equals("von") || !TableStationEditor.this.fromStation && evt.getPropertyName().equals("bis")) {
                        TableStationEditor.this.cleanup();
                        TableStationEditor.this.cidsBean = (CidsBean)evt.getNewValue();
                        TableStationEditor.this.init();
                        TableStationEditor.this.cidsBeanChanged((Double)TableStationEditor.this.getValue());
                    }
                }
            });
        }
        this.diaExp.addWindowListener(this.dialogCleanupListener);
    }

    public boolean isLine() {
        return this.line;
    }

    public CidsBean getLineBean() {
        return this.lineBean;
    }

    private void setButRemoveVisibility() {
        this.butRemove.setVisible(this.parentFeature != null && this.stationProperty != null && this.parentFeature.getProperty(this.stationProperty) != null);
    }

    private View getParentView(Component c) {
        if (c.getParent() == null || c.getParent() instanceof View) {
            return (View)c.getParent();
        }
        return this.getParentView(c.getParent());
    }

    public void setCidsBean(CidsBean cidsBean) {
        CidsBean newBean = cidsBean;
        if (this.line && this.lineBean != null && cidsBean.getClass().getName().equals(this.lineBean.getClass().getName())) {
            newBean = this.linearReferencingHelper.getStationBeanFromLineBean(cidsBean, this.fromStation);
        }
        this.cleanup();
        this.cidsBean = newBean;
        this.createBackupBean();
        if (this.line && this.lineBean != null) {
            this.fromStation = this.cidsBean.equals(this.lineBean.getProperty("von"));
        }
        this.init();
        this.cidsBeanChanged((Double)this.getValue());
        if (this.diaExp.isVisible()) {
            this.diaExp.pack();
        }
    }

    private void initComponents() {
        this.diaExp = new JDialog();
        this.dialogPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.jSpinner1 = new JSpinner();
        this.butExpand = new JButton();
        this.butRemove = new JButton();
        this.diaExp.setDefaultCloseOperation(2);
        this.diaExp.setTitle(NbBundle.getMessage(TableStationEditor.class, (String)"TableStationEditor.diaExp.title"));
        this.diaExp.getContentPane().setLayout(new GridBagLayout());
        this.dialogPanel.setLayout(new BorderLayout());
        this.jScrollPane1.setViewportView(this.jPanel1);
        this.dialogPanel.add((Component)this.jScrollPane1, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.diaExp.getContentPane().add((Component)this.dialogPanel, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        this.jSpinner1.setModel(new SpinnerNumberModel(0.0, 0.0, 0.0, 1.0));
        this.jSpinner1.setEditor(new JSpinner.NumberEditor(this.jSpinner1, "###.##"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jSpinner1, gridBagConstraints);
        this.butExpand.setText(NbBundle.getMessage(TableStationEditor.class, (String)"TableStationEditor.butExpand.text"));
        this.butExpand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableStationEditor.this.butExpandActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.butExpand, gridBagConstraints);
        this.butRemove.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/linearreferencing/icon-remove-sign.png")));
        this.butRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableStationEditor.this.butRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.butRemove, gridBagConstraints);
    }

    private void butExpandActionPerformed(ActionEvent evt) {
        View w = this.getParentView(this);
        if (w != null) {
            w.removeListener(this.windowCleanupListener);
            w.addListener(this.windowCleanupListener);
        }
        if (!this.dialogInitialised && !this.diaExp.isVisible()) {
            if (this.line) {
                this.dialogLineEditor = new LinearReferencedLineEditor(true, true, true, this.routeTable);
                if (this.otherLinesFrom != null && this.otherLinesQuery != null) {
                    this.dialogLineEditor.setOtherLinesEnabled(true);
                    this.dialogLineEditor.setOtherLinesQueryAddition(this.otherLinesFrom, this.otherLinesQuery);
                }
                this.dialogLineEditor.setCidsBeanStore((CidsBeanStore)this, this.lineBean);
                this.jPanel1.removeAll();
                this.jPanel1.add(this.dialogLineEditor);
                this.dialogLineEditor.addListener(new LinearReferencedLineEditorListener(){

                    @Override
                    public void linearReferencedLineCreated() {
                        if (TableStationEditor.this.line) {
                            CidsBean newLineBean = TableStationEditor.this.dialogLineEditor.getCidsBean();
                            for (String propertyName : newLineBean.getPropertyNames()) {
                                if (propertyName.equalsIgnoreCase("id")) continue;
                                try {
                                    TableStationEditor.this.lineBean.setProperty(propertyName, newLineBean.getProperty(propertyName));
                                }
                                catch (Exception ex) {
                                    LOG.error((Object)"Error while setting a property", (Throwable)ex);
                                }
                            }
                        }
                    }

                    @Override
                    public void otherLinesPanelVisibilityChange(boolean visible) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                TableStationEditor.this.diaExp.pack();
                            }
                        });
                    }
                });
                this.diaExp.pack();
            } else {
                this.dialogStationEditor = new StationEditor(true, this.routeTable, true);
                this.dialogStationEditor.setCidsBeanStore((CidsBeanStore)this);
                this.jPanel1.removeAll();
                this.jPanel1.add(this.dialogStationEditor);
                this.diaExp.pack();
            }
            this.dialogInitialised = true;
        }
        EventQueue.invokeLater(new Thread("show linear referencing editor popup"){

            @Override
            public void run() {
                TableStationEditor.this.diaExp.setAlwaysOnTop(true);
                try {
                    Point p = TableStationEditor.this.getLocationOnScreen();
                    Rectangle r = TableStationEditor.this.getBounds();
                    TableStationEditor.this.diaExp.setLocation((int)p.getX(), (int)(p.getY() + r.getHeight()));
                    TableStationEditor.this.diaExp.setVisible(true);
                }
                catch (IllegalComponentStateException e) {
                    LOG.warn((Object)"Cannot calculate popup position under editor", (Throwable)e);
                    StaticSwingTools.centerWindowOnScreen((Window)TableStationEditor.this.diaExp);
                }
            }
        });
    }

    private void butRemoveActionPerformed(ActionEvent evt) {
        int ans = JOptionPane.showConfirmDialog(ComponentRegistry.getRegistry().getMainWindow(), NbBundle.getMessage(TableStationEditor.class, (String)"TableStationEditor.butExpand1ActionPerformed.JOptionPane.message"), NbBundle.getMessage(TableStationEditor.class, (String)"TableStationEditor.butExpand1ActionPerformed.JOptionPane.title"), 0, 3);
        if (ans == 0 && this.parentFeature != null) {
            this.parentFeature.setProperty(this.stationProperty, null);
        }
    }

    public CidsBean getCidsBean() {
        return this.cidsBean;
    }

    public void undoChanges() {
        this.restore();
    }

    private void createBackupBean() {
        try {
            if (this.cidsBean == null || this.linearReferencingHelper.getRouteBeanFromStationBean(this.cidsBean) == null) {
                return;
            }
            Double value = this.linearReferencingHelper.getLinearValueFromStationBean(this.cidsBean);
            CidsBean routeBean = this.linearReferencingHelper.getRouteBeanFromStationBean(this.cidsBean);
            this.backupBean = this.linearReferencingHelper.createStationBeanFromRouteBean(routeBean, value);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while creatng backup bean.", (Throwable)e);
        }
    }

    private void restore() {
        try {
            if (this.backupBean == null) {
                this.cidsBean = null;
            }
            Double value = this.linearReferencingHelper.getLinearValueFromStationBean(this.backupBean);
            this.linearReferencingHelper.setLinearValueToStationBean(value, this.cidsBean);
            CidsBean routeBean = this.linearReferencingHelper.getRouteBeanFromStationBean(this.backupBean);
            if (routeBean != null) {
                this.linearReferencingHelper.setRouteBeanToStationBean(routeBean, this.cidsBean);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot restore station bean.", (Throwable)e);
        }
    }

    private boolean isCrsSupported(Crs crs) {
        return CrsTransformer.extractSridFromCrs((String)crs.getCode()) == 35833 || CrsTransformer.extractSridFromCrs((String)crs.getCode()) == 5650;
    }

    private void cleanup() {
        LinearReferencedPointFeature oldFeature;
        CidsBean pointBean = this.getCidsBean();
        if (pointBean != null) {
            pointBean.removePropertyChangeListener(this.getCidsBeanListener());
        }
        if (pointBean != null && (oldFeature = FeatureRegistry.getInstance().removeStationFeature(pointBean)) != null) {
            oldFeature.removeListener(this.getFeatureListener());
        }
        this.setInited(false);
    }

    private void dialogCleanup() {
        View w;
        if (this.dialogLineEditor != null) {
            this.dialogLineEditor.dispose();
            this.jPanel1.remove(this.dialogLineEditor);
            this.dialogLineEditor = null;
            this.dialogInitialised = false;
        }
        if (this.dialogStationEditor != null) {
            this.dialogStationEditor.dispose();
            this.jPanel1.remove(this.dialogStationEditor);
            this.dialogStationEditor = null;
            this.dialogInitialised = false;
        }
        if ((w = this.getParentView(this)) != null) {
            w.removeListener(this.windowCleanupListener);
        }
    }

    private void init() {
        CidsBean pointBean;
        if (this.isCrsSupported(CismapBroker.getInstance().getSrs()) && !this.isInited() && (pointBean = this.getCidsBean()) != null && this.linearReferencingHelper.getRouteBeanFromStationBean(pointBean) != null) {
            pointBean.addPropertyChangeListener(this.getCidsBeanListener());
            double pointValue = (Double)this.getValue();
            this.setValueToFeature(pointValue);
            this.setValueToSpinner(pointValue);
            LinearReferencedPointFeature pointFeature = FeatureRegistry.getInstance().addStationFeature(pointBean);
            pointFeature.setEditable(true);
            ((SpinnerNumberModel)this.jSpinner1.getModel()).setMaximum(Double.valueOf(Math.ceil(pointFeature.getLineGeometry().getLength())));
            pointFeature.addListener(this.getFeatureListener());
            this.setInited(true);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.jSpinner1.setEnabled(enabled);
        this.butExpand.setEnabled(enabled);
    }

    public LinearReferencedPointFeature getStationFeature() {
        return (LinearReferencedPointFeature)FeatureRegistry.getInstance().getFeature(this.cidsBean);
    }

    private void initSpinnerListener() {
        ((JSpinner.DefaultEditor)this.jSpinner1.getEditor()).getTextField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent de) {
                TableStationEditor.this.spinnerChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
                TableStationEditor.this.spinnerChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent de) {
                TableStationEditor.this.spinnerChanged();
            }
        });
        ((JSpinner.DefaultEditor)this.jSpinner1.getEditor()).getTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent fe) {
            }
        });
    }

    private void initFeatureListener() {
        this.setFeatureListener(new LinearReferencedPointFeatureListener(){

            public void featureMoved(LinearReferencedPointFeature pointFeature) {
                TableStationEditor.this.featureChanged(pointFeature.getCurrentPosition());
            }

            public void featureMerged(LinearReferencedPointFeature mergePoint, LinearReferencedPointFeature withPoint) {
                CidsBean withBean = FeatureRegistry.getInstance().getCidsBean((Feature)withPoint);
                TableStationEditor.this.setCidsBean(withBean);
            }
        });
    }

    private void initCidsBeanListener() {
        this.setCidsBeanListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                if (pce.getPropertyName().equals(TableStationEditor.this.linearReferencingHelper.getValueProperty(TableStationEditor.this.cidsBean))) {
                    TableStationEditor.this.cidsBeanChanged((Double)pce.getNewValue());
                }
            }
        });
    }

    public Object getValue() {
        if (this.cidsBean != null) {
            return this.linearReferencingHelper.getLinearValueFromStationBean(this.cidsBean);
        }
        return 0.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cidsBeanChanged(double value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("cidsbean changed: " + value), (Throwable)new CurrentStackTrace());
        }
        try {
            this.lockBeanChange(true);
            this.setChangedSinceDrop(true);
            Object oldValue = this.jSpinner1.getValue();
            if (oldValue == null) {
                oldValue = -1;
            }
            this.setValueToSpinner(value);
            this.setValueToFeature(value);
            this.firePropertyChange("wert", oldValue, (Object)value);
            if (this.isInited()) {
                this.updateGeometry();
            }
        }
        finally {
            this.lockBeanChange(false);
        }
    }

    private void lockBeanChange(boolean lock) {
        this.isBeanChangeLocked = lock;
    }

    private void setChangedSinceDrop(boolean changedSinceDrop) {
        this.changedSinceDrop = changedSinceDrop;
    }

    private PropertyChangeListener getCidsBeanListener() {
        return this.cidsBeanListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spinnerChanged() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"spinner changed", (Throwable)new CurrentStackTrace());
        }
        try {
            this.lockSpinnerChange(true);
            JFormattedTextField.AbstractFormatter formatter = ((JSpinner.DefaultEditor)this.jSpinner1.getEditor()).getTextField().getFormatter();
            String text = ((JSpinner.DefaultEditor)this.jSpinner1.getEditor()).getTextField().getText();
            if (!text.isEmpty()) {
                Double d = new Double(text.replace(',', '.'));
                this.setPointValue(d);
            }
        }
        finally {
            this.lockSpinnerChange(false);
        }
    }

    private void featureChanged(double value) {
        try {
            this.lockFeatureChange(true);
            this.setPointValue(value);
        }
        finally {
            this.lockFeatureChange(false);
        }
    }

    private void setValueToSpinner(double value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"change spinner");
        }
        if (!this.isSpinnerChangeLocked()) {
            this.jSpinner1.setValue(value);
        }
    }

    private LinearReferencedPointFeatureListener getFeatureListener() {
        return this.featureListener;
    }

    private void setFeatureListener(LinearReferencedPointFeatureListener featureListener) {
        this.featureListener = featureListener;
    }

    private void setValueToFeature(double value) {
        if (!this.isFeatureChangeLocked()) {
            LinearReferencedPointFeature pointFeature = this.getFeature();
            if (pointFeature != null) {
                Geometry routeGeometry = this.linearReferencingHelper.getGeometryFromRoute(this.linearReferencingHelper.getRouteBeanFromStationBean(this.cidsBean));
                pointFeature.setInfoFormat((Format)new DecimalFormat("###.00"));
                pointFeature.moveToPosition(value);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"there are no feature to move");
            }
        }
    }

    public Geometry updateGeometry() {
        try {
            Geometry geom = LinearReferencedPointFeature.getPointOnLine((double)this.linearReferencingHelper.getLinearValueFromStationBean(this.cidsBean), (Geometry)this.linearReferencingHelper.getRouteGeometryFromStationBean(this.cidsBean));
            geom.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
            this.linearReferencingHelper.setPointGeometryToStationBean(geom, this.getCidsBean());
            return geom;
        }
        catch (Exception ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"error while setting the station geometry", (Throwable)ex);
            }
            return null;
        }
    }

    public void setPointValue(double value) {
        block8: {
            CidsBean pointBean;
            double oldValue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("change bean value to " + value));
            }
            if ((oldValue = this.linearReferencingHelper.getLinearValueFromStationBean(pointBean = this.getCidsBean())) != value) {
                try {
                    if (!this.isFeatureChangeLocked()) {
                        // empty if block
                    }
                    if (!this.isBeanChangeLocked()) {
                        this.linearReferencingHelper.setLinearValueToStationBean(value, pointBean);
                    }
                    break block8;
                }
                catch (Exception ex) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"error changing bean", (Throwable)ex);
                    }
                    break block8;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("no changes needed, old value was " + oldValue));
            }
        }
    }

    private void setCidsBeanListener(PropertyChangeListener cidsBeanListener) {
        this.cidsBeanListener = cidsBeanListener;
    }

    public LinearReferencedPointFeature getFeature() {
        return (LinearReferencedPointFeature)FeatureRegistry.getInstance().getFeature(this.getCidsBean());
    }

    private boolean isSpinnerChangeLocked() {
        return this.isSpinnerChangeLocked;
    }

    private boolean isFeatureChangeLocked() {
        return this.isFeatureChangeLocked;
    }

    private boolean isBeanChangeLocked() {
        return this.isBeanChangeLocked;
    }

    private void lockSpinnerChange(boolean lock) {
        this.isSpinnerChangeLocked = lock;
    }

    private void lockFeatureChange(boolean lock) {
        this.isFeatureChangeLocked = lock;
    }

    public void dispose() {
        this.cleanup();
    }

    private boolean isInited() {
        return this.inited;
    }

    private void setInited(boolean inited) {
        this.inited = inited;
    }

    public String getOtherLinesFrom() {
        return this.otherLinesFrom;
    }

    public void setOtherLinesFrom(String otherLinesFrom) {
        this.otherLinesFrom = otherLinesFrom;
    }

    public String getOtherLinesQuery() {
        return this.otherLinesQuery;
    }

    public void setOtherLinesQuery(String otherLinesQuery) {
        this.otherLinesQuery = otherLinesQuery;
    }

    public FeatureServiceFeature getParentFeature() {
        return this.parentFeature;
    }

    public void setParentFeature(FeatureServiceFeature parentFeature) {
        this.parentFeature = parentFeature;
    }

    public String getStationProperty() {
        return this.stationProperty;
    }

    public void setStationProperty(String stationProperty) {
        this.stationProperty = stationProperty;
    }

    public Geometry getGeometry() {
        return this.linearReferencingHelper.getPointGeometryFromStationBean(this.cidsBean);
    }
}

