/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin;

import de.cismet.cismap.commons.util.DnDUtils;
import de.cismet.commons.cismap.io.AddGeometriesToMapWizardAction;
import de.cismet.tools.gui.menu.CidsUiComponent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URI;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;

public class AddGeomDnDButton
extends JButton
implements DropTargetListener,
CidsUiComponent {
    private final transient DropTarget dropTarget = new DropTarget(this, this);

    public AddGeomDnDButton() {
        this.setAction((Action)new AddGeometriesToMapWizardAction());
    }

    public AddGeometriesToMapWizardAction getAction() {
        return (AddGeometriesToMapWizardAction)super.getAction();
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || dtde.isDataFlavorSupported(DnDUtils.URI_LIST_FLAVOR) || dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            dtde.acceptDrag(3);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || dtde.isDataFlavorSupported(DnDUtils.URI_LIST_FLAVOR) || dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            dtde.acceptDrag(3);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
        if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || dtde.isDataFlavorSupported(DnDUtils.URI_LIST_FLAVOR) || dtde.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            dtde.acceptDrag(3);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            Object data;
            dtde.acceptDrop(3);
            boolean performAction = false;
            if (dtde.isDataFlavorSupported(DnDUtils.URI_LIST_FLAVOR)) {
                String uriList = (String)dtde.getTransferable().getTransferData(DnDUtils.URI_LIST_FLAVOR);
                String[] uris = uriList.split(System.getProperty("line.separator"));
                if (uris.length == 1) {
                    File file = new File(new URI(uris[0].replaceFirst("localhost", "")));
                    dtde.dropComplete(true);
                    this.getAction().setInputFile(file);
                    performAction = true;
                } else {
                    dtde.dropComplete(false);
                }
            } else if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                data = (List)dtde.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                if (data.size() == 1) {
                    File file = (File)data.get(0);
                    dtde.dropComplete(true);
                    this.getAction().setInputFile(file);
                    performAction = true;
                } else {
                    dtde.dropComplete(false);
                }
            } else {
                data = (String)dtde.getTransferable().getTransferData(DataFlavor.stringFlavor);
                dtde.dropComplete(true);
                this.getAction().setInputData((String)data);
                performAction = true;
            }
            if (performAction) {
                final ActionEvent ae = new ActionEvent(this, 1, "data_dnd");
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AddGeomDnDButton.this.getAction().actionPerformed(ae);
                    }
                });
            }
        }
        catch (Exception e) {
            dtde.dropComplete(false);
        }
    }

    public String getValue(String string) {
        return "AddGeomDnDButton";
    }

    public Component getComponent() {
        return this;
    }
}

