/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import org.apache.log4j.Logger;

public class BeanUpdatingCidsFeature
extends CidsFeature {
    String geoPropertyName;
    Geometry oldGeom = null;
    private final transient Logger log = Logger.getLogger(this.getClass());

    public BeanUpdatingCidsFeature(CidsBean cidsBean, String geoPropertyName) throws IllegalArgumentException {
        super(cidsBean.getMetaObject());
        this.geoPropertyName = geoPropertyName;
        this.oldGeom = cidsBean.getProperty(geoPropertyName) != null ? (Geometry)((Geometry)cidsBean.getProperty(geoPropertyName)).clone() : null;
    }

    public CidsBean getCidsBean() {
        return this.getMetaObject().getBean();
    }

    @Override
    public void setGeometry(Geometry geom) {
        super.setGeometry(geom);
        this.updateBeanGeometry();
    }

    public String getGeoPropertyName() {
        return this.geoPropertyName;
    }

    public void updateBeanGeometry() {
        try {
            Geometry geom = this.getGeometry();
            if (!(this.oldGeom == geom || this.oldGeom != null && this.oldGeom.equalsExact(geom))) {
                this.getCidsBean().setProperty(this.geoPropertyName, (Object)geom);
            }
        }
        catch (Exception e) {
            this.log.error((Object)"error while storing updated geometry in bean", (Throwable)e);
        }
    }
}

