/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.localserver.attribute.ClassAttribute;
import Sirius.server.localserver.attribute.ObjectAttribute;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.featurerenderer.CustomCidsFeatureRenderer;
import de.cismet.cids.featurerenderer.SubFeatureAwareFeatureRenderer;
import de.cismet.cids.utils.ClassloadingHelper;
import de.cismet.cids.utils.interfaces.CidsBeanAction;
import de.cismet.cids.utils.interfaces.CidsBeanActionsProvider;
import de.cismet.cismap.commons.Refreshable;
import de.cismet.cismap.commons.features.Bufferable;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureGroup;
import de.cismet.cismap.commons.features.FeatureGroups;
import de.cismet.cismap.commons.features.FeatureRenderer;
import de.cismet.cismap.commons.features.FeatureRendererAwareFeature;
import de.cismet.cismap.commons.features.Highlightable;
import de.cismet.cismap.commons.features.InfoNodeAwareFeature;
import de.cismet.cismap.commons.features.PureFeatureGroup;
import de.cismet.cismap.commons.features.RasterLayerSupportedFeature;
import de.cismet.cismap.commons.features.XStyledFeature;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.piccolo.FeatureAnnotationSymbol;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.raster.wms.featuresupportlayer.SimpleFeatureSupporterRasterServiceUrl;
import de.cismet.cismap.commons.rasterservice.FeatureAwareRasterService;
import de.cismet.commons.classloading.BlacklistClassloading;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Stroke;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class CidsFeature
implements XStyledFeature,
Highlightable,
Bufferable,
RasterLayerSupportedFeature,
FeatureGroup,
CidsBeanActionsProvider,
InfoNodeAwareFeature,
FeatureRendererAwareFeature,
ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(CidsFeature.class);
    private Paint featureFG = Color.black;
    private Paint featureBG = Color.gray;
    private float featureTranslucency = 0.5f;
    private float featureBorder = 10.0f;
    private String renderFeatureString = null;
    private String renderMultipleFeatures = null;
    private int renderAllFeatures = 1;
    private boolean hiding = false;
    private Geometry geom;
    private MetaObject mo;
    private MetaClass mc;
    private boolean editable = false;
    private String namenszusatz = "";
    private FeatureRenderer featureRenderer = null;
    private SubFeatureAwareFeatureRenderer parentFeatureRenderer = null;
    private FeatureAwareRasterService featureAwareRasterService = null;
    private String supportingRasterServiceRasterLayerName = null;
    private String supportingRasterServiceRasterLayerPrefix = null;
    private String supportingRasterServiceRasterLayerPostfix = null;
    private String supportingRasterServiceIdAttributeName = null;
    private String supportingRasterServiceLayerStyleName = "default";
    private Image pointSymbol = null;
    private double pointSymbolSweetSpotX = 0.0;
    private double pointSymbolSweetSpotY = 0.0;
    private final Collection<Feature> subFeatures = new ArrayList<Feature>();
    private FeatureGroup parentFeature = null;
    private String myAttributeStringInParentFeature = null;
    private Collection<CidsBeanAction> cidsBeanActions = new ArrayList<CidsBeanAction>();
    private boolean infoNodeEnabled = true;
    private final ConnectionContext connectionContext = ConnectionContext.createDummy();

    @Deprecated
    public CidsFeature(MetaObjectNode mon) throws IllegalArgumentException {
        this(mon.getObject());
    }

    public CidsFeature(MetaObject mo) throws IllegalArgumentException {
        this(mo, null, null);
    }

    public CidsFeature(MetaObject mo, ObjectAttribute oAttr) throws IllegalArgumentException {
        this(mo, oAttr != null ? oAttr.getMai().getFieldName() : null, null);
    }

    @Deprecated
    public CidsFeature(MetaObjectNode mon, ObjectAttribute oAttr) throws IllegalArgumentException {
        this(mon.getObject(), oAttr.getMai().getFieldName(), null);
    }

    private CidsFeature(MetaObject mo, SubFeatureAwareFeatureRenderer rootRenderer) {
        this(mo, null, rootRenderer);
    }

    private CidsFeature(MetaObject mo, String localRenderFeatureString, SubFeatureAwareFeatureRenderer rootRenderer) throws IllegalArgumentException {
        this.parentFeatureRenderer = rootRenderer;
        try {
            this.mo = mo;
            this.mc = SessionManager.getProxy().getMetaClass(mo.getClassKey(), this.getConnectionContext());
            this.initFeatureSettings();
            try {
                if (localRenderFeatureString != null) {
                    this.renderFeatureString = localRenderFeatureString;
                }
                if (this.renderFeatureString != null && !this.renderFeatureString.equals("")) {
                    String[] renderFeatures = this.renderFeatureString.split(",");
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("renderFeatures: " + Arrays.asList(renderFeatures)));
                    }
                    if (renderFeatures.length == 1) {
                        Object tester = mo.getBean().getProperty(this.renderFeatureString);
                        if (tester instanceof Collection) {
                            this.createSubFeatures(renderFeatures);
                        } else if (tester instanceof Geometry) {
                            this.geom = (Geometry)tester;
                        } else if (tester instanceof CidsBean) {
                            this.geom = this.searchGeometryInMetaObject(((CidsBean)tester).getMetaObject());
                        } else if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Wert in Attribut RENDER_FEATURE = " + this.renderFeatureString + " hat zu keinem Geometrieobjekt gefuehrt."));
                        }
                    } else {
                        this.createSubFeatures(renderFeatures);
                    }
                }
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("RENDER_FEATURE war fehlerhaft gesetzt. Geometrie unter Attribut mit dem Namen: " + this.renderFeatureString + " konnte nicht gefunden werden"), (Throwable)e);
                }
                this.geom = null;
            }
            if (this.geom == null) {
                this.geom = this.searchGeometryInMetaObject(mo);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error CidsFeature(MetaObjectNode mon)", (Throwable)e);
            throw new IllegalArgumentException("Error on creating a CidsFeatures", e);
        }
    }

    private Geometry searchGeometryInMetaObject(MetaObject mo) {
        Collection c = mo.getAttributesByType(Geometry.class, 1);
        Iterator iterator = c.iterator();
        if (iterator.hasNext()) {
            Object elem = iterator.next();
            ObjectAttribute oa = (ObjectAttribute)elem;
            return (Geometry)oa.getValue();
        }
        return null;
    }

    private void createSubFeatures(String[] renderFeatures) {
        SubFeatureAwareFeatureRenderer rootRenderer = this.parentFeatureRenderer;
        if (rootRenderer == null && this.featureRenderer instanceof SubFeatureAwareFeatureRenderer) {
            rootRenderer = (SubFeatureAwareFeatureRenderer)this.featureRenderer;
        }
        for (String renderFeature : renderFeatures) {
            CidsFeature result;
            renderFeature = renderFeature.trim();
            Object tester = this.mo.getBean().getProperty(renderFeature);
            if (tester instanceof Collection) {
                Collection cbc = (Collection)tester;
                PureFeatureGroup fg = new PureFeatureGroup();
                for (CidsBean cb : cbc) {
                    CidsFeature cf = new CidsFeature(cb.getMetaObject(), rootRenderer);
                    cf.setParentFeature(this);
                    cf.setMyAttributeStringInParentFeature(renderFeature);
                    fg.addFeature((Feature)cf);
                    cf.setInfoNodeEnabled(false);
                }
                fg.setParentFeature((FeatureGroup)this);
                fg.setMyAttributeStringInParentFeature(renderFeature);
                result = fg;
            } else {
                CidsFeature cf = new CidsFeature(this.getMetaObject(), renderFeature, rootRenderer);
                cf.setParentFeature(this);
                cf.setMyAttributeStringInParentFeature(renderFeature);
                cf.setInfoNodeEnabled(false);
                result = cf;
            }
            if (result.getGeometry() != null) {
                this.subFeatures.add((Feature)result);
                continue;
            }
            LOG.warn((Object)("Did not add Feature " + result + " because the geometry is null"));
        }
        this.geom = FeatureGroups.getEnclosingGeometry(this.subFeatures);
        this.hide(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("subFeatures: " + this.subFeatures));
        }
    }

    private void initFeatureSettings() {
        block67: {
            Constructor constructor;
            block66: {
                String s;
                int a;
                int b;
                int g;
                int r;
                String[] t;
                try {
                    if (CismapBroker.getInstance().getMappingComponent().getMappingModel() instanceof ActiveLayerModel && ((ActiveLayerModel)CismapBroker.getInstance().getMappingComponent().getMappingModel()).getSrs().getCode().equalsIgnoreCase("epsg:4326")) {
                        this.featureBorder = 0.001f;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.renderFeatureString = this.getAttribValue("RENDER_FEATURE", this.mo, this.mc).toString();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("RENDER_FEATURE=" + this.renderFeatureString));
                    }
                }
                catch (Exception t2) {
                    LOG.info((Object)"RENDER_FEATURE corrupt or missing", (Throwable)t2);
                }
                try {
                    this.renderMultipleFeatures = this.getAttribValue("RENDER_MULTIPLE_FEATURES", this.mo, this.mc).toString();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("RENDER_MULTIPLE_FEATURES=" + this.renderMultipleFeatures));
                    }
                }
                catch (Exception t3) {
                    LOG.info((Object)"RENDER_MULTIPLE_FEATURES corrupt or missing", (Throwable)t3);
                }
                try {
                    this.renderAllFeatures = new Integer(this.getAttribValue("RENDER_ALL_FEATURES", this.mo, this.mc).toString());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("renderAllFeatures=" + this.renderAllFeatures));
                    }
                }
                catch (Exception t4) {
                    LOG.info((Object)"RENDER_AKK_FEATURES corrupt or missing", (Throwable)t4);
                }
                try {
                    Object hideFeature = this.getAttribValue("HIDE_FEATURE", this.mo, this.mc);
                    this.hiding = hideFeature == null ? false : Boolean.valueOf(hideFeature.toString());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("HIDE_FEATURE=" + this.hiding));
                    }
                }
                catch (Exception e) {
                    LOG.info((Object)"HIDE_FEATURE corrupt or missing", (Throwable)e);
                }
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"VERSUCHE FEATURERENDERER ZU SETZEN");
                    }
                    Class clazz = ClassloadingHelper.getDynamicClass((MetaClass)this.mc, (ClassloadingHelper.CLASS_TYPE)ClassloadingHelper.CLASS_TYPE.FEATURE_RENDERER);
                    constructor = clazz.getConstructor(new Class[0]);
                    this.featureRenderer = (FeatureRenderer)constructor.newInstance(new Object[0]);
                    ((CustomCidsFeatureRenderer)this.featureRenderer).setMetaObject(this.mo);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("HAT GEKLAPPT:" + clazz));
                    }
                }
                catch (Exception t5) {
                    LOG.warn((Object)"FEATURE_RENDERER corrupt or missing", (Throwable)t5);
                }
                try {
                    float featureTranslucencyValue = new Float(this.getAttribValue("FEATURE_TRANSLUCENCY", this.mo, this.mc).toString()).floatValue();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("FEATURE_TRANSLUCENCY=" + featureTranslucencyValue));
                    }
                    this.featureTranslucency = featureTranslucencyValue;
                }
                catch (Exception t6) {
                    LOG.info((Object)"FEATURE_TRANSLUCENCY corrupt or missing", (Throwable)t6);
                }
                try {
                    this.setFeatureBorder(new Float(this.getAttribValue("FEATURE_BORDER", this.mo, this.mc).toString()).floatValue());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("featureBorder=" + this.featureBorder));
                    }
                }
                catch (Exception t7) {
                    LOG.info((Object)"FEATURE_BORDER corrupt or missing", (Throwable)t7);
                    try {
                        this.setFeatureBorder(new Float(this.getAttribValue("UMGEBUNG", this.mo, this.mc).toString()).floatValue());
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("featureBorder=" + this.featureBorder));
                        }
                    }
                    catch (Exception tt) {
                        LOG.info((Object)"UMGEBUNG corrupt or missing", (Throwable)tt);
                    }
                }
                try {
                    String fg = this.getAttribValue("FEATURE_FG", this.mo, this.mc).toString();
                    t = fg.split(",");
                    r = new Integer(t[0]);
                    g = new Integer(t[1]);
                    b = new Integer(t[2]);
                    if (t.length == 4) {
                        a = new Integer(t[3]);
                        this.featureFG = new Color(r, g, b, a);
                    } else {
                        this.featureFG = new Color(r, g, b);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("FEATURE_FG=Color(" + r + "," + g + "," + b + ")"));
                    }
                }
                catch (Exception t8) {
                    LOG.info((Object)"FEATURE_FG corrupt or missing", (Throwable)t8);
                }
                try {
                    s = this.getAttribValue("FEATURE_BG", this.mo, this.mc).toString();
                    t = s.split(",");
                    r = new Integer(t[0]);
                    g = new Integer(t[1]);
                    b = new Integer(t[2]);
                    if (t.length == 4) {
                        a = new Integer(t[3]);
                        this.featureBG = new Color(r, g, b, a);
                    } else {
                        this.featureBG = new Color(r, g, b);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("FEATURE_BG=Color(" + r + "," + g + "," + b + ")"));
                    }
                }
                catch (Exception t9) {
                    LOG.info((Object)"FEATURE_BG corrupt or missing", (Throwable)t9);
                }
                try {
                    s = this.getAttribValue("FEATURE_HIGH_FG", this.mo, this.mc).toString();
                    t = s.split(",");
                    r = new Integer(t[0]);
                    g = new Integer(t[1]);
                    b = new Integer(t[2]);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("FEATURE_HIGH_FG=Color(" + r + "," + g + "," + b + ")"));
                    }
                }
                catch (Exception t10) {
                    LOG.info((Object)"FEATURE_HIGH_FG corrupt or missing", (Throwable)t10);
                }
                try {
                    s = this.getAttribValue("FEATURE_HIGH_BG", this.mo, this.mc).toString();
                    t = s.split(",");
                    r = new Integer(t[0]);
                    g = new Integer(t[1]);
                    b = new Integer(t[2]);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("FEATURE_HIGH_BG=Color(" + r + "," + g + "," + b + ")"));
                    }
                }
                catch (Exception t11) {
                    LOG.info((Object)"FEATURE_HIGH_BG corrupt or missing", (Throwable)t11);
                }
                try {
                    String path = this.getAttribValue("FEATURE_POINT_SYMBOL", this.mo, this.mc).toString();
                    this.pointSymbol = new ImageIcon(this.getClass().getResource(path)).getImage();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("FEATURE_POINT_SYMBOL=" + path));
                    }
                }
                catch (Exception t12) {
                    LOG.info((Object)"FEATURE_POINT_SYMBOL Error", (Throwable)t12);
                }
                try {
                    String x = this.getAttribValue("FEATURE_POINT_SYMBOL_SWEETSPOT_X", this.mo, this.mc).toString();
                    this.pointSymbolSweetSpotX = new Double(x);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("FEATURE_POINT_SYMBOL_SWEETSPOT_X=" + x));
                    }
                }
                catch (Exception t13) {
                    LOG.info((Object)"FEATURE_POINT_SYMBOL_SWEETSPOT_X Error", (Throwable)t13);
                }
                try {
                    String y = this.getAttribValue("FEATURE_POINT_SYMBOL_SWEETSPOT_Y", this.mo, this.mc).toString();
                    this.pointSymbolSweetSpotY = new Double(y);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("FEATURE_POINT_SYMBOL_SWEETSPOT_Y=" + y));
                    }
                }
                catch (Exception t14) {
                    LOG.info((Object)"FEATURE_POINT_SYMBOL_SWEETSPOT_Y Error", (Throwable)t14);
                }
                try {
                    String supportingRasterService = String.valueOf(this.getAttribValue("FEATURESUPPORTINGRASTERSERVICE_TYPE", this.mo, this.mc));
                    String supportingRasterServiceUrl = (String)this.getAttribValue("FEATURESUPPORTINGRASTERSERVICE_SIMPLEURL", this.mo, this.mc);
                    this.supportingRasterServiceRasterLayerName = (String)this.getAttribValue("FEATURESUPPORTINGRASTERSERVICE_RASTERLAYER", this.mo, this.mc);
                    this.supportingRasterServiceRasterLayerPrefix = (String)this.getAttribValue("FEATURESUPPORTINGRASTERSERVICE_RASTERLAYERPREFIX", this.mo, this.mc);
                    this.supportingRasterServiceRasterLayerPostfix = (String)this.getAttribValue("FEATURESUPPORTINGRASTERSERVICE_RASTERLAYERPOSTFIX", this.mo, this.mc);
                    this.supportingRasterServiceIdAttributeName = (String)this.getAttribValue("FEATURESUPPORTINGRASTERSERVICE_ID_ATTRIBUTE", this.mo, this.mc);
                    String serviceName = (String)this.getAttribValue("FEATURESUPPORTINGRASTERSERVICE_NAME", this.mo, this.mc);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("FEATURESUPPORTINGRASTERSERVICE_TYPE=" + supportingRasterService));
                    }
                    Class c = BlacklistClassloading.forName((String)supportingRasterService);
                    if (supportingRasterServiceUrl != null) {
                        SimpleFeatureSupporterRasterServiceUrl url = new SimpleFeatureSupporterRasterServiceUrl(supportingRasterServiceUrl);
                        Constructor constructor2 = c.getConstructor(SimpleFeatureSupporterRasterServiceUrl.class);
                        this.featureAwareRasterService = (FeatureAwareRasterService)constructor2.newInstance(url);
                    } else {
                        Constructor constructor3 = c.getConstructor(new Class[0]);
                        this.featureAwareRasterService = (FeatureAwareRasterService)constructor3.newInstance(new Object[0]);
                    }
                    this.featureAwareRasterService.setName(serviceName);
                }
                catch (Exception t15) {
                    if (!LOG.isDebugEnabled()) break block66;
                    LOG.debug((Object)"Error while creating the FeaureSupportingRasterService, or it does not exist.", (Throwable)t15);
                }
            }
            try {
                Class clazz;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"VERSUCHE OBJECTACTIONSPROVIDER ZU SETZEN");
                }
                if ((clazz = ClassloadingHelper.getDynamicClass((MetaClass)this.mc, (ClassloadingHelper.CLASS_TYPE)ClassloadingHelper.CLASS_TYPE.ACTION_PROVIDER)) != null) {
                    constructor = clazz.getConstructor(new Class[0]);
                    CidsBeanActionsProvider provider = (CidsBeanActionsProvider)constructor.newInstance(new Object[0]);
                    this.cidsBeanActions = provider.getActions();
                    for (CidsBeanAction cba : this.cidsBeanActions) {
                        cba.setCidsBean(this.getMetaObject().getBean());
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("HAT GEKLAPPT:" + clazz));
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"ACTION_PROVIDER corrupt or missing");
                }
            }
            catch (Exception t) {
                if (!LOG.isDebugEnabled()) break block67;
                LOG.debug((Object)"ACTION_PROVIDER corrupt or missing", (Throwable)t);
            }
        }
    }

    private Object getAttribValue(String name, MetaObject mo, MetaClass mc) {
        if (name == null || mo == null || mc == null) {
            throw new IllegalArgumentException("no argument must be null");
        }
        Collection coa = mo.getAttributeByName(name, 1);
        Collection cca = mc.getAttributeByName(name);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("mc.getAttributeByName(" + name + ")=" + cca));
        }
        if (coa.size() == 1) {
            ObjectAttribute oa = (ObjectAttribute)coa.toArray()[0];
            return oa.getValue();
        }
        if (cca.size() > 0) {
            ClassAttribute ca = (ClassAttribute)cca.toArray()[0];
            return ca.getValue();
        }
        return null;
    }

    public void setGeometry(Geometry geom) {
        this.geom = geom;
    }

    public float getTransparency() {
        float transparency = -1.0f;
        if (this.parentFeatureRenderer != null) {
            transparency = this.parentFeatureRenderer.getTransparency(this);
        } else if (this.featureRenderer != null) {
            transparency = this.featureRenderer.getTransparency();
        }
        return transparency > 0.0f ? transparency : this.featureTranslucency;
    }

    public Stroke getLineStyle() {
        if (this.subFeatures.isEmpty()) {
            if (this.parentFeatureRenderer != null) {
                return this.parentFeatureRenderer.getLineStyle(this);
            }
            if (this.featureRenderer != null) {
                return this.featureRenderer.getLineStyle();
            }
        }
        return null;
    }

    public Paint getLinePaint() {
        if (this.subFeatures.isEmpty()) {
            if (this.parentFeatureRenderer != null) {
                return this.parentFeatureRenderer.getLinePaint(this);
            }
            if (this.featureRenderer != null && this.featureRenderer.getLinePaint() != null) {
                return this.featureRenderer.getLinePaint();
            }
            return this.featureFG;
        }
        return new Color(255, 255, 255, 0);
    }

    public Geometry getGeometry() {
        return this.geom;
    }

    public Paint getFillingPaint() {
        if (this.subFeatures.isEmpty()) {
            if (this.parentFeatureRenderer != null) {
                return this.parentFeatureRenderer.getFillingStyle(this);
            }
            if (this.featureRenderer != null && this.featureRenderer.getFillingStyle() != null) {
                return this.featureRenderer.getFillingStyle();
            }
            return this.featureBG;
        }
        return null;
    }

    public boolean canBeSelected() {
        return this.subFeatures.isEmpty();
    }

    public void setCanBeSelected(boolean canBeSelected) {
    }

    public void setHighlighting(boolean highlighting) {
    }

    public boolean getHighlighting() {
        return false;
    }

    public String getName() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getName() von " + this.mo));
        }
        try {
            if (this.featureRenderer instanceof CustomCidsFeatureRenderer && ((CustomCidsFeatureRenderer)this.featureRenderer).getAlternativeName() != null) {
                return ((CustomCidsFeatureRenderer)this.featureRenderer).getAlternativeName();
            }
            return this.mo.toString() + this.namenszusatz;
        }
        catch (Exception t) {
            LOG.info((Object)"Error while identifying the name.", (Throwable)t);
            return null;
        }
    }

    public JComponent getInfoComponent(Refreshable refresh) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"getInfoComponent");
        }
        if (this.parentFeatureRenderer != null) {
            return this.parentFeatureRenderer.getInfoComponent(refresh, this);
        }
        if (this.featureRenderer != null) {
            return this.featureRenderer.getInfoComponent(refresh);
        }
        return null;
    }

    public ImageIcon getIconImage() {
        ImageIcon ii = null;
        try {
            ii = new ImageIcon(this.mc.getObjectIconData());
        }
        catch (Exception t) {
            LOG.info((Object)"Error on reading icon data. Trying to load class icon.", (Throwable)t);
            try {
                ii = new ImageIcon(this.mc.getIconData());
            }
            catch (Exception tt) {
                LOG.info((Object)"Error on reading icon data.", (Throwable)tt);
                ii = null;
            }
            ii = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getIconImage:" + ii));
        }
        return ii;
    }

    public float getFeatureBorder() {
        return this.featureBorder;
    }

    public double getBuffer() {
        return this.featureBorder;
    }

    public void setFeatureBorder(float featureBorder) {
        this.featureBorder = featureBorder;
    }

    public String getType() {
        return this.mc.getName();
    }

    public boolean equals(Object o) {
        if (!(o instanceof CidsFeature)) {
            return false;
        }
        try {
            String thisString = this.mo.getID() + "@" + this.mo.getMetaClass().getID() + "(" + this.renderFeatureString + ")";
            CidsFeature that = (CidsFeature)o;
            String thatString = that.mo.getID() + "@" + that.mo.getMetaClass().getID() + "(" + that.renderFeatureString + ")";
            boolean parents = this.getParentFeature() == that.getParentFeature() ? true : (this.getParentFeature() == null ? false : this.getParentFeature().equals(that.getParentFeature()));
            return thisString.equals(thatString) && parents;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isEditable() {
        return this.editable && this.subFeatures.isEmpty();
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public int hashCode() {
        int retValue;
        if (this.mo != null) {
            String thisString = this.mo.getID() + "@" + this.mo.getMetaClass().getID() + "(" + this.renderFeatureString + ")";
            retValue = thisString.hashCode();
            if (this.getParentFeature() != null) {
                retValue += this.parentFeature.hashCode();
            }
        } else {
            retValue = super.hashCode();
        }
        return retValue;
    }

    public void hide(boolean hiding) {
        this.hiding = hiding;
    }

    public boolean isHidden() {
        return this.hiding;
    }

    public void setSupportingRasterService(FeatureAwareRasterService featureAwareRasterService) {
        this.featureAwareRasterService = featureAwareRasterService;
    }

    public FeatureAwareRasterService getSupportingRasterService() {
        return this.featureAwareRasterService;
    }

    public MetaObject getMetaObject() {
        return this.mo;
    }

    public MetaClass getMetaClass() {
        return this.mc;
    }

    public String getFilterPart() {
        ObjectAttribute oa = (ObjectAttribute)this.mo.getAttributeByName(this.supportingRasterServiceIdAttributeName, 1).toArray()[0];
        String id = oa.getValue().toString();
        return this.supportingRasterServiceRasterLayerName + "@" + id + "@" + this.supportingRasterServiceLayerStyleName + ",";
    }

    public String getSpecialLayerName() {
        if (this.supportingRasterServiceRasterLayerPrefix == null) {
            this.supportingRasterServiceRasterLayerPrefix = "";
        }
        if (this.supportingRasterServiceRasterLayerPostfix == null) {
            this.supportingRasterServiceRasterLayerPostfix = "";
        }
        if (this.supportingRasterServiceRasterLayerName != null && this.supportingRasterServiceRasterLayerName.startsWith("cidsAttribute::")) {
            try {
                String ret;
                String attrField = this.supportingRasterServiceRasterLayerName.substring("cidsAttribute::".length());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("FeatureSupportingRasterService:attrField:" + attrField));
                }
                return (ret = this.getMetaObject().getBean().getProperty(attrField).toString()) == null ? null : this.supportingRasterServiceRasterLayerPrefix + ret + this.supportingRasterServiceRasterLayerPostfix;
            }
            catch (Exception e) {
                LOG.error((Object)"AttrFieldProblem", (Throwable)e);
            }
        }
        return this.supportingRasterServiceRasterLayerName == null ? null : this.supportingRasterServiceRasterLayerPrefix + this.supportingRasterServiceRasterLayerName + this.supportingRasterServiceRasterLayerPostfix;
    }

    public Object clone() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"CLONE");
        }
        try {
            return super.clone();
        }
        catch (Exception e) {
            return null;
        }
    }

    public FeatureAnnotationSymbol getPointAnnotationSymbol() {
        if (this.parentFeatureRenderer != null) {
            return this.parentFeatureRenderer.getPointSymbol(this);
        }
        if (this.featureRenderer != null && this.featureRenderer.getPointSymbol() != null) {
            return this.featureRenderer.getPointSymbol();
        }
        if (this.pointSymbol != null) {
            FeatureAnnotationSymbol ret = new FeatureAnnotationSymbol(this.pointSymbol);
            ret.setSweetSpotX(this.pointSymbolSweetSpotX);
            ret.setSweetSpotY(this.pointSymbolSweetSpotY);
            return ret;
        }
        return null;
    }

    public int getLineWidth() {
        if (this.subFeatures.isEmpty()) {
            if (this.featureRenderer != null && this.featureRenderer.getLineStyle() != null && this.featureRenderer.getLineStyle() instanceof BasicStroke) {
                return (int)((BasicStroke)this.featureRenderer.getLineStyle()).getLineWidth();
            }
            return 1;
        }
        return 0;
    }

    public void setFillingPaint(Paint fillingStyle) {
    }

    public void setLineWidth(int width) {
    }

    public void setPointAnnotationSymbol(FeatureAnnotationSymbol featureAnnotationSymbol) {
    }

    public void setTransparency(float transparrency) {
        this.featureTranslucency = transparrency;
    }

    public boolean isHighlightingEnabled() {
        return true;
    }

    public void setHighlightingEnabled(boolean enabled) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setLinePaint(Paint linePaint) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public FeatureGroup getParentFeature() {
        return this.parentFeature;
    }

    public void setParentFeature(FeatureGroup parentFeature) {
        this.parentFeature = parentFeature;
    }

    public Collection<Feature> getSubFeatures() {
        return this.subFeatures;
    }

    public Collection<Feature> getFeatures() {
        return this.subFeatures;
    }

    public String getMyAttributeStringInParentFeature() {
        return this.myAttributeStringInParentFeature;
    }

    public void setMyAttributeStringInParentFeature(String myAttributeStringInParentFeature) {
        this.myAttributeStringInParentFeature = myAttributeStringInParentFeature;
    }

    public Iterator<Feature> iterator() {
        return this.subFeatures.iterator();
    }

    public boolean addFeature(Feature toAdd) {
        return this.subFeatures.add(toAdd);
    }

    public boolean addFeatures(Collection<? extends Feature> toAdd) {
        return this.subFeatures.addAll(toAdd);
    }

    public boolean removeFeature(Feature toRemove) {
        return this.subFeatures.remove(toRemove);
    }

    public boolean removeFeatures(Collection<? extends Feature> toRemove) {
        return this.subFeatures.removeAll(toRemove);
    }

    public FeatureRenderer getFeatureRenderer() {
        return this.featureRenderer;
    }

    public SubFeatureAwareFeatureRenderer getParentFeatureRenderer() {
        return this.parentFeatureRenderer;
    }

    public String toString() {
        return "CidsFeature<" + this.getMetaObject() + ">";
    }

    public Collection<CidsBeanAction> getActions() {
        return this.cidsBeanActions;
    }

    public void setInfoNodeEnabled(boolean infoNodeEnabled) {
        this.infoNodeEnabled = infoNodeEnabled;
    }

    public boolean hasInfoNode() {
        return this.infoNodeEnabled;
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }
}

