/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin;

import Sirius.navigator.ProxyCredentials;
import Sirius.navigator.connection.Connection;
import Sirius.navigator.connection.ConnectionFactory;
import Sirius.navigator.connection.ConnectionInfo;
import Sirius.navigator.connection.ConnectionSession;
import Sirius.navigator.connection.RESTfulConnection;
import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.connection.proxy.ConnectionProxy;
import Sirius.navigator.connection.proxy.DefaultConnectionProxyHandler;
import Sirius.navigator.plugin.context.PluginContext;
import Sirius.navigator.plugin.interfaces.FloatingPluginUI;
import Sirius.navigator.plugin.interfaces.PluginMethod;
import Sirius.navigator.plugin.interfaces.PluginProperties;
import Sirius.navigator.plugin.interfaces.PluginSupport;
import Sirius.navigator.plugin.interfaces.PluginUI;
import Sirius.navigator.plugin.listener.MetaNodeSelectionListener;
import Sirius.navigator.types.iterator.AttributeRestriction;
import Sirius.navigator.types.iterator.ComplexAttributeRestriction;
import Sirius.navigator.types.iterator.SingleAttributeIterator;
import Sirius.navigator.types.treenode.DefaultMetaTreeNode;
import Sirius.navigator.types.treenode.ObjectTreeNode;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.server.localserver.attribute.ObjectAttribute;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.middleware.types.MetaObjectNode;
import Sirius.server.newuser.User;
import Sirius.server.newuser.UserGroup;
import com.jgoodies.looks.HeaderStyle;
import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.RestrictedFileSystemView;
import de.cismet.cismap.commons.debug.DebugPanel;
import de.cismet.cismap.commons.drophandler.MappingComponentDropHandler;
import de.cismet.cismap.commons.drophandler.MappingComponentDropHandlerRegistry;
import de.cismet.cismap.commons.features.AbstractNewFeature;
import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.FeatureGroup;
import de.cismet.cismap.commons.features.FeatureGroups;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.ToolbarComponentDescription;
import de.cismet.cismap.commons.gui.ToolbarComponentsProvider;
import de.cismet.cismap.commons.gui.about.AboutDialog;
import de.cismet.cismap.commons.gui.capabilitywidget.CapabilityWidget;
import de.cismet.cismap.commons.gui.featurecontrolwidget.FeatureControl;
import de.cismet.cismap.commons.gui.featureinfowidget.FeatureInfoWidget;
import de.cismet.cismap.commons.gui.infowidgets.LayerInfo;
import de.cismet.cismap.commons.gui.infowidgets.Legend;
import de.cismet.cismap.commons.gui.infowidgets.ServerInfo;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.layerwidget.LayerDropUtils;
import de.cismet.cismap.commons.gui.layerwidget.LayerWidget;
import de.cismet.cismap.commons.gui.layerwidget.LayerWidgetProvider;
import de.cismet.cismap.commons.gui.options.CapabilityWidgetOptionsPanel;
import de.cismet.cismap.commons.gui.overviewwidget.OverviewComponent;
import de.cismet.cismap.commons.gui.piccolo.AngleMeasurementDialog;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateNewGeometryListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.SelectionListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.actions.CustomAction;
import de.cismet.cismap.commons.gui.printing.Scale;
import de.cismet.cismap.commons.gui.shapeexport.ShapeExport;
import de.cismet.cismap.commons.gui.statusbar.StatusBar;
import de.cismet.cismap.commons.interaction.ActiveLayerListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.CrsChangeListener;
import de.cismet.cismap.commons.interaction.MapBoundsListener;
import de.cismet.cismap.commons.interaction.MapDnDListener;
import de.cismet.cismap.commons.interaction.StatusListener;
import de.cismet.cismap.commons.interaction.events.MapDnDEvent;
import de.cismet.cismap.commons.interaction.events.StatusEvent;
import de.cismet.cismap.commons.rasterservice.georeferencing.RasterGeoReferencingBackend;
import de.cismet.cismap.commons.util.DnDUtils;
import de.cismet.cismap.commons.wfsforms.AbstractWFSForm;
import de.cismet.cismap.commons.wfsforms.WFSFormFactory;
import de.cismet.cismap.navigatorplugin.AddGeomDnDButton;
import de.cismet.cismap.navigatorplugin.CidsFeature;
import de.cismet.cismap.navigatorplugin.ConfigProperties;
import de.cismet.cismap.navigatorplugin.GeoSelectionButton;
import de.cismet.cismap.navigatorplugin.GotoPointDialog;
import de.cismet.cismap.navigatorplugin.MapExportPanel;
import de.cismet.cismap.navigatorplugin.MapVisualisationProvider;
import de.cismet.cismap.navigatorplugin.MetaSearchHelper;
import de.cismet.cismap.navigatorplugin.ShowObjectsWaitDialog;
import de.cismet.cismap.navigatorplugin.export_map_actions.ExportGeoPointToClipboardAction;
import de.cismet.cismap.navigatorplugin.export_map_actions.ExportMapToClipboardAction;
import de.cismet.cismap.navigatorplugin.export_map_actions.ExportMapToFileAction;
import de.cismet.commons.cismap.io.AddGeometriesToMapWizardAction;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.connectioncontext.ConnectionContextStore;
import de.cismet.ext.CExtContext;
import de.cismet.ext.CExtManager;
import de.cismet.lookupoptions.gui.OptionsClient;
import de.cismet.lookupoptions.gui.OptionsDialog;
import de.cismet.netutil.Proxy;
import de.cismet.netutil.ProxyHandler;
import de.cismet.tools.BrowserLauncher;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.CurrentStackTrace;
import de.cismet.tools.JnlpSystemPropertyHelper;
import de.cismet.tools.JnlpTools;
import de.cismet.tools.Static2DTools;
import de.cismet.tools.StaticDebuggingTools;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.ConfigurationManager;
import de.cismet.tools.gui.BasicGuiComponentProvider;
import de.cismet.tools.gui.CheckThreadViolationRepaintManager;
import de.cismet.tools.gui.CustomButtonProvider;
import de.cismet.tools.gui.EventDispatchThreadHangMonitor;
import de.cismet.tools.gui.JPopupMenuButton;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.DownloadManagerAction;
import de.cismet.tools.gui.historybutton.HistoryModel;
import de.cismet.tools.gui.historybutton.HistoryModelListener;
import de.cismet.tools.gui.historybutton.JHistoryButton;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import edu.umd.cs.piccolo.PCanvas;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.RepaintManager;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.SplitWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.View;
import net.infonode.docking.mouse.DockingWindowActionMouseButtonListener;
import net.infonode.docking.properties.RootWindowProperties;
import net.infonode.docking.theme.ShapedGradientDockingTheme;
import net.infonode.docking.util.AbstractViewMap;
import net.infonode.docking.util.DockingUtil;
import net.infonode.docking.util.PropertiesUtil;
import net.infonode.docking.util.StringViewMap;
import net.infonode.gui.componentpainter.AlphaGradientComponentPainter;
import net.infonode.gui.componentpainter.ComponentPainter;
import net.infonode.util.Direction;
import org.apache.commons.collections.MultiHashMap;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CismapPlugin
extends JFrame
implements PluginSupport,
Observer,
FloatingPluginUI,
Configurable,
MapDnDListener,
StatusListener,
HistoryModelListener,
FeatureCollectionListener,
ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(CismapPlugin.class);
    public static final String DEFAULT_LOCAL_LAYOUT = "/defaultCismap.layout";
    private static final String DEFAULT_LOCAL_LAYOUT_LANGUAGE = "/defaultCismap_" + System.getProperty("user.language") + ".layout";
    private static final String DEFAULT_LOCAL_LAYOUT_LANGUAGE_COUNTRY = "/defaultCismap_" + System.getProperty("user.language") + "_" + System.getProperty("user.country") + ".layout";
    int httpInterfacePort = 9098;
    boolean nodeSelectionEventBlocker = false;
    boolean featureCollectionEventBlocker = false;
    DataFlavor fromCapabilityWidget = new DataFlavor("application/x-java-jvm-local-objectref", "SelectionAndCapabilities");
    DataFlavor fromNavigatorNode = new DataFlavor("application/x-java-jvm-local-objectref;class=" + DefaultMetaTreeNode.class.getName(), "a DefaultMetaTreeNode");
    DataFlavor fromNavigatorCollection = new DataFlavor("application/x-java-jvm-local-objectref;class=" + Collection.class.getName(), "a java.util.Collection of Sirius.navigator.types.treenode.DefaultMetaTreeNode objects");
    BoundingBox buffer;
    private MappingComponent mapC;
    private LayerWidget activeLayers;
    private CapabilityWidget capabilities;
    private StatusBar statusBar;
    private Legend legend;
    private ServerInfo serverInfo;
    private LayerInfo layerInfo;
    private FeatureInfoWidget featureInfo;
    private FeatureControl featureControl;
    private DebugPanel debugPanel;
    private ShapeExport shapeExport;
    private View vLayers;
    private View vCaps;
    private View vServerInfo;
    private View vLayerInfo;
    private View vMap;
    private View vLegend;
    private View vFeatureInfo;
    private View vFeatureControl;
    private View vOverview;
    private RootWindow rootWindow;
    private final StringViewMap viewMap = new StringViewMap();
    private final Map<String, JMenuItem> viewMenuMap = new HashMap<String, JMenuItem>();
    private final ConfigurationManager configurationManager = new ConfigurationManager();
    private final ShowObjectsMethod showObjectsMethod = new ShowObjectsMethod();
    private final ResetLayoutMethod resetLayoutMethod = new ResetLayoutMethod();
    private final Map<String, PluginMethod> pluginMethods = new HashMap<String, PluginMethod>();
    private final MyPluginProperties myPluginProperties = new MyPluginProperties();
    private final List<JMenuItem> menues = new ArrayList<JMenuItem>();
    private final Map<DefaultMetaTreeNode, Feature> featuresInMap = new HashMap<DefaultMetaTreeNode, Feature>();
    private final Map<Feature, DefaultMetaTreeNode> featuresInMapReverse = new HashMap<Feature, DefaultMetaTreeNode>();
    private WFSFormFactory wfsFormFactory;
    private final Set<View> wfsFormViews = new HashSet<View>();
    private final List<View> wfs = new ArrayList<View>();
    private DockingWindow[] wfsViews;
    private DockingWindow[] legendTab = new DockingWindow[3];
    private PluginContext context;
    private boolean plugin = false;
    private String home = System.getProperty("user.home");
    private String fs = System.getProperty("file.separator");
    private String standaloneLayoutName = "cismap.layout";
    private String pluginLayoutName = "plugin.layout";
    private ShowObjectsWaitDialog showObjectsWaitDialog;
    private String cismapDirectory = this.home + this.fs + ".cismap";
    private ImageIcon miniBack = new ImageIcon(this.getClass().getResource("/images/miniBack.png"));
    private ImageIcon miniForward = new ImageIcon(this.getClass().getResource("/images/miniForward.png"));
    private ImageIcon current = new ImageIcon(this.getClass().getResource("/images/current.png"));
    private ImageIcon logo = new ImageIcon(this.getClass().getResource("/images/cismetlogo16.png"));
    private String helpUrl = null;
    private String newsUrl = null;
    private AboutDialog about;
    private OverviewComponent overviewComponent = null;
    private Dimension oldWindowDimension = new Dimension(-1, -1);
    private int oldWindowPositionX = -1;
    private int oldWindowPositionY = -1;
    private String dirExtension = "";
    private Element cismapPluginUIPreferences;
    private List<String> windows2skip;
    private final transient Map<BasicGuiComponentProvider, DockingWindow> extensionWindows;
    private MetaSearchHelper metaSearchComponentFactory;
    private WindowAdapter loadLayoutWhenOpenedAdapter = null;
    private final ConnectionContext connectionContext = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.OTHER, (String)this.getClass().getSimpleName());
    private JButton btnAddGeometryWizard;
    private JButton cmdBack;
    private MapExportPanel cmdClipboard;
    private JButton cmdDownloads;
    private JToggleButton cmdFeatureInfo;
    private JButton cmdForward;
    private ButtonGroup cmdGroupNodes;
    private ButtonGroup cmdGroupPrimaryInteractionMode;
    private JButton cmdHome;
    private JToggleButton cmdMoveGeometry;
    private JToggleButton cmdNewLinearReferencing;
    private JToggleButton cmdNewLinestring;
    private JToggleButton cmdNewPoint;
    private JToggleButton cmdNewPolygon;
    private JToggleButton cmdNodeAdd;
    private JToggleButton cmdNodeMove;
    private JToggleButton cmdNodeReflectGeometry;
    private JToggleButton cmdNodeRemove;
    private JToggleButton cmdNodeRotateGeometry;
    private JToggleButton cmdPan;
    private JButton cmdPluginSearch;
    private JButton cmdPrint;
    private JButton cmdReconfig;
    private JButton cmdRedo;
    private JButton cmdRefresh;
    private JToggleButton cmdRemoveGeometry;
    private JButton cmdSelect;
    private JToggleButton cmdSelectSingle;
    private JToggleButton cmdSnap;
    private JButton cmdUndo;
    private JToggleButton cmdZoom;
    private JSeparator jSeparator1;
    private JSeparator jSeparator10;
    private JSeparator jSeparator11;
    private JPopupMenu.Separator jSeparator12;
    private JSeparator jSeparator13;
    private JSeparator jSeparator14;
    private JSeparator jSeparator15;
    private JSeparator jSeparator16;
    private JPopupMenu.Separator jSeparator17;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JSeparator jSeparator9;
    private JMenu menBookmarks;
    private JMenu menEdit;
    private JMenu menExtras;
    private JMenu menFile;
    private JMenu menHelp;
    private JMenu menHistory;
    private JMenu menSearch;
    private JMenu menWindows;
    private JMenuItem mniAddBookmark;
    private JMenuItem mniAngleMeasurement;
    private JMenuItem mniAppendConfig;
    private JMenuItem mniBack;
    private JMenuItem mniBookmarkManager;
    private JMenuItem mniBookmarkSidebar;
    private JMenuItem mniBufferSelectedGeom;
    private JMenuItem mniCapabilities;
    private JMenuItem mniClipboard;
    private JMenuItem mniClose;
    private JMenuItem mniFeatureControl;
    private JMenuItem mniFeatureInfo;
    private JMenuItem mniForward;
    private JMenuItem mniGeoLinkClipboard;
    private JMenuItem mniGotoPoint;
    private JMenuItem mniHistorySidebar;
    private JMenuItem mniHome;
    private JMenuItem mniLayer;
    private JMenuItem mniLayerInfo;
    private JMenuItem mniLegend;
    private JMenuItem mniLoadConfig;
    private JMenuItem mniLoadConfigFromServer;
    private JMenuItem mniLoadLayout;
    private JMenuItem mniLoadShape;
    private JMenuItem mniMap;
    private JMenuItem mniMapToFile;
    private JMenuItem mniNews;
    private JMenuItem mniOnlineHelp;
    private JMenuItem mniOptions;
    private JMenuItem mniOverview;
    private JMenuItem mniPrint;
    private JMenuItem mniRefresh;
    private JMenuItem mniRemoveAllObjects;
    private JMenuItem mniRemoveSelectedObject;
    private JMenuItem mniResetWindowLayout;
    private JMenuItem mniSaveConfig;
    private JMenuItem mniSaveLayout;
    private JMenuItem mniScale;
    private JMenuItem mniServerInfo;
    private JMenuItem mniZoomToAllObjects;
    private JMenuItem mniZoomToSelectedObjects;
    private JMenuBar mnuBar;
    private JMenuItem mnuConfigServer;
    private JPanel panAll;
    private JPanel panMain;
    private JPanel panStatus;
    private JPanel panToolbar;
    private JPopupMenu popMen;
    private JSeparator sepAfterPos;
    private JSeparator sepBeforePos;
    private JSeparator sepResetWindowLayout;
    private JSeparator sepServerProfilesEnd;
    private JSeparator sepServerProfilesStart;
    private JToolBar tlbMain;
    private JToggleButton togInvisible;

    public CismapPlugin(PluginContext context) {
        this(null, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CismapPlugin(String config, PluginContext context) {
        Object fallBackConfig;
        this.extensionWindows = new HashMap<BasicGuiComponentProvider, DockingWindow>(1);
        if (StaticDebuggingTools.checkHomeForFile((String)"cismetCheckForEDThreadVialoation")) {
            RepaintManager.setCurrentManager((RepaintManager)new CheckThreadViolationRepaintManager());
        }
        try {
            JnlpTools.adjustDefaultLocale();
            System.out.println("Using default Locale: " + Locale.getDefault());
        }
        catch (SecurityException e) {
            System.err.println("You have insufficient rights to set the default locale.");
        }
        try {
            String ext = JnlpSystemPropertyHelper.getProperty((String)"directory.extension");
            System.out.println("SystemdirExtension=:" + ext);
            if (ext != null) {
                this.dirExtension = ext;
                this.cismapDirectory = this.cismapDirectory + ext;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while adding DirectoryExtension");
        }
        CismapBroker.getInstance().setCismapFolderPath(this.cismapDirectory);
        this.setIconImage(this.logo.getImage());
        this.context = context;
        boolean bl = this.plugin = context != null;
        if (!this.plugin) {
            StaticSwingTools.tweakUI();
        }
        try {
            Collection guiCompProviders;
            if (this.plugin && context.getEnvironment() != null && this.context.getEnvironment().isProgressObservable()) {
                this.context.getEnvironment().getProgressObserver().setProgress(0, NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.CismapPlugin(PluginContext).initializingCismapPlugin"));
            }
            if (!this.plugin) {
                try {
                    try (InputStream configStream = this.getClass().getResourceAsStream("/cismap.log4j.xml");){
                        ConfigurationSource source = new ConfigurationSource(configStream);
                        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
                        ctx.start((Configuration)new XmlConfiguration(ctx, source));
                    }
                    if (StaticDebuggingTools.checkHomeForFile((String)"cismetDebuggingInitEventDispatchThreadHangMonitor")) {
                        EventDispatchThreadHangMonitor.initMonitoring();
                    }
                    if (StaticDebuggingTools.checkHomeForFile((String)"cismetCheckForEDThreadVialoation")) {
                        RepaintManager.setCurrentManager((RepaintManager)new CheckThreadViolationRepaintManager());
                    }
                }
                catch (Exception e) {
                    System.err.println("LOG4J is not configured propperly\n\n");
                    e.printStackTrace();
                }
            }
            if (config != null) {
                CismapPlugin.initConnection(ConfigProperties.getInstance().load(config), this.getConnectionContext());
                ProxyCredentials.initFromConfAttr((String)"proxy.credentials", (ConnectionContext)this.getConnectionContext());
            }
            try {
                UIManager.setLookAndFeel((LookAndFeel)new Plastic3DLookAndFeel());
            }
            catch (Exception e) {
                LOG.warn((Object)"Error while creating Look&Feel!", (Throwable)e);
            }
            this.showObjectsWaitDialog = new ShowObjectsWaitDialog((Frame)this, false);
            if (this.plugin && context.getEnvironment() != null && this.context.getEnvironment().isProgressObservable()) {
                this.context.getEnvironment().getProgressObserver().setProgress(100, NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.CismapPlugin(PluginContext).createWidgets"));
            }
            this.serverInfo = new ServerInfo();
            this.layerInfo = new LayerInfo();
            this.mapC = new MappingComponent(true);
            CismapBroker.getInstance().addCrsChangeListener((CrsChangeListener)this.mapC);
            this.mapC.addHistoryModelListener((HistoryModelListener)this);
            this.activeLayers = new LayerWidget(this.mapC);
            this.activeLayers.setPreferredSize(new Dimension(100, 120));
            this.legend = new Legend();
            this.statusBar = new StatusBar(this.mapC);
            this.featureInfo = new FeatureInfoWidget();
            this.capabilities = new CapabilityWidget();
            CapabilityWidgetOptionsPanel.setCapabilityWidget((CapabilityWidget)this.capabilities);
            this.featureControl = new FeatureControl(this.mapC);
            this.debugPanel = new DebugPanel();
            this.debugPanel.setPCanvas((PCanvas)this.mapC);
            this.shapeExport = new ShapeExport();
            this.wfsFormFactory = WFSFormFactory.getInstance((MappingComponent)this.mapC);
            this.overviewComponent = new OverviewComponent();
            this.overviewComponent.setMasterMap(this.mapC);
            this.metaSearchComponentFactory = MetaSearchHelper.createNewInstance(this.plugin, "SEARCH_POLYGON", this.mapC, null, this.getConnectionContext());
            if (this.plugin && context.getEnvironment() != null && this.context.getEnvironment().isProgressObservable()) {
                this.context.getEnvironment().getProgressObserver().setProgress(200, NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.CismapPlugin(PluginContext).initializingGUI"));
            }
            try {
                this.initComponents();
            }
            catch (Exception e) {
                LOG.fatal((Object)"Error in initComponents.", (Throwable)e);
            }
            this.mapC.setInteractionButtonGroup(this.cmdGroupPrimaryInteractionMode);
            if (!this.plugin) {
                this.menSearch.setVisible(false);
                this.cmdPluginSearch.setVisible(false);
                KeyStroke configLoggerKeyStroke = KeyStroke.getKeyStroke(76, 3);
                AbstractAction configAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Log4JQuickConfig.getSingletonInstance().setVisible(true);
                            }
                        });
                    }
                };
                this.getRootPane().getInputMap(2).put(configLoggerKeyStroke, "CONFIGLOGGING");
                this.getRootPane().getActionMap().put("CONFIGLOGGING", configAction);
            }
            if (this.plugin) {
                this.menExtras.remove(this.mniOptions);
                this.menExtras.remove(this.jSeparator16);
            }
            this.menues.add(this.menFile);
            this.menues.add(this.menEdit);
            this.menues.add(this.menHistory);
            this.menues.add(this.menSearch);
            this.menues.add(this.menBookmarks);
            this.menues.add(this.menExtras);
            this.menues.add(this.menWindows);
            this.menues.add(this.menHelp);
            this.panStatus.add((Component)this.statusBar, "Center");
            this.tlbMain.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
            this.tlbMain.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
            this.tlbMain.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
            if (this.plugin) {
                this.tlbMain.remove(this.cmdDownloads);
            }
            if (this.plugin && context.getEnvironment() != null && this.context.getEnvironment().isProgressObservable()) {
                this.context.getEnvironment().getProgressObserver().setProgress(300, NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.CismapPlugin(PluginContext).connectingWidgets"));
            }
            ((JHistoryButton)this.cmdForward).setDirection(1);
            ((JHistoryButton)this.cmdBack).setDirection(2);
            ((JHistoryButton)this.cmdForward).setHistoryModel((HistoryModel)this.mapC);
            ((JHistoryButton)this.cmdBack).setHistoryModel((HistoryModel)this.mapC);
            CismapBroker.getInstance().addActiveLayerListener((ActiveLayerListener)RasterGeoReferencingBackend.getInstance().getActiveLayerListenerHandler());
            CismapBroker.getInstance().addMapDnDListener((MapDnDListener)this);
            CismapBroker.getInstance().addStatusListener((StatusListener)this);
            this.mapC.getFeatureCollection().addFeatureCollectionListener((FeatureCollectionListener)this.featureControl);
            this.mapC.getFeatureCollection().addFeatureCollectionListener((FeatureCollectionListener)this.statusBar);
            CismapBroker.getInstance().addMapBoundsListener((MapBoundsListener)this.featureControl);
            CismapBroker.getInstance().addMapBoundsListener((MapBoundsListener)this.capabilities);
            CismapBroker.getInstance().setMappingComponent(this.mapC);
            String cismapconfig = null;
            fallBackConfig = null;
            try {
                UserGroup group;
                Object groups;
                Iterator onlyOne;
                User user = SessionManager.getSession().getUser();
                UserGroup userGroup = user.getUserGroup();
                String prefix = "cismapconfig:";
                String username = user.getName();
                if (userGroup != null) {
                    onlyOne = new ArrayList<UserGroup>();
                    ((ArrayList)((Object)onlyOne)).add(userGroup);
                    groups = onlyOne;
                } else {
                    groups = user.getPotentialUserGroups();
                }
                if (cismapconfig == null) {
                    onlyOne = groups.iterator();
                    while (onlyOne.hasNext()) {
                        group = (UserGroup)onlyOne.next();
                        cismapconfig = context.getEnvironment().getParameter("cismapconfig:" + username + "@" + group.getName() + "@" + group.getDomain());
                        if (cismapconfig == null) continue;
                        break;
                    }
                }
                if (cismapconfig == null) {
                    onlyOne = groups.iterator();
                    while (onlyOne.hasNext()) {
                        group = (UserGroup)onlyOne.next();
                        cismapconfig = context.getEnvironment().getParameter("cismapconfig:*@" + group.getName() + "@" + group.getDomain());
                        if (cismapconfig == null) continue;
                        break;
                    }
                }
                if (cismapconfig == null) {
                    onlyOne = groups.iterator();
                    while (onlyOne.hasNext()) {
                        group = (UserGroup)onlyOne.next();
                        cismapconfig = context.getEnvironment().getParameter("cismapconfig:*@*@" + group.getDomain());
                        if (cismapconfig == null) continue;
                        break;
                    }
                }
                if (cismapconfig == null) {
                    cismapconfig = context.getEnvironment().getParameter("cismapconfig:default");
                }
                fallBackConfig = context.getEnvironment().getParameter("cismapconfig:default");
            }
            catch (Exception e) {
                LOG.info((Object)"cismap started standalone", (Throwable)e);
            }
            if (cismapconfig == null) {
                cismapconfig = "defaultCismapProperties.xml";
            }
            if (fallBackConfig == null) {
                fallBackConfig = "defaultCismapProperties.xml";
            }
            LOG.info((Object)("ServerConfigFile=" + cismapconfig));
            this.configurationManager.setDefaultFileName(cismapconfig);
            this.configurationManager.setFallBackFileName((String)fallBackConfig);
            if (!this.plugin) {
                this.configurationManager.setFileName("configuration.xml");
            } else {
                this.configurationManager.setFileName("configurationPlugin.xml");
                this.configurationManager.addConfigurable((Configurable)this.metaSearchComponentFactory);
            }
            this.configurationManager.setClassPathFolder("/");
            this.configurationManager.setFolder(".cismap" + this.dirExtension);
            this.configurationManager.addConfigurable((Configurable)this);
            this.configurationManager.addConfigurable((Configurable)this.mapC);
            this.configurationManager.addConfigurable((Configurable)this.capabilities);
            this.configurationManager.addConfigurable((Configurable)this.wfsFormFactory);
            this.configurationManager.addConfigurable((Configurable)this.activeLayers);
            this.configurationManager.addConfigurable((Configurable)this.featureControl);
            this.configurationManager.addConfigurable((Configurable)this.overviewComponent);
            this.configurationManager.addConfigurable((Configurable)this.shapeExport);
            this.configurationManager.addConfigurable((Configurable)this.btnAddGeometryWizard.getAction());
            this.configurationManager.addConfigurable((Configurable)this.cmdClipboard);
            if (!this.plugin) {
                this.configurationManager.addConfigurable((Configurable)OptionsClient.getInstance());
            }
            if (this.plugin && context.getEnvironment() != null && this.context.getEnvironment().isProgressObservable()) {
                this.context.getEnvironment().getProgressObserver().setProgress(400, NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.CismapPlugin(PluginContext).initializingDockingsystem"));
            }
            ImageIcon icoLayers = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/raster/wms/res/layers.png"));
            ImageIcon icoServer = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/raster/wms/res/server.png"));
            ImageIcon icoServerInfo = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/capabilitywidget/res/serverInfo.png"));
            ImageIcon icoLayerInfo = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/capabilitywidget/res/layerInfo.png"));
            ImageIcon icoFeatureInfo = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/featureinfowidget/res/featureInfo16.png"));
            ImageIcon icoLegend = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/navigatorplugin/res/legend.png"));
            ImageIcon icoMap = new ImageIcon(this.getClass().getResource("/de/cismet/cismap/navigatorplugin/map.png"));
            ImageIcon icoFeatureControl = new ImageIcon(this.getClass().getResource("/images/objects.png"));
            this.rootWindow = DockingUtil.createRootWindow((AbstractViewMap)this.viewMap, (boolean)true);
            this.vMap = new View(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.CismapPlugin(PluginContext).vMap.title"), Static2DTools.borderIcon((Icon)icoMap, (int)0, (int)3, (int)0, (int)1), (Component)this.mapC);
            this.viewMap.addView("map", this.vMap);
            this.viewMenuMap.put("map", this.mniMap);
            this.vLayers = new View(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.CismapPlugin(PluginContext).vLayer.title"), Static2DTools.borderIcon((Icon)icoLayers, (int)0, (int)3, (int)0, (int)1), (Component)this.activeLayers);
            this.viewMap.addView("activeLayers", this.vLayers);
            this.viewMenuMap.put("activeLayers", this.mniLayer);
            this.vCaps = new View(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.CismapPlugin(PluginContext).vCapabilities.title"), Static2DTools.borderIcon((Icon)icoServer, (int)0, (int)3, (int)0, (int)1), (Component)this.capabilities);
            this.viewMap.addView("capabilities", this.vCaps);
            this.viewMenuMap.put("capabilities", this.mniCapabilities);
            this.vServerInfo = new View(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.CismapPlugin(PluginContext).vServerInfo.title"), Static2DTools.borderIcon((Icon)icoServerInfo, (int)0, (int)3, (int)0, (int)1), (Component)this.serverInfo);
            this.viewMap.addView("serverinfo", this.vServerInfo);
            this.viewMenuMap.put("serverinfo", this.mniServerInfo);
            this.vOverview = new View(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.CismapPlugin(PluginContext).vOverview.title"), Static2DTools.borderIcon((Icon)icoMap, (int)0, (int)3, (int)0, (int)1), (Component)this.overviewComponent);
            this.viewMap.addView("overview", this.vOverview);
            this.viewMenuMap.put("overview", this.mniOverview);
            this.legendTab[1] = this.vOverview;
            this.vLayerInfo = new View(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.CismapPlugin(PluginContext).vLayerInfo.title"), Static2DTools.borderIcon((Icon)icoLayerInfo, (int)0, (int)3, (int)0, (int)1), (Component)this.layerInfo);
            this.viewMap.addView("layerinfo", this.vLayerInfo);
            this.viewMenuMap.put("layerinfo", this.mniLayerInfo);
            this.legendTab[2] = this.vLayerInfo;
            this.vLegend = new View(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.CismapPlugin(PluginContext).vLegende.title"), Static2DTools.borderIcon((Icon)icoLegend, (int)0, (int)3, (int)0, (int)1), (Component)this.legend);
            this.viewMap.addView("legend", this.vLegend);
            this.viewMenuMap.put("legend", this.mniLegend);
            this.vFeatureInfo = new View(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.CismapPlugin(PluginContext).vFeatureInfo.title"), Static2DTools.borderIcon((Icon)icoFeatureInfo, (int)0, (int)3, (int)0, (int)1), (Component)this.featureInfo);
            this.viewMap.addView("featureInfo", this.vFeatureInfo);
            this.viewMenuMap.put("featureInfo", this.mniFeatureInfo);
            this.vFeatureControl = new View(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.CismapPlugin(PluginContext).vFeatureControl.title"), Static2DTools.borderIcon((Icon)icoFeatureControl, (int)0, (int)3, (int)0, (int)1), (Component)this.featureControl);
            this.viewMap.addView("featureControl", this.vFeatureControl);
            this.viewMenuMap.put("featureControl", this.mniFeatureControl);
            this.configurationManager.configure((Configurable)this.wfsFormFactory);
            Set keySet = this.wfsFormFactory.getForms().keySet();
            JMenu wfsFormsMenu = new JMenu(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.CismapPlugin(PluginContext).wfsFormMenu.title"));
            for (String key : keySet) {
                AbstractWFSForm form = (AbstractWFSForm)this.wfsFormFactory.getForms().get(key);
                form.setMappingComponent(this.mapC);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("WFSForms: key,form" + key + "," + form));
                }
                final View formView = new View(form.getTitle(), Static2DTools.borderIcon((Icon)form.getIcon(), (int)0, (int)3, (int)0, (int)1), (Component)form);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("WFSForms: formView" + formView));
                }
                this.viewMap.addView(form.getId(), formView);
                this.wfsFormViews.add(formView);
                this.wfs.add(formView);
                JMenuItem menuItem = new JMenuItem(form.getMenuString());
                menuItem.setIcon(form.getIcon());
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("showOrHideView:" + formView));
                        }
                        CismapPlugin.this.showOrHideView(formView);
                    }
                });
                wfsFormsMenu.add(menuItem);
            }
            this.wfsViews = new DockingWindow[this.wfsFormViews.size()];
            for (int i = 0; i < this.wfsViews.length; ++i) {
                this.wfsViews[i] = (DockingWindow)this.wfs.get(i);
            }
            if (keySet.size() > 0) {
                this.menues.remove(this.menHelp);
                this.menues.add(wfsFormsMenu);
                this.menues.add(this.menHelp);
                this.mnuBar.remove(this.menHelp);
                this.mnuBar.add(wfsFormsMenu);
                this.mnuBar.add(this.menHelp);
            }
            if ((guiCompProviders = Lookup.getDefault().lookupAll(BasicGuiComponentProvider.class)) != null) {
                this.initExtensionViewComponents(guiCompProviders);
            }
            this.legendTab[0] = this.vLegend;
            this.rootWindow.addTabMouseButtonListener(DockingWindowActionMouseButtonListener.MIDDLE_BUTTON_CLOSE_LISTENER);
            ShapedGradientDockingTheme theme = new ShapedGradientDockingTheme();
            this.rootWindow.getRootWindowProperties().addSuperObject(theme.getRootWindowProperties());
            RootWindowProperties titleBarStyleProperties = PropertiesUtil.createTitleBarStyleRootWindowProperties();
            this.rootWindow.getRootWindowProperties().addSuperObject(titleBarStyleProperties);
            this.rootWindow.getRootWindowProperties().getDockingWindowProperties().setUndockEnabled(true);
            AlphaGradientComponentPainter x = new AlphaGradientComponentPainter((Color)SystemColor.inactiveCaptionText, (Color)SystemColor.activeCaptionText, (Color)SystemColor.activeCaptionText, (Color)SystemColor.inactiveCaptionText);
            this.vMap.getViewProperties().getViewTitleBarProperties().getNormalProperties().getCloseButtonProperties().setVisible(true);
            this.rootWindow.getRootWindowProperties().getDragRectangleShapedPanelProperties().setComponentPainter((ComponentPainter)x);
            if (this.plugin && context.getEnvironment() != null && this.context.getEnvironment().isProgressObservable()) {
                this.context.getEnvironment().getProgressObserver().setProgress(500, NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.CismapPlugin(PluginContext).loadPreferences"));
            }
        }
        catch (Exception ex) {
            LOG.fatal((Object)"Error in Constructor of CismapPlugin", (Throwable)ex);
            System.err.println("Error in Constructor of CismapPlugin");
            ex.printStackTrace();
        }
        this.mapC.setReadOnly(false);
        Object blocker = new Object();
        if (this.plugin) {
            try {
                try {
                    fallBackConfig = blocker;
                    synchronized (fallBackConfig) {
                        if (context != null && context.getEnvironment() != null && context.getEnvironment().getProgressObserver() != null && this.context.getEnvironment().isProgressObservable()) {
                            this.context.getEnvironment().getProgressObserver().setProgress(500, NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.CismapPlugin(PluginContext).loadMethods"));
                        }
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)"No progress report available", (Throwable)e);
                }
                this.mniClose.setVisible(false);
                this.pluginMethods.put(this.showObjectsMethod.getId(), this.showObjectsMethod);
                this.pluginMethods.put(this.resetLayoutMethod.getId(), this.resetLayoutMethod);
                this.context.getMetadata().addMetaNodeSelectionListener((MetaNodeSelectionListener)new NodeChangeListener());
                if (context != null && context.getEnvironment() != null && this.context.getEnvironment().isProgressObservable()) {
                    this.context.getEnvironment().getProgressObserver().setProgress(650, NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.CismapPlugin(PluginContext).loadConfiguration"));
                }
                if (context != null && context.getEnvironment() != null && this.context.getEnvironment().isProgressObservable()) {
                    this.context.getEnvironment().getProgressObserver().setProgress(1000, NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.CismapPlugin(PluginContext).cismapPluginReady"));
                }
                if (context != null && context.getEnvironment() != null && context.getEnvironment().isProgressObservable()) {
                    this.context.getEnvironment().getProgressObserver().setFinished(true);
                }
            }
            catch (Throwable t) {
                context.getLogger().fatal((Object)"Error in CismapPlugin constructor", t);
            }
        }
        LOG.info((Object)"add InfoNode main component to the panMain Panel");
        this.panMain.add((Component)this.rootWindow, "Center");
        this.vMap.doLayout();
        this.mapC.setMappingModel((MappingModel)this.activeLayers.getMappingModel());
        this.setVisible(true);
        this.configureApp(false);
        for (Scale s : this.mapC.getScales()) {
            if (s.getDenominator() <= 0) continue;
            this.menExtras.add(this.getScaleMenuItem(s.getText(), s.getDenominator()));
        }
        this.statusBar.addScalePopups();
        this.statusBar.addCrsPopups();
        this.cmdReconfig.setVisible(false);
        this.jSeparator1.setVisible(false);
        this.mapC.getFeatureCollection().addFeatureCollectionListener((FeatureCollectionListener)this);
        this.repaint();
        if (!StaticDebuggingTools.checkHomeForFile((String)"cismetTurnOffInternalWebserver")) {
            this.initHttpServer();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"CismapPlugin als Observer anmelden");
        }
        ((Observable)this.mapC.getMemUndo()).addObserver(this);
        ((Observable)this.mapC.getMemRedo()).addObserver(this);
        this.mapC.unlock();
        this.overviewComponent.getOverviewMap().unlock();
        this.layerInfo.initDividerLocation();
        try {
            this.initPluginToolbarComponents();
        }
        catch (Exception e) {
            LOG.error((Object)"Exception while initializing Toolbar!", (Throwable)e);
        }
        if (!this.plugin) {
            this.loadLayoutWhenOpenedAdapter = new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    CismapPlugin.this.loadLayout(CismapPlugin.this.cismapDirectory + CismapPlugin.this.fs + CismapPlugin.this.standaloneLayoutName, true);
                    CismapPlugin.this.removeWindowListener(CismapPlugin.this.loadLayoutWhenOpenedAdapter);
                }
            };
            this.addWindowListener(this.loadLayoutWhenOpenedAdapter);
        }
        if (this.plugin) {
            if (ComponentRegistry.getRegistry().getMainWindow() != null) {
                this.loadLayoutWhenOpenedAdapter = new WindowAdapter(){

                    @Override
                    public void windowOpened(WindowEvent e) {
                        CismapPlugin.this.loadLayout(CismapPlugin.this.cismapDirectory + CismapPlugin.this.fs + CismapPlugin.this.pluginLayoutName, true);
                        ComponentRegistry.getRegistry().getMainWindow().removeWindowListener(CismapPlugin.this.loadLayoutWhenOpenedAdapter);
                    }
                };
                ComponentRegistry.getRegistry().getMainWindow().addWindowListener(this.loadLayoutWhenOpenedAdapter);
            } else {
                this.loadLayout(this.cismapDirectory + this.fs + this.pluginLayoutName, true);
            }
        }
    }

    private static void initConnection(ConfigProperties configProperties, ConnectionContext connectionContext) {
        try {
            Proxy proxy = ProxyHandler.getInstance().init(configProperties.getProxyProperties());
            Connection connection = ConnectionFactory.getFactory().createConnection(RESTfulConnection.class.getCanonicalName(), configProperties.getCallserverUrl(), configProperties.getClientName(), proxy, configProperties.isCompressionEnabled(), connectionContext);
            connection.setConnectionName(configProperties.getClientName());
            ConnectionInfo connectionInfo = new ConnectionInfo();
            connectionInfo.setCallserverURL(configProperties.getCallserverUrl());
            connectionInfo.setUserDomain(configProperties.getDomain());
            connectionInfo.setUsername(configProperties.getUsername());
            connectionInfo.setPassword(configProperties.getPassword());
            ConnectionSession connectionSession = ConnectionFactory.getFactory().createSession(connection, connectionInfo, true, connectionContext);
            ConnectionProxy connectionProxy = ConnectionFactory.getFactory().createProxy(DefaultConnectionProxyHandler.class.getCanonicalName(), connectionSession, connectionContext);
            SessionManager.init((ConnectionProxy)connectionProxy);
        }
        catch (Exception ex) {
            LOG.warn((Object)"could not init connection", (Throwable)ex);
        }
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initExtensionViewComponents(Collection<? extends BasicGuiComponentProvider> guiCompProviders) {
        ArrayList<? extends BasicGuiComponentProvider> gcpList = new ArrayList<BasicGuiComponentProvider>(guiCompProviders);
        Collections.sort(gcpList, new Comparator<BasicGuiComponentProvider>(){

            @Override
            public int compare(BasicGuiComponentProvider o1, BasicGuiComponentProvider o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        boolean first = true;
        this.menWindows.remove(this.mniResetWindowLayout);
        this.menWindows.remove(this.sepResetWindowLayout);
        try {
            for (BasicGuiComponentProvider basicGuiComponentProvider : gcpList) {
                Icon icon;
                block9: {
                    if (basicGuiComponentProvider.getType() != BasicGuiComponentProvider.GuiType.GUICOMPONENT) continue;
                    basicGuiComponentProvider.setLinkObject((Object)this);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)(basicGuiComponentProvider.getName() + " (try to add)"));
                    }
                    icon = null;
                    try {
                        icon = Static2DTools.borderIcon((Icon)basicGuiComponentProvider.getIcon(), (int)0, (int)3, (int)0, (int)1);
                    }
                    catch (Exception e) {
                        if (!LOG.isDebugEnabled()) break block9;
                        LOG.debug((Object)("cannot create extension view border icon: " + basicGuiComponentProvider.getName()), (Throwable)e);
                    }
                }
                final View extensionView = new View(basicGuiComponentProvider.getName(), icon, (Component)basicGuiComponentProvider.getComponent());
                JMenuItem newItem = new JMenuItem(basicGuiComponentProvider.getName(), icon);
                newItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CismapPlugin.this.showOrHideView(extensionView);
                    }
                });
                if (first) {
                    first = false;
                    this.menWindows.add(new JSeparator());
                }
                this.menWindows.add(newItem);
                this.viewMap.addView(basicGuiComponentProvider.getId(), extensionView);
                this.viewMenuMap.put(basicGuiComponentProvider.getId(), newItem);
                this.extensionWindows.put(basicGuiComponentProvider, (DockingWindow)extensionView);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(basicGuiComponentProvider.getName() + " added"));
                }
                if (!(basicGuiComponentProvider instanceof CustomButtonProvider)) continue;
                extensionView.getCustomTitleBarComponents().addAll(((CustomButtonProvider)basicGuiComponentProvider).getCustomButtons());
            }
        }
        finally {
            this.menWindows.add(this.sepResetWindowLayout);
            this.menWindows.add(this.mniResetWindowLayout);
        }
    }

    private void initPluginToolbarComponents() {
        Collection toolbarguiCompProviders;
        Collection toolbarCompProviders = Lookup.getDefault().lookupAll(ToolbarComponentsProvider.class);
        if (toolbarCompProviders != null) {
            for (ToolbarComponentsProvider toolbarCompProvider : toolbarCompProviders) {
                Collection componentDescriptions;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Registering Toolbar Components for Plugin: " + toolbarCompProvider.getPluginName()));
                }
                if (toolbarCompProvider instanceof ConnectionContextStore) {
                    ((ConnectionContextStore)toolbarCompProvider).initWithConnectionContext(this.getConnectionContext());
                }
                if ((componentDescriptions = toolbarCompProvider.getToolbarComponents()) == null) continue;
                for (ToolbarComponentDescription componentDescription : componentDescriptions) {
                    int insertionIndex = this.tlbMain.getComponentCount();
                    String anchor = componentDescription.getAnchorComponentName();
                    JComponent component = componentDescription.getComponent();
                    if (componentDescription.isInteractionMode() && component instanceof AbstractButton) {
                        this.cmdGroupPrimaryInteractionMode.add((AbstractButton)component);
                    }
                    if (anchor != null) {
                        int i = this.tlbMain.getComponentCount();
                        while (--i >= 0) {
                            Component currentAnchorCandidate = this.tlbMain.getComponent(i);
                            if (!anchor.equals(currentAnchorCandidate.getName())) continue;
                            if (ToolbarComponentsProvider.ToolbarPositionHint.BEFORE.equals((Object)componentDescription.getPositionHint())) {
                                insertionIndex = i;
                                break;
                            }
                            insertionIndex = i + 1;
                            break;
                        }
                    }
                    this.tlbMain.add((Component)component, insertionIndex);
                }
            }
        }
        if ((toolbarguiCompProviders = Lookup.getDefault().lookupAll(BasicGuiComponentProvider.class)) != null) {
            for (BasicGuiComponentProvider gui : toolbarguiCompProviders) {
                if (gui.getType() != BasicGuiComponentProvider.GuiType.TOOLBARCOMPONENT) continue;
                int insertionIndex = this.tlbMain.getComponentCount();
                this.tlbMain.add((Component)gui.getComponent(), insertionIndex);
            }
        }
    }

    private JMenuItem getScaleMenuItem(String t, final int d) {
        JMenuItem jmi = new JMenuItem(t);
        jmi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CismapPlugin.this.mapC.gotoBoundingBoxWithHistory(CismapPlugin.this.mapC.getBoundingBoxFromScale((double)d));
            }
        });
        return jmi;
    }

    public MappingComponent getMappingComponent() {
        return this.mapC;
    }

    public ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    private void setupDefaultLayout() {
        ArrayList<Object> capabilitiesSection = new ArrayList<Object>(2);
        capabilitiesSection.add(this.vCaps);
        capabilitiesSection.add(this.vServerInfo);
        ArrayList<Object> layerSection = new ArrayList<Object>(3);
        layerSection.add(this.vLayers);
        layerSection.add(this.vFeatureControl);
        layerSection.add(this.vFeatureInfo);
        ArrayList<DockingWindow> layerInfoSection = new ArrayList<DockingWindow>(Arrays.asList(this.legendTab));
        ArrayList<Object> mapSection = new ArrayList<Object>(1);
        mapSection.add(this.vMap);
        ArrayList<DockingWindow> wfsSection = new ArrayList<DockingWindow>(Arrays.asList(this.wfsViews));
        for (Map.Entry<BasicGuiComponentProvider, DockingWindow> entry : this.extensionWindows.entrySet()) {
            Object positionHint = entry.getKey().getPositionHint();
            if (positionHint instanceof ViewSection) {
                ViewSection section = (ViewSection)((Object)positionHint);
                switch (section) {
                    case CAPABILITIES: {
                        capabilitiesSection.add(entry.getValue());
                        break;
                    }
                    case LAYER: {
                        layerSection.add(entry.getValue());
                        break;
                    }
                    case LAYER_INFO: {
                        layerInfoSection.add(entry.getValue());
                        break;
                    }
                    case MAP: {
                        mapSection.add(entry.getValue());
                        break;
                    }
                    case WFS: {
                        wfsSection.add(entry.getValue());
                        break;
                    }
                    default: {
                        LOG.warn((Object)("unrecognised view section: " + (Object)((Object)section)));
                        break;
                    }
                }
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("ignoring extension window in layout, because the position hint is not a ViewSection" + entry.getKey().getName()));
        }
        TabWindow capabilitiesTabs = new TabWindow(capabilitiesSection.toArray(new DockingWindow[capabilitiesSection.size()]));
        TabWindow layerTabs = new TabWindow(layerSection.toArray(new DockingWindow[layerSection.size()]));
        TabWindow layerInfoTabs = new TabWindow(layerInfoSection.toArray(new DockingWindow[layerInfoSection.size()]));
        TabWindow mapTabs = new TabWindow(mapSection.toArray(new DockingWindow[mapSection.size()]));
        TabWindow wfsTabs = wfsSection.isEmpty() ? null : new TabWindow(wfsSection.toArray(new DockingWindow[wfsSection.size()]));
        this.rootWindow.setWindow((DockingWindow)new SplitWindow(true, 0.716448f, (DockingWindow)new SplitWindow(false, 0.72572404f, (DockingWindow)(wfsTabs == null ? mapTabs : new SplitWindow(false, 0.21391752f, (DockingWindow)wfsTabs, (DockingWindow)mapTabs)), (DockingWindow)layerTabs), (DockingWindow)new SplitWindow(false, 0.66f, (DockingWindow)capabilitiesTabs, (DockingWindow)layerInfoTabs)));
        for (int i = 0; i < this.wfsViews.length; ++i) {
            this.wfsViews[i].close();
        }
        this.rootWindow.getWindowBar(Direction.LEFT).setEnabled(true);
        this.rootWindow.getWindowBar(Direction.RIGHT).setEnabled(true);
        this.vLegend.restoreFocus();
        this.vCaps.restoreFocus();
        this.vLayers.restoreFocus();
        this.vMap.restoreFocus();
        if (this.windows2skip != null) {
            for (String id : this.windows2skip) {
                JMenuItem menu;
                View v = this.viewMap.getView(id);
                if (v != null) {
                    v.close();
                }
                if ((menu = this.viewMenuMap.get(id)) == null) continue;
                menu.setVisible(false);
            }
        }
    }

    private void openUrlInExternalBrowser(String url) {
        try {
            BrowserLauncher.openURL((String)url);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error while opening: " + url + ". Try again"), (Throwable)e);
            try {
                BrowserLauncher.openURL((String)url);
            }
            catch (Exception e2) {
                LOG.warn((Object)("The second time failed, too. Error while trying to open: " + url + " last attempt"), (Throwable)e2);
                try {
                    BrowserLauncher.openURL((String)("file://" + url));
                }
                catch (Exception e3) {
                    LOG.error((Object)("3rd time fail:file://" + url), (Throwable)e3);
                }
            }
        }
    }

    private void initComponents() {
        this.cmdGroupPrimaryInteractionMode = new ButtonGroup();
        this.popMen = new JPopupMenu();
        this.mnuConfigServer = new JMenuItem();
        this.cmdGroupNodes = new ButtonGroup();
        this.menBookmarks = new JMenu();
        this.mniAddBookmark = new JMenuItem();
        this.mniBookmarkManager = new JMenuItem();
        this.mniBookmarkSidebar = new JMenuItem();
        this.panAll = new JPanel();
        this.panToolbar = new JPanel();
        this.panMain = new JPanel();
        this.tlbMain = new JToolBar();
        this.cmdReconfig = new JPopupMenuButton();
        ((JPopupMenuButton)this.cmdReconfig).setPopupMenu(this.popMen);
        this.jSeparator1 = new JSeparator();
        this.cmdBack = new JHistoryButton(){

            public void historyActionPerformed() {
                if (CismapPlugin.this.mapC != null) {
                    CismapPlugin.this.mapC.back(true);
                }
            }
        };
        this.cmdHome = new JButton();
        this.cmdForward = new JHistoryButton(){

            public void historyActionPerformed() {
                if (CismapPlugin.this.mapC != null) {
                    CismapPlugin.this.mapC.forward(true);
                }
            }
        };
        this.jSeparator2 = new JSeparator();
        this.cmdRefresh = new JButton();
        this.jSeparator6 = new JSeparator();
        this.cmdPrint = new JButton();
        this.cmdClipboard = new MapExportPanel(this.getConnectionContext());
        this.cmdDownloads = new JButton();
        this.jSeparator4 = new JSeparator();
        this.togInvisible = new JToggleButton();
        this.togInvisible.setVisible(false);
        this.cmdSelectSingle = new JToggleButton();
        this.cmdSelect = new GeoSelectionButton("SELECT", this.mapC, null);
        this.cmdZoom = new JToggleButton();
        this.cmdPan = new JToggleButton();
        this.cmdFeatureInfo = new JToggleButton();
        this.cmdPluginSearch = this.metaSearchComponentFactory.getCmdPluginSearch();
        this.cmdNewPolygon = new JToggleButton();
        this.cmdNewLinestring = new JToggleButton();
        this.cmdNewPoint = new JToggleButton();
        this.btnAddGeometryWizard = new AddGeomDnDButton();
        this.cmdNewLinearReferencing = new JToggleButton();
        this.cmdMoveGeometry = new JToggleButton();
        this.cmdRemoveGeometry = new JToggleButton();
        this.jSeparator3 = new JSeparator();
        this.cmdNodeMove = new JToggleButton();
        this.cmdNodeAdd = new JToggleButton();
        this.cmdNodeRemove = new JToggleButton();
        this.cmdNodeRotateGeometry = new JToggleButton();
        this.cmdNodeReflectGeometry = new JToggleButton();
        this.jSeparator5 = new JSeparator();
        this.cmdSnap = new JToggleButton();
        this.jSeparator11 = new JSeparator();
        this.cmdUndo = new JButton();
        this.cmdRedo = new JButton();
        this.panStatus = new JPanel();
        this.mnuBar = new JMenuBar();
        this.menFile = new JMenu();
        this.mniLoadConfig = new JMenuItem();
        this.mniAppendConfig = new JMenuItem();
        this.mniSaveConfig = new JMenuItem();
        this.mniLoadConfigFromServer = new JMenuItem();
        this.sepServerProfilesStart = new JSeparator();
        this.sepServerProfilesEnd = new JSeparator();
        this.mniSaveLayout = new JMenuItem();
        this.mniLoadLayout = new JMenuItem();
        this.jSeparator9 = new JSeparator();
        this.mniLoadShape = new JMenuItem();
        this.jSeparator12 = new JPopupMenu.Separator();
        this.mniClipboard = new JMenuItem();
        this.mniMapToFile = new JMenuItem();
        this.mniGeoLinkClipboard = new JMenuItem();
        this.mniPrint = new JMenuItem();
        this.jSeparator10 = new JSeparator();
        this.mniClose = new JMenuItem();
        this.menEdit = new JMenu();
        this.mniRefresh = new JMenuItem();
        this.jSeparator13 = new JSeparator();
        this.mniZoomToSelectedObjects = new JMenuItem();
        this.mniZoomToAllObjects = new JMenuItem();
        this.jSeparator15 = new JSeparator();
        this.mniRemoveSelectedObject = new JMenuItem();
        this.mniRemoveAllObjects = new JMenuItem();
        this.menHistory = new JMenu();
        this.mniBack = new JMenuItem();
        this.mniForward = new JMenuItem();
        this.mniHome = new JMenuItem();
        this.sepBeforePos = new JSeparator();
        this.sepAfterPos = new JSeparator();
        this.mniHistorySidebar = new JMenuItem();
        this.menSearch = this.metaSearchComponentFactory.getMenSearch();
        this.menExtras = new JMenu();
        this.mniOptions = new JMenuItem();
        this.jSeparator16 = new JSeparator();
        this.mniBufferSelectedGeom = new JMenuItem();
        this.mniAngleMeasurement = new JMenuItem();
        this.jSeparator17 = new JPopupMenu.Separator();
        this.mniGotoPoint = new JMenuItem();
        this.jSeparator14 = new JSeparator();
        this.mniScale = new JMenuItem();
        this.menWindows = new JMenu();
        this.mniLayer = new JMenuItem();
        this.mniCapabilities = new JMenuItem();
        this.mniFeatureInfo = new JMenuItem();
        this.mniServerInfo = new JMenuItem();
        this.mniLayerInfo = new JMenuItem();
        this.mniLegend = new JMenuItem();
        this.mniFeatureControl = new JMenuItem();
        this.mniMap = new JMenuItem();
        this.mniOverview = new JMenuItem();
        this.sepResetWindowLayout = new JSeparator();
        this.mniResetWindowLayout = new JMenuItem();
        this.menHelp = new JMenu();
        this.mniOnlineHelp = new JMenuItem();
        this.mniNews = new JMenuItem();
        this.mnuConfigServer.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/raster/wms/res/server.png")));
        this.mnuConfigServer.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mnuConfigServer.text"));
        this.mnuConfigServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mnuConfigServerActionPerformed(evt);
            }
        });
        this.popMen.add(this.mnuConfigServer);
        this.menBookmarks.setMnemonic('L');
        this.menBookmarks.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.menBookmarks.text"));
        this.mniAddBookmark.setIcon(new ImageIcon(this.getClass().getResource("/images/bookmark_add.png")));
        this.mniAddBookmark.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniAddBookmark.text"));
        this.mniAddBookmark.setEnabled(false);
        this.menBookmarks.add(this.mniAddBookmark);
        this.mniBookmarkManager.setIcon(new ImageIcon(this.getClass().getResource("/images/bookmark_folder.png")));
        this.mniBookmarkManager.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniBookmarkManager.text"));
        this.mniBookmarkManager.setEnabled(false);
        this.menBookmarks.add(this.mniBookmarkManager);
        this.mniBookmarkSidebar.setIcon(new ImageIcon(this.getClass().getResource("/images/bookmark.png")));
        this.mniBookmarkSidebar.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniBookmarkSidebar.text"));
        this.mniBookmarkSidebar.setEnabled(false);
        this.menBookmarks.add(this.mniBookmarkSidebar);
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.Form.title"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                CismapPlugin.this.formWindowClosed(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                CismapPlugin.this.formComponentResized(evt);
            }

            @Override
            public void componentShown(ComponentEvent evt) {
                CismapPlugin.this.formComponentShown(evt);
            }
        });
        this.panAll.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.panAll.setLayout(new BorderLayout());
        this.panToolbar.setLayout(new BorderLayout());
        this.panAll.add((Component)this.panToolbar, "North");
        this.panMain.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.panMain.setFocusCycleRoot(true);
        this.panMain.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                CismapPlugin.this.panMainMouseExited(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                CismapPlugin.this.panMainMouseEntered(evt);
            }
        });
        this.panMain.setLayout(new BorderLayout());
        this.tlbMain.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                CismapPlugin.this.tlbMainMouseClicked(evt);
            }
        });
        this.cmdReconfig.setIcon(new ImageIcon(this.getClass().getResource("/images/open.gif")));
        this.cmdReconfig.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.cmdReconfig.toolTipText"));
        this.cmdReconfig.setBorderPainted(false);
        this.cmdReconfig.setFocusPainted(false);
        this.cmdReconfig.setName("cmdReconfig");
        this.cmdReconfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.cmdReconfigActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.cmdReconfig);
        this.jSeparator1.setOrientation(1);
        this.jSeparator1.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        this.jSeparator1.setPreferredSize(new Dimension(2, 10));
        this.tlbMain.add(this.jSeparator1);
        this.cmdBack.setIcon(new ImageIcon(this.getClass().getResource("/images/back.png")));
        this.cmdBack.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.cmdBack.toolTipText"));
        this.cmdBack.setBorderPainted(false);
        this.cmdBack.setFocusPainted(false);
        this.cmdBack.setName("cmdBack");
        this.cmdBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.cmdBackActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.cmdBack);
        this.cmdHome.setIcon(new ImageIcon(this.getClass().getResource("/images/home.gif")));
        this.cmdHome.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.cmdHome.toolTipText"));
        this.cmdHome.setBorderPainted(false);
        this.cmdHome.setFocusPainted(false);
        this.cmdHome.setName("cmdHome");
        this.cmdHome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.cmdHomeActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.cmdHome);
        this.cmdForward.setIcon(new ImageIcon(this.getClass().getResource("/images/forward.png")));
        this.cmdForward.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.cmdForward.toolTipText"));
        this.cmdForward.setBorderPainted(false);
        this.cmdForward.setFocusPainted(false);
        this.cmdForward.setName("cmdForward");
        this.tlbMain.add(this.cmdForward);
        this.jSeparator2.setOrientation(1);
        this.jSeparator2.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        this.jSeparator2.setPreferredSize(new Dimension(2, 10));
        this.tlbMain.add(this.jSeparator2);
        this.cmdRefresh.setIcon(new ImageIcon(this.getClass().getResource("/images/reload.gif")));
        this.cmdRefresh.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.cmdRefresh.toolTipText"));
        this.cmdRefresh.setBorderPainted(false);
        this.cmdRefresh.setFocusPainted(false);
        this.cmdRefresh.setName("cmdRefresh");
        this.cmdRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.cmdRefreshActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.cmdRefresh);
        this.jSeparator6.setOrientation(1);
        this.jSeparator6.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        this.jSeparator6.setPreferredSize(new Dimension(2, 10));
        this.tlbMain.add(this.jSeparator6);
        this.cmdPrint.setIcon(new ImageIcon(this.getClass().getResource("/images/frameprint.png")));
        this.cmdPrint.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.cmdPrint.text"));
        this.cmdPrint.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.cmdPrint.toolTipText"));
        this.cmdPrint.setBorderPainted(false);
        this.cmdPrint.setFocusPainted(false);
        this.cmdPrint.setName("cmdPrint");
        this.cmdPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.cmdPrintActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.cmdPrint);
        this.cmdClipboard.setName("cmdClipboard");
        this.tlbMain.add(this.cmdClipboard);
        this.cmdDownloads.setAction((Action)new DownloadManagerAction((Component)this));
        this.cmdDownloads.setBorderPainted(false);
        this.tlbMain.add(this.cmdDownloads);
        this.jSeparator4.setOrientation(1);
        this.jSeparator4.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        this.jSeparator4.setPreferredSize(new Dimension(2, 10));
        this.tlbMain.add(this.jSeparator4);
        this.cmdGroupPrimaryInteractionMode.add(this.togInvisible);
        this.togInvisible.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.togInvisible.text"));
        this.togInvisible.setFocusPainted(false);
        this.tlbMain.add(this.togInvisible);
        this.cmdGroupPrimaryInteractionMode.add(this.cmdSelectSingle);
        this.cmdSelectSingle.setIcon(new ImageIcon(this.getClass().getResource("/images/select.png")));
        this.cmdSelectSingle.setSelected(true);
        this.cmdSelectSingle.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.cmdSelectSingle.toolTipText"));
        this.cmdSelectSingle.setBorderPainted(false);
        this.cmdSelectSingle.setFocusPainted(false);
        this.cmdSelectSingle.setFocusable(false);
        this.cmdSelectSingle.setHorizontalTextPosition(0);
        this.cmdSelectSingle.setName("cmdSelectSingle");
        this.cmdSelectSingle.setVerticalTextPosition(3);
        this.cmdSelectSingle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.cmdSelectSingleActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.cmdSelectSingle);
        this.cmdSelectSingle.setVisible(!this.hasExtendedSelectionCapabilities());
        this.cmdSelect.setIcon(new ImageIcon(this.getClass().getResource("/images/selectRectangle.png")));
        this.cmdSelect.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.cmdSelect.toolTipText"));
        this.cmdGroupPrimaryInteractionMode.add(this.cmdSelect);
        this.cmdSelect.setFocusable(false);
        this.cmdSelect.setHorizontalTextPosition(0);
        this.cmdSelect.setName("cmdSelect");
        this.cmdSelect.setVerticalTextPosition(3);
        this.tlbMain.add(this.cmdSelect);
        this.cmdSelect.setVisible(this.hasExtendedSelectionCapabilities());
        this.cmdGroupPrimaryInteractionMode.add(this.cmdZoom);
        this.cmdZoom.setIcon(new ImageIcon(this.getClass().getResource("/images/zoom.gif")));
        this.cmdZoom.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.cmdZoom.toolTipText"));
        this.cmdZoom.setBorderPainted(false);
        this.cmdZoom.setFocusPainted(false);
        this.cmdZoom.setName("cmdZoom");
        this.cmdZoom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.cmdZoomActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.cmdZoom);
        this.cmdGroupPrimaryInteractionMode.add(this.cmdPan);
        this.cmdPan.setIcon(new ImageIcon(this.getClass().getResource("/images/pan.gif")));
        this.cmdPan.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.cmdPan.toolTipText"));
        this.cmdPan.setBorderPainted(false);
        this.cmdPan.setFocusPainted(false);
        this.cmdPan.setName("cmdPan");
        this.cmdPan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.cmdPanActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.cmdPan);
        this.cmdGroupPrimaryInteractionMode.add(this.cmdFeatureInfo);
        this.cmdFeatureInfo.setIcon(new ImageIcon(this.getClass().getResource("/images/featureInfos.gif")));
        this.cmdFeatureInfo.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.cmdFeatureInfo.toolTipText"));
        this.cmdFeatureInfo.setBorderPainted(false);
        this.cmdFeatureInfo.setFocusPainted(false);
        this.cmdFeatureInfo.setName("cmdFeatureInfo");
        this.cmdFeatureInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.cmdFeatureInfoActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.cmdFeatureInfo);
        this.cmdPluginSearch.setIcon(new ImageIcon(this.getClass().getResource("/images/pluginSearchRectangle.png")));
        this.cmdGroupPrimaryInteractionMode.add(this.cmdPluginSearch);
        this.cmdPluginSearch.setName("cmdPluginSearch");
        this.tlbMain.add(this.cmdPluginSearch);
        this.cmdGroupPrimaryInteractionMode.add(this.cmdNewPolygon);
        this.cmdNewPolygon.setIcon(new ImageIcon(this.getClass().getResource("/images/newPolygon.png")));
        this.cmdNewPolygon.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.cmdNewPolygon.toolTipText"));
        this.cmdNewPolygon.setBorderPainted(false);
        this.cmdNewPolygon.setFocusPainted(false);
        this.cmdNewPolygon.setName("cmdNewPolygon");
        this.cmdNewPolygon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.cmdNewPolygonActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.cmdNewPolygon);
        this.cmdGroupPrimaryInteractionMode.add(this.cmdNewLinestring);
        this.cmdNewLinestring.setIcon(new ImageIcon(this.getClass().getResource("/images/newLinestring.png")));
        this.cmdNewLinestring.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.cmdNewLinestring.toolTipText"));
        this.cmdNewLinestring.setBorderPainted(false);
        this.cmdNewLinestring.setFocusPainted(false);
        this.cmdNewLinestring.setName("cmdNewLinestring");
        this.cmdNewLinestring.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.createGeometryAction(evt);
            }
        });
        this.tlbMain.add(this.cmdNewLinestring);
        this.cmdGroupPrimaryInteractionMode.add(this.cmdNewPoint);
        this.cmdNewPoint.setIcon(new ImageIcon(this.getClass().getResource("/images/newPoint.png")));
        this.cmdNewPoint.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.cmdNewPoint.toolTipText"));
        this.cmdNewPoint.setBorderPainted(false);
        this.cmdNewPoint.setFocusPainted(false);
        this.cmdNewPoint.setName("cmdNewPoint");
        this.cmdNewPoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.cmdNewPointActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.cmdNewPoint);
        this.btnAddGeometryWizard.setAction((Action)new AddGeometriesToMapWizardAction());
        this.btnAddGeometryWizard.setFocusable(false);
        this.btnAddGeometryWizard.setHorizontalTextPosition(0);
        this.btnAddGeometryWizard.setVerticalTextPosition(3);
        this.tlbMain.add(this.btnAddGeometryWizard);
        this.cmdGroupPrimaryInteractionMode.add(this.cmdNewLinearReferencing);
        this.cmdNewLinearReferencing.setIcon(new ImageIcon(this.getClass().getResource("/images/linref.png")));
        this.cmdNewLinearReferencing.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.cmdNewLinearReferencing.text"));
        this.cmdNewLinearReferencing.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.cmdNewLinearReferencing.toolTipText"));
        this.cmdNewLinearReferencing.setFocusPainted(false);
        this.cmdNewLinearReferencing.setName("cmdNewLinearReferencing");
        this.cmdNewLinearReferencing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.cmdNewLinearReferencingcreateGeometryAction(evt);
            }
        });
        this.tlbMain.add(this.cmdNewLinearReferencing);
        this.cmdNewLinearReferencing.setVisible(false);
        this.cmdGroupPrimaryInteractionMode.add(this.cmdMoveGeometry);
        this.cmdMoveGeometry.setIcon(new ImageIcon(this.getClass().getResource("/images/move.png")));
        this.cmdMoveGeometry.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.cmdMoveGeometry.toolTipText"));
        this.cmdMoveGeometry.setBorderPainted(false);
        this.cmdMoveGeometry.setFocusPainted(false);
        this.cmdMoveGeometry.setMaximumSize(new Dimension(29, 29));
        this.cmdMoveGeometry.setMinimumSize(new Dimension(29, 29));
        this.cmdMoveGeometry.setName("cmdMoveGeometry");
        this.cmdMoveGeometry.setPreferredSize(new Dimension(29, 29));
        this.cmdMoveGeometry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.cmdMoveGeometryActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.cmdMoveGeometry);
        this.cmdGroupPrimaryInteractionMode.add(this.cmdRemoveGeometry);
        this.cmdRemoveGeometry.setIcon(new ImageIcon(this.getClass().getResource("/images/remove.png")));
        this.cmdRemoveGeometry.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.cmdRemoveGeometry.toolTipText"));
        this.cmdRemoveGeometry.setBorderPainted(false);
        this.cmdRemoveGeometry.setFocusPainted(false);
        this.cmdRemoveGeometry.setName("cmdRemoveGeometry");
        this.cmdRemoveGeometry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.cmdRemoveGeometryActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.cmdRemoveGeometry);
        this.jSeparator3.setOrientation(1);
        this.jSeparator3.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        this.jSeparator3.setPreferredSize(new Dimension(2, 10));
        this.tlbMain.add(this.jSeparator3);
        this.cmdGroupNodes.add(this.cmdNodeMove);
        this.cmdNodeMove.setIcon(new ImageIcon(this.getClass().getResource("/images/moveNodes.png")));
        this.cmdNodeMove.setSelected(true);
        this.cmdNodeMove.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.cmdNodeMove.toolTipText"));
        this.cmdNodeMove.setBorderPainted(false);
        this.cmdNodeMove.setFocusPainted(false);
        this.cmdNodeMove.setName("cmdNodeMove");
        this.cmdNodeMove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.cmdNodeMoveActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.cmdNodeMove);
        this.cmdGroupNodes.add(this.cmdNodeAdd);
        this.cmdNodeAdd.setIcon(new ImageIcon(this.getClass().getResource("/images/insertNodes.png")));
        this.cmdNodeAdd.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.cmdNodeAdd.toolTipText"));
        this.cmdNodeAdd.setBorderPainted(false);
        this.cmdNodeAdd.setFocusPainted(false);
        this.cmdNodeAdd.setName("cmdNodeAdd");
        this.cmdNodeAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.cmdNodeAddActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.cmdNodeAdd);
        this.cmdGroupNodes.add(this.cmdNodeRemove);
        this.cmdNodeRemove.setIcon(new ImageIcon(this.getClass().getResource("/images/removeNodes.png")));
        this.cmdNodeRemove.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.cmdNodeRemove.toolTipText"));
        this.cmdNodeRemove.setBorderPainted(false);
        this.cmdNodeRemove.setFocusPainted(false);
        this.cmdNodeRemove.setName("cmdNodeRemove");
        this.cmdNodeRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.cmdNodeRemoveActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.cmdNodeRemove);
        this.cmdGroupNodes.add(this.cmdNodeRotateGeometry);
        this.cmdNodeRotateGeometry.setIcon(new ImageIcon(this.getClass().getResource("/images/rotate.png")));
        this.cmdNodeRotateGeometry.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.cmdNodeRotateGeometry.toolTipText"));
        this.cmdNodeRotateGeometry.setBorderPainted(false);
        this.cmdNodeRotateGeometry.setFocusPainted(false);
        this.cmdNodeRotateGeometry.setName("cmdNodeRotateGeometry");
        this.cmdNodeRotateGeometry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.cmdNodeRotateGeometryActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.cmdNodeRotateGeometry);
        this.cmdGroupNodes.add(this.cmdNodeReflectGeometry);
        this.cmdNodeReflectGeometry.setIcon(new ImageIcon(this.getClass().getResource("/images/mirror.png")));
        this.cmdNodeReflectGeometry.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.cmdNodeReflectGeometry.toolTipText"));
        this.cmdNodeReflectGeometry.setBorderPainted(false);
        this.cmdNodeReflectGeometry.setFocusPainted(false);
        this.cmdNodeReflectGeometry.setFocusable(false);
        this.cmdNodeReflectGeometry.setHorizontalTextPosition(0);
        this.cmdNodeReflectGeometry.setName("cmdNodeReflectGeometry");
        this.cmdNodeReflectGeometry.setVerticalTextPosition(3);
        this.cmdNodeReflectGeometry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.cmdNodeReflectGeometryActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.cmdNodeReflectGeometry);
        this.jSeparator5.setOrientation(1);
        this.jSeparator5.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        this.jSeparator5.setPreferredSize(new Dimension(2, 10));
        this.tlbMain.add(this.jSeparator5);
        this.cmdSnap.setIcon(new ImageIcon(this.getClass().getResource("/images/snap.png")));
        this.cmdSnap.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.cmdSnap.toolTipText"));
        this.cmdSnap.setBorderPainted(false);
        this.cmdSnap.setFocusPainted(false);
        this.cmdSnap.setMaximumSize(new Dimension(29, 29));
        this.cmdSnap.setMinimumSize(new Dimension(29, 29));
        this.cmdSnap.setName("cmdSnap");
        this.cmdSnap.setPreferredSize(new Dimension(29, 29));
        this.cmdSnap.setRolloverSelectedIcon(new ImageIcon(this.getClass().getResource("/images/snap_selected.png")));
        this.cmdSnap.setSelectedIcon(new ImageIcon(this.getClass().getResource("/images/snap_selected.png")));
        this.cmdSnap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.cmdSnapActionPerformed(evt);
            }
        });
        this.tlbMain.add(this.cmdSnap);
        this.jSeparator11.setOrientation(1);
        this.jSeparator11.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        this.jSeparator11.setPreferredSize(new Dimension(2, 10));
        this.tlbMain.add(this.jSeparator11);
        this.cmdUndo.setIcon(new ImageIcon(this.getClass().getResource("/images/undo.png")));
        this.cmdUndo.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.cmdUndo.toolTipText"));
        this.cmdUndo.setBorderPainted(false);
        this.cmdUndo.setEnabled(false);
        this.cmdUndo.setFocusPainted(false);
        this.cmdUndo.setName("cmdUndo");
        this.cmdUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniUndoPerformed(evt);
            }
        });
        this.tlbMain.add(this.cmdUndo);
        this.cmdRedo.setIcon(new ImageIcon(this.getClass().getResource("/images/redo.png")));
        this.cmdRedo.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.cmdRedo.toolTipText"));
        this.cmdRedo.setBorderPainted(false);
        this.cmdRedo.setEnabled(false);
        this.cmdRedo.setFocusPainted(false);
        this.cmdRedo.setName("cmdRedo");
        this.cmdRedo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniRedoPerformed(evt);
            }
        });
        this.tlbMain.add(this.cmdRedo);
        this.panMain.add((Component)this.tlbMain, "North");
        this.panAll.add((Component)this.panMain, "Center");
        this.panStatus.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 4));
        this.panStatus.setLayout(new BorderLayout());
        this.panAll.add((Component)this.panStatus, "South");
        this.getContentPane().add((Component)this.panAll, "Center");
        this.menFile.setMnemonic('D');
        this.menFile.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.menFile.text"));
        this.mniLoadConfig.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.mniLoadConfig.setIcon(new ImageIcon(this.getClass().getResource("/images/config.png")));
        this.mniLoadConfig.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniLoadConfig.text"));
        this.mniLoadConfig.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniLoadConfig.tooltip"));
        this.mniLoadConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniLoadConfigActionPerformed(evt);
            }
        });
        this.menFile.add(this.mniLoadConfig);
        this.mniAppendConfig.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.mniAppendConfig.setIcon(new ImageIcon(this.getClass().getResource("/images/config.png")));
        this.mniAppendConfig.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniAppendConfig.text"));
        this.mniAppendConfig.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniAppendConfig.toolTipText"));
        this.mniAppendConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniAppendConfigActionPerformed(evt);
            }
        });
        this.menFile.add(this.mniAppendConfig);
        this.mniSaveConfig.setAccelerator(KeyStroke.getKeyStroke(75, 2));
        this.mniSaveConfig.setIcon(new ImageIcon(this.getClass().getResource("/images/config.png")));
        this.mniSaveConfig.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniSaveConfig.text"));
        this.mniSaveConfig.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniSaveConfig.tooltip"));
        this.mniSaveConfig.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniSaveConfigActionPerformed(evt);
            }
        });
        this.menFile.add(this.mniSaveConfig);
        this.mniLoadConfigFromServer.setIcon(new ImageIcon(this.getClass().getResource("/images/config.png")));
        this.mniLoadConfigFromServer.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniLoadConfigFromServer.text"));
        this.mniLoadConfigFromServer.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniLoadConfigFromServer.tooltip"));
        this.mniLoadConfigFromServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniLoadConfigFromServerActionPerformed(evt);
            }
        });
        this.menFile.add(this.mniLoadConfigFromServer);
        this.sepServerProfilesStart.setName("sepServerProfilesStart");
        this.menFile.add(this.sepServerProfilesStart);
        this.sepServerProfilesEnd.setName("sepServerProfilesEnd");
        this.menFile.add(this.sepServerProfilesEnd);
        this.mniSaveLayout.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.mniSaveLayout.setIcon(new ImageIcon(this.getClass().getResource("/images/layout.png")));
        this.mniSaveLayout.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniSaveLayout.text"));
        this.mniSaveLayout.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniSaveLayout.tooltip"));
        this.mniSaveLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniSaveLayoutActionPerformed(evt);
            }
        });
        this.menFile.add(this.mniSaveLayout);
        this.mniLoadLayout.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.mniLoadLayout.setIcon(new ImageIcon(this.getClass().getResource("/images/layout.png")));
        this.mniLoadLayout.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniLoadLayout.text"));
        this.mniLoadLayout.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniLoadLayout.tooltip"));
        this.mniLoadLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniLoadLayoutActionPerformed(evt);
            }
        });
        this.menFile.add(this.mniLoadLayout);
        this.menFile.add(this.jSeparator9);
        this.mniLoadShape.setIcon(new ImageIcon(this.getClass().getResource("/images/icon-importfile.png")));
        this.mniLoadShape.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniLoadShape.text"));
        this.mniLoadShape.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniLoadShape.toolTipText", (Object[])new Object[0]));
        this.mniLoadShape.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniLoadShapeActionPerformed(evt);
            }
        });
        this.menFile.add(this.mniLoadShape);
        this.menFile.add(this.jSeparator12);
        this.mniClipboard.setAction(new ExportMapToClipboardAction());
        this.mniClipboard.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.mniClipboard.setIcon(new ImageIcon(this.getClass().getResource("/images/clipboard16.png")));
        this.mniClipboard.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniClipboard.text"));
        this.menFile.add(this.mniClipboard);
        this.mniMapToFile.setAction(new ExportMapToFileAction());
        this.mniMapToFile.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.mniMapToFile.setIcon(new ImageIcon(this.getClass().getResource("/images/clipboard16.png")));
        this.mniMapToFile.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniMapToFile.text"));
        this.mniMapToFile.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniMapToFile.toolTipText"));
        this.menFile.add(this.mniMapToFile);
        this.mniGeoLinkClipboard.setAction(new ExportGeoPointToClipboardAction());
        this.mniGeoLinkClipboard.setAccelerator(KeyStroke.getKeyStroke(67, 10));
        this.mniGeoLinkClipboard.setIcon(new ImageIcon(this.getClass().getResource("/images/clipboard16.png")));
        this.mniGeoLinkClipboard.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniGeoLinkClipboard.text"));
        this.mniGeoLinkClipboard.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniGeoLinkClipboard.tooltip"));
        this.menFile.add(this.mniGeoLinkClipboard);
        this.mniPrint.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.mniPrint.setIcon(new ImageIcon(this.getClass().getResource("/images/frameprint16.png")));
        this.mniPrint.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniPrint.text"));
        this.mniPrint.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniPrint.tooltip"));
        this.mniPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniPrintActionPerformed(evt);
            }
        });
        this.menFile.add(this.mniPrint);
        this.menFile.add(this.jSeparator10);
        this.mniClose.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        this.mniClose.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniClose.text"));
        this.mniClose.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniClose.tooltip"));
        this.mniClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniCloseActionPerformed(evt);
            }
        });
        this.menFile.add(this.mniClose);
        this.mnuBar.add(this.menFile);
        this.menEdit.setMnemonic('B');
        this.menEdit.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.menEdit.text"));
        this.menEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.menEditActionPerformed(evt);
            }
        });
        this.mniRefresh.setIcon(new ImageIcon(this.getClass().getResource("/images/reload16.gif")));
        this.mniRefresh.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniRefresh.text"));
        this.mniRefresh.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniRefresh.tooltip"));
        this.mniRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniRefreshActionPerformed(evt);
            }
        });
        this.menEdit.add(this.mniRefresh);
        this.menEdit.add(this.jSeparator13);
        this.mniZoomToSelectedObjects.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/zoomToSelection.png")));
        this.mniZoomToSelectedObjects.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniZoomToSelectedObjects.text"));
        this.mniZoomToSelectedObjects.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniZoomToSelectedObjects.tooltip"));
        this.mniZoomToSelectedObjects.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniZoomToSelectedObjectsActionPerformed(evt);
            }
        });
        this.menEdit.add(this.mniZoomToSelectedObjects);
        this.mniZoomToAllObjects.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/zoomToAll.png")));
        this.mniZoomToAllObjects.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniZoomToAllObjects.text"));
        this.mniZoomToAllObjects.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniZoomToAllObjects.tooltip"));
        this.mniZoomToAllObjects.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniZoomToAllObjectsActionPerformed(evt);
            }
        });
        this.menEdit.add(this.mniZoomToAllObjects);
        this.menEdit.add(this.jSeparator15);
        this.mniRemoveSelectedObject.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/removerow.png")));
        this.mniRemoveSelectedObject.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniRemoveSelectedObject.text"));
        this.mniRemoveSelectedObject.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniRemoveSelectedObject.tooltip"));
        this.mniRemoveSelectedObject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniRemoveSelectedObjectActionPerformed(evt);
            }
        });
        this.menEdit.add(this.mniRemoveSelectedObject);
        this.mniRemoveAllObjects.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/res/removeAll.png")));
        this.mniRemoveAllObjects.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniRemoveAllObjects.text"));
        this.mniRemoveAllObjects.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniRemoveAllObjects.tooltip"));
        this.mniRemoveAllObjects.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniRemoveAllObjectsActionPerformed(evt);
            }
        });
        this.menEdit.add(this.mniRemoveAllObjects);
        this.mnuBar.add(this.menEdit);
        this.menHistory.setMnemonic('C');
        this.menHistory.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.menHistory.text"));
        this.mniBack.setAccelerator(KeyStroke.getKeyStroke(37, 2));
        this.mniBack.setIcon(new ImageIcon(this.getClass().getResource("/images/back16.png")));
        this.mniBack.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniBack.text"));
        this.mniBack.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniBack.tooltip"));
        this.mniBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniBackActionPerformed(evt);
            }
        });
        this.menHistory.add(this.mniBack);
        this.mniForward.setAccelerator(KeyStroke.getKeyStroke(39, 2));
        this.mniForward.setIcon(new ImageIcon(this.getClass().getResource("/images/forward16.png")));
        this.mniForward.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniForward.text"));
        this.mniForward.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniForward.tooltip"));
        this.mniForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniForwardActionPerformed(evt);
            }
        });
        this.menHistory.add(this.mniForward);
        this.mniHome.setAccelerator(KeyStroke.getKeyStroke(36, 0));
        this.mniHome.setIcon(new ImageIcon(this.getClass().getResource("/images/home16.png")));
        this.mniHome.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniHome.text"));
        this.mniHome.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniHome.tooltip"));
        this.mniHome.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniHomeActionPerformed(evt);
            }
        });
        this.menHistory.add(this.mniHome);
        this.menHistory.add(this.sepBeforePos);
        this.menHistory.add(this.sepAfterPos);
        this.mniHistorySidebar.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniHistorySidebar.text"));
        this.mniHistorySidebar.setEnabled(false);
        this.menHistory.add(this.mniHistorySidebar);
        this.mnuBar.add(this.menHistory);
        this.menSearch.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.menSearch.text"));
        this.mnuBar.add(this.menSearch);
        this.menExtras.setMnemonic('E');
        this.menExtras.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.menExtras.text"));
        this.mniOptions.setIcon(new ImageIcon(this.getClass().getResource("/images/tooloptions.png")));
        this.mniOptions.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniOptions.text"));
        this.mniOptions.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniOptions.tooltip"));
        this.mniOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniOptionsActionPerformed(evt);
            }
        });
        this.menExtras.add(this.mniOptions);
        this.menExtras.add(this.jSeparator16);
        this.mniBufferSelectedGeom.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        this.mniBufferSelectedGeom.setIcon(new ImageIcon(this.getClass().getResource("/images/buffer.png")));
        this.mniBufferSelectedGeom.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniBufferSelectedGeom.text"));
        this.mniBufferSelectedGeom.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniBufferSelectedGeom.tooltip"));
        this.mniBufferSelectedGeom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniBufferSelectedGeomActionPerformed(evt);
            }
        });
        this.menExtras.add(this.mniBufferSelectedGeom);
        this.mniAngleMeasurement.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.mniAngleMeasurement.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/piccolo/Angle-Thingy-icon_16.png")));
        this.mniAngleMeasurement.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniAngleMeasurement.text"));
        this.mniAngleMeasurement.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniAngleMeasurement.toolTipText"));
        this.mniAngleMeasurement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniAngleMeasurementActionPerformed(evt);
            }
        });
        this.menExtras.add(this.mniAngleMeasurement);
        this.menExtras.add(this.jSeparator17);
        this.mniGotoPoint.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.mniGotoPoint.setIcon(new ImageIcon(this.getClass().getResource("/images/goto.png")));
        this.mniGotoPoint.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniGotoPoint.text"));
        this.mniGotoPoint.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniGotoPoint.tooltip"));
        this.mniGotoPoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniGotoPointActionPerformed(evt);
            }
        });
        this.menExtras.add(this.mniGotoPoint);
        this.menExtras.add(this.jSeparator14);
        this.mniScale.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        this.mniScale.setIcon(new ImageIcon(this.getClass().getResource("/images/scale.png")));
        this.mniScale.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniScale.text"));
        this.mniScale.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniScale.tooltip"));
        this.mniScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniScaleActionPerformed(evt);
            }
        });
        this.menExtras.add(this.mniScale);
        this.mnuBar.add(this.menExtras);
        this.menWindows.setMnemonic('F');
        this.menWindows.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.menWindows.text"));
        this.menWindows.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.menWindowsActionPerformed(evt);
            }
        });
        this.mniLayer.setAccelerator(KeyStroke.getKeyStroke(49, 2));
        this.mniLayer.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/raster/wms/res/layers.png")));
        this.mniLayer.setMnemonic('L');
        this.mniLayer.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniLayer.text"));
        this.mniLayer.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniLayer.tooltip"));
        this.mniLayer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniLayerActionPerformed(evt);
            }
        });
        this.menWindows.add(this.mniLayer);
        this.mniCapabilities.setAccelerator(KeyStroke.getKeyStroke(50, 2));
        this.mniCapabilities.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/raster/wms/res/server.png")));
        this.mniCapabilities.setMnemonic('C');
        this.mniCapabilities.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.CismapPlugin(PluginContext).vCapabilities.title"));
        this.mniCapabilities.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniCapabilities.tooltip"));
        this.mniCapabilities.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniCapabilitiesActionPerformed(evt);
            }
        });
        this.menWindows.add(this.mniCapabilities);
        this.mniFeatureInfo.setAccelerator(KeyStroke.getKeyStroke(51, 2));
        this.mniFeatureInfo.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/featureinfowidget/res/featureInfo16.png")));
        this.mniFeatureInfo.setMnemonic('F');
        this.mniFeatureInfo.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniFeatureInfo.text"));
        this.mniFeatureInfo.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniFeatureInfo.tooltip"));
        this.mniFeatureInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniFeatureInfoActionPerformed(evt);
            }
        });
        this.menWindows.add(this.mniFeatureInfo);
        this.mniServerInfo.setAccelerator(KeyStroke.getKeyStroke(53, 2));
        this.mniServerInfo.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/capabilitywidget/res/serverInfo.png")));
        this.mniServerInfo.setMnemonic('S');
        this.mniServerInfo.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.CismapPlugin(PluginContext).vServerInfo.title"));
        this.mniServerInfo.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniServerInfo.tooltip"));
        this.mniServerInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniServerInfoActionPerformed(evt);
            }
        });
        this.menWindows.add(this.mniServerInfo);
        this.mniLayerInfo.setAccelerator(KeyStroke.getKeyStroke(54, 2));
        this.mniLayerInfo.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/capabilitywidget/res/layerInfo.png")));
        this.mniLayerInfo.setMnemonic('L');
        this.mniLayerInfo.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.CismapPlugin(PluginContext).vLayerInfo.title"));
        this.mniLayerInfo.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniLayerInfo.tooltip"));
        this.mniLayerInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniLayerInfoActionPerformed(evt);
            }
        });
        this.menWindows.add(this.mniLayerInfo);
        this.mniLegend.setAccelerator(KeyStroke.getKeyStroke(55, 2));
        this.mniLegend.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/navigatorplugin/res/legend.png")));
        this.mniLegend.setMnemonic('L');
        this.mniLegend.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniLegend.text"));
        this.mniLegend.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniLegend.tooltip"));
        this.mniLegend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniLegendActionPerformed(evt);
            }
        });
        this.menWindows.add(this.mniLegend);
        this.mniFeatureControl.setAccelerator(KeyStroke.getKeyStroke(56, 2));
        this.mniFeatureControl.setIcon(new ImageIcon(this.getClass().getResource("/images/objects.png")));
        this.mniFeatureControl.setMnemonic('O');
        this.mniFeatureControl.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniFeatureControl.text"));
        this.mniFeatureControl.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniFeatureControl.tooltip"));
        this.mniFeatureControl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniFeatureControlActionPerformed(evt);
            }
        });
        this.menWindows.add(this.mniFeatureControl);
        this.mniMap.setAccelerator(KeyStroke.getKeyStroke(57, 2));
        this.mniMap.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/navigatorplugin/map.png")));
        this.mniMap.setMnemonic('M');
        this.mniMap.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniMap.text"));
        this.mniMap.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniMap.tooltip"));
        this.mniMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniMapActionPerformed(evt);
            }
        });
        this.menWindows.add(this.mniMap);
        this.mniOverview.setAccelerator(KeyStroke.getKeyStroke(48, 2));
        this.mniOverview.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/navigatorplugin/map.png")));
        this.mniOverview.setMnemonic('M');
        this.mniOverview.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniOverview.text"));
        this.mniOverview.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniOverview.tooltip"));
        this.mniOverview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniOverviewActionPerformed(evt);
            }
        });
        this.menWindows.add(this.mniOverview);
        this.menWindows.add(this.sepResetWindowLayout);
        this.mniResetWindowLayout.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.mniResetWindowLayout.setIcon(new ImageIcon(this.getClass().getResource("/images/layout.png")));
        this.mniResetWindowLayout.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniResetWindowLayout.text"));
        this.mniResetWindowLayout.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniResetWindowLayout.toolTipText"));
        this.mniResetWindowLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniResetWindowLayoutActionPerformed(evt);
            }
        });
        this.menWindows.add(this.mniResetWindowLayout);
        this.mnuBar.add(this.menWindows);
        this.menHelp.setMnemonic('H');
        this.menHelp.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.menHelp.text"));
        this.menHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.menHelpActionPerformed(evt);
            }
        });
        this.mniOnlineHelp.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.mniOnlineHelp.setIcon(new ImageIcon(this.getClass().getResource("/images/help.png")));
        this.mniOnlineHelp.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniOnlineHelp.text"));
        this.mniOnlineHelp.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniOnlineHelp.tooltip"));
        this.mniOnlineHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniOnlineHelpActionPerformed(evt);
            }
        });
        this.menHelp.add(this.mniOnlineHelp);
        this.mniNews.setIcon(new ImageIcon(this.getClass().getResource("/images/news.png")));
        this.mniNews.setText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniNews.text"));
        this.mniNews.setToolTipText(NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniNews.tooltip"));
        this.mniNews.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CismapPlugin.this.mniNewsActionPerformed(evt);
            }
        });
        this.menHelp.add(this.mniNews);
        this.mnuBar.add(this.menHelp);
        this.setJMenuBar(this.mnuBar);
    }

    private void cmdNewLinearReferencingcreateGeometryAction(ActionEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CismapPlugin.this.mapC.setInteractionMode("LINEMEASUREMENT");
            }
        });
    }

    private void mniBufferSelectedGeomActionPerformed(ActionEvent evt) {
        Collection c = this.mapC.getFeatureCollection().getSelectedFeatures();
        if (c != null && c.size() > 0) {
            String s = (String)JOptionPane.showInputDialog(StaticSwingTools.getParentFrame((Component)this.mapC), NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniBufferSelectedGeom.Dialog.text"), NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniBufferSelectedGeom.Dialog.title"), -1, null, null, "");
            for (Object o : c) {
                if (!(o instanceof Feature)) continue;
                int srid = ((Feature)o).getGeometry().getSRID();
                Geometry oldG = CrsTransformer.transformToMetricCrs((Geometry)((Feature)o).getGeometry());
                Geometry newG = oldG.buffer(Double.parseDouble(s));
                newG = CrsTransformer.transformToGivenCrs((Geometry)newG, (String)CrsTransformer.createCrsFromSrid((int)srid));
                if (o instanceof PureNewFeature) {
                    ((Feature)o).setGeometry(newG);
                    ((PureNewFeature)o).setGeometryType(AbstractNewFeature.geomTypes.POLYGON);
                    PFeature sel = (PFeature)this.mapC.getPFeatureHM().get(o);
                    sel.setCoordArr(newG.getCoordinates());
                    sel.syncGeometry();
                    ArrayList<Feature> v = new ArrayList<Feature>();
                    v.add(sel.getFeature());
                    ((DefaultFeatureCollection)this.mapC.getFeatureCollection()).fireFeaturesChanged(v);
                    continue;
                }
                PureNewFeature pnf = new PureNewFeature(newG);
                pnf.setGeometryType(AbstractNewFeature.geomTypes.POLYGON);
                ((DefaultFeatureCollection)this.mapC.getFeatureCollection()).addFeature((Feature)pnf);
                ((DefaultFeatureCollection)this.mapC.getFeatureCollection()).holdFeature((Feature)pnf);
            }
        } else {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this.mapC), NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniBufferSelectedGeom.Dialog.noneselected"), NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniBufferSelectedGeom.Dialog.title"), 2);
        }
    }

    private void cmdNodeReflectGeometryActionPerformed(ActionEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CismapPlugin.this.mapC.setHandleInteractionMode("REFLECT_POLYGON");
                CismapPlugin.this.mapC.setInteractionMode("SELECT");
            }
        });
    }

    private void mniAngleMeasurementActionPerformed(ActionEvent evt) {
        StaticSwingTools.showDialog((JDialog)AngleMeasurementDialog.getInstance());
    }

    private void mniLoadShapeActionPerformed(ActionEvent evt) {
        JFileChooser fc;
        try {
            fc = new JFileChooser(this.cismapDirectory);
        }
        catch (Exception bug) {
            fc = new JFileChooser(this.cismapDirectory, (FileSystemView)new RestrictedFileSystemView());
        }
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".shp");
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniLoadShapeActionPerformed.FileFiltergetDescription.return");
            }
        });
        int state = fc.showOpenDialog(this);
        if (state == 0) {
            File file = fc.getSelectedFile();
            String name = file.getAbsolutePath();
            ActiveLayerModel model = (ActiveLayerModel)this.mapC.getMappingModel();
            LayerDropUtils.handleFiles(Collections.nCopies(1, file), (ActiveLayerModel)model, (int)0, (Component)this);
        }
    }

    private void cmdSelectSingleActionPerformed(ActionEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CismapPlugin.this.mapC.setInteractionMode("SELECT");
                ((SelectionListener)CismapPlugin.this.mapC.getInputListener("SELECT")).setMode("BOUNDING_BOX");
            }
        });
    }

    private void mniAppendConfigActionPerformed(ActionEvent evt) {
        this.loadConfiguration(true);
    }

    private void loadConfiguration(boolean merge) {
        JFileChooser fc;
        try {
            fc = new JFileChooser(this.cismapDirectory);
        }
        catch (Exception bug) {
            fc = new JFileChooser(this.cismapDirectory, (FileSystemView)new RestrictedFileSystemView());
        }
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniLoadConfigActionPerformed.FileFiltergetDescription.return");
            }
        });
        int state = fc.showOpenDialog(this);
        if (state == 0) {
            File file = fc.getSelectedFile();
            final String name = file.getAbsolutePath();
            if (!merge) {
                this.activeLayers.removeAllLayers();
            }
            if (name.endsWith(".xml")) {
                if (!merge) {
                    this.mapC.getMapServiceLayer().removeAllChildren();
                }
                this.configurationManager.configure(name, merge);
            } else {
                if (!merge) {
                    this.mapC.getMapServiceLayer().removeAllChildren();
                }
                this.configurationManager.configure(name + ".xml", merge);
            }
            if (!merge) {
                EventQueue.invokeLater(new Thread("refresh local project"){

                    @Override
                    public void run() {
                        CismapPlugin.this.refreshConfigurationFileIfRequired(name);
                    }
                });
            }
        }
    }

    private void mniRedoPerformed(ActionEvent evt) {
        LOG.info((Object)"REDO");
        CustomAction a = this.mapC.getMemRedo().getLastAction();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("... execute action: " + a.info()));
        }
        try {
            a.doAction();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while executing an action", (Throwable)e);
        }
        CustomAction inverse = a.getInverse();
        this.mapC.getMemUndo().addAction(inverse);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("... new action on UNDO stack: " + inverse));
            LOG.debug((Object)"... completed");
        }
    }

    private void mniUndoPerformed(ActionEvent evt) {
        LOG.info((Object)"UNDO");
        CustomAction a = this.mapC.getMemUndo().getLastAction();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("... execute action: " + a.info()));
        }
        try {
            a.doAction();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while executing action", (Throwable)e);
        }
        CustomAction inverse = a.getInverse();
        this.mapC.getMemRedo().addAction(inverse);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("... new action on REDO stack: " + inverse));
            LOG.debug((Object)"... completed");
        }
    }

    private void menHelpActionPerformed(ActionEvent evt) {
    }

    private void mniAboutActionPerformed(ActionEvent evt) {
        if (this.about == null) {
            this.about = new AboutDialog(StaticSwingTools.getParentFrame((Component)this.panAll), true);
        }
        StaticSwingTools.showDialog((JDialog)this.about);
    }

    private void mniNewsActionPerformed(ActionEvent evt) {
        this.openUrlInExternalBrowser(this.newsUrl);
    }

    private void mniOnlineHelpActionPerformed(ActionEvent evt) {
        this.openUrlInExternalBrowser(this.helpUrl);
    }

    private void mniGotoPointActionPerformed(ActionEvent evt) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"mniGotoPointActionPerformed");
        }
        GotoPointDialog gotoPointDialog = GotoPointDialog.getInstance();
        StaticSwingTools.showDialog((Component)this.mapC, (JDialog)gotoPointDialog, (boolean)true);
    }

    private void mniScaleActionPerformed(ActionEvent evt) {
        try {
            String s = JOptionPane.showInputDialog(StaticSwingTools.getParentFrame((Component)this.mapC), NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.scaleManually"), (int)this.mapC.getScaleDenominator() + "");
            Integer i = new Integer(s);
            this.mapC.gotoBoundingBoxWithHistory(this.mapC.getBoundingBoxFromScale((double)i.intValue()));
        }
        catch (Exception skip) {
            LOG.error((Object)"Error in mniScaleActionPerformed", (Throwable)skip);
        }
    }

    private void mniMapActionPerformed(ActionEvent evt) {
        this.showOrHideView(this.vMap);
    }

    private void mniRemoveAllObjectsActionPerformed(ActionEvent evt) {
        if (this.mapC != null) {
            ArrayList v = new ArrayList(this.mapC.getFeatureCollection().getAllFeatures());
            this.mapC.getFeatureCollection().removeFeatures(v);
        }
    }

    private void mniZoomToSelectedObjectsActionPerformed(ActionEvent evt) {
        if (this.mapC != null) {
            this.mapC.zoomToSelection();
        }
    }

    private void mniZoomToAllObjectsActionPerformed(ActionEvent evt) {
        if (this.mapC != null) {
            this.mapC.zoomToFeatureCollection();
        }
    }

    private void mniForwardActionPerformed(ActionEvent evt) {
        if (this.mapC != null && this.mapC.isForwardPossible()) {
            this.mapC.forward(true);
        }
    }

    private void mniBackActionPerformed(ActionEvent evt) {
        if (this.mapC != null && this.mapC.isBackPossible()) {
            this.mapC.back(true);
        }
    }

    private void mniHomeActionPerformed(ActionEvent evt) {
        this.cmdHomeActionPerformed(null);
    }

    private void mniRefreshActionPerformed(ActionEvent evt) {
        this.cmdRefreshActionPerformed(null);
    }

    private void mniRemoveSelectedObjectActionPerformed(ActionEvent evt) {
        if (this.mapC != null) {
            ArrayList v = new ArrayList(this.mapC.getFeatureCollection().getSelectedFeatures());
            this.mapC.getFeatureCollection().removeFeatures(v);
        }
    }

    private void mniLoadConfigActionPerformed(ActionEvent evt) {
        this.loadConfiguration(false);
    }

    private void refreshConfigurationFileIfRequired(String path) {
        try {
            SAXBuilder builder = new SAXBuilder(false);
            Document doc = builder.build(new File(path));
            Document currentDoc = this.configurationManager.getConfigurationDocument();
            if (doc != null && currentDoc != null && !this.configurationManager.isEqual(doc, currentDoc)) {
                if (path.endsWith(".xml")) {
                    this.configurationManager.writeConfiguration(path);
                } else {
                    this.configurationManager.writeConfiguration(path + ".xml");
                }
            }
        }
        catch (Exception e) {
            String message = "Error while comparing loaded configuration with the current configuration";
            LOG.warn((Object)"Error while comparing loaded configuration with the current configuration", (Throwable)e);
        }
    }

    private void mniSaveConfigActionPerformed(ActionEvent evt) {
        JFileChooser fc;
        try {
            fc = new JFileChooser(this.cismapDirectory);
        }
        catch (Exception bug) {
            fc = new JFileChooser(this.cismapDirectory, (FileSystemView)new RestrictedFileSystemView());
        }
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniSaveConfigActionPerformed.FileFilter.getDescription.return");
            }
        });
        int state = fc.showSaveDialog(this);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("state:" + state));
        }
        if (state == 0) {
            File file = fc.getSelectedFile();
            String name = file.getAbsolutePath();
            if (name.endsWith(".xml")) {
                this.configurationManager.writeConfiguration(name);
            } else {
                this.configurationManager.writeConfiguration(name + ".xml");
            }
        }
    }

    private void mniLoadConfigFromServerActionPerformed(ActionEvent evt) {
        this.activeLayers.removeAllLayers();
        this.mapC.getMapServiceLayer().removeAllChildren();
        this.mapC.lock();
        this.configureApp(true);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CismapPlugin.this.mapC.unlock();
            }
        });
    }

    private void mniPrintActionPerformed(ActionEvent evt) {
        this.cmdPrintActionPerformed(null);
    }

    private void mniSaveLayoutActionPerformed(ActionEvent evt) {
        JFileChooser fc;
        try {
            fc = new JFileChooser(this.cismapDirectory);
        }
        catch (Exception bug) {
            fc = new JFileChooser(this.cismapDirectory, (FileSystemView)new RestrictedFileSystemView());
        }
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".layout");
            }

            @Override
            public String getDescription() {
                return "Layout";
            }
        });
        fc.setMultiSelectionEnabled(false);
        int state = fc.showSaveDialog(this);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("state:" + state));
        }
        if (state == 0) {
            File file = fc.getSelectedFile();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("file:" + file));
            }
            String name = file.getAbsolutePath();
            if ((name = name.toLowerCase()).endsWith(".layout")) {
                this.saveLayout(name);
            } else {
                this.saveLayout(name + ".layout");
            }
        }
    }

    private void mniLoadLayoutActionPerformed(ActionEvent evt) {
        JFileChooser fc;
        try {
            fc = new JFileChooser(this.cismapDirectory);
        }
        catch (Exception bug) {
            fc = new JFileChooser(this.cismapDirectory, (FileSystemView)new RestrictedFileSystemView());
        }
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".layout");
            }

            @Override
            public String getDescription() {
                return "Layout";
            }
        });
        fc.setMultiSelectionEnabled(false);
        int state = fc.showOpenDialog(this);
        if (state == 0) {
            File file = fc.getSelectedFile();
            String name = file.getAbsolutePath();
            if ((name = name.toLowerCase()).endsWith(".layout")) {
                this.loadLayout(name, false);
            } else {
                JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this.mapC), NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniLoadLayoutActionPerformed(ActionEvent).JOptionPane.msg"), NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.mniLoadLayoutActionPerformed(ActionEvent).JOptionPane.title"), 1);
            }
        }
    }

    private void mniCloseActionPerformed(ActionEvent evt) {
        this.dispose();
        System.exit(0);
    }

    private void menEditActionPerformed(ActionEvent evt) {
    }

    private void menWindowsActionPerformed(ActionEvent evt) {
    }

    private void tlbMainMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 3) {
            // empty if block
        }
    }

    private void cmdPrintActionPerformed(ActionEvent evt) {
        this.mapC.showPrintingSettingsDialog();
        this.setButtonSelectionAccordingToMappingComponent();
    }

    private void cmdSnapActionPerformed(ActionEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CismapPlugin.this.mapC.setSnappingEnabled(CismapPlugin.this.cmdSnap.isSelected());
            }
        });
    }

    private void cmdRemoveGeometryActionPerformed(ActionEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CismapPlugin.this.mapC.setInteractionMode("REMOVE_POLYGON");
            }
        });
    }

    private void cmdMoveGeometryActionPerformed(ActionEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CismapPlugin.this.mapC.setInteractionMode("MOVE_POLYGON");
            }
        });
    }

    private void cmdNewPointActionPerformed(ActionEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((CreateNewGeometryListener)CismapPlugin.this.mapC.getInputListener("NEW_POLYGON")).setMode("POINT");
                CismapPlugin.this.mapC.setInteractionMode("NEW_POLYGON");
            }
        });
    }

    private void cmdNewPolygonActionPerformed(ActionEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((CreateNewGeometryListener)CismapPlugin.this.mapC.getInputListener("NEW_POLYGON")).setMode("POLYGON");
                CismapPlugin.this.mapC.setInteractionMode("NEW_POLYGON");
            }
        });
    }

    private void createGeometryAction(ActionEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((CreateNewGeometryListener)CismapPlugin.this.mapC.getInputListener("NEW_POLYGON")).setMode("LINESTRING");
                CismapPlugin.this.mapC.setInteractionMode("NEW_POLYGON");
            }
        });
    }

    private void cmdNodeRemoveActionPerformed(ActionEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CismapPlugin.this.mapC.setHandleInteractionMode("REMOVE_HANDLE");
                CismapPlugin.this.mapC.setInteractionMode("SELECT");
            }
        });
    }

    private void cmdNodeAddActionPerformed(ActionEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CismapPlugin.this.mapC.setHandleInteractionMode("ADD_HANDLE");
                CismapPlugin.this.mapC.setInteractionMode("SELECT");
            }
        });
    }

    private void cmdNodeMoveActionPerformed(ActionEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CismapPlugin.this.mapC.setHandleInteractionMode("MOVE_HANDLE");
                CismapPlugin.this.mapC.setInteractionMode("SELECT");
            }
        });
    }

    private void mniResetWindowLayoutActionPerformed(ActionEvent evt) {
        this.loadLayout(DEFAULT_LOCAL_LAYOUT, true);
    }

    private void mniFeatureControlActionPerformed(ActionEvent evt) {
        this.showOrHideView(this.vFeatureControl);
    }

    private void cmdReconfigActionPerformed(ActionEvent evt) {
        this.activeLayers.removeAllLayers();
        this.mapC.getRasterServiceLayer().removeAllChildren();
        this.configureApp(false);
    }

    private void mniFeatureInfoActionPerformed(ActionEvent evt) {
        this.showOrHideView(this.vFeatureInfo);
    }

    private void mniServerInfoActionPerformed(ActionEvent evt) {
        this.showOrHideView(this.vServerInfo);
    }

    private void mniLayerInfoActionPerformed(ActionEvent evt) {
        this.showOrHideView(this.vLayerInfo);
    }

    private void mniLegendActionPerformed(ActionEvent evt) {
        this.showOrHideView(this.vLegend);
    }

    private void mniCapabilitiesActionPerformed(ActionEvent evt) {
        this.showOrHideView(this.vCaps);
    }

    private void mniLayerActionPerformed(ActionEvent evt) {
        this.showOrHideView(this.vLayers);
    }

    private void cmdFeatureInfoActionPerformed(ActionEvent evt) {
        this.mapC.setInteractionMode("FEATURE_INFO");
    }

    private void formComponentShown(ComponentEvent evt) {
    }

    private void formWindowClosed(WindowEvent evt) {
        LOG.info((Object)"CLOSE");
    }

    private void showOrHideView(View v) {
        if (v.isClosable()) {
            v.close();
        } else {
            v.restore();
        }
    }

    private void cmdPanActionPerformed(ActionEvent evt) {
        if (this.mapC != null) {
            this.mapC.setInteractionMode("PAN");
        }
    }

    private void cmdZoomActionPerformed(ActionEvent evt) {
        if (this.mapC != null) {
            this.mapC.setInteractionMode("ZOOM");
        }
    }

    private void cmdRefreshActionPerformed(ActionEvent evt) {
        if (this.mapC != null) {
            this.mapC.refresh();
        }
    }

    private void cmdHomeActionPerformed(ActionEvent evt) {
        if (this.mapC != null) {
            this.mapC.gotoInitialBoundingBox();
        }
    }

    private void cmdBackActionPerformed(ActionEvent evt) {
    }

    private void panMainMouseEntered(MouseEvent evt) {
    }

    private void panMainMouseExited(MouseEvent evt) {
    }

    private void cmdNodeRotateGeometryActionPerformed(ActionEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CismapPlugin.this.mapC.setHandleInteractionMode("ROTATE_POLYGON");
                CismapPlugin.this.mapC.setInteractionMode("SELECT");
            }
        });
    }

    private void mniOverviewActionPerformed(ActionEvent evt) {
        this.showOrHideView(this.vOverview);
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.getExtendedState() != 6) {
            this.oldWindowDimension.setSize(this.getWidth(), this.getHeight());
            this.oldWindowPositionX = (int)this.getLocation().getX();
            this.oldWindowPositionY = (int)this.getLocation().getY();
        }
    }

    private void mniOptionsActionPerformed(ActionEvent evt) {
        OptionsDialog od = new OptionsDialog(StaticSwingTools.getParentFrame((Component)this.panAll), true);
        StaticSwingTools.showDialog((JDialog)od);
    }

    private void mnuConfigServerActionPerformed(ActionEvent evt) {
        this.activeLayers.removeAllLayers();
        this.mapC.getRasterServiceLayer().removeAllChildren();
        this.configureApp(true);
    }

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPopupMenu.setDefaultLightWeightPopupEnabled(false);
                ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
                CismapPlugin cp = args.length == 1 ? new CismapPlugin(args[0], null) : new CismapPlugin(null);
                cp.setVisible(true);
            }
        });
    }

    private void configureApp(boolean serverFirst) {
        try {
            EventQueue.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = CismapPlugin.this.getTreeLock();
                    synchronized (object) {
                        CismapPlugin.this.validateTree();
                    }
                }
            });
        }
        catch (Exception e) {
            EventQueue.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    LOG.warn((Object)"Error in validateTree()", (Throwable)e);
                    Object object = CismapPlugin.this.getTreeLock();
                    synchronized (object) {
                        CismapPlugin.this.validateTree();
                    }
                }
            });
        }
        if (serverFirst) {
            this.configurationManager.configureFromClasspath();
        } else {
            this.configurationManager.configure();
        }
        this.setButtonSelectionAccordingToMappingComponent();
    }

    private void activateLineRef() {
        block3: {
            if (this.cismapPluginUIPreferences != null) {
                try {
                    boolean isLineRefActivated = this.cismapPluginUIPreferences.getChild("LinearReferencedMarks").getAttribute("isActivated").getBooleanValue();
                    this.cmdNewLinearReferencing.setVisible(isLineRefActivated);
                }
                catch (Exception ex) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug((Object)"error reading LinearReferencedMarks from cismapPluginUIPreferences", (Throwable)ex);
                }
            }
        }
    }

    public List<Feature> getAllFeaturesSorted() {
        return this.featureControl.getAllFeaturesSorted();
    }

    public PluginUI getUI(String str) {
        return this;
    }

    public PluginMethod getMethod(String str) {
        return this.pluginMethods.get(str);
    }

    public void setActive(boolean param) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setActive:" + param));
        }
        if (!param) {
            this.configurationManager.writeConfiguration();
            CismapBroker.getInstance().writePropertyFile();
            this.saveLayout(this.cismapDirectory + this.fs + this.pluginLayoutName);
        }
    }

    public Iterator getUIs() {
        LinkedList<CismapPlugin> ll = new LinkedList<CismapPlugin>();
        ll.add(this);
        return ll.iterator();
    }

    public PluginProperties getProperties() {
        return this.myPluginProperties;
    }

    public Iterator getMethods() {
        return this.pluginMethods.values().iterator();
    }

    public void shown() {
    }

    public void resized() {
    }

    public void moved() {
    }

    public void hidden() {
    }

    public Collection getMenus() {
        return this.menues;
    }

    public CapabilityWidget getCapabilities() {
        return this.capabilities;
    }

    public String getId() {
        return "cismap";
    }

    public JComponent getComponent() {
        return this.panAll;
    }

    public Collection getButtons() {
        return null;
    }

    public int getHttpInterfacePort() {
        return this.httpInterfacePort;
    }

    public void floatingStopped() {
    }

    public void floatingStarted() {
    }

    @Override
    public void setVisible(boolean b) {
        if (this.plugin) {
            JFrame mainWindow = ComponentRegistry.getRegistry().getMainWindow();
            this.showObjectsWaitDialog = new ShowObjectsWaitDialog((Frame)mainWindow, false);
        } else {
            super.setVisible(b);
        }
    }

    public boolean isFeatureCollectionEventBlocker() {
        return this.featureCollectionEventBlocker;
    }

    public void setFeatureCollectionEventBlocker(boolean featureCollectionEventBlocker) {
        this.featureCollectionEventBlocker = featureCollectionEventBlocker;
    }

    @Override
    public void dispose() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"dispose().CIAO");
            }
            this.saveLayout(this.cismapDirectory + this.fs + this.standaloneLayoutName);
            this.configurationManager.writeConfiguration();
            CismapBroker.getInstance().writePropertyFile();
            super.dispose();
            System.exit(0);
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Error during disposing frame.", t);
        }
    }

    public Element getConfiguration() {
        boolean windowMaximised;
        Element ret = new Element("cismapPluginUIPreferences");
        Element window = new Element("window");
        int windowHeight = this.getHeight();
        int windowWidth = this.getWidth();
        int windowX = (int)this.getLocation().getX();
        int windowY = (int)this.getLocation().getY();
        boolean bl = windowMaximised = this.getExtendedState() == 6;
        if (windowMaximised) {
            window.setAttribute("height", "" + (int)this.oldWindowDimension.getHeight());
            window.setAttribute("width", "" + (int)this.oldWindowDimension.getWidth());
            window.setAttribute("x", "" + this.oldWindowPositionX);
            window.setAttribute("y", "" + this.oldWindowPositionY);
        } else {
            window.setAttribute("height", "" + windowHeight);
            window.setAttribute("width", "" + windowWidth);
            window.setAttribute("x", "" + windowX);
            window.setAttribute("y", "" + windowY);
        }
        window.setAttribute("max", "" + windowMaximised);
        ret.addContent((Content)window);
        return ret;
    }

    private boolean hasExtendedSelectionCapabilities() {
        boolean visible;
        try {
            visible = SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), "extendedSelectionCapabilities", this.getConnectionContext());
        }
        catch (Exception ex) {
            visible = false;
        }
        return visible;
    }

    public void masterConfigure(Element e) {
        Element prefs;
        this.cismapPluginUIPreferences = prefs = e.getChild("cismapPluginUIPreferences");
        this.activateLineRef();
        try {
            Element help_url_element = prefs.getChild("help_url");
            Element news_url_element = prefs.getChild("news_url");
            Element httpInterfacePortElement = prefs.getChild("httpInterfacePort");
            try {
                this.httpInterfacePort = new Integer(httpInterfacePortElement.getText());
            }
            catch (Throwable t) {
                LOG.warn((Object)("httpInterface was not configured. Set default value: " + this.httpInterfacePort), t);
            }
            this.helpUrl = help_url_element.getText();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("helpUrl:" + this.helpUrl));
            }
            this.newsUrl = news_url_element.getText();
        }
        catch (Throwable t) {
            LOG.error((Object)("Error while loading the help urls (" + prefs.getChildren() + "), disabling menu items"), t);
        }
        this.mniOnlineHelp.setEnabled(this.helpUrl != null);
        this.mniNews.setEnabled(this.newsUrl != null);
        this.menHelp.setEnabled(this.mniOnlineHelp.isEnabled() && this.mniNews.isEnabled());
        this.windows2skip = new ArrayList<String>();
        try {
            Element windows2SkipElement = e.getChild("skipWindows");
            for (Element next : windows2SkipElement.getChildren("skip")) {
                JMenuItem menu;
                String id = next.getAttributeValue("windowid");
                this.windows2skip.add(id);
                View v = this.viewMap.getView(id);
                if (v != null) {
                    v.close();
                }
                if ((menu = this.viewMenuMap.get(id)) == null) continue;
                menu.setVisible(false);
            }
        }
        catch (Exception x) {
            LOG.info((Object)"No skipWindow Info available or error while reading the configuration", (Throwable)x);
        }
        try {
            ArrayList<View> before = new ArrayList<View>();
            ArrayList<JSeparator> after = new ArrayList<JSeparator>();
            after.add(this.sepServerProfilesEnd);
            View comps = this.menFile.getMenuComponents();
            ArrayList<View> active = before;
            for (View comp : comps) {
                if (active != null) {
                    active.add(comp);
                }
                if (active == before && comp.getName() != null && comp.getName().trim().equals("sepServerProfilesStart")) {
                    active = null;
                    continue;
                }
                if (active != null || comp.getName() == null || !comp.getName().trim().equals("sepServerProfilesEnd")) continue;
                active = after;
            }
            ArrayList<JMenuItem> serverProfileItems = new ArrayList<JMenuItem>();
            Element serverprofiles = e.getChild("serverProfiles");
            for (Element next : serverprofiles.getChildren("profile")) {
                String string = next.getAttributeValue("id");
                String sorter = next.getAttributeValue("sorter");
                String name = next.getAttributeValue("name");
                final String path = next.getAttributeValue("path");
                String icon = next.getAttributeValue("icon");
                String descr = next.getAttributeValue("descr");
                String descrWidth = next.getAttributeValue("descrwidth");
                String complexDescriptionText = next.getTextTrim();
                String complexDescriptionSwitch = next.getAttributeValue("complexdescr");
                JMenuItem serverProfileMenuItem = new JMenuItem();
                serverProfileMenuItem.setText(name);
                serverProfileMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            ((ActiveLayerModel)CismapPlugin.this.mapC.getMappingModel()).removeAllLayers();
                            CismapPlugin.this.configurationManager.configureFromClasspath(path, null);
                            CismapPlugin.this.setButtonSelectionAccordingToMappingComponent();
                        }
                        catch (Throwable ex) {
                            LOG.fatal((Object)"No ServerProfile", ex);
                        }
                    }
                });
                serverProfileMenuItem.setName("ServerProfile:" + sorter + ":" + name);
                if (complexDescriptionSwitch != null && complexDescriptionSwitch.equalsIgnoreCase("true") && complexDescriptionText != null) {
                    serverProfileMenuItem.setToolTipText(complexDescriptionText);
                } else if (descrWidth != null) {
                    serverProfileMenuItem.setToolTipText("<html><table width=\"" + descrWidth + "\" border=\"0\"><tr><td>" + descr + "</p></td></tr></table></html>");
                } else {
                    serverProfileMenuItem.setToolTipText(descr);
                }
                try {
                    serverProfileMenuItem.setIcon(new ImageIcon(this.getClass().getResource(icon)));
                }
                catch (Exception iconE) {
                    LOG.warn((Object)"Could not create Icon for ServerProfile.", (Throwable)iconE);
                }
                serverProfileItems.add(serverProfileMenuItem);
            }
            Collections.sort(serverProfileItems, new Comparator<JMenuItem>(){

                @Override
                public int compare(JMenuItem o1, JMenuItem o2) {
                    if (o1.getName() != null && o2.getName() != null) {
                        return o1.getName().compareTo(o2.getName());
                    }
                    return 0;
                }
            });
            this.menFile.removeAll();
            for (Component component : before) {
                this.menFile.add(component);
            }
            for (JMenuItem jMenuItem : serverProfileItems) {
                this.menFile.add(jMenuItem);
            }
            for (Component component : after) {
                this.menFile.add(component);
            }
        }
        catch (Exception x) {
            LOG.info((Object)"No server profile available, or error while cerating analysis.", (Throwable)x);
        }
        try {
            Element disableRasterGeoReferencing = prefs.getChild("disableRasterGeoReferencing");
            if (disableRasterGeoReferencing != null && disableRasterGeoReferencing.getText() != null && disableRasterGeoReferencing.getText().equalsIgnoreCase("true")) {
                CismapBroker.getInstance().setEnableRasterGeoReferencingToolbar(false);
            }
        }
        catch (Exception x) {
            LOG.info((Object)"RasterGeoReferencingToolbarComponentProvider properties available", (Throwable)x);
        }
    }

    public void configure(Element e) {
        Element prefs;
        this.cismapPluginUIPreferences = prefs = e.getChild("cismapPluginUIPreferences");
        this.activateLineRef();
        try {
            Element window = prefs.getChild("window");
            final int windowHeight = window.getAttribute("height").getIntValue();
            final int windowWidth = window.getAttribute("width").getIntValue();
            final int windowX = window.getAttribute("x").getIntValue();
            final int windowY = window.getAttribute("y").getIntValue();
            this.oldWindowDimension.setSize(windowWidth, windowHeight);
            this.oldWindowPositionX = windowX;
            this.oldWindowPositionY = windowY;
            final boolean windowMaximised = window.getAttribute("max").getBooleanValue();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CismapPlugin.this.setSize(windowWidth, windowHeight);
                    CismapPlugin.this.setLocation(windowX, windowY);
                    CismapPlugin.this.mapC.formComponentResized(null);
                    if (windowMaximised) {
                        CismapPlugin.this.setExtendedState(6);
                    }
                }
            });
        }
        catch (Throwable t) {
            LOG.error((Object)"Error while loading the sie of the window.", t);
        }
    }

    public void loadLayout(String file, boolean isInit) {
        boolean layoutExists;
        this.setupDefaultLayout();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Load Layout.. from " + file));
        }
        File layoutFile = null;
        InputStream layoutFileInputStream = null;
        String defaultLayout = this.getInternationalizedDefaultLayout();
        if (isInit && (file.equals(DEFAULT_LOCAL_LAYOUT) || file.equals(defaultLayout)) && this.getClass().getResource(defaultLayout) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("loading default layout from local layout file '" + defaultLayout + "'"));
            }
            layoutFileInputStream = this.getClass().getResourceAsStream(defaultLayout);
            layoutExists = true;
        } else {
            layoutFile = new File(file);
            layoutExists = layoutFile.exists();
        }
        if (layoutExists) {
            try {
                if (layoutFileInputStream == null) {
                    layoutFileInputStream = new FileInputStream(layoutFile);
                }
                this.loadLayout(layoutFileInputStream, isInit);
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)("Layout File '" + file + "' not found"), (Throwable)e);
                JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this.mapC), NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.loadLayout(String).JOptionPane.message3"), NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.loadLayout(String).JOptionPane.title"), 1);
            }
        } else if (isInit) {
            LOG.error((Object)("File '" + file + "' does not exist --> default layout (init)"));
            if (isInit && defaultLayout != null) {
                this.loadLayout(defaultLayout, isInit);
            } else {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CismapPlugin.this.setupDefaultLayout();
                        if (CismapPlugin.this.mapC != null) {
                            CismapPlugin.this.mapC.componentResizedIntermediate();
                            CismapPlugin.this.mapC.componentResizedDelayed();
                        }
                        if (CismapPlugin.this.overviewComponent != null && CismapPlugin.this.overviewComponent.getOverviewMap() != null) {
                            CismapPlugin.this.overviewComponent.getOverviewMap().componentResizedIntermediate();
                            CismapPlugin.this.overviewComponent.getOverviewMap().componentResizedDelayed();
                        }
                    }
                });
            }
        } else {
            LOG.error((Object)("File '" + file + "' does not exist)"));
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this.mapC), NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.loadLayout(String).JOptionPane.message3"), NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.loadLayout(String).JOptionPane.title"), 1);
        }
    }

    protected String getInternationalizedDefaultLayout() {
        URL defaultLayoutUrl = this.getClass().getResource(DEFAULT_LOCAL_LAYOUT_LANGUAGE_COUNTRY);
        if (defaultLayoutUrl == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("default layout file '" + DEFAULT_LOCAL_LAYOUT_LANGUAGE_COUNTRY + "' not found, trying to find '" + DEFAULT_LOCAL_LAYOUT_LANGUAGE + "'"));
            }
        } else {
            return DEFAULT_LOCAL_LAYOUT_LANGUAGE_COUNTRY;
        }
        defaultLayoutUrl = this.getClass().getResource(DEFAULT_LOCAL_LAYOUT_LANGUAGE);
        if (defaultLayoutUrl == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("default layout file '" + DEFAULT_LOCAL_LAYOUT_LANGUAGE + "' not found, trying to find '" + DEFAULT_LOCAL_LAYOUT + "'"));
            }
        } else {
            return DEFAULT_LOCAL_LAYOUT_LANGUAGE;
        }
        defaultLayoutUrl = this.getClass().getResource(DEFAULT_LOCAL_LAYOUT);
        if (defaultLayoutUrl != null) {
            return DEFAULT_LOCAL_LAYOUT;
        }
        LOG.warn((Object)"default layout file '/defaultCismap.layout' not found, giving up!");
        return null;
    }

    public void loadLayout(InputStream layoutInput, boolean isInit) {
        if (layoutInput != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Layout File exists");
            }
            try {
                ObjectInputStream in = new ObjectInputStream(layoutInput);
                this.rootWindow.read(in);
                in.close();
                this.rootWindow.getWindowBar(Direction.LEFT).setEnabled(true);
                this.rootWindow.getWindowBar(Direction.DOWN).setEnabled(true);
                this.rootWindow.getWindowBar(Direction.RIGHT).setEnabled(true);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Loading Layout successfull");
                }
            }
            catch (IOException ex) {
                LOG.error((Object)"Layout File IO Exception --> loading default Layout", (Throwable)ex);
                if (isInit) {
                    JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this.mapC), NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.loadLayout(String).JOptionPane.message1"), NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.loadLayout(String).JOptionPane.title"), 1);
                    this.setupDefaultLayout();
                }
                JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this.mapC), NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.loadLayout(String).JOptionPane.message2"), NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.loadLayout(String).JOptionPane.title"), 1);
            }
        }
    }

    public void saveLayout(String file) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Saving Layout.. to " + file), (Throwable)new CurrentStackTrace());
        }
        File layoutFile = new File(file);
        try {
            if (!layoutFile.exists()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Saving Layout.. File does not exit");
                }
                layoutFile.createNewFile();
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Saving Layout.. File does exit");
            }
            FileOutputStream layoutOutput = new FileOutputStream(layoutFile);
            ObjectOutputStream out = new ObjectOutputStream(layoutOutput);
            this.rootWindow.write(out);
            out.flush();
            out.close();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Saving Layout.. to " + file + " successfull"));
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this.mapC), NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.saveLayout(String).JOptionPane.message"), NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.saveLayout(String).JOptionPane.title"), 1);
            LOG.error((Object)"A failure occured during writing the layout file", (Throwable)ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dropOnMap(MapDnDEvent mde) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"drop on map");
        }
        if (!(mde.getDte() instanceof DropTargetDropEvent)) return;
        DropTargetDropEvent dtde = (DropTargetDropEvent)mde.getDte();
        if (dtde.getTransferable().isDataFlavorSupported(this.fromCapabilityWidget)) {
            this.activeLayers.drop(dtde);
            return;
        } else if (dtde.getTransferable().isDataFlavorSupported(this.fromNavigatorNode) && dtde.getTransferable().isDataFlavorSupported(this.fromNavigatorCollection)) {
            try {
                Object object = dtde.getTransferable().getTransferData(this.fromNavigatorCollection);
                if (!(object instanceof Collection)) return;
                Collection c = (Collection)object;
                this.showObjectsMethod.invoke(c);
                return;
            }
            catch (Throwable t) {
                LOG.fatal((Object)"Error on drop", t);
            }
            return;
        } else if (DnDUtils.isFilesOrUriList((DropTargetDropEvent)dtde)) {
            dtde.acceptDrop(1);
            try {
                List data = DnDUtils.getFilesFrom((DropTargetDropEvent)dtde);
                MultiHashMap filesPerDropHandlerMap = new MultiHashMap();
                if (data != null) {
                    for (File file : data) {
                        MappingComponentDropHandler dropHandler = MappingComponentDropHandlerRegistry.getInstance().getDropHandler(file);
                        if (dropHandler == null) continue;
                        filesPerDropHandlerMap.put((Object)dropHandler, (Object)file);
                        if (!(dropHandler instanceof LayerWidgetProvider)) continue;
                        ((LayerWidgetProvider)dropHandler).setLayerWidget(this.activeLayers);
                    }
                }
                if (filesPerDropHandlerMap.isEmpty()) return;
                for (final MappingComponentDropHandler dropHandler : filesPerDropHandlerMap.keySet()) {
                    final Collection files = filesPerDropHandlerMap.getCollection((Object)dropHandler);
                    new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() throws Exception {
                            dropHandler.dropFiles(files);
                            return null;
                        }
                    }.execute();
                }
                return;
            }
            catch (Exception ex) {
                LOG.error((Object)"Failure during drag & drop opertation", (Throwable)ex);
                return;
            }
        } else {
            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this.mapC), NbBundle.getMessage(CismapPlugin.class, (String)"CismapPlugin.dropOnMap(MapDnDEvent).JOptionPane.message"));
            LOG.error((Object)("Unable to process the datatype." + dtde.getTransferable().getTransferDataFlavors()[0]));
        }
    }

    public void showInMap(Collection c, boolean editable) throws Exception {
        this.showObjectsMethod.invoke(c, editable);
    }

    public CidsFeature showInMap(MetaObject mo, boolean editable) throws Exception {
        return this.showObjectsMethod.invoke(mo, editable);
    }

    public void dragOverMap(MapDnDEvent mde) {
    }

    private void setButtonSelectionAccordingToMappingComponent() {
        if (this.mapC.getInteractionMode().equals("ZOOM")) {
            if (!this.cmdZoom.isSelected()) {
                this.cmdZoom.setSelected(true);
            }
        } else if (this.mapC.getInteractionMode().equals("PAN")) {
            if (!this.cmdPan.isSelected()) {
                this.cmdPan.setSelected(true);
            }
        } else if (this.mapC.getInteractionMode().equals("FEATURE_INFO")) {
            if (!this.cmdFeatureInfo.isSelected()) {
                this.cmdFeatureInfo.setSelected(true);
            }
        } else if (this.mapC.getInteractionMode().equals("SEARCH_POLYGON")) {
            if (!this.cmdPluginSearch.isSelected()) {
                this.cmdPluginSearch.setSelected(true);
            }
        } else if (this.mapC.getInteractionMode().equals("SELECT")) {
            if (this.cmdSelect.isVisible() && !this.cmdSelect.isSelected()) {
                this.cmdSelect.setSelected(true);
            }
            if (this.cmdSelectSingle.isVisible() && !this.cmdSelectSingle.isSelected()) {
                this.cmdSelectSingle.setSelected(true);
            }
        } else if (this.mapC.getInteractionMode().equals("NEW_POLYGON")) {
            if (((CreateNewGeometryListener)this.mapC.getInputListener("NEW_POLYGON")).isInMode("POLYGON")) {
                if (!this.cmdNewPolygon.isSelected()) {
                    this.cmdNewPolygon.setSelected(true);
                }
            } else if (((CreateNewGeometryListener)this.mapC.getInputListener("NEW_POLYGON")).isInMode("LINESTRING")) {
                if (!this.cmdNewLinestring.isSelected()) {
                    this.cmdNewLinestring.setSelected(true);
                }
            } else if (((CreateNewGeometryListener)this.mapC.getInputListener("NEW_POLYGON")).isInMode("POINT") && !this.cmdNewPoint.isSelected()) {
                this.cmdNewPoint.setSelected(true);
            }
        } else if (this.mapC.getInteractionMode().equals("MOVE_POLYGON")) {
            if (!this.cmdMoveGeometry.isSelected()) {
                this.cmdMoveGeometry.setSelected(true);
            }
        } else if (this.mapC.getInteractionMode().equals("REMOVE_POLYGON")) {
            if (!this.cmdRemoveGeometry.isSelected()) {
                this.cmdRemoveGeometry.setSelected(true);
            }
        } else if (this.mapC.getInteractionMode().equals("LINEMEASUREMENT")) {
            this.cmdNewLinearReferencing.setSelected(true);
        }
        if (this.mapC.getHandleInteractionMode().equals("MOVE_HANDLE")) {
            if (!this.cmdNodeMove.isSelected()) {
                this.cmdNodeMove.setSelected(true);
            }
        } else if (this.mapC.getHandleInteractionMode().equals("ADD_HANDLE")) {
            if (!this.cmdNodeAdd.isSelected()) {
                this.cmdNodeAdd.setSelected(true);
            }
        } else if (this.mapC.getHandleInteractionMode().equals("REMOVE_HANDLE")) {
            if (!this.cmdNodeRemove.isSelected()) {
                this.cmdNodeRemove.setSelected(true);
            }
        } else if (this.mapC.getHandleInteractionMode().equals("ROTATE_POLYGON")) {
            if (!this.cmdNodeRemove.isSelected()) {
                this.cmdNodeRotateGeometry.setSelected(true);
            }
        } else if (this.mapC.getHandleInteractionMode().equals("REFLECT_POLYGON") && !this.cmdNodeRemove.isSelected()) {
            this.cmdNodeReflectGeometry.setSelected(true);
        }
        if (!this.mapC.getInteractionMode().equals("SELECT")) {
            this.cmdGroupNodes.clearSelection();
        }
        if (this.mapC.isSnappingEnabled()) {
            if (!this.cmdSnap.isSelected()) {
                this.cmdSnap.setSelected(true);
            }
        } else if (this.cmdSnap.isSelected()) {
            this.cmdSnap.setSelected(false);
        }
    }

    public void statusValueChanged(StatusEvent e) {
        if (e.getName().equals("mode")) {
            this.setButtonSelectionAccordingToMappingComponent();
        }
    }

    public void historyChanged() {
        Vector backPos = this.mapC.getBackPossibilities();
        Vector forwPos = this.mapC.getForwardPossibilities();
        if (this.menHistory != null) {
            this.menHistory.removeAll();
            this.menHistory.add(this.mniBack);
            this.menHistory.add(this.mniForward);
            this.menHistory.add(this.mniHome);
            this.menHistory.add(this.sepBeforePos);
            int start = 0;
            if (backPos.size() - 10 > 0) {
                start = backPos.size() - 10;
            }
            for (int index = start; index < backPos.size(); ++index) {
                Object elem = backPos.get(index);
                JMenuItem item = new JMenuItem(elem.toString());
                item.setIcon(this.miniBack);
                final int pos = backPos.size() - 1 - index;
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        for (int i = 0; i < pos; ++i) {
                            CismapPlugin.this.mapC.back(false);
                        }
                        CismapPlugin.this.mapC.back(true);
                    }
                });
                this.menHistory.add(item);
            }
            JMenuItem currentItem = new JMenuItem(this.mapC.getCurrentElement().toString());
            currentItem.setEnabled(false);
            currentItem.setIcon(this.current);
            this.menHistory.add(currentItem);
            int counter = 0;
            for (int index = forwPos.size() - 1; index >= 0; --index) {
                Object elem = forwPos.get(index);
                JMenuItem item = new JMenuItem(elem.toString());
                item.setIcon(this.miniForward);
                final int pos = forwPos.size() - 1 - index;
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        for (int i = 0; i < pos; ++i) {
                            CismapPlugin.this.mapC.forward(false);
                        }
                        CismapPlugin.this.mapC.forward(true);
                    }
                });
                this.menHistory.add(item);
                if (counter++ > 10) break;
            }
            this.menHistory.add(this.sepAfterPos);
            this.menHistory.add(this.mniHistorySidebar);
        }
    }

    public void historyActionPerformed() {
        LOG.fatal((Object)"historyActionPerformed");
    }

    public void forwardStatusChanged() {
        this.mniForward.setEnabled(this.mapC.isForwardPossible());
    }

    public void backStatusChanged() {
        this.mniBack.setEnabled(this.mapC.isBackPossible());
    }

    public void featuresRemoved(FeatureCollectionEvent fce) {
        for (Feature feature : fce.getEventFeatures()) {
            DefaultMetaTreeNode node = this.featuresInMapReverse.get(feature);
            if (node == null) continue;
            this.featuresInMapReverse.remove(feature);
            this.featuresInMap.remove(node);
        }
    }

    public void featuresChanged(FeatureCollectionEvent fce) {
    }

    public void featuresAdded(FeatureCollectionEvent fce) {
    }

    public void featureSelectionChanged(FeatureCollectionEvent fce) {
        if (this.plugin && !this.featureCollectionEventBlocker) {
            ArrayList fc = new ArrayList(this.mapC.getFeatureCollection().getSelectedFeatures());
            final ArrayList<DefaultMetaTreeNode> nodeVector = new ArrayList<DefaultMetaTreeNode>();
            for (Feature f : fc) {
                if (!(f instanceof CidsFeature) && !(f instanceof FeatureGroup)) continue;
                nodeVector.add(this.featuresInMapReverse.get(f));
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CismapPlugin.this.nodeSelectionEventBlocker = true;
                    ComponentRegistry.getRegistry().getActiveCatalogue().setSelectedNodes((Collection)nodeVector, true);
                    CismapPlugin.this.nodeSelectionEventBlocker = false;
                }
            });
        }
    }

    public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
    }

    public void allFeaturesRemoved(FeatureCollectionEvent fce) {
        this.featuresInMap.clear();
        this.featuresInMapReverse.clear();
    }

    private void initHttpServer() {
        try {
            Thread http = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1500L);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"Http Interface initialisieren");
                        }
                        int PORT = 9098;
                        Server server = new Server(9098);
                        ServerConnector connector = new ServerConnector(server);
                        connector.setPort(9098);
                        server.setConnectors(new Connector[]{connector});
                        AbstractHandler param = new AbstractHandler(){

                            public void handle(String target, Request rqst, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                                Request base_request = rqst;
                                base_request.setHandled(true);
                                response.setContentType("text/html");
                                response.setStatus(202);
                                response.getWriter().println("<html><head><title>HTTP interface</title></head><body><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"80%\"><tr><td width=\"30%\" align=\"center\" valign=\"middle\"><img border=\"0\" src=\"http://www.cismet.de/images/cismetLogo250M.png\" ><br></td><td width=\"%\">&nbsp;</td><td width=\"50%\" align=\"left\" valign=\"middle\"><font face=\"Arial\" size=\"3\" color=\"#1c449c\">... and <b><font face=\"Arial\" size=\"3\" color=\"#1c449c\">http://</font></b> just works</font><br><br><br></td></tr></table></body></html>");
                            }
                        };
                        AbstractHandler hello = new AbstractHandler(){

                            public void handle(String target, Request rqst, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                                block13: {
                                    try {
                                        if (request.getLocalAddr().equals(request.getRemoteAddr())) {
                                            String y1;
                                            String x1;
                                            LOG.info((Object)"HttpInterface connected");
                                            if (target.equalsIgnoreCase("/gotoBoundingBox")) {
                                                x1 = request.getParameter("x1");
                                                y1 = request.getParameter("y1");
                                                String x2 = request.getParameter("x2");
                                                String y2 = request.getParameter("y2");
                                                try {
                                                    BoundingBox bb = new BoundingBox(new Double(x1).doubleValue(), new Double(y1).doubleValue(), new Double(x2).doubleValue(), new Double(y2).doubleValue());
                                                    CismapPlugin.this.mapC.gotoBoundingBoxWithHistory(bb);
                                                }
                                                catch (Exception e) {
                                                    LOG.warn((Object)"gotoBoundingBox failed", (Throwable)e);
                                                }
                                            }
                                            if (target.equalsIgnoreCase("/gotoScale")) {
                                                x1 = request.getParameter("x1");
                                                y1 = request.getParameter("y1");
                                                String scaleDenominator = request.getParameter("scaleDenominator");
                                                try {
                                                    BoundingBox bb = new BoundingBox(new Double(x1).doubleValue(), new Double(y1).doubleValue(), new Double(x1).doubleValue(), new Double(y1).doubleValue());
                                                    CismapPlugin.this.mapC.gotoBoundingBoxWithHistory(CismapPlugin.this.mapC.getScaledBoundingBox(new Double(scaleDenominator).doubleValue(), bb));
                                                }
                                                catch (Exception e) {
                                                    LOG.warn((Object)"gotoBoundingBox failed", (Throwable)e);
                                                }
                                            }
                                            if (target.equalsIgnoreCase("/centerOnPoint")) {
                                                x1 = request.getParameter("x1");
                                                y1 = request.getParameter("y1");
                                                try {
                                                    BoundingBox bb = new BoundingBox(new Double(x1).doubleValue(), new Double(y1).doubleValue(), new Double(x1).doubleValue(), new Double(y1).doubleValue());
                                                    CismapPlugin.this.mapC.gotoBoundingBoxWithHistory(bb);
                                                }
                                                catch (Exception e) {
                                                    LOG.warn((Object)"centerOnPoint failed", (Throwable)e);
                                                }
                                            } else {
                                                LOG.warn((Object)("Unknown target: " + target));
                                            }
                                            break block13;
                                        }
                                        LOG.warn((Object)"Someone tries to access the http interface from an other computer. Access denied.");
                                    }
                                    catch (Throwable t) {
                                        LOG.error((Object)"Error while handle http requests", t);
                                    }
                                }
                            }
                        };
                        HandlerCollection handlers = new HandlerCollection();
                        handlers.setHandlers(new Handler[]{param, hello});
                        server.setHandler((Handler)handlers);
                        server.start();
                        server.join();
                    }
                    catch (Throwable t) {
                        LOG.error((Object)"Error in the HttpInterface of cismap", t);
                    }
                }
            });
            http.start();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Initialise HTTP interface");
            }
        }
        catch (Throwable t) {
            LOG.fatal((Object)"Nothing at all", t);
        }
    }

    public void featureCollectionChanged() {
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o.equals(this.mapC.getMemUndo())) {
            if (arg.equals("ACTIVATE") && !this.cmdUndo.isEnabled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"activate UNDO button");
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CismapPlugin.this.cmdUndo.setEnabled(true);
                    }
                });
            } else if (arg.equals("DEACTIVATE") && this.cmdUndo.isEnabled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"deactivate UNDO button");
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CismapPlugin.this.cmdUndo.setEnabled(false);
                    }
                });
            }
        } else if (o.equals(this.mapC.getMemRedo())) {
            if (arg.equals("ACTIVATE") && !this.cmdRedo.isEnabled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"activate REDO button");
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CismapPlugin.this.cmdRedo.setEnabled(true);
                    }
                });
            } else if (arg.equals("DEACTIVATE") && this.cmdRedo.isEnabled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"deactivate REDO button");
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CismapPlugin.this.cmdRedo.setEnabled(false);
                    }
                });
            }
        }
    }

    class MyPluginProperties
    implements PluginProperties {
        MyPluginProperties() {
        }

        public Object getProperty(String propertyName) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"GetProperty was invoked from CismapPlugin");
            }
            if (propertyName.equalsIgnoreCase("coordinate")) {
                double[][] pointCoordinates = new double[4][2];
                pointCoordinates[0][0] = CismapPlugin.this.mapC.getCurrentBoundingBoxFromCamera().getX1();
                pointCoordinates[0][1] = CismapPlugin.this.mapC.getCurrentBoundingBoxFromCamera().getY1();
                pointCoordinates[1][0] = CismapPlugin.this.mapC.getCurrentBoundingBoxFromCamera().getX2();
                pointCoordinates[1][1] = CismapPlugin.this.mapC.getCurrentBoundingBoxFromCamera().getY1();
                pointCoordinates[2][0] = CismapPlugin.this.mapC.getCurrentBoundingBoxFromCamera().getX2();
                pointCoordinates[2][1] = CismapPlugin.this.mapC.getCurrentBoundingBoxFromCamera().getY2();
                pointCoordinates[3][0] = CismapPlugin.this.mapC.getCurrentBoundingBoxFromCamera().getX1();
                pointCoordinates[3][1] = CismapPlugin.this.mapC.getCurrentBoundingBoxFromCamera().getY2();
                return pointCoordinates;
            }
            if (propertyName.equalsIgnoreCase("coordinateString")) {
                return "(" + CismapPlugin.this.mapC.getCurrentBoundingBoxFromCamera().getX1() + "," + CismapPlugin.this.mapC.getCurrentBoundingBoxFromCamera().getX1() + ") (" + CismapPlugin.this.mapC.getCurrentBoundingBoxFromCamera().getX2() + "," + CismapPlugin.this.mapC.getCurrentBoundingBoxFromCamera().getX2() + ") (" + CismapPlugin.this.mapC.getCurrentBoundingBoxFromCamera().getX2() + "," + CismapPlugin.this.mapC.getCurrentBoundingBoxFromCamera().getY2() + ") (" + CismapPlugin.this.mapC.getCurrentBoundingBoxFromCamera().getX1() + "," + CismapPlugin.this.mapC.getCurrentBoundingBoxFromCamera().getY2() + ")";
            }
            if (propertyName.equalsIgnoreCase("ogcFeatureString")) {
                CismapPlugin.this.mapC.getCurrentBoundingBoxFromCamera().getGeometryFromTextCompatibleString();
            }
            return null;
        }

        public void setProperty(String propertyName, Object value) {
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        }
    }

    private class ShowObjectsMethod
    implements PluginMethod {
        private ShowObjectsMethod() {
        }

        public void invoke() throws Exception {
            Collection selectedNodes = CismapPlugin.this.context.getMetadata().getSelectedNodes();
            this.invoke(selectedNodes);
        }

        public void invoke(Collection nodes) throws Exception {
            this.invoke(nodes, false);
        }

        public synchronized CidsFeature invoke(MetaObject mo, boolean editable) throws Exception {
            CidsFeature cidsFeature = new CidsFeature(mo);
            this.invoke(cidsFeature, editable);
            return cidsFeature;
        }

        private void invoke(CidsFeature cidsFeature, boolean editable) throws Exception {
            ArrayList<CidsFeature> v = new ArrayList<CidsFeature>();
            cidsFeature.setEditable(editable);
            v.add(cidsFeature);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("mapC.getFeatureCollection().getAllFeatures():" + CismapPlugin.this.mapC.getFeatureCollection().getAllFeatures()));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("cidsFeature:" + cidsFeature));
                LOG.debug((Object)("mapC.getFeatureCollection().getAllFeatures().contains(cidsFeature):" + CismapPlugin.this.mapC.getFeatureCollection().getAllFeatures().contains(cidsFeature)));
            }
            CismapPlugin.this.mapC.getFeatureLayer().setVisible(true);
            CismapPlugin.this.mapC.getFeatureCollection().removeFeature((Feature)cidsFeature);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("mapC.getFeatureCollection().getAllFeatures():" + CismapPlugin.this.mapC.getFeatureCollection().getAllFeatures()));
            }
            CismapPlugin.this.mapC.getFeatureCollection().substituteFeatures(v);
            if (editable) {
                CismapPlugin.this.mapC.getFeatureCollection().select(v);
            }
            if (!CismapPlugin.this.mapC.isFixedMapExtent()) {
                CismapPlugin.this.mapC.zoomToFeatureCollection(CismapPlugin.this.mapC.isFixedMapScale());
                CismapPlugin.this.mapC.showHandles(true);
            }
        }

        public synchronized CidsFeature invoke(DefaultMetaTreeNode node, ObjectAttribute oAttr, boolean editable) throws Exception {
            MetaObject loader = ((ObjectTreeNode)node).getMetaObject();
            MetaObjectNode mon = ((ObjectTreeNode)node).getMetaObjectNode();
            CidsFeature cidsFeature = this.invoke(loader, editable);
            cidsFeature = oAttr != null ? new CidsFeature(mon, oAttr) : new CidsFeature(mon);
            CismapPlugin.this.featuresInMap.put(node, cidsFeature);
            CismapPlugin.this.featuresInMapReverse.put(cidsFeature, node);
            this.invoke(cidsFeature, editable);
            return cidsFeature;
        }

        public synchronized void invoke(final Collection<DefaultMetaTreeNode> nodes, final boolean editable) throws Exception {
            LOG.info((Object)"invoke shows objects in the map");
            Runnable showWaitRunnable = new Runnable(){

                @Override
                public void run() {
                    StaticSwingTools.showDialog((JDialog)CismapPlugin.this.showObjectsWaitDialog);
                    SwingWorker<List<Feature>, Void> addToMapWorker = new SwingWorker<List<Feature>, Void>(){
                        private Map<DefaultMetaTreeNode, Feature> tmpFeaturesInMap = null;
                        private Map<Feature, DefaultMetaTreeNode> tmpFeaturesInMapReverse = null;

                        @Override
                        protected List<Feature> doInBackground() throws Exception {
                            Thread.currentThread().setName("ShowObjectsMethod addToMapWorker");
                            Iterator mapIter = CismapPlugin.this.featuresInMap.keySet().iterator();
                            while (mapIter.hasNext()) {
                                DefaultMetaTreeNode node = (DefaultMetaTreeNode)mapIter.next();
                                Feature f = (Feature)CismapPlugin.this.featuresInMap.get(node);
                                if (CismapPlugin.this.mapC.getFeatureCollection().isHoldFeature(f)) continue;
                                mapIter.remove();
                                CismapPlugin.this.featuresInMapReverse.remove(f);
                            }
                            ArrayList<Feature> features = new ArrayList<Feature>();
                            for (DefaultMetaTreeNode node : nodes) {
                                List<Feature> allFeaturesToAdd;
                                MetaObjectNode mon = ((ObjectTreeNode)node).getMetaObjectNode();
                                MetaObject mo = mon.getObject();
                                if (mo == null) {
                                    mo = ((ObjectTreeNode)node).getMetaObject();
                                }
                                CExtContext context = new CExtContext("__ctx_prop_reference__", (Object)mo.getBean());
                                MapVisualisationProvider mvp = (MapVisualisationProvider)CExtManager.getInstance().getExtension(MapVisualisationProvider.class, context);
                                Feature feature = mvp.getFeature(mo.getBean());
                                if (feature == null) continue;
                                feature.setEditable(editable);
                                if (feature instanceof FeatureGroup) {
                                    FeatureGroup fg = (FeatureGroup)feature;
                                    allFeaturesToAdd = new ArrayList<Feature>(FeatureGroups.expandAll((FeatureGroup)fg));
                                } else {
                                    allFeaturesToAdd = Arrays.asList(feature);
                                }
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("allFeaturesToAdd:" + allFeaturesToAdd));
                                }
                                if (CismapPlugin.this.featuresInMap.containsValue(feature)) continue;
                                features.addAll(allFeaturesToAdd);
                                CismapPlugin.this.featuresInMap.put(node, feature);
                                for (Feature f : allFeaturesToAdd) {
                                    CismapPlugin.this.featuresInMapReverse.put(f, node);
                                }
                                if (!LOG.isDebugEnabled()) continue;
                                LOG.debug((Object)("featuresInMap.put(node,cidsFeature):" + node + "," + feature));
                            }
                            this.tmpFeaturesInMap = new HashMap<DefaultMetaTreeNode, Feature>(CismapPlugin.this.featuresInMap);
                            this.tmpFeaturesInMapReverse = new HashMap<Feature, DefaultMetaTreeNode>(CismapPlugin.this.featuresInMapReverse);
                            return features;
                        }

                        @Override
                        protected void done() {
                            try {
                                CismapPlugin.this.showObjectsWaitDialog.setVisible(false);
                                List features = (List)this.get();
                                CismapPlugin.this.mapC.getFeatureLayer().setVisible(true);
                                CismapPlugin.this.mapC.getFeatureCollection().substituteFeatures((Collection)features);
                                CismapPlugin.this.featuresInMap.clear();
                                CismapPlugin.this.featuresInMap.putAll(this.tmpFeaturesInMap);
                                CismapPlugin.this.featuresInMapReverse.clear();
                                CismapPlugin.this.featuresInMapReverse.putAll(this.tmpFeaturesInMapReverse);
                                if (!CismapPlugin.this.mapC.isFixedMapExtent()) {
                                    CismapPlugin.this.mapC.zoomToFeatureCollection(CismapPlugin.this.mapC.isFixedMapScale());
                                }
                            }
                            catch (InterruptedException e) {
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)e, (Throwable)e);
                                }
                            }
                            catch (Exception e) {
                                LOG.error((Object)"Error while displaying objects:", (Throwable)e);
                            }
                        }
                    };
                    CismetThreadPool.execute((Runnable)addToMapWorker);
                }
            };
            if (EventQueue.isDispatchThread()) {
                showWaitRunnable.run();
            } else {
                EventQueue.invokeLater(showWaitRunnable);
            }
        }

        public String getId() {
            return this.getClass().getName();
        }
    }

    private class ResetLayoutMethod
    implements PluginMethod {
        private ResetLayoutMethod() {
        }

        public String getId() {
            return this.getClass().getName();
        }

        public void invoke() throws Exception {
            CismapPlugin.this.loadLayout(CismapPlugin.DEFAULT_LOCAL_LAYOUT, true);
        }
    }

    private class NodeChangeListener
    extends MetaNodeSelectionListener {
        private final SingleAttributeIterator attributeIterator;
        private final Collection classNames;
        private final Collection attributeNames;

        private NodeChangeListener() {
            this.classNames = CismapPlugin.this.context.getEnvironment().getAttributeMappings("className");
            this.attributeNames = CismapPlugin.this.context.getEnvironment().getAttributeMappings("attributeName");
            if (this.attributeNames.size() == 0) {
                this.attributeNames.add("id");
            }
            ComplexAttributeRestriction attributeRestriction = new ComplexAttributeRestriction(2L, -1, null, this.attributeNames, null);
            this.attributeIterator = new SingleAttributeIterator((AttributeRestriction)attributeRestriction, false);
        }

        protected void nodeSelectionChanged(Collection wirdNichtGebrauchtWeilScheissevonPascalgefuelltCollection) {
            if (!CismapPlugin.this.nodeSelectionEventBlocker) {
                try {
                    Collection c = CismapPlugin.this.context.getMetadata().getSelectedNodes();
                    if (c != null && !c.isEmpty()) {
                        Object[] nodes = c.toArray();
                        boolean oneHit = false;
                        ArrayList features = new ArrayList();
                        for (Object o : nodes) {
                            if (!(o instanceof DefaultMetaTreeNode)) continue;
                            DefaultMetaTreeNode node = (DefaultMetaTreeNode)o;
                            if (!CismapPlugin.this.featuresInMap.containsKey(node)) continue;
                            oneHit = true;
                            features.add(CismapPlugin.this.featuresInMap.get(node));
                        }
                        if (oneHit) {
                            CismapPlugin.this.featureCollectionEventBlocker = true;
                            CismapPlugin.this.mapC.getFeatureCollection().select(features);
                            CismapPlugin.this.featureCollectionEventBlocker = false;
                        } else {
                            CismapPlugin.this.featureCollectionEventBlocker = true;
                            CismapPlugin.this.mapC.getFeatureCollection().unselectAll();
                            CismapPlugin.this.featureCollectionEventBlocker = false;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("featuresInMap:" + CismapPlugin.this.featuresInMap));
                            }
                        }
                    }
                }
                catch (Exception t) {
                    LOG.error((Object)"Error in WizardMode:", (Throwable)t);
                }
            }
        }
    }

    class ShutdownHook
    extends Thread {
        public ShutdownHook() {
            super("ShutDownHook");
        }

        @Override
        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"CIAO");
            }
            CismapPlugin.this.configurationManager.writeConfiguration();
            CismapBroker.getInstance().writePropertyFile();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Shutdownhook --> saving layout");
            }
            CismapPlugin.this.saveLayout(CismapPlugin.this.cismapDirectory + CismapPlugin.this.fs + CismapPlugin.this.standaloneLayoutName);
        }
    }

    public static enum ViewSection {
        MAP,
        WFS,
        LAYER,
        LAYER_INFO,
        CAPABILITIES;

    }
}

