/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin;

import Sirius.navigator.tools.StaticNavigatorTools;
import de.cismet.netutil.ProxyProperties;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Properties;
import lombok.Generated;
import org.apache.log4j.Logger;

public class ConfigProperties
extends Properties {
    private static final Logger LOG = Logger.getLogger(ConfigProperties.class);
    private final ProxyProperties proxyProperties = new ProxyProperties();

    public ConfigProperties load(String cfgFile) throws Exception {
        this.load(StaticNavigatorTools.getInputStreamFromFileOrUrl((String)cfgFile));
        String proxyConfig = this.getProxyConfig();
        if (proxyConfig != null && !proxyConfig.isEmpty()) {
            try {
                String cfgFileName = Paths.get(new URI(cfgFile).getPath(), new String[0]).getFileName().toString();
                String cfgDirname = cfgFile.substring(0, cfgFile.lastIndexOf(cfgFileName));
                this.proxyProperties.load(StaticNavigatorTools.getInputStreamFromFileOrUrl((String)(cfgDirname + proxyConfig)));
            }
            catch (Exception ex) {
                LOG.warn((Object)String.format("error while loading proxy properties from %s", proxyConfig), (Throwable)ex);
            }
        }
        return this;
    }

    public String getCallserverUrl() {
        return this.getProperty("callserverUrl");
    }

    public boolean isCompressionEnabled() {
        try {
            return Boolean.parseBoolean(this.getProperty("compressionEnabled"));
        }
        catch (Exception ex) {
            return true;
        }
    }

    public String getDomain() {
        return this.getProperty("domain");
    }

    public String getUsername() {
        return this.getProperty("username");
    }

    public String getPassword() {
        return this.getProperty("password");
    }

    public String getClientName() {
        return this.getProperty("clientName");
    }

    public boolean isIntranetUse() {
        try {
            return Boolean.parseBoolean(this.getProperty("intranetUse"));
        }
        catch (Exception ex) {
            return false;
        }
    }

    public String getProxyConfig() {
        return this.getProperty("proxy.config");
    }

    public static ConfigProperties getInstance() {
        return LazyInitializer.INSTANCE;
    }

    @Generated
    public ProxyProperties getProxyProperties() {
        return this.proxyProperties;
    }

    private static final class LazyInitializer {
        private static final transient ConfigProperties INSTANCE = new ConfigProperties();

        private LazyInitializer() {
        }
    }
}

