/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin;

import de.cismet.cismap.commons.features.AbstractNewFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.AbstractCreateSearchGeometryListener;
import de.cismet.cismap.navigatorplugin.GeoSearchButton;
import de.cismet.cismap.navigatorplugin.metasearch.MetaSearch;
import de.cismet.cismap.navigatorplugin.metasearch.SearchTopic;
import de.cismet.tools.gui.HighlightingRadioButtonMenuItem;
import de.cismet.tools.gui.StayOpenCheckBoxMenuItem;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class GeoSearchMenu
extends JMenu
implements PropertyChangeListener {
    private final String interactionMode;
    private final MappingComponent mappingComponent;
    private final AbstractCreateSearchGeometryListener searchListener;
    private Action searchRectangleAction;
    private Action searchPolygonAction;
    private Action searchCidsFeatureAction;
    private Action searchEllipseAction;
    private Action searchPolylineAction;
    private Action searchRedoAction;
    private Action searchShowLastFeatureAction;
    private Action searchBufferAction;
    private JPopupMenu.Separator jSeparator12;
    private JMenuItem mniSearchBuffer1;
    private JRadioButtonMenuItem mniSearchCidsFeature1;
    private JRadioButtonMenuItem mniSearchEllipse1;
    private JRadioButtonMenuItem mniSearchPolygon1;
    private JRadioButtonMenuItem mniSearchPolyline1;
    private JRadioButtonMenuItem mniSearchRectangle1;
    private JMenuItem mniSearchRedo1;
    private JMenuItem mniSearchShowLastFeature1;

    public GeoSearchMenu(String interactionMode, MappingComponent mappingComponent) {
        this.interactionMode = interactionMode;
        this.mappingComponent = mappingComponent;
        this.searchListener = (AbstractCreateSearchGeometryListener)mappingComponent.getInputListener(interactionMode);
        this.searchListener.addPropertyChangeListener((PropertyChangeListener)this);
        this.searchRectangleAction = GeoSearchButton.createSearchRectangleAction(interactionMode, mappingComponent);
        this.searchPolygonAction = GeoSearchButton.createSearchPolygonAction(interactionMode, mappingComponent);
        this.searchCidsFeatureAction = GeoSearchButton.createSearchCidsFeatureAction(interactionMode, mappingComponent);
        this.searchEllipseAction = GeoSearchButton.createSearchEllipseAction(interactionMode, mappingComponent);
        this.searchPolylineAction = GeoSearchButton.createSearchPolylineAction(interactionMode, mappingComponent);
        this.searchRedoAction = GeoSearchButton.createSearchRedoAction(interactionMode, mappingComponent);
        this.searchShowLastFeatureAction = GeoSearchButton.createSearchShowLastFeatureAction(interactionMode, mappingComponent);
        this.searchBufferAction = GeoSearchButton.createSearchBufferAction(interactionMode, mappingComponent);
        this.initComponents();
    }

    private void initComponents() {
        this.mniSearchRectangle1 = new HighlightingRadioButtonMenuItem(UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE);
        this.mniSearchPolygon1 = new HighlightingRadioButtonMenuItem(UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE);
        this.mniSearchEllipse1 = new HighlightingRadioButtonMenuItem(UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE);
        this.mniSearchPolyline1 = new HighlightingRadioButtonMenuItem(UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE);
        this.jSeparator12 = new JPopupMenu.Separator();
        this.mniSearchCidsFeature1 = new JRadioButtonMenuItem();
        this.mniSearchShowLastFeature1 = new JMenuItem();
        this.mniSearchRedo1 = new JMenuItem();
        this.mniSearchBuffer1 = new JMenuItem();
        Mnemonics.setLocalizedText((AbstractButton)this, (String)NbBundle.getMessage(GeoSearchMenu.class, (String)"GeoSearchMenu.text"));
        this.mniSearchRectangle1.setAction(this.searchRectangleAction);
        this.mniSearchRectangle1.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.mniSearchRectangle1, (String)NbBundle.getMessage(GeoSearchMenu.class, (String)"GeoSearchMenu.mniSearchRectangle1.text"));
        this.mniSearchRectangle1.setIcon(new ImageIcon(this.getClass().getResource("/images/rectangle.png")));
        this.add(this.mniSearchRectangle1);
        this.mniSearchPolygon1.setAction(this.searchPolygonAction);
        Mnemonics.setLocalizedText((AbstractButton)this.mniSearchPolygon1, (String)NbBundle.getMessage(GeoSearchMenu.class, (String)"GeoSearchMenu.mniSearchPolygon1.text"));
        this.mniSearchPolygon1.setIcon(new ImageIcon(this.getClass().getResource("/images/polygon.png")));
        this.add(this.mniSearchPolygon1);
        this.mniSearchEllipse1.setAction(this.searchEllipseAction);
        Mnemonics.setLocalizedText((AbstractButton)this.mniSearchEllipse1, (String)NbBundle.getMessage(GeoSearchMenu.class, (String)"GeoSearchMenu.mniSearchEllipse1.text"));
        this.mniSearchEllipse1.setIcon(new ImageIcon(this.getClass().getResource("/images/ellipse.png")));
        this.add(this.mniSearchEllipse1);
        this.mniSearchPolyline1.setAction(this.searchPolylineAction);
        Mnemonics.setLocalizedText((AbstractButton)this.mniSearchPolyline1, (String)NbBundle.getMessage(GeoSearchMenu.class, (String)"GeoSearchMenu.mniSearchPolyline1.text"));
        this.mniSearchPolyline1.setIcon(new ImageIcon(this.getClass().getResource("/images/polyline.png")));
        this.add(this.mniSearchPolyline1);
        this.add(this.jSeparator12);
        this.mniSearchCidsFeature1.setAction(this.searchCidsFeatureAction);
        Mnemonics.setLocalizedText((AbstractButton)this.mniSearchCidsFeature1, (String)NbBundle.getMessage(GeoSearchMenu.class, (String)"GeoSearchMenu.mniSearchCidsFeature1.text"));
        this.mniSearchCidsFeature1.setIcon(new ImageIcon(this.getClass().getResource("/images/polygon.png")));
        this.add(this.mniSearchCidsFeature1);
        this.mniSearchShowLastFeature1.setAction(this.searchShowLastFeatureAction);
        this.mniSearchShowLastFeature1.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        Mnemonics.setLocalizedText((AbstractButton)this.mniSearchShowLastFeature1, (String)NbBundle.getMessage(GeoSearchMenu.class, (String)"GeoSearchMenu.mniSearchShowLastFeature1.text"));
        this.mniSearchShowLastFeature1.setToolTipText(NbBundle.getMessage(GeoSearchMenu.class, (String)"GeoSearchMenu.mniSearchShowLastFeature1.toolTipText"));
        this.add(this.mniSearchShowLastFeature1);
        this.mniSearchRedo1.setAction(this.searchRedoAction);
        this.mniSearchRedo1.setAccelerator(KeyStroke.getKeyStroke(89, 10));
        Mnemonics.setLocalizedText((AbstractButton)this.mniSearchRedo1, (String)NbBundle.getMessage(GeoSearchMenu.class, (String)"GeoSearchMenu.mniSearchRedo1.text"));
        this.mniSearchRedo1.setToolTipText(NbBundle.getMessage(GeoSearchMenu.class, (String)"GeoSearchMenu.mniSearchRedo1.toolTipText"));
        this.add(this.mniSearchRedo1);
        this.mniSearchBuffer1.setAction(this.searchBufferAction);
        this.mniSearchBuffer1.setIcon(new ImageIcon(this.getClass().getResource("/images/buffer.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.mniSearchBuffer1, (String)NbBundle.getMessage(GeoSearchMenu.class, (String)"GeoSearchMenu.mniSearchBuffer1.text"));
        this.mniSearchBuffer1.setToolTipText(NbBundle.getMessage(GeoSearchMenu.class, (String)"GeoSearchMenu.mniSearchBuffer1.toolTipText"));
        this.add(this.mniSearchBuffer1);
    }

    public void initSearchTopicMenues(MetaSearch metaSearch) {
        this.removeAll();
        this.initComponents();
        if (metaSearch.getSearchTopics() != null && !metaSearch.getSearchTopics().isEmpty()) {
            this.add(new JSeparator());
            for (SearchTopic searchTopic : metaSearch.getSearchTopics()) {
                this.add((JMenuItem)new StayOpenCheckBoxMenuItem((Action)searchTopic, UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE));
                searchTopic.addPropertyChangeListener((PropertyChangeListener)this.mappingComponent.getInputListener(this.interactionMode));
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource().equals(this.searchListener)) {
            if ("PROPERTY_LAST_FEATURE".equals(evt.getPropertyName())) {
                this.setLastFeature((AbstractNewFeature)this.searchListener.getLastSearchFeature());
            } else if ("PROPERTY_MODE".equals(evt.getPropertyName())) {
                this.setModeSelection(this.searchListener.getMode());
            }
        }
    }

    private void setModeSelection(String mode) {
        this.mniSearchRectangle1.setSelected("BOUNDING_BOX".equals(mode));
        this.mniSearchPolygon1.setSelected("POLYGON".equals(mode));
        this.mniSearchEllipse1.setSelected("ELLIPSE".equals(mode));
        this.mniSearchPolyline1.setSelected("LINESTRING".equals(mode));
    }

    private void setLastFeature(AbstractNewFeature lastFeature) {
        if (lastFeature == null) {
            this.mniSearchShowLastFeature1.setIcon(null);
            this.mniSearchShowLastFeature1.setEnabled(false);
            this.mniSearchRedo1.setIcon(null);
            this.mniSearchRedo1.setEnabled(false);
            this.mniSearchBuffer1.setEnabled(false);
        } else {
            switch (lastFeature.getGeometryType()) {
                case ELLIPSE: {
                    this.mniSearchRedo1.setIcon(this.mniSearchEllipse1.getIcon());
                    break;
                }
                case LINESTRING: {
                    this.mniSearchRedo1.setIcon(this.mniSearchPolyline1.getIcon());
                    break;
                }
                case POLYGON: {
                    this.mniSearchRedo1.setIcon(this.mniSearchPolygon1.getIcon());
                    break;
                }
                case RECTANGLE: {
                    this.mniSearchRedo1.setIcon(this.mniSearchRectangle1.getIcon());
                }
            }
            this.mniSearchRedo1.setEnabled(true);
            this.mniSearchBuffer1.setEnabled(true);
            this.mniSearchShowLastFeature1.setIcon(this.mniSearchRedo1.getIcon());
            this.mniSearchShowLastFeature1.setEnabled(true);
        }
    }
}

