/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.plugin.PluginRegistry;
import de.cismet.cismap.navigatorplugin.CismapPlugin;
import de.cismet.cismap.navigatorplugin.GeoSearchButton;
import de.cismet.cismap.navigatorplugin.export_map_actions.ExportGeoPointToClipboardAction;
import de.cismet.cismap.navigatorplugin.export_map_actions.ExportMapDataProvider;
import de.cismet.cismap.navigatorplugin.export_map_actions.ExportMapFileTypes;
import de.cismet.cismap.navigatorplugin.export_map_actions.ExportMapToClipboardAction;
import de.cismet.cismap.navigatorplugin.export_map_actions.ExportMapToFileAction;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.NoWriteError;
import de.cismet.tools.gui.HighlightingRadioButtonMenuItem;
import de.cismet.tools.gui.JPopupMenuButton;
import de.cismet.tools.gui.StayOpenCheckBoxMenuItem;
import de.cismet.tools.gui.menu.CidsUiComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class MapExportPanel
extends JPanel
implements Configurable,
ExportMapDataProvider,
ConnectionContextProvider,
CidsUiComponent {
    private static final Logger LOG = Logger.getLogger(GeoSearchButton.class);
    private static final String ACTION_TAG = "cismap.export_map.restricted_dpi";
    private final ExportMapToClipboardAction exportMapToClipboardAction;
    private final ExportGeoPointToClipboardAction exportGeoPointToClipboardAction;
    private final ExportMapToFileAction exportMapToFileAction;
    private final ConnectionContext connectionContext;
    private JPopupMenuButton btnClipboard;
    private ButtonGroup btngDpi;
    private ButtonGroup btngExportMap;
    private ButtonGroup btngFileFormat;
    private JCheckBoxMenuItem cmniWorldFile;
    private JPopupMenu jPopupMenu1;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JRadioButtonMenuItem rmniExportMapClipboard;
    private JRadioButtonMenuItem rmniExportMapFile;
    private JMenuItem rmniExportPointToClipboard;
    private JMenuItem rmniGif;
    private JMenuItem rmniJpeg;
    private JMenuItem rmniPng;
    private JMenuItem rmniTif;

    public MapExportPanel() {
        this(ConnectionContext.createDeprecated());
    }

    public MapExportPanel(ConnectionContext connectionContext) {
        this.connectionContext = connectionContext;
        this.exportMapToClipboardAction = new ExportMapToClipboardAction(this);
        this.exportGeoPointToClipboardAction = new ExportGeoPointToClipboardAction(this);
        this.exportMapToFileAction = new ExportMapToFileAction(this);
        this.initComponents();
        this.setMaximumSize(new Dimension(34, 34));
        this.setMinimumSize(new Dimension(34, 34));
        this.setPreferredSize(new Dimension(34, 34));
    }

    private boolean checkActionTag() {
        boolean result;
        try {
            result = SessionManager.getConnection().hasConfigAttr(SessionManager.getSession().getUser(), ACTION_TAG, this.getConnectionContext());
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Can not check ActionTag!", (Throwable)ex);
            result = false;
        }
        return result;
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.rmniExportMapClipboard = new HighlightingRadioButtonMenuItem(UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE);
        this.rmniExportMapFile = new HighlightingRadioButtonMenuItem(UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE);
        this.jSeparator1 = new JPopupMenu.Separator();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.rmniPng = new StayOpenCheckBoxMenuItem(null, UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE);
        this.rmniTif = new StayOpenCheckBoxMenuItem(null, UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE);
        this.rmniGif = new StayOpenCheckBoxMenuItem(null, UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE);
        this.rmniJpeg = new StayOpenCheckBoxMenuItem(null, UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE);
        this.jSeparator3 = new JPopupMenu.Separator();
        this.cmniWorldFile = new StayOpenCheckBoxMenuItem(null, UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE);
        this.jSeparator4 = new JPopupMenu.Separator();
        this.rmniExportPointToClipboard = new HighlightingRadioButtonMenuItem(UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE);
        this.btngExportMap = new ButtonGroup();
        this.btngFileFormat = new ButtonGroup();
        this.btngDpi = new ButtonGroup();
        this.btnClipboard = new JPopupMenuButton();
        this.rmniExportMapClipboard.setAction(this.exportMapToClipboardAction);
        this.btngExportMap.add(this.rmniExportMapClipboard);
        this.rmniExportMapClipboard.setSelected(true);
        this.jPopupMenu1.add(this.rmniExportMapClipboard);
        this.rmniExportMapFile.setAction(this.exportMapToFileAction);
        this.btngExportMap.add(this.rmniExportMapFile);
        this.jPopupMenu1.add(this.rmniExportMapFile);
        this.jPopupMenu1.add(this.jSeparator1);
        this.jPopupMenu1.add(this.jSeparator2);
        Mnemonics.setLocalizedText((AbstractButton)this.rmniPng, (String)NbBundle.getMessage(MapExportPanel.class, (String)"MapExportPanel.rmniPng.text"));
        this.btngFileFormat.add(this.rmniPng);
        this.rmniPng.setSelected(true);
        this.jPopupMenu1.add(this.rmniPng);
        Mnemonics.setLocalizedText((AbstractButton)this.rmniTif, (String)NbBundle.getMessage(MapExportPanel.class, (String)"MapExportPanel.rmniTif.text"));
        this.btngFileFormat.add(this.rmniTif);
        this.jPopupMenu1.add(this.rmniTif);
        Mnemonics.setLocalizedText((AbstractButton)this.rmniGif, (String)NbBundle.getMessage(MapExportPanel.class, (String)"MapExportPanel.rmniGif.text"));
        this.btngFileFormat.add(this.rmniGif);
        this.jPopupMenu1.add(this.rmniGif);
        Mnemonics.setLocalizedText((AbstractButton)this.rmniJpeg, (String)NbBundle.getMessage(MapExportPanel.class, (String)"MapExportPanel.rmniJpeg.text"));
        this.btngFileFormat.add(this.rmniJpeg);
        this.jPopupMenu1.add(this.rmniJpeg);
        this.jPopupMenu1.add(this.jSeparator3);
        this.cmniWorldFile.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cmniWorldFile, (String)NbBundle.getMessage(MapExportPanel.class, (String)"MapExportPanel.cmniWorldFile.text"));
        this.jPopupMenu1.add(this.cmniWorldFile);
        this.jPopupMenu1.add(this.jSeparator4);
        this.rmniExportPointToClipboard.setAction(this.exportGeoPointToClipboardAction);
        this.btngExportMap.add(this.rmniExportPointToClipboard);
        this.jPopupMenu1.add(this.rmniExportPointToClipboard);
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.btnClipboard.setAction((Action)this.exportMapToClipboardAction);
        this.btnClipboard.setIcon((Icon)new ImageIcon(this.getClass().getResource("/images/clipboard.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClipboard, (String)NbBundle.getMessage(MapExportPanel.class, (String)"MapExportPanel.btnClipboard.text"));
        this.btnClipboard.setBorderPainted(false);
        this.btnClipboard.setContentAreaFilled(false);
        this.btnClipboard.setHideActionText(true);
        this.btnClipboard.setPopupMenu(this.jPopupMenu1);
        this.add((Component)this.btnClipboard, "Center");
    }

    public void configure(Element parent) {
    }

    public void masterConfigure(Element parent) {
        Element prefs = parent.getChild("cismapMappingPreferences");
        prefs = prefs.getChild("exportMap");
        try {
            List dpis = prefs.getChildren("DPI");
            int addAtIndex = 3;
            for (Element dpi : dpis) {
                boolean add;
                String name = dpi.getAttributeValue("name");
                String value = dpi.getAttributeValue("value");
                boolean restricted = "true".equals(dpi.getAttributeValue("restricted"));
                boolean bl = add = !restricted || restricted && this.checkActionTag();
                if (add) {
                    StayOpenCheckBoxMenuItem item = new StayOpenCheckBoxMenuItem(null, UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE);
                    item.setText(name);
                    item.setSelected(value.equals("72"));
                    item.setActionCommand(value);
                    this.btngDpi.add((AbstractButton)item);
                    this.jPopupMenu1.add((Component)item, addAtIndex);
                    ++addAtIndex;
                }
                this.jPopupMenu1.revalidate();
            }
        }
        catch (Throwable t) {
            LOG.error((Object)("Error while loading the help urls (" + prefs.getChildren() + ")"), t);
        }
    }

    public Element getConfiguration() throws NoWriteError {
        return null;
    }

    @Override
    public int getDpi() {
        if (this.btngDpi == null || this.btngDpi.getSelection() == null) {
            return 72;
        }
        return Integer.parseInt(this.btngDpi.getSelection().getActionCommand());
    }

    @Override
    public void setLastUsedAction(Action action) {
        this.btnClipboard.setAction(action);
    }

    @Override
    public boolean isGenerateWorldFile() {
        return this.cmniWorldFile.isSelected();
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public ExportMapFileTypes getFileType() {
        if (this.rmniGif.isSelected()) {
            return ExportMapFileTypes.GIF;
        }
        if (this.rmniJpeg.isSelected()) {
            return ExportMapFileTypes.JPEG;
        }
        if (this.rmniPng.isSelected()) {
            return ExportMapFileTypes.PNG;
        }
        if (this.rmniTif.isSelected()) {
            return ExportMapFileTypes.TIF;
        }
        LOG.error((Object)"No file type selected. This should not happen.");
        return null;
    }

    @Override
    public int getHttpInterfacePort() {
        CismapPlugin cismapPlugin = (CismapPlugin)PluginRegistry.getRegistry().getPlugin("cismap");
        if (cismapPlugin == null) {
            return 9098;
        }
        return cismapPlugin.getHttpInterfacePort();
    }

    public final ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public String getValue(String key) {
        return "MapExportPanel";
    }
}

