/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin;

import Sirius.navigator.search.CidsSearchExecutor;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.server.search.MetaObjectNodeServerSearch;
import de.cismet.cids.server.search.SearchResultListener;
import de.cismet.cids.server.search.SearchResultListenerProvider;
import de.cismet.cids.server.search.builtin.GeoSearch;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.CreateSearchGeometryListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.MetaSearchCreateSearchGeometryListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.MetaSearchFacade;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.MapSearchListener;
import de.cismet.cismap.commons.interaction.events.MapSearchEvent;
import de.cismet.cismap.navigatorplugin.GeoSearchButton;
import de.cismet.cismap.navigatorplugin.GeoSearchMenu;
import de.cismet.cismap.navigatorplugin.metasearch.MetaSearch;
import de.cismet.cismap.navigatorplugin.metasearch.SearchTopic;
import de.cismet.cismap.navigatorplugin.protocol.GeoSearchProtocolStepImpl;
import de.cismet.commons.gui.protocol.ProtocolHandler;
import de.cismet.commons.gui.protocol.ProtocolStep;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.connectioncontext.ConnectionContextProvider;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.NoWriteError;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.event.PopupMenuEvent;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class MetaSearchHelper
extends JPanel
implements MapSearchListener,
Configurable,
ConnectionContextProvider {
    private static final Logger LOG = Logger.getLogger(MetaSearchHelper.class);
    private final MappingComponent mappingComponent;
    private final String interactionMode;
    private final String searchName;
    private final MetaSearch metaSearch;
    private GeoSearch customGeoSearch;
    private final ConnectionContext connectionContext;
    private boolean configured = false;
    private JButton cmdPluginSearch;
    private JMenu metaSearchMenu;

    private MetaSearchHelper() {
        this.interactionMode = "SEARCH_POLYGON";
        this.mappingComponent = CismapBroker.getInstance().getMappingComponent();
        this.searchName = null;
        this.metaSearch = MetaSearch.instance();
        CismapBroker.getInstance().addMapSearchListener((MapSearchListener)this);
        MetaSearchCreateSearchGeometryListener listener = new MetaSearchCreateSearchGeometryListener(this.mappingComponent, (MetaSearchFacade)this.metaSearch);
        this.mappingComponent.addInputListener(this.interactionMode, (PBasicInputEventHandler)listener);
        this.mappingComponent.addPropertyChangeListener((PropertyChangeListener)listener);
        CismapBroker.getInstance().setMetaSearch((MetaSearchFacade)this.metaSearch);
        this.connectionContext = ConnectionContext.createDeprecated();
        this.initComponents();
    }

    private MetaSearchHelper(boolean plugin, String interactionMode, MappingComponent mappingComponent, String searchName, ConnectionContext connectionContext) {
        this.interactionMode = interactionMode;
        this.mappingComponent = mappingComponent;
        this.searchName = searchName;
        this.connectionContext = connectionContext;
        this.metaSearch = MetaSearch.instance();
        CismapBroker.getInstance().addMapSearchListener((MapSearchListener)this);
        if (plugin) {
            MetaSearchCreateSearchGeometryListener listener = new MetaSearchCreateSearchGeometryListener(mappingComponent, (MetaSearchFacade)this.metaSearch);
            mappingComponent.addInputListener(interactionMode, (PBasicInputEventHandler)listener);
            mappingComponent.addPropertyChangeListener((PropertyChangeListener)listener);
        }
        CismapBroker.getInstance().setMetaSearch((MetaSearchFacade)this.metaSearch);
        this.initComponents();
    }

    @Deprecated
    public static MetaSearchHelper createNewInstance(boolean plugin, String interactionMode, MappingComponent mappingComponent, String searchName) {
        return MetaSearchHelper.createNewInstance(plugin, interactionMode, mappingComponent, searchName, ConnectionContext.createDeprecated());
    }

    public static MetaSearchHelper createNewInstance(boolean plugin, String interactionMode, MappingComponent mappingComponent, String searchName, ConnectionContext connectionContext) {
        return new MetaSearchHelper(plugin, interactionMode, mappingComponent, searchName, connectionContext);
    }

    public static MetaSearchHelper getInstance() {
        return LazyInitializer.INSTANCE;
    }

    public MetaSearch getMetaSearch() {
        return this.metaSearch;
    }

    public JMenu getMenSearch() {
        return this.metaSearchMenu;
    }

    public JButton getCmdPluginSearch() {
        return this.cmdPluginSearch;
    }

    private void initMetaSearch(Geometry geom) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("selected Search Classes " + this.metaSearch.getSelectedSearchClassesForQuery()));
        }
        Geometry transformed = CrsTransformer.transformToDefaultCrs((Geometry)geom);
        transformed.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
        final GeoSearch geoSearch = this.customGeoSearch == null ? (GeoSearch)Lookup.getDefault().lookup(GeoSearch.class) : this.customGeoSearch;
        geoSearch.setGeometry(transformed);
        geoSearch.setValidClassesFromStrings(this.metaSearch.getSelectedSearchClassesForQuery());
        if (geoSearch instanceof SearchResultListenerProvider) {
            ((SearchResultListenerProvider)geoSearch).setSearchResultListener(new SearchResultListener(){

                public void searchDone(List results) {
                    if (ProtocolHandler.getInstance().isRecordEnabled()) {
                        Collection<SearchTopic> searchTopics = MetaSearch.instance().getSelectedSearchTopics();
                        CreateSearchGeometryListener createSearchGeometryListener = (CreateSearchGeometryListener)CismapBroker.getInstance().getMappingComponent().getInputListener("SEARCH_POLYGON");
                        ProtocolHandler.getInstance().recordStep((ProtocolStep)new GeoSearchProtocolStepImpl(geoSearch, (MetaSearchCreateSearchGeometryListener)createSearchGeometryListener, searchTopics, results));
                    }
                }
            });
        }
        CidsSearchExecutor.searchAndDisplayResultsWithDialog((MetaObjectNodeServerSearch)geoSearch, (ConnectionContext)this.getConnectionContext());
    }

    public GeoSearch getCustomGeoSearch() {
        return this.customGeoSearch;
    }

    public void setCustomGeoSearch(GeoSearch customGeoSearch) {
        this.customGeoSearch = customGeoSearch;
    }

    public void mapSearchStarted(MapSearchEvent mse) {
        this.initMetaSearch(mse.getGeometry());
    }

    private void initComponents() {
        this.cmdPluginSearch = new GeoSearchButton(this.interactionMode, this.mappingComponent, this.searchName);
        this.metaSearchMenu = new GeoSearchMenu(this.interactionMode, this.mappingComponent);
        this.cmdPluginSearch.setToolTipText(NbBundle.getMessage(MetaSearchHelper.class, (String)"GeoSearchButton.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.metaSearchMenu, (String)NbBundle.getMessage(MetaSearchHelper.class, (String)"GeoSearchMenu.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    private void popMenSearchPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
    }

    public void configure(Element parent) {
        this.metaSearch.configure(parent);
        ((GeoSearchButton)((Object)this.cmdPluginSearch)).initSearchTopicMenues(this.metaSearch);
        ((GeoSearchMenu)this.metaSearchMenu).initSearchTopicMenues(this.metaSearch);
        this.configured = true;
    }

    public void masterConfigure(Element parent) {
        this.metaSearch.masterConfigure(parent);
    }

    public Element getConfiguration() throws NoWriteError {
        return this.metaSearch.getConfiguration();
    }

    public ConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public boolean isConfigured() {
        return this.configured;
    }

    private static final class LazyInitializer {
        private static final transient MetaSearchHelper INSTANCE = new MetaSearchHelper();

        private LazyInitializer() {
        }
    }
}

