/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin.actions;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.features.AbstractNewFeature;
import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.menu.CidsUiAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.openide.util.NbBundle;

public class BufferSelectedGeometryAction
extends AbstractAction
implements CidsUiAction {
    public BufferSelectedGeometryAction() {
        String tooltip = NbBundle.getMessage(BufferSelectedGeometryAction.class, (String)"BufferSelectedGeometryAction.toolTipText");
        String name = NbBundle.getMessage(BufferSelectedGeometryAction.class, (String)"BufferSelectedGeometryAction.name");
        this.putValue("Name", name);
        this.putValue("ShortDescription", tooltip);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(66, 2));
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/buffer.png")));
        this.putValue("SwingLargeIconKey", new ImageIcon(this.getClass().getResource("/images/buffer.png")));
        this.putValue("CidsActionKey", "BufferSelectedGeometryAction");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MappingComponent mapC = CismapBroker.getInstance().getMappingComponent();
        if (mapC != null) {
            Collection c = mapC.getFeatureCollection().getSelectedFeatures();
            if (c != null && c.size() > 0) {
                String s = (String)JOptionPane.showInputDialog(StaticSwingTools.getParentFrame((Component)mapC), NbBundle.getMessage(BufferSelectedGeometryAction.class, (String)"BufferSelectedGeometryAction.Dialog.text"), NbBundle.getMessage(BufferSelectedGeometryAction.class, (String)"BufferSelectedGeometryAction.Dialog.title"), -1, null, null, "");
                for (Object o : c) {
                    if (!(o instanceof Feature)) continue;
                    int srid = ((Feature)o).getGeometry().getSRID();
                    Geometry oldG = CrsTransformer.transformToMetricCrs((Geometry)((Feature)o).getGeometry());
                    Geometry newG = oldG.buffer(Double.parseDouble(s));
                    newG = CrsTransformer.transformToGivenCrs((Geometry)newG, (String)CrsTransformer.createCrsFromSrid((int)srid));
                    if (o instanceof PureNewFeature) {
                        ((Feature)o).setGeometry(newG);
                        ((PureNewFeature)o).setGeometryType(AbstractNewFeature.geomTypes.POLYGON);
                        PFeature sel = (PFeature)mapC.getPFeatureHM().get(o);
                        sel.setCoordArr(newG.getCoordinates());
                        sel.syncGeometry();
                        ArrayList<Feature> v = new ArrayList<Feature>();
                        v.add(sel.getFeature());
                        ((DefaultFeatureCollection)mapC.getFeatureCollection()).fireFeaturesChanged(v);
                        continue;
                    }
                    PureNewFeature pnf = new PureNewFeature(newG);
                    pnf.setGeometryType(AbstractNewFeature.geomTypes.POLYGON);
                    ((DefaultFeatureCollection)mapC.getFeatureCollection()).addFeature((Feature)pnf);
                    ((DefaultFeatureCollection)mapC.getFeatureCollection()).holdFeature((Feature)pnf);
                }
            } else {
                JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)mapC), NbBundle.getMessage(BufferSelectedGeometryAction.class, (String)"BufferSelectedGeometryAction.Dialog.noneselected"), NbBundle.getMessage(BufferSelectedGeometryAction.class, (String)"BufferSelectedGeometryAction.Dialog.title"), 2);
            }
        }
    }
}

