/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.navigatorplugin.actions;

import Sirius.navigator.NavigatorX;
import Sirius.navigator.ui.ComponentRegistry;
import de.cismet.tools.BrowserLauncher;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.ConfigurationManager;
import de.cismet.tools.configuration.NoWriteError;
import de.cismet.tools.gui.menu.CidsUiAction;
import de.cismet.tools.gui.menu.CidsUiActionProvider;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.openide.util.NbBundle;

public class HelpMenuActionProvider
implements CidsUiActionProvider,
Configurable {
    private static final Logger LOG = Logger.getLogger(HelpMenuActionProvider.class);
    private static String cismapDirectory;
    private static String helpUrl;
    private static String newsUrl;
    private boolean helpEnabled = true;
    private boolean newsEnabled = true;

    public List<CidsUiAction> getActions() {
        ArrayList<CidsUiAction> actionList = new ArrayList<CidsUiAction>();
        NavigatorX navigator = (NavigatorX)ComponentRegistry.getRegistry().getMainWindow();
        ConfigurationManager configManager = navigator.getCismapConfigurationManager();
        configManager.configure((Configurable)this);
        if (this.helpEnabled) {
            actionList.add(new OnlineHelpAction());
        }
        if (this.newsEnabled) {
            actionList.add(new NewsAction());
        }
        return actionList;
    }

    public void masterConfigure(Element e) {
        Element prefs = e.getChild("cismapPluginUIPreferences");
        try {
            Element help_url_element = prefs.getChild("help_url");
            Element news_url_element = prefs.getChild("news_url");
            helpUrl = help_url_element.getText();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("helpUrl:" + helpUrl));
            }
            newsUrl = news_url_element.getText();
        }
        catch (Throwable t) {
            LOG.error((Object)("Error while loading the help urls (" + prefs.getChildren() + "), disabling menu items"), t);
        }
        this.helpEnabled = helpUrl != null;
        this.newsEnabled = newsUrl != null;
    }

    public void configure(Element elmnt) {
    }

    public Element getConfiguration() throws NoWriteError {
        return null;
    }

    private static void openUrlInExternalBrowser(String url) {
        try {
            BrowserLauncher.openURL((String)url);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error while opening: " + url + ". Try again"), (Throwable)e);
            try {
                BrowserLauncher.openURL((String)url);
            }
            catch (Exception e2) {
                LOG.warn((Object)("The second time failed, too. Error while trying to open: " + url + " last attempt"), (Throwable)e2);
                try {
                    BrowserLauncher.openURL((String)("file://" + url));
                }
                catch (Exception e3) {
                    LOG.error((Object)("3rd time fail:file://" + url), (Throwable)e3);
                }
            }
        }
    }

    static {
        helpUrl = null;
        newsUrl = null;
    }

    private static class NewsAction
    extends AbstractAction
    implements CidsUiAction {
        public NewsAction() {
            this.initAction();
        }

        private void initAction() {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/news.png")));
            this.putValue("Name", NbBundle.getMessage(HelpMenuActionProvider.class, (String)"HelpMenuActionProvider.NewsAction.initAction.title"));
            this.putValue("ShortDescription", NbBundle.getMessage(HelpMenuActionProvider.class, (String)"HelpMenuActionProvider.NewsAction.initAction.tooltip"));
            this.putValue("CidsActionKey", "NewsAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HelpMenuActionProvider.openUrlInExternalBrowser(newsUrl);
        }
    }

    private static class OnlineHelpAction
    extends AbstractAction
    implements CidsUiAction {
        public OnlineHelpAction() {
            this.initAction();
        }

        private void initAction() {
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("/images/help.png")));
            this.putValue("Name", NbBundle.getMessage(HelpMenuActionProvider.class, (String)"HelpMenuActionProvider.OnlineHelpAction.initAction.title"));
            this.putValue("ShortDescription", NbBundle.getMessage(HelpMenuActionProvider.class, (String)"HelpMenuActionProvider.OnlineHelpAction.initAction.tooltip"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(112, 0));
            this.putValue("CidsActionKey", "OnlineHelpAction");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HelpMenuActionProvider.openUrlInExternalBrowser(helpUrl);
        }
    }
}

